ALTER TABLE ADR.RPT_FORM_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_FORM_TYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_FORM_TYPE
(
  RPT_FORM_TYPE_ID         NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  ENROLLMENT_FORM_TYPE_ID  NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE INDEX ADR.ENROL_FORM_TYP_RPT_FORM_TYP_FK ON ADR.RPT_FORM_TYPE
(ENROLLMENT_FORM_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IX_RPT_SCHED_REP_RPT_FORM_TYP ON ADR.RPT_FORM_TYPE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPT_FORM_TYPE_ID_PK ON ADR.RPT_FORM_TYPE
(RPT_FORM_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_FORM_TYPE FOR ADR.RPT_FORM_TYPE;


ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT RPT_FORM_TYPE_ID_PK
  PRIMARY KEY
  (RPT_FORM_TYPE_ID)
  USING INDEX ADR.RPT_FORM_TYPE_ID_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT ENRL_FORM_TYP_RPT_FORM_TYP_FK 
  FOREIGN KEY (ENROLLMENT_FORM_TYPE_ID) 
  REFERENCES VOA.ENROLLMENT_FORM_TYPE (ENROLLMENT_FORM_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT RPT_SCHED_REP_RPT_FORM_TYP 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_FORM_TYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_FORM_TYPE TO ADR_RW;

GRANT SELECT ON ADR.RPT_FORM_TYPE TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_FORM_TYPE TO ES_RW;
ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG CASCADE CONSTRAINTS;

CREATE TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG
(
  HL7_TRANSACTION_LOG_ID          NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20),
  MESSAGE_TRANSMISSION_TYPE_ID    NUMBER(20)    NOT NULL,
  HL7_MESSAGE_STATUS_TYPE_ID      NUMBER(20),
  STD_INSTITUTION_ID              NUMBER(20),
  ACK_TYPE_ID                     NUMBER(20),
  MESSAGE_CONTROL_NUMBER          VARCHAR2(20 BYTE) NOT NULL,
  BATCH_CONTROL_NUMBER            VARCHAR2(20 BYTE),
  ACK_DATE                        DATE,
  TRANSMISSION_DATE               DATE,
  RETRANSMISSION_COUNT            NUMBER(10)    NOT NULL,
  RETRANSMISSION_INFO_TEXT        VARCHAR2(30 BYTE),
  ERROR_TEXT                      VARCHAR2(2000 BYTE),
  SITE_RECORD_ELGBTY_STATUS_CODE  VARCHAR2(30 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  MESSAGE_BODY                    CLOB,
  INTERNAL_ERROR_TEXT             CLOB,
  REF_HL7_TRANSACTION_LOG_ID      NUMBER(20)
)
LOB (MESSAGE_BODY) STORE AS MESSAGE_BODY_LOB (
  TABLESPACE  L_DATA_03
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  PCTVERSION  10
  NOCACHE
  NOLOGGING)
LOB (INTERNAL_ERROR_TEXT) STORE AS INTERNAL_ERROR_TEXT_LOB (
  TABLESPACE  L_DATA_03
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  PCTVERSION  10
  NOCACHE
  NOLOGGING)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_03
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY HASH (PERSON_ID)
(  
  PARTITION HL7_ARC_TRANSACTION_LOG_P01
    TABLESPACE L_DATA_03
    LOB (MESSAGE_BODY) STORE AS HL7LOG_ARC_MSGBDY_LOB_P01_I (TABLESPACE L_DATA_03)
    LOB (INTERNAL_ERROR_TEXT) STORE AS HL7LOG_ARC_ERRTXT_LOB_P01_I (TABLESPACE L_DATA_03),  
  PARTITION HL7_ARC_TRANSACTION_LOG_P02
    TABLESPACE L_DATA_03
    LOB (MESSAGE_BODY) STORE AS HL7LOG_ARC_MSGBDY_LOB_P02_I (TABLESPACE L_DATA_03)
    LOB (INTERNAL_ERROR_TEXT) STORE AS HL7LOG_ARC_ERRTXT_LOB_P02_I (TABLESPACE L_DATA_03),  
  PARTITION HL7_ARC_TRANSACTION_LOG_P03
    TABLESPACE L_DATA_03
    LOB (MESSAGE_BODY) STORE AS HL7LOG_ARC_MSGBDY_LOB_P03_I (TABLESPACE L_DATA_03)
    LOB (INTERNAL_ERROR_TEXT) STORE AS HL7LOG_ARC_ERRTXT_LOB_P03_I (TABLESPACE L_DATA_03),  
  PARTITION HL7_ARC_TRANSACTION_LOG_P04
    TABLESPACE L_DATA_03
    LOB (MESSAGE_BODY) STORE AS HL7LOG_ARC_MSGBDY_LOB_P04_I (TABLESPACE L_DATA_03)
    LOB (INTERNAL_ERROR_TEXT) STORE AS HL7LOG_ARC_ERRTXT_LOB_P04_I (TABLESPACE L_DATA_03),  
  PARTITION HL7_ARC_TRANSACTION_LOG_P05
    TABLESPACE L_DATA_03
    LOB (MESSAGE_BODY) STORE AS HL7LOG_ARC_MSGBDY_LOB_P05_I (TABLESPACE L_DATA_03)
    LOB (INTERNAL_ERROR_TEXT) STORE AS HL7LOG_ARC_ERRTXT_LOB_P05_I (TABLESPACE L_DATA_03),  
  PARTITION HL7_ARC_TRANSACTION_LOG_P06
    TABLESPACE L_DATA_03
    LOB (MESSAGE_BODY) STORE AS HL7LOG_ARC_MSGBDY_LOB_P06_I (TABLESPACE L_DATA_03)
    LOB (INTERNAL_ERROR_TEXT) STORE AS HL7LOG_ARC_ERRTXT_LOB_P06_I (TABLESPACE L_DATA_03),  
  PARTITION HL7_ARC_TRANSACTION_LOG_P07
    TABLESPACE L_DATA_03
    LOB (MESSAGE_BODY) STORE AS HL7LOG_ARC_MSGBDY_LOB_P07_I (TABLESPACE L_DATA_03)
    LOB (INTERNAL_ERROR_TEXT) STORE AS HL7LOG_ARC_ERRTXT_LOB_P07_I (TABLESPACE L_DATA_03),  
  PARTITION HL7_ARC_TRANSACTION_LOG_P08
    TABLESPACE L_DATA_03
    LOB (MESSAGE_BODY) STORE AS HL7LOG_ARC_MSGBDY_LOB_P08_I (TABLESPACE L_DATA_03)
    LOB (INTERNAL_ERROR_TEXT) STORE AS HL7LOG_ARC_ERRTXT_LOB_P08_I (TABLESPACE L_DATA_03)
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG IS 'Messages marked for archive, deletion.';


CREATE INDEX ADR.HL7ARCLOG_HL7TRNLG_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(REF_HL7_TRANSACTION_LOG_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (REF_HL7_TRANSACTION_LOG_ID) (  
  PARTITION HL7LOG_REFTRNID_FK_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;

CREATE INDEX ADR.HL7ARCLOG_PERSONID_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(PERSON_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION HL7_ARC_TRANSACTION_LOG_P01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;

CREATE INDEX ADR.HL7_ARCLOG_BTCHCNTLNO_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(BATCH_CONTROL_NUMBER)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (BATCH_CONTROL_NUMBER) (  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;

CREATE INDEX ADR.HL7_ARCLOG_MSGCNTLNO_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(MESSAGE_CONTROL_NUMBER)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (MESSAGE_CONTROL_NUMBER) (  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;

CREATE INDEX ADR.HL7_ARCLOG_MSGTYPID_FK_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(MESSAGE_TRANSMISSION_TYPE_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (MESSAGE_TRANSMISSION_TYPE_ID) (  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;

CREATE INDEX ADR.HL7_ARCLOG_PK ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(HL7_TRANSACTION_LOG_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (HL7_TRANSACTION_LOG_ID) (  
  PARTITION HL7_ARCLOG_PK_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;

CREATE INDEX ADR.HL7_ARCLOG_TRNDT_TRNTYP_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(TRANSMISSION_DATE, MESSAGE_TRANSMISSION_TYPE_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (TRANSMISSION_DATE, MESSAGE_TRANSMISSION_TYPE_ID) (  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HL7_ARCHIVE_TRANSACTION_LOG FOR ADR.HL7_ARCHIVE_TRANSACTION_LOG;


ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG ADD (
  CONSTRAINT HL7_ARCLOG_PK
  PRIMARY KEY
  (HL7_TRANSACTION_LOG_ID)
  USING INDEX ADR.HL7_ARCLOG_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HL7_ARCHIVE_TRANSACTION_LOG TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HL7_ARCHIVE_TRANSACTION_LOG TO ADR_RW;

GRANT SELECT ON ADR.HL7_ARCHIVE_TRANSACTION_LOG TO ES_R;

GRANT INSERT, SELECT ON ADR.HL7_ARCHIVE_TRANSACTION_LOG TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_DESCRIPTOR CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_DESCRIPTOR
(
  CAT_DSBLTY_DESCRIPTOR_ID    NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  DESCRIPTOR_TYPE_ID          NUMBER(20)        NOT NULL,
  DETERMINATION_DATE          DATE,
  STD_INSTITUTION_ID          NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.CAT_DSBLTY_DESCRIPTOR.CAT_DSBLTY_DESCRIPTOR_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DESCRIPTOR.CATASTROPHIC_DISABILITY_ID IS 'FK to ADR.CATASTROPHIC_DISABILITY.CATASTROPHIC_DISABILITY_ID';


CREATE UNIQUE INDEX ADR.CAT_DSBLTY_DESCRIPTOR_PK ON ADR.CAT_DSBLTY_DESCRIPTOR
(CAT_DSBLTY_DESCRIPTOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CAT_DSBL_CAT_DSBL_DESC_FK_I ON ADR.CAT_DSBLTY_DESCRIPTOR
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_DESC_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.CAT_DSBLTY_DESCRIPTOR
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO ADR.CAT_DSBLTY_DESCRIPTOR_H
        (CAT_DSBLTY_DESCRIPTOR_ID_H,
         CAT_DSBLTY_DESCRIPTOR_ID,
         CATASTROPHIC_DISABILITY_ID,
         DESCRIPTOR_TYPE_ID,
         DETERMINATION_DATE,
         STD_INSTITUTION_ID,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CAT_DSBLTY_DESCRIPTOR_H_S.NEXTVAL,
         :OLD.CAT_DSBLTY_DESCRIPTOR_ID,
         :OLD.CATASTROPHIC_DISABILITY_ID,
         :OLD.DESCRIPTOR_TYPE_ID,
         :OLD.DETERMINATION_DATE,
         :OLD.STD_INSTITUTION_ID,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_count,
         :OLD.Record_modified_date,
         SYSDATE,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO ADR.CAT_DSBLTY_DESCRIPTOR_H
        (CAT_DSBLTY_DESCRIPTOR_ID_H,
         CAT_DSBLTY_DESCRIPTOR_ID,
         CATASTROPHIC_DISABILITY_ID,
         DESCRIPTOR_TYPE_ID,
         DETERMINATION_DATE,
         STD_INSTITUTION_ID,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CAT_DSBLTY_DESCRIPTOR_H_S.NEXTVAL,
         :NEW.CAT_DSBLTY_DESCRIPTOR_ID,
         :NEW.CATASTROPHIC_DISABILITY_ID,
         :NEW.DESCRIPTOR_TYPE_ID,
         :NEW.DETERMINATION_DATE,
         :NEW.STD_INSTITUTION_ID,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_count,
         :NEW.Record_modified_date,
         SYSDATE,
         mDML
        );

    END IF;

  END CAT_DSBLTY_DESC_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_DESCRIPTOR FOR ADR.CAT_DSBLTY_DESCRIPTOR;


ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR ADD (
  CONSTRAINT CAT_DSBLTY_DESCRIPTOR_PK
  PRIMARY KEY
  (CAT_DSBLTY_DESCRIPTOR_ID)
  USING INDEX ADR.CAT_DSBLTY_DESCRIPTOR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR ADD (
  CONSTRAINT CAT_DSBLTY_CAT_DSBLTY_DESC_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_DESCRIPTOR TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H
(
  CAT_DSBLTY_DESCRIPTOR_ID_H  NUMBER(20)        NOT NULL,
  CAT_DSBLTY_DESCRIPTOR_ID    NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20),
  DESCRIPTOR_TYPE_ID          NUMBER(20),
  DETERMINATION_DATE          DATE,
  STD_INSTITUTION_ID          NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  HISTORY_CREATED_DATE        DATE              NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.CAT_DSBLTY_DESCRIPTOR_H.CAT_DSBLTY_DESCRIPTOR_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DESCRIPTOR_H.CATASTROPHIC_DISABILITY_ID IS 'FK to ADR.CATASTROPHIC_DISABILITY.CATASTROPHIC_DISABILITY_ID';


CREATE UNIQUE INDEX ADR.CAT_DSBLTY_DESCRIPTOR_H_PK ON ADR.CAT_DSBLTY_DESCRIPTOR_H
(CAT_DSBLTY_DESCRIPTOR_ID_H)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_DESCRIPTOR_H FOR ADR.CAT_DSBLTY_DESCRIPTOR_H;


ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H ADD (
  CONSTRAINT CAT_DSBLTY_DESCRIPTOR_H_PK
  PRIMARY KEY
  (CAT_DSBLTY_DESCRIPTOR_ID_H)
  USING INDEX ADR.CAT_DSBLTY_DESCRIPTOR_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DESCRIPTOR_H TO ES_RW;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_PREFERRED_LANGUAGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_PREFERRED_LANGUAGE
(
  PERSON_PREFERRED_LANGUAGE_ID  NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20)      NOT NULL,
  STD_LANGUAGECODE_ID           NUMBER(20)      NOT NULL,
  LANGUAGE_ENTRY_DATE           DATE            NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.PERSON_PREFERRED_LANGUAGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.PERSON_ID IS 'Person table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.STD_LANGUAGECODE_ID IS 'Language_code table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PERSON_PREFERRED_LANGUAGE_PK ON ADR.PERSON_PREFERRED_LANGUAGE
(PERSON_PREFERRED_LANGUAGE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PRSNPRFLNG_PRSN_ID_UI ON ADR.PERSON_PREFERRED_LANGUAGE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PRSN_PREF_LANG_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.PERSON_PREFERRED_LANGUAGE  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
  if DELETING then
      insert into PERSON_PREFERRED_LANGUAGE_H
      (
      PERSON_PREFERRED_LANG_H_ID,
      PERSON_PREFERRED_LANGUAGE_ID,
      PERSON_ID,
      STD_LANGUAGECODE_ID,
      LANGUAGE_ENTRY_DATE,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      HISTORY_CREATED_DATE,
      TRANSACTION_TYPE_CODE
      )
      values
      (
      PERSON_PREFERRED_LANGUAGE_H_S.nextval,
      :old.PERSON_PREFERRED_LANGUAGE_ID,
      :old.PERSON_ID,
      :old.STD_LANGUAGECODE_ID,
      :old.LANGUAGE_ENTRY_DATE,
      :old.RECORD_CREATED_BY,
      :old.RECORD_CREATED_DATE,
      :old.RECORD_MODIFIED_BY,
      :old.RECORD_MODIFIED_DATE,
      :old.RECORD_MODIFIED_COUNT,
      SYSDATE,
      'D'
      );

  else
      if UPDATING then
          mDML := 'U';
      else
          mDML := 'I';
      end if;

       insert into PERSON_PREFERRED_LANGUAGE_H
      (
      PERSON_PREFERRED_LANG_H_ID,
      PERSON_PREFERRED_LANGUAGE_ID,
      PERSON_ID,
      STD_LANGUAGECODE_ID,
      LANGUAGE_ENTRY_DATE,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      HISTORY_CREATED_DATE,
      TRANSACTION_TYPE_CODE
      )
      values
      (
      PERSON_PREFERRED_LANGUAGE_H_S.nextval,
      :new.PERSON_PREFERRED_LANGUAGE_ID,
      :new.PERSON_ID,
      :new.STD_LANGUAGECODE_ID,
      :new.LANGUAGE_ENTRY_DATE,
      :new.RECORD_CREATED_BY,
      :new.RECORD_CREATED_DATE,
      :new.RECORD_MODIFIED_BY,
      :new.RECORD_MODIFIED_DATE,
      :new.RECORD_MODIFIED_COUNT,
      SYSDATE,
      mDML
      );

  end if;

end PRSN_PREF_LANG_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON_PREFERRED_LANGUAGE FOR ADR.PERSON_PREFERRED_LANGUAGE;


ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT PERSON_PREFERRED_LANGUAGE_PK
  PRIMARY KEY
  (PERSON_PREFERRED_LANGUAGE_ID)
  USING INDEX ADR.PERSON_PREFERRED_LANGUAGE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT PRSNPRSNPREFLANG_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE,
  CONSTRAINT STDLNGCD_PRSNPREFLNG_FK 
  FOREIGN KEY (STD_LANGUAGECODE_ID) 
  REFERENCES ADRREF.STD_LANGUAGECODE (ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE TO ADREXT;

GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_PREFERRED_LANGUAGE TO ADR_RW;

GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_PREFERRED_LANGUAGE TO ES_RW;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_PREFERRED_LANGUAGE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_PREFERRED_LANGUAGE_H
(
  PERSON_PREFERRED_LANG_H_ID    NUMBER(20)      NOT NULL,
  PERSON_PREFERRED_LANGUAGE_ID  NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20)      NOT NULL,
  STD_LANGUAGECODE_ID           NUMBER(20)      NOT NULL,
  LANGUAGE_ENTRY_DATE           DATE            NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL,
  HISTORY_CREATED_DATE          DATE            NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.PERSON_PREFERRED_LANG_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.PERSON_PREFERRED_LANGUAGE_ID IS 'Person_preferred_language table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.PERSON_ID IS 'person table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.STD_LANGUAGECODE_ID IS 'Language_code table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.HISTORY_CREATED_DATE IS 'Date history record created.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';


CREATE UNIQUE INDEX ADR.PERSON_PREFERRED_LANGUAGE_H_PK ON ADR.PERSON_PREFERRED_LANGUAGE_H
(PERSON_PREFERRED_LANG_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_PREFERRED_LANGUAGE_H FOR ADR.PERSON_PREFERRED_LANGUAGE_H;


ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H ADD (
  CONSTRAINT PERSON_PREFERRED_LANGUAGE_H_PK
  PRIMARY KEY
  (PERSON_PREFERRED_LANG_H_ID)
  USING INDEX ADR.PERSON_PREFERRED_LANGUAGE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.PERSON_PREFERRED_LANGUAGE_H TO ADR_RW;

GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_PREFERRED_LANGUAGE_H TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PROFILE CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PROFILE
(
  HEALTH_BENEFIT_PROFILE_ID  NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  TRIGGERZ11                 VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFIT_PROFILE IS 'A collection of Health Benefit Plans associated to a Person.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.HEALTH_BENEFIT_PROFILE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.PERSON_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_CREATED_BY IS 'Account or user ID that created the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PROFILE.TRIGGERZ11 IS 'It will store T or F';


CREATE INDEX ADR.HLTBNFPRF_PRSN_FK_I ON ADR.HEALTH_BENEFIT_PROFILE
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HLTHBENPRF_PK ON ADR.HEALTH_BENEFIT_PROFILE
(HEALTH_BENEFIT_PROFILE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HEALTH_BENEFIT_PROF_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.Health_Benefit_Profile
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO Health_Benefit_Profile_H
        (Health_benefit_profile_h_id,
         Health_benefit_profile_id,
         Person_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Transaction_type_code,
         triggerZ11
        )
        VALUES
        (Health_Benefit_Profile_H_S.NEXTVAL,
         :OLD.Health_benefit_profile_id,
         :OLD.Person_id,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_date,
         :OLD.Record_modified_count,
         SYSDATE,
         'D',
         :OLD.triggerZ11
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO Health_Benefit_Profile_H
        (Health_benefit_profile_h_id,
         Health_benefit_profile_id,
         Person_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Transaction_type_code,
         triggerZ11
        )
        VALUES
        (Health_Benefit_Profile_H_S.NEXTVAL,
         :NEW.Health_benefit_profile_id,
         :NEW.Person_id,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_date,
         :NEW.Record_modified_count,
         SYSDATE,
         mDML,
         :NEW.triggerZ11
        );

    END IF;

  END Health_Benefit_Prof_Audir_Trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PROFILE FOR ADR.HEALTH_BENEFIT_PROFILE;


ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE ADD (
  CONSTRAINT HLTHBENPRF_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PROFILE_ID)
  USING INDEX ADR.HLTHBENPRF_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE ADD (
  CONSTRAINT HLTBNFPRF_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PROFILE TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PROFILE TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PROFILE TO ES_RW;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PROFILE TO VETCHOICE_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN_H
(
  HEALTH_BENEFIT_PLAN_H_ID     NUMBER(20)       NOT NULL,
  HEALTH_BENEFIT_PLAN_ID       NUMBER(20)       NOT NULL,
  HEALTH_BENEFIT_PROFILE_ID    NUMBER(20),
  STD_HEALTHBENEFITPLAN_ID     NUMBER(20),
  HEALTH_BNFT_PLN_UPDATE_DATE  DATE,
  STD_DATACHANGESOURCE_ID      NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  HISTORY_CREATED_DATE         DATE             NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  OVERRIDE_FLAG                NUMBER(1),
  OVERRIDE_ASSIGNMENT          NUMBER(1),
  OVERRIDE_REASON              VARCHAR2(200 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFIT_PLAN_H IS 'A description of a type of benefit used to associate the authority for care to the provisioning of health care services for a Person.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.HEALTH_BENEFIT_PLAN_H_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.HEALTH_BENEFIT_PLAN_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.HEALTH_BENEFIT_PROFILE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.STD_HEALTHBENEFITPLAN_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.STD_DATACHANGESOURCE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.STD_INSTITUTION_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_CREATED_BY IS 'Account or user ID that created the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE INDEX ADR.HLTHBENPLNH_BENPLANID_NU_I ON ADR.HEALTH_BENEFIT_PLAN_H
(HEALTH_BENEFIT_PLAN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE INDEX ADR.HLTHBENPLNH_BENPROFID_NU_I ON ADR.HEALTH_BENEFIT_PLAN_H
(HEALTH_BENEFIT_PROFILE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE UNIQUE INDEX ADR.HLTHBENPLNH_PK ON ADR.HEALTH_BENEFIT_PLAN_H
(HEALTH_BENEFIT_PLAN_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HLTHBENPLNH_SHBPID_NU_I ON ADR.HEALTH_BENEFIT_PLAN_H
(STD_HEALTHBENEFITPLAN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN_H FOR ADR.HEALTH_BENEFIT_PLAN_H;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H ADD (
  CONSTRAINT HLTHBENPLNH_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_H_ID)
  USING INDEX ADR.HLTHBENPLNH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN_H TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN_H TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFIT_PLAN CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFIT_PLAN
(
  HEALTH_BENEFIT_PLAN_ID       NUMBER(20)       NOT NULL,
  HEALTH_BENEFIT_PROFILE_ID    NUMBER(20)       NOT NULL,
  STD_HEALTHBENEFITPLAN_ID     NUMBER(20)       NOT NULL,
  HEALTH_BNFT_PLN_UPDATE_DATE  DATE,
  STD_DATACHANGESOURCE_ID      NUMBER(20)       NOT NULL,
  STD_INSTITUTION_ID           NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  OVERRIDE_FLAG                NUMBER(1),
  OVERRIDE_ASSIGNMENT          NUMBER(1),
  OVERRIDE_REASON              VARCHAR2(200 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFIT_PLAN IS 'A description of a type of benefit used to associate the authority for care to the provisioning of health care services for a Person.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.HEALTH_BENEFIT_PLAN_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.HEALTH_BENEFIT_PROFILE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.STD_HEALTHBENEFITPLAN_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.STD_DATACHANGESOURCE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.STD_INSTITUTION_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_CREATED_BY IS 'Account or user ID that created the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFIT_PLAN.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.HLTBNFPLN_HLTBNFPRF_FK_I ON ADR.HEALTH_BENEFIT_PLAN
(HEALTH_BENEFIT_PROFILE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.HLTHBENPLN_PK ON ADR.HEALTH_BENEFIT_PLAN
(HEALTH_BENEFIT_PLAN_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HEALTH_BENEFIT_PLAN_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.Health_Benefit_Plan
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO Health_Benefit_Plan_H
        (Health_benefit_plan_h_id,
         Health_benefit_plan_id,
         Health_benefit_profile_id,
         Std_healthbenefitplan_id,
         Health_bnft_pln_update_date,
         Std_datachangesource_id,
         Std_institution_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Override_flag,
         Override_assignment,
         Override_reason,
         Transaction_type_code
        )
        VALUES
        (Health_Benefit_Plan_H_S.NEXTVAL,
         :OLD.Health_benefit_plan_id,
         :OLD.Health_benefit_profile_id,
         :OLD.Std_healthbenefitplan_id,
         :OLD.Health_bnft_pln_update_date,
         :OLD.Std_datachangesource_id,
         :OLD.Std_institution_id,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_date,
         :OLD.Record_modified_count,
         SYSDATE,
         :OLD.Override_flag,
         :OLD.Override_assignment,
         :OLD.Override_reason,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      insert into HEALTH_BENEFIT_PLAN_H
        (Health_benefit_plan_h_id,
         Health_benefit_plan_id,
         Health_benefit_profile_id,
         Std_healthbenefitplan_id,
         Health_bnft_pln_update_date,
         Std_datachangesource_id,
         Std_institution_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Override_flag,
         Override_assignment,
         Override_reason,
         Transaction_type_code
        )
        VALUES
        (Health_Benefit_Plan_H_S.NEXTVAL,
         :NEW.Health_benefit_plan_id,
         :NEW.Health_benefit_profile_id,
         :NEW.Std_healthbenefitplan_id,
         :NEW.Health_bnft_pln_update_date,
         :NEW.Std_datachangesource_id,
         :NEW.Std_institution_id,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_date,
         :NEW.Record_modified_count,
         SYSDATE,
         :NEW.Override_flag,
         :NEW.Override_assignment,
         :NEW.Override_reason,
         mDML
        );

    END IF;

  END Health_Benefit_Plan_Audir_Trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFIT_PLAN FOR ADR.HEALTH_BENEFIT_PLAN;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT HLTHBENPLN_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_ID)
  USING INDEX ADR.HLTHBENPLN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT HLTBNFPLN_HLTBNFPRF_FK 
  FOREIGN KEY (HEALTH_BENEFIT_PROFILE_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PROFILE (HEALTH_BENEFIT_PROFILE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFIT_PLAN TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFIT_PLAN TO ES_RW;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFIT_PLAN TO VETCHOICE_RW;
DROP TABLE ADR.SSN_VERIFICATION_EXT CASCADE CONSTRAINTS;

CREATE TABLE ADR.SSN_VERIFICATION_EXT
(
  SSN              VARCHAR2(9 BYTE),
  ENTRY_CODE       VARCHAR2(3 BYTE),
  PROCESSING_CODE  VARCHAR2(3 BYTE),
  LAST_NAME        VARCHAR2(13 BYTE),
  FIRST_NAME       VARCHAR2(10 BYTE),
  MIDDLE_NAME      VARCHAR2(7 BYTE),
  DOB              VARCHAR2(8 BYTE),
  SEX              VARCHAR2(1 BYTE),
  INCOME_YEAR      VARCHAR2(4 BYTE),
  HEC_VA_ID        VARCHAR2(15 BYTE),
  SPOUSE_CODE      VARCHAR2(1 BYTE),
  BLANK_1          VARCHAR2(29 BYTE),
  BLANK_2          VARCHAR2(20 BYTE),
  REQUEST_CODE     VARCHAR2(4 BYTE),
  BLANK_3          VARCHAR2(3 BYTE)
)
ORGANIZATION EXTERNAL
  (  TYPE ORACLE_LOADER
     DEFAULT DIRECTORY BATCH_SSN_ADRTOPROCESS_DIR
     ACCESS PARAMETERS 
       ( RECORDS DELIMITED BY NEWLINE 
BADFILE BATCH_SSN_ERR_DIR:'SSA.r_%a_%p.err' 
LOGFILE BATCH_SSN_LOG_DIR:'SSA.r_%a_%p.log' 
FIELDS (
SSN          POSITION(1:9) CHAR(9),
ENTRY_CODE   POSITION(10:12) CHAR(3),
PROCESSING_CODE  POSITION(13:15) CHAR(3),
LAST_NAME    POSITION(16:28) CHAR(13),
FIRST_NAME   POSITION(29:38) CHAR(10),
MIDDLE_NAME  POSITION(39:45) CHAR(7),
DOB          POSITION(46:53) CHAR(8),
SEX          POSITION(54:54) CHAR(1),
INCOME_YEAR  POSITION(55:58) CHAR(4),
HEC_VA_ID    POSITION(59:73) CHAR(15),
SPOUSE_CODE  POSITION(74:74) CHAR(1),
BLANK_1      POSITION(75:103) CHAR(29),
BLANK_2      POSITION(104:123) CHAR(20),
REQUEST_CODE POSITION(124:127) CHAR(4),
BLANK_3      POSITION(128:130) CHAR(3)
)  )
     LOCATION (BATCH_SSN_ADRTOPROCESS_DIR:'SSA.r122491.txt')
  )
REJECT LIMIT UNLIMITED
PARALLEL ( DEGREE 4 INSTANCES 1 )
NOMONITORING;


CREATE OR REPLACE PUBLIC SYNONYM SSN_VERIFICATION_EXT FOR ADR.SSN_VERIFICATION_EXT;


GRANT SELECT ON ADR.SSN_VERIFICATION_EXT TO ADR_R;

GRANT SELECT ON ADR.SSN_VERIFICATION_EXT TO ES_R;
ALTER TABLE ADR.VCESTATUSTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCESTATUSTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCESTATUSTYPE
(
  VCESTATUSTYPE_ID  NUMBER(20)                  NOT NULL,
  CODE              VARCHAR2(3 BYTE)            NOT NULL,
  NAME              VARCHAR2(30 BYTE)           NOT NULL,
  DESCRIPTION       VARCHAR2(250 BYTE),
  CREATED           DATE                        NOT NULL,
  UPDATED           DATE,
  CREATEDBY         VARCHAR2(32 BYTE)           NOT NULL,
  UPDATEDBY         VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCESTATUSTYPE IS 'Lookup table used by VetChoice';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.VCESTATUSTYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.CODE IS 'Shortened code';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.NAME IS 'User readable name';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.DESCRIPTION IS 'Description of the status';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';


CREATE UNIQUE INDEX ADR.VCESTATUSTYPE_PK ON ADR.VCESTATUSTYPE
(VCESTATUSTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VCESTATUSTYPE FOR ADR.VCESTATUSTYPE;


ALTER TABLE ADR.VCESTATUSTYPE ADD (
  CONSTRAINT VCESTATUSTYPE_PK
  PRIMARY KEY
  (VCESTATUSTYPE_ID)
  USING INDEX ADR.VCESTATUSTYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCESTATUSTYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCESTATUSTYPE TO ADR_RW;
ALTER TABLE ADR.WAITTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WAITTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.WAITTYPE
(
  WAITTYPE_ID  NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  CREATED      DATE                             NOT NULL,
  UPDATED      DATE,
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WAITTYPE IS 'Lookup table used by VetChoice';

COMMENT ON COLUMN ADR.WAITTYPE.WAITTYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WAITTYPE.CODE IS 'Shortened code';

COMMENT ON COLUMN ADR.WAITTYPE.NAME IS 'User readable name';

COMMENT ON COLUMN ADR.WAITTYPE.DESCRIPTION IS 'Description of the wait type code';

COMMENT ON COLUMN ADR.WAITTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WAITTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WAITTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WAITTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';


CREATE UNIQUE INDEX ADR.WAITTYPE_PK ON ADR.WAITTYPE
(WAITTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WAITTYPE FOR ADR.WAITTYPE;


ALTER TABLE ADR.WAITTYPE ADD (
  CONSTRAINT WAITTYPE_PK
  PRIMARY KEY
  (WAITTYPE_ID)
  USING INDEX ADR.WAITTYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WAITTYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WAITTYPE TO ADR_RW;

GRANT SELECT ON ADR.WAITTYPE TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON ADR.WAITTYPE TO VETCHOICE_R;
ALTER TABLE ADR.CASSCERTIFIEDTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CASSCERTIFIEDTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.CASSCERTIFIEDTYPE
(
  CASSCERTIFIEDTYPE_ID  NUMBER(20)              NOT NULL,
  CODE                  VARCHAR2(3 BYTE)        NOT NULL,
  NAME                  VARCHAR2(30 BYTE)       NOT NULL,
  DESCRIPTION           VARCHAR2(250 BYTE),
  CREATED               DATE                    NOT NULL,
  UPDATED               DATE,
  CREATEDBY             VARCHAR2(32 BYTE)       NOT NULL,
  UPDATEDBY             VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CASSCERTIFIEDTYPE IS 'Lookup table used by VetChoice';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.CASSCERTIFIEDTYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.CODE IS 'Shortened code';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.NAME IS 'User readable name';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.DESCRIPTION IS 'Description of the CASS status code';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CASSCERTIFIEDTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';


CREATE UNIQUE INDEX ADR.CASSCERTIFIEDTYPE_PK ON ADR.CASSCERTIFIEDTYPE
(CASSCERTIFIEDTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CASSCERTIFIEDTYPE FOR ADR.CASSCERTIFIEDTYPE;


ALTER TABLE ADR.CASSCERTIFIEDTYPE ADD (
  CONSTRAINT CASSCERTIFIEDTYPE_PK
  PRIMARY KEY
  (CASSCERTIFIEDTYPE_ID)
  USING INDEX ADR.CASSCERTIFIEDTYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CASSCERTIFIEDTYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CASSCERTIFIEDTYPE TO ADR_RW;

GRANT SELECT ON ADR.CASSCERTIFIEDTYPE TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON ADR.CASSCERTIFIEDTYPE TO ES_R;

GRANT INSERT, SELECT ON ADR.CASSCERTIFIEDTYPE TO ES_RW;
ALTER TABLE ADR.VCADMISTATUS_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCADMISTATUS_TYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCADMISTATUS_TYPE
(
  VCADMISTATUS_TYPE_ID  NUMBER(20)              NOT NULL,
  CODE                  VARCHAR2(3 BYTE)        NOT NULL,
  NAME                  VARCHAR2(30 BYTE)       NOT NULL,
  DESCRIPTION           VARCHAR2(250 BYTE),
  CREATED               DATE                    NOT NULL,
  UPDATED               DATE,
  CREATEDBY             VARCHAR2(32 BYTE)       NOT NULL,
  UPDATEDBY             VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCADMISTATUS_TYPE IS 'Lookup table used by VetChoice';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.VCADMISTATUS_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.CODE IS 'Shortened code';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.NAME IS 'User readable name';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.DESCRIPTION IS 'Description of the status';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';


CREATE UNIQUE INDEX ADR.VCADMISTATUS_TYPE_PK ON ADR.VCADMISTATUS_TYPE
(VCADMISTATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VCADMISTATUS_TYPE FOR ADR.VCADMISTATUS_TYPE;


ALTER TABLE ADR.VCADMISTATUS_TYPE ADD (
  CONSTRAINT VCADMISTATUS_TYPE_PK
  PRIMARY KEY
  (VCADMISTATUS_TYPE_ID)
  USING INDEX ADR.VCADMISTATUS_TYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCADMISTATUS_TYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMISTATUS_TYPE TO ADR_RW;
ALTER TABLE ADR.VCADMIN
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCADMIN CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCADMIN
(
  VCADMIN_ID             NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  VCADMISTATUS_TYPE_ID   NUMBER(20)             NOT NULL,
  ERROR_TXT              VARCHAR2(30 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCADMIN IS 'Log of records sent to VC Contractor';

COMMENT ON COLUMN ADR.VCADMIN.VCADMIN_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCADMIN.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.VCADMIN.VCADMISTATUS_TYPE_ID IS 'FK to ADR.VCADMISTATUS_TYPE table';

COMMENT ON COLUMN ADR.VCADMIN.ERROR_TXT IS 'Error message';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.VCADMIN_PERSON_ID ON ADR.VCADMIN
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.VCADMIN_PK ON ADR.VCADMIN
(VCADMIN_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.VCADMIN_AUDIR_TRGR
    AFTER UPDATE OR DELETE OR INSERT
    ON ADR.VCADMIN
    FOR EACH ROW
DECLARE
    mDML   CHAR (1);
BEGIN
    IF DELETING
    THEN
        INSERT INTO ADR.VCADMIN_H (VCADMIN_H_ID,
                                   VCADMIN_ID,
                                   PERSON_ID,
                                   ERROR_TXT,
                                   VCADMISTATUS_TYPE_ID,
                                   TRANSACTION_TYPE_CODE,
                                   RECORD_CREATED_BY,
                                   RECORD_CREATED_DATE,
                                   RECORD_MODIFIED_BY,
                                   RECORD_MODIFIED_DATE,
                                   RECORD_MODIFIED_COUNT)
             VALUES (VCADMIN_H_S.NEXTVAL,
                     :old.VCADMIN_ID,
                     :old.PERSON_ID,
                     :old.ERROR_TXT,
                     :old.VCADMISTATUS_TYPE_ID,
                     'D',
                     :old.RECORD_CREATED_BY,
                     :old.RECORD_CREATED_DATE,
                     :old.RECORD_MODIFIED_BY,
                     :old.RECORD_MODIFIED_DATE,
                     :old.RECORD_MODIFIED_COUNT);
    ELSE
        IF UPDATING
        THEN
            mDML := 'U';
        ELSE
            mDML := 'I';
        END IF;

        INSERT INTO ADR.VCADMIN_H (VCADMIN_H_ID,
                                   VCADMIN_ID,
                                   PERSON_ID,
                                   ERROR_TXT,
                                   VCADMISTATUS_TYPE_ID,
                                   TRANSACTION_TYPE_CODE,
                                   RECORD_CREATED_BY,
                                   RECORD_CREATED_DATE,
                                   RECORD_MODIFIED_BY,
                                   RECORD_MODIFIED_DATE,
                                   RECORD_MODIFIED_COUNT)
             VALUES (VCADMIN_H_S.NEXTVAL,
                     :new.VCADMIN_ID,
                     :new.PERSON_ID,
                     :new.ERROR_TXT,
                     :new.VCADMISTATUS_TYPE_ID,
                     mDML,
                     :new.RECORD_CREATED_BY,
                     :new.RECORD_CREATED_DATE,
                     :new.RECORD_MODIFIED_BY,
                     :new.RECORD_MODIFIED_DATE,
                     :new.RECORD_MODIFIED_COUNT);
    END IF;
END VCADMIN_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM VCADMIN FOR ADR.VCADMIN;


ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_PK
  PRIMARY KEY
  (VCADMIN_ID)
  USING INDEX ADR.VCADMIN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_PRSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT VCADMIN_VCEADMINSTATS_FK 
  FOREIGN KEY (VCADMISTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCADMIN TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMIN TO ADR_RW;

GRANT SELECT ON ADR.VCADMIN TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMIN TO VETCHOICE_RW;
ALTER TABLE ADR.VCADMIN_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCADMIN_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCADMIN_H
(
  VCADMIN_H_ID           NUMBER(20)             NOT NULL,
  VCADMIN_ID             NUMBER(20),
  PERSON_ID              NUMBER(20)             NOT NULL,
  ERROR_TXT              VARCHAR2(30 BYTE),
  VCADMISTATUS_TYPE_ID   NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCADMIN_H IS 'History table of VC Contractor log';

COMMENT ON COLUMN ADR.VCADMIN_H.VCADMIN_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCADMIN_H.VCADMIN_ID IS 'FK to ADR.VCADMIN table';

COMMENT ON COLUMN ADR.VCADMIN_H.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.VCADMIN_H.ERROR_TXT IS 'Error message';

COMMENT ON COLUMN ADR.VCADMIN_H.VCADMISTATUS_TYPE_ID IS 'FK to ADR.VCADMISTATUS_TYPE table';

COMMENT ON COLUMN ADR.VCADMIN_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.VCADMIN_H_PERSON_ID_NU_I ON ADR.VCADMIN_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.VCADMIN_H_PK ON ADR.VCADMIN_H
(VCADMIN_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VCADMIN_H FOR ADR.VCADMIN_H;


ALTER TABLE ADR.VCADMIN_H ADD (
  CONSTRAINT VCADMIN_H_PK
  PRIMARY KEY
  (VCADMIN_H_ID)
  USING INDEX ADR.VCADMIN_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCADMIN_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMIN_H TO ADR_RW;

GRANT SELECT ON ADR.VCADMIN_H TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMIN_H TO VETCHOICE_RW;
ALTER TABLE ADR.VCELIGIBILITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCELIGIBILITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCELIGIBILITY
(
  VCELIGIBILITY_ID       NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  VCESTATUSTYPE_ID       NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCELIGIBILITY IS 'Current VC Eligibility determinations';

COMMENT ON COLUMN ADR.VCELIGIBILITY.VCELIGIBILITY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCELIGIBILITY.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.VCELIGIBILITY.VCESTATUSTYPE_ID IS 'FK to ADR.VCESTATUSTYPE table';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.VCELIGIBILITY_PK ON ADR.VCELIGIBILITY
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VCELIGIBIL_PERSON_ID ON ADR.VCELIGIBILITY
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.VCELIGIB_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.VCELIGIBILITY for each row
declare
     mDML char(1);
begin

  if DELETING then

INSERT INTO ADR.VCELIGIBILITY_H (
   VCELIGIBILITY_H_ID,TRANSACTION_TYPE_CODE,VCELIGIBILITY_ID, PERSON_ID, VCESTATUSTYPE_ID,
   RECORD_CREATED_BY, RECORD_CREATED_DATE, RECORD_MODIFIED_BY,
   RECORD_MODIFIED_DATE, RECORD_MODIFIED_COUNT)
VALUES ( VCELIGIBILITY_H_S.nextval,
'D',
:old.VCELIGIBILITY_ID,
 :old.PERSON_ID ,
 :old.VCESTATUSTYPE_ID ,
 :old.RECORD_CREATED_BY ,
 :old.RECORD_CREATED_DATE ,
 :old.RECORD_MODIFIED_BY ,
 :old.RECORD_MODIFIED_DATE ,
 :old.RECORD_MODIFIED_COUNT  );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

  INSERT INTO ADR.VCELIGIBILITY_H (
   VCELIGIBILITY_H_ID,TRANSACTION_TYPE_CODE,VCELIGIBILITY_ID, PERSON_ID, VCESTATUSTYPE_ID,
   RECORD_CREATED_BY, RECORD_CREATED_DATE, RECORD_MODIFIED_BY,
   RECORD_MODIFIED_DATE, RECORD_MODIFIED_COUNT)
VALUES ( VCELIGIBILITY_H_S.nextval,
mDML,
:new.VCELIGIBILITY_ID,
 :new.PERSON_ID ,
 :new.VCESTATUSTYPE_ID ,
 :new.RECORD_CREATED_BY ,
 :new.RECORD_CREATED_DATE ,
 :new.RECORD_MODIFIED_BY ,
 :new.RECORD_MODIFIED_DATE ,
 :new.RECORD_MODIFIED_COUNT  );

  end if;

end VCELIGIB_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM VCELIGIBILITY FOR ADR.VCELIGIBILITY;


ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCELIGIBILITY_PK
  PRIMARY KEY
  (VCELIGIBILITY_ID)
  USING INDEX ADR.VCELIGIBILITY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCEELGB_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT VCEELGB_VCESTATS_FK 
  FOREIGN KEY (VCESTATUSTYPE_ID) 
  REFERENCES ADR.VCESTATUSTYPE (VCESTATUSTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCELIGIBILITY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCELIGIBILITY TO ADR_RW;

GRANT SELECT ON ADR.VCELIGIBILITY TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCELIGIBILITY TO VETCHOICE_RW;
ALTER TABLE ADR.VCELIGIBILITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCELIGIBILITY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCELIGIBILITY_H
(
  VCELIGIBILITY_H_ID     NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  VCELIGIBILITY_ID       NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  VCESTATUSTYPE_ID       NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCELIGIBILITY_H IS 'Historical VC Eligibility determinations';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.VCELIGIBILITY_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.VCELIGIBILITY_ID IS 'FK to ADR.VCELIGIBILITY table';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.VCESTATUSTYPE_ID IS 'FK to ADR.VCESTATUSTYPE table';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.VCELIGIBILITY_H_PK ON ADR.VCELIGIBILITY_H
(VCELIGIBILITY_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VCELIGIBILITY_ID_NU_I ON ADR.VCELIGIBILITY_H
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE INDEX ADR.VCELI_H_PERSON_ID_NU_I ON ADR.VCELIGIBILITY_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VCELIGIBILITY_H FOR ADR.VCELIGIBILITY_H;


ALTER TABLE ADR.VCELIGIBILITY_H ADD (
  CONSTRAINT VCELIGIBILITY_H_PK
  PRIMARY KEY
  (VCELIGIBILITY_H_ID)
  USING INDEX ADR.VCELIGIBILITY_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCELIGIBILITY_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCELIGIBILITY_H TO ADR_RW;

GRANT SELECT ON ADR.VCELIGIBILITY_H TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCELIGIBILITY_H TO VETCHOICE_RW;
ALTER TABLE ADR.GEOCODE_STATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.GEOCODE_STATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.GEOCODE_STATION
(
  GEOCODE_STATION_ID        NUMBER(20)          NOT NULL,
  STD_INSTITUTION_ID        NUMBER(20),
  STATION_NUMBER            VARCHAR2(7 BYTE),
  STATION_ADRR_LINE1        VARCHAR2(100 BYTE),
  STATION_ADRR_LINE2        VARCHAR2(100 BYTE),
  STATION_ADRR_LINE3        VARCHAR2(100 BYTE),
  STATION_ADRR_LINE4        VARCHAR2(100 BYTE),
  STATION_CITY              VARCHAR2(50 BYTE),
  STATION_STATE             VARCHAR2(2 BYTE),
  STATION_ZIP               VARCHAR2(5 BYTE),
  STATION_ZIP4              VARCHAR2(5 BYTE),
  VA_SITE_IND               VARCHAR2(1 BYTE),
  CONTRACTED_IND            VARCHAR2(1 BYTE),
  NUMBER_OF_PROVIDERS       NUMBER(8),
  PARENT_STATION            VARCHAR2(6 BYTE),
  PARENT_STA_COMPLEXITY     VARCHAR2(80 BYTE),
  PLANNED_OR_OPERATIONAL    VARCHAR2(1 BYTE),
  STATION_PHONE             VARCHAR2(12 BYTE),
  STATION_FAX               VARCHAR2(12 BYTE),
  SHARED_IND                VARCHAR2(1 BYTE),
  SHARED_PARENT_STATION     VARCHAR2(6 BYTE),
  HEALTHCARE_CENTER         NUMBER(8),
  MSCBOC                    NUMBER(8),
  NEW_VAMC                  NUMBER(8),
  PCCBOC                    NUMBER(8),
  COC_CLASSIFICATION_CODE   NUMBER(16),
  VA_HOSPITAL               NUMBER(8),
  VHA_SITE_CATEGORY_CODE    VARCHAR2(6 BYTE),
  SITE_CLASSIFICATION_NAME  VARCHAR2(150 BYTE),
  PRIMARY_SVC_TYPE          VARCHAR2(6 BYTE),
  OP_COC_CLASSIFICATION     VARCHAR2(25 BYTE),
  STATION_LONGITUDE         NUMBER(20),
  STATION_LATITUDE          NUMBER(20),
  STATION_NEW_VISN          VARCHAR2(6 BYTE),
  STATION_MARKET            VARCHAR2(4 BYTE),
  STATION_SUBMARKET         VARCHAR2(6 BYTE),
  STATION_COUNTYNAME        VARCHAR2(255 BYTE),
  STATION_DISTRICT          VARCHAR2(4 BYTE),
  STATION_DISTRICT_NAME     VARCHAR2(100 BYTE),
  STATION_URH_CODE          VARCHAR2(1 BYTE),
  STATION_OPERATION_DATE    DATE,
  VAST_EXTRACT_DATE         DATE,
  ACTIVE_START_DT           CHAR(20 BYTE),
  ACTIVE_END_DT             CHAR(20 BYTE),
  ACTIVE_FAG                CHAR(20 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  STATION_NAME              VARCHAR2(100 BYTE),
  STATION_LONG              NUMBER(13,8),
  STATION_LAT               NUMBER(13,8)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.GEOCODE_STATION IS 'List of stations provided by geocode service';

COMMENT ON COLUMN ADR.GEOCODE_STATION.GEOCODE_STATION_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STD_INSTITUTION_ID IS 'FK to ADR.STD_INSTITUTION table';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_NUMBER IS 'Unique site identifier - station identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ADRR_LINE1 IS 'Station Address line 1';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ADRR_LINE2 IS 'Station Address line 2';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ADRR_LINE3 IS 'Station Address line 3';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ADRR_LINE4 IS 'Station Address line 4';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_CITY IS 'Station City';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_STATE IS 'Station State';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ZIP IS 'Station Zip';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_ZIP4 IS 'Station four-digit ZIP code extension';

COMMENT ON COLUMN ADR.GEOCODE_STATION.VA_SITE_IND IS 'VA-owned site flag';

COMMENT ON COLUMN ADR.GEOCODE_STATION.CONTRACTED_IND IS 'V=VA; L=Leased; C=Contracted';

COMMENT ON COLUMN ADR.GEOCODE_STATION.NUMBER_OF_PROVIDERS IS 'Number of sites providing service under this station identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PARENT_STATION IS 'Administrative Parent Station';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PARENT_STA_COMPLEXITY IS 'Administrative Parent Station Complexity Level';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PLANNED_OR_OPERATIONAL IS 'Planned (P) or operational/activated (A)';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_PHONE IS 'Station phone number';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_FAX IS 'Station fax number';

COMMENT ON COLUMN ADR.GEOCODE_STATION.SHARED_IND IS 'Shared flag (indicates multiple station numbers operate at the same geographic location)';

COMMENT ON COLUMN ADR.GEOCODE_STATION.SHARED_PARENT_STATION IS 'First responsible site / parent of sharing site';

COMMENT ON COLUMN ADR.GEOCODE_STATION.HEALTHCARE_CENTER IS 'Health Care Center';

COMMENT ON COLUMN ADR.GEOCODE_STATION.MSCBOC IS 'Multi-Specialty Community-Based Outpatient Clinic';

COMMENT ON COLUMN ADR.GEOCODE_STATION.NEW_VAMC IS 'VA Medical Center';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PCCBOC IS 'Primary Care Community-Based Outpatient Clinic';

COMMENT ON COLUMN ADR.GEOCODE_STATION.COC_CLASSIFICATION_CODE IS 'Station Continuum of Care (CoC) classification. It will be blank for stations permanently deactivated prior to 10/1/14, as those stations never received a CoC Classification. It will also be blank for Vet Centers, Mobile Vet Centers, and Multicontract sites, as these dont receive CoC classifications.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.VA_HOSPITAL IS 'VA Hospital';

COMMENT ON COLUMN ADR.GEOCODE_STATION.VHA_SITE_CATEGORY_CODE IS 'Internal indicator that identifies whether a facility is classified according to VHA Handbook 1006.02  VHA Site Classifications and Definitions';

COMMENT ON COLUMN ADR.GEOCODE_STATION.SITE_CLASSIFICATION_NAME IS 'Site of care classifications name ';

COMMENT ON COLUMN ADR.GEOCODE_STATION.PRIMARY_SVC_TYPE IS 'Primary service type';

COMMENT ON COLUMN ADR.GEOCODE_STATION.OP_COC_CLASSIFICATION IS 'Outpatient Detailed CoC Site Classification. Each point of service receives an outpatient care rating within the VHA site classifications based on the services provided at that location, including mental health, primary care, and specialty care.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_LONGITUDE IS 'Station longitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_LATITUDE IS 'Station Latitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_NEW_VISN IS 'Station NEW Veterans Integrated Service Network identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_MARKET IS 'Station Market Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_SUBMARKET IS 'Station Submarket Identifier';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_COUNTYNAME IS 'Station County Name';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_DISTRICT IS 'ID assigned to fit into the five Department Level Districts that are part of the MyVA Realignment';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_DISTRICT_NAME IS 'Stations assigned VA Department Level District Name';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_URH_CODE IS 'Rurality flag: U=Urban; R=Rural; H=Highly rural';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_OPERATION_DATE IS 'Operational date of site: (A) is date opened/saw first patient; (P) is date planned to open. Format: CYYMMDD';

COMMENT ON COLUMN ADR.GEOCODE_STATION.VAST_EXTRACT_DATE IS 'VAST extraction date. Format: CYYMMDD';

COMMENT ON COLUMN ADR.GEOCODE_STATION.ACTIVE_START_DT IS 'Date station became active';

COMMENT ON COLUMN ADR.GEOCODE_STATION.ACTIVE_END_DT IS 'Date station became inactive';

COMMENT ON COLUMN ADR.GEOCODE_STATION.ACTIVE_FAG IS 'Indicator of the stations active/inactive status';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_NAME IS 'Name of the VACAA facility';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_LONG IS 'Station longitude of site location, relative to WGS1984 datum';

COMMENT ON COLUMN ADR.GEOCODE_STATION.STATION_LAT IS 'Station Latitude of site location, relative to WGS1984 datum';


CREATE UNIQUE INDEX ADR.GEOCODE_STATION_PK ON ADR.GEOCODE_STATION
(GEOCODE_STATION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.GEOCODE_STATION_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.GEOCODE_STATION
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO GEOCODE_STATION_H (
         GEOCODE_STATION_H_ID  ,
         GEOCODE_STATION_ID,
         STD_INSTITUTION_ID,
         STATION_NUMBER,
         STATION_ADRR_LINE1,
         STATION_ADRR_LINE2,
         STATION_ADRR_LINE3 ,
         STATION_ADRR_LINE4,
         STATION_CITY ,
         STATION_STATE ,
         STATION_ZIP ,
         STATION_ZIP4,
         VA_SITE_IND ,
         CONTRACTED_IND ,
         NUMBER_OF_PROVIDERS,
         PARENT_STATION,
         PARENT_STA_COMPLEXITY,
         PLANNED_OR_OPERATIONAL,
         STATION_PHONE,
         STATION_FAX,
         SHARED_IND,
         SHARED_PARENT_STATION,
         HEALTHCARE_CENTER,
         MSCBOC,
         NEW_VAMC,
         PCCBOC,
         COC_CLASSIFICATION_CODE ,
         VA_HOSPITAL,
         VHA_SITE_CATEGORY_CODE,
         SITE_CLASSIFICATION_NAME,
         PRIMARY_SVC_TYPE ,
         OP_COC_CLASSIFICATION,
         STATION_LONGITUDE,
         STATION_LATITUDE,
         STATION_NEW_VISN,
         STATION_MARKET,
         STATION_SUBMARKET,
         STATION_COUNTYNAME,
         STATION_DISTRICT,
         STATION_DISTRICT_NAME,
         STATION_URH_CODE,
         STATION_OPERATION_DATE,
         VAST_EXTRACT_DATE ,
         ACTIVE_START_DT,
         ACTIVE_END_DT,
         ACTIVE_FAG,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         STATION_NAME ,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE,
         STATION_LAT,
         STATION_LONG
         )
 VALUES (GEOCODE_TRANSMIT_H_S.NEXTVAL,
       :old.GEOCODE_STATION_ID,
       :old.STD_INSTITUTION_ID,
       :old.STATION_NUMBER,
       :old.STATION_ADRR_LINE1,
       :old.STATION_ADRR_LINE2,
       :old.STATION_ADRR_LINE3 ,
       :old.STATION_ADRR_LINE4,
       :old.STATION_CITY ,
       :old.STATION_STATE ,
       :old.STATION_ZIP ,
       :old.STATION_ZIP4,
       :old.VA_SITE_IND ,
       :old.CONTRACTED_IND ,
       :old.NUMBER_OF_PROVIDERS,
       :old.PARENT_STATION,
       :old.PARENT_STA_COMPLEXITY,
       :old.PLANNED_OR_OPERATIONAL,
       :old.STATION_PHONE,
       :old.STATION_FAX,
       :old.SHARED_IND,
       :old.SHARED_PARENT_STATION,
       :old.HEALTHCARE_CENTER,
       :old.MSCBOC,
       :old.NEW_VAMC,
       :old.PCCBOC,
       :old.COC_CLASSIFICATION_CODE ,
       :old.VA_HOSPITAL,
       :old.VHA_SITE_CATEGORY_CODE,
       :old.SITE_CLASSIFICATION_NAME,
       :old.PRIMARY_SVC_TYPE ,
       :old.OP_COC_CLASSIFICATION,
       :old.STATION_LONGITUDE,
       :old.STATION_LATITUDE,
       :old.STATION_NEW_VISN,
       :old.STATION_MARKET,
       :old.STATION_SUBMARKET,
       :old.STATION_COUNTYNAME,
       :old.STATION_DISTRICT,
       :old.STATION_DISTRICT_NAME,
       :old.STATION_URH_CODE,
       :old.STATION_OPERATION_DATE,
       :old.VAST_EXTRACT_DATE ,
       :old.ACTIVE_START_DT,
       :old.ACTIVE_END_DT,
       :old.ACTIVE_FAG,
       :old.RECORD_CREATED_BY,
       :old.RECORD_CREATED_DATE,
       :old.RECORD_MODIFIED_BY,
       :old.RECORD_MODIFIED_DATE,
       :old.RECORD_MODIFIED_COUNT,
       :old.STATION_NAME ,
       sysdate,
       mDML,
       :old.STATION_LAT,
       :old.STATION_LONG);
ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

       INSERT INTO GEOCODE_STATION_H (
         GEOCODE_STATION_H_ID  ,
         GEOCODE_STATION_ID,
         STD_INSTITUTION_ID,
         STATION_NUMBER,
         STATION_ADRR_LINE1,
         STATION_ADRR_LINE2,
         STATION_ADRR_LINE3 ,
         STATION_ADRR_LINE4,
         STATION_CITY ,
         STATION_STATE ,
         STATION_ZIP ,
         STATION_ZIP4,
         VA_SITE_IND ,
         CONTRACTED_IND ,
         NUMBER_OF_PROVIDERS,
         PARENT_STATION,
         PARENT_STA_COMPLEXITY,
         PLANNED_OR_OPERATIONAL,
         STATION_PHONE,
         STATION_FAX,
         SHARED_IND,
         SHARED_PARENT_STATION,
         HEALTHCARE_CENTER,
         MSCBOC,
         NEW_VAMC,
         PCCBOC,
         COC_CLASSIFICATION_CODE ,
         VA_HOSPITAL,
         VHA_SITE_CATEGORY_CODE,
         SITE_CLASSIFICATION_NAME,
         PRIMARY_SVC_TYPE ,
         OP_COC_CLASSIFICATION,
         STATION_LONGITUDE,
         STATION_LATITUDE,
         STATION_NEW_VISN,
         STATION_MARKET,
         STATION_SUBMARKET,
         STATION_COUNTYNAME,
         STATION_DISTRICT,
         STATION_DISTRICT_NAME,
         STATION_URH_CODE,
         STATION_OPERATION_DATE,
         VAST_EXTRACT_DATE ,
         ACTIVE_START_DT,
         ACTIVE_END_DT,
         ACTIVE_FAG,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         STATION_NAME ,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE,
         STATION_LAT,
         STATION_LONG)
 VALUES (GEOCODE_STATION_H_S.NEXTVAL  ,
        :new.GEOCODE_STATION_ID,
        :new.STD_INSTITUTION_ID,
        :new.STATION_NUMBER,
        :new.STATION_ADRR_LINE1,
        :new.STATION_ADRR_LINE2,
        :new.STATION_ADRR_LINE3 ,
        :new.STATION_ADRR_LINE4,
        :new.STATION_CITY ,
        :new.STATION_STATE ,
        :new.STATION_ZIP ,
        :new.STATION_ZIP4,
        :new.VA_SITE_IND ,
        :new.CONTRACTED_IND ,
        :new.NUMBER_OF_PROVIDERS,
        :new.PARENT_STATION,
        :new.PARENT_STA_COMPLEXITY,
        :new.PLANNED_OR_OPERATIONAL,
        :new.STATION_PHONE,
        :new.STATION_FAX,
        :new.SHARED_IND,
        :new.SHARED_PARENT_STATION,
        :new.HEALTHCARE_CENTER,
        :new.MSCBOC,
        :new.NEW_VAMC,
        :new.PCCBOC,
        :new.COC_CLASSIFICATION_CODE ,
        :new.VA_HOSPITAL,
        :new.VHA_SITE_CATEGORY_CODE,
        :new.SITE_CLASSIFICATION_NAME,
        :new.PRIMARY_SVC_TYPE ,
        :new.OP_COC_CLASSIFICATION,
        :new.STATION_LONGITUDE,
        :new.STATION_LATITUDE,
        :new.STATION_NEW_VISN,
        :new.STATION_MARKET,
        :new.STATION_SUBMARKET,
        :new.STATION_COUNTYNAME,
        :new.STATION_DISTRICT,
        :new.STATION_DISTRICT_NAME,
        :new.STATION_URH_CODE,
        :new.STATION_OPERATION_DATE,
        :new.VAST_EXTRACT_DATE ,
        :new.ACTIVE_START_DT,
        :new.ACTIVE_END_DT,
        :new.ACTIVE_FAG,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.STATION_NAME ,
        sysdate,
        mDML,
        :new.STATION_LAT,
        :new.STATION_LONG);
   END IF;

 END GEOCODE_STATION_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM GEOCODE_STATION FOR ADR.GEOCODE_STATION;


ALTER TABLE ADR.GEOCODE_STATION ADD (
  CONSTRAINT GEOCODE_STATION_PK
  PRIMARY KEY
  (GEOCODE_STATION_ID)
  USING INDEX ADR.GEOCODE_STATION_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.GEOCODE_STATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_STATION TO ADR_RW;

GRANT SELECT ON ADR.GEOCODE_STATION TO ES_R;

GRANT INSERT, SELECT ON ADR.GEOCODE_STATION TO ES_RW;

GRANT SELECT ON ADR.GEOCODE_STATION TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.GEOCODE_STATION TO VETCHOICE_RW;
DROP TABLE ADR.IVM_MIGRATE_ARCHIVE CASCADE CONSTRAINTS;

CREATE TABLE ADR.IVM_MIGRATE_ARCHIVE
(
  IVM_MIGRATE_ID            NUMBER(20)          NOT NULL,
  IVM_MIGRATE_ARCHIVE_ID    NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  MIGRATE_DATE              DATE,
  INCOME_YEAR               NUMBER(4),
  LEGACY_ICN                VARCHAR2(30 BYTE),
  LOAD_FAILURE_DESCRIPTION  VARCHAR2(2000 BYTE),
  MARKED_FLAG               NUMBER(1)           DEFAULT 0                     NOT NULL,
  REMIGRATE_FLAG            NUMBER(1)           DEFAULT 0                     NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  STD_MESSAGESTATUS_ID      NUMBER(20)
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_03
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION IVMMGRTARC_P001 VALUES LESS THAN (TO_DATE(' 2014-03-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-04-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-07-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-09-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-11-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-12-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-01-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-02-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-03-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-04-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-07-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-09-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-01-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-02-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-03-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-04-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-11-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-12-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2017-12-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2018-01-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2018-04-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2018-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2018-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2018-07-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2018-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IVM_MIGRATE_ARCHIVE IS 'For a brief period just after Deployment, the ADR database to be running in parallel with an EDB database that contains the IVM data. During this period, any deltas that occur in the ADR system after initial migration, will be stored in this table. Hence, this is a one-time, IVM migration related table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.IVM_MIGRATE_ARCHIVE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.INCOME_YEAR IS 'IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.IVMMGRTARC_PK ON ADR.IVM_MIGRATE_ARCHIVE
(IVM_MIGRATE_ARCHIVE_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (IVM_MIGRATE_ARCHIVE_ID) (  
  PARTITION IVMMGRTARC_IDX_P001
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P002
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P003
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P004
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P005
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P006
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P007
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P008
    TABLESPACE L_INDEX_03
)
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE_ARCHIVE FOR ADR.IVM_MIGRATE_ARCHIVE;


GRANT SELECT ON ADR.IVM_MIGRATE_ARCHIVE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_ARCHIVE TO ADR_RW;

GRANT SELECT ON ADR.IVM_MIGRATE_ARCHIVE TO ES_R;

GRANT INSERT, SELECT ON ADR.IVM_MIGRATE_ARCHIVE TO ES_RW;
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_STATEMENT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_STATEMENT_H
(
  FINANCIAL_STATEMENT_H_ID        NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  FINANCIAL_STATEMENT_ID          NUMBER(20),
  PERSON_ID                       NUMBER(20),
  PERSON_RELATION_ID              NUMBER(20),
  REF_FINANCIAL_STATEMENT_ID      NUMBER(20),
  INCOME_YEAR                     NUMBER(4),
  FIN_STMT_MAPPING_TYPE_CODE      VARCHAR2(6 BYTE),
  CONTRIBUTION_TO_SPOUSE_AMT      NUMBER(10,2),
  CONTRIBUTION_TO_DEPENDENT_AMT   NUMBER(10,2),
  DISCLOSED_FINANCIAL_INFO_IND    VARCHAR2(1 BYTE),
  SPOUSE_HAS_INCOME_IND           VARCHAR2(1 BYTE),
  MARRIED_CURR_CALENDAR_YEAR_IND  VARCHAR2(1 BYTE),
  MARRIED_PREV_CALENDAR_YEAR_IND  VARCHAR2(1 BYTE),
  VALID_DEPENDENT_IND             VARCHAR2(1 BYTE),
  DEPENDENT_CHILDREN_COUNT        NUMBER(3),
  DEPENDENT_INCOME_AVAILABLE_IND  VARCHAR2(1 BYTE),
  DEPENDENT_HAS_INCOME_IND        VARCHAR2(1 BYTE),
  DEPENDENT_IN_SCHOOL_IND         VARCHAR2(1 BYTE),
  LIVED_WITH_VETERAN_IND          VARCHAR2(1 BYTE),
  IS_INCAPABLE_SELF_SUPPORT_IND   VARCHAR2(1 BYTE),
  CHILD_SUPPORT_IND               VARCHAR2(1 BYTE),
  VERIFIED_DATE                   DATE,
  POST_2005_DISPLAY_FORMAT_FLAG   NUMBER(1),
  REMARKS                         VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10),
  CONTRIBUTED_TO_SPOUSE_IND       VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_STATEMENT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.FINANCIAL_STATEMENT_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.REF_FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.INCOME_YEAR IS 'Incomeyearforwhichthe visitsummaryinformation isbeingcollected.IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.FIN_STMT_MAPPING_TYPE_CODE IS 'Hibernatemapping:used toidentifywhetherthis isaperson,spouse,or dependentstatement.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.CONTRIBUTION_TO_SPOUSE_AMT IS 'Dollaramountaperson contributestosupportof aspouse';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.CONTRIBUTION_TO_DEPENDENT_AMT IS 'Dollaramountaperson contributestosupportof adependent.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DISCLOSED_FINANCIAL_INFO_IND IS 'Indicatorthataperson, whenasked,declinedto provideincome information.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.SPOUSE_HAS_INCOME_IND IS 'Indicatorthatapersons spousehashisorherown income.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.MARRIED_CURR_CALENDAR_YEAR_IND IS 'Indicatesthattheperson wasmarriedinthe currentcalendaryear.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.MARRIED_PREV_CALENDAR_YEAR_IND IS 'Marriedlastcalendar yearisdefinedasan Indicatorofwhether veteranwasmarried duringlastcalendar year.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.VALID_DEPENDENT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DEPENDENT_CHILDREN_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DEPENDENT_INCOME_AVAILABLE_IND IS 'BR6803Incomeavailable isdefined,asan IndicatorYes/Nothe childsincomewas availabletotheveteran.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DEPENDENT_HAS_INCOME_IND IS 'Childhasincomeis definedasanIndicator Yes/Nothechildhad incomeduringlast calendaryear.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.DEPENDENT_IN_SCHOOL_IND IS 'Dependentchildschool indicatorisdefinedas anindicatorIfthechild isbetweentheagesof18 and23indicateYes/Noif theyattendedschoollast calendaryear';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.LIVED_WITH_VETERAN_IND IS 'Livedwithpatientis definedasanIndicator whetherspouselivedwith patientduringlast calendaryear.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.IS_INCAPABLE_SELF_SUPPORT_IND IS 'DependentChildis PermanentlyIncapableOf Self-Support.Indicator isdefinedasan Indicatorifthechildis overtheageof18and becamepermanently incapableofselfsupport beforereachingtheage of18.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.VERIFIED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.POST_2005_DISPLAY_FORMAT_FLAG IS 'Flagtoindicatethaton thescreen,therecord shouldbeformattedin thepost-2005style.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT_H.CONTRIBUTED_TO_SPOUSE_IND IS 'This is a Yes/No indicator to show whether or not the Veteran contributed to Spousal or Dependent support during the income year.';


CREATE INDEX ADR.FINSTATEH_FINSTATID_NU_I ON ADR.FINANCIAL_STATEMENT_H
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FINSTATEH_PK ON ADR.FINANCIAL_STATEMENT_H
(FINANCIAL_STATEMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINSTATEH_PRSNID_NU_I ON ADR.FINANCIAL_STATEMENT_H
(PERSON_ID, FIN_STMT_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINSTATEH_REFSTATID_NU_I ON ADR.FINANCIAL_STATEMENT_H
(REF_FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_STATEMENT_H FOR ADR.FINANCIAL_STATEMENT_H;


ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_070
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067445
  CHECK ("FINANCIAL_STATEMENT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067446
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067447
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067448
  CHECK ("POST_2005_DISPLAY_FORMAT_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067449
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067450
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067451
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067452
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067453
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FINSTATEH_PK
  PRIMARY KEY
  (FINANCIAL_STATEMENT_H_ID)
  USING INDEX ADR.FINSTATEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H TO ADR_R;

GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_STATEMENT_H TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_STATEMENT_H TO ES_RW;
ALTER TABLE ADR.FINANCIAL_STATEMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_STATEMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_STATEMENT
(
  FINANCIAL_STATEMENT_ID          NUMBER(20),
  PERSON_ID                       NUMBER(20),
  PERSON_RELATION_ID              NUMBER(20),
  REF_FINANCIAL_STATEMENT_ID      NUMBER(20),
  FIN_STMT_MAPPING_TYPE_CODE      VARCHAR2(6 BYTE),
  INCOME_YEAR                     NUMBER(4),
  CONTRIBUTION_TO_SPOUSE_AMT      NUMBER(10,2),
  CONTRIBUTION_TO_DEPENDENT_AMT   NUMBER(10,2),
  DISCLOSED_FINANCIAL_INFO_IND    VARCHAR2(1 BYTE),
  VALID_DEPENDENT_IND             VARCHAR2(1 BYTE),
  SPOUSE_HAS_INCOME_IND           VARCHAR2(1 BYTE),
  MARRIED_CURR_CALENDAR_YEAR_IND  VARCHAR2(1 BYTE),
  MARRIED_PREV_CALENDAR_YEAR_IND  VARCHAR2(1 BYTE),
  DEPENDENT_INCOME_AVAILABLE_IND  VARCHAR2(1 BYTE),
  DEPENDENT_HAS_INCOME_IND        VARCHAR2(1 BYTE),
  DEPENDENT_IN_SCHOOL_IND         VARCHAR2(1 BYTE),
  LIVED_WITH_VETERAN_IND          VARCHAR2(1 BYTE),
  IS_INCAPABLE_SELF_SUPPORT_IND   VARCHAR2(1 BYTE),
  DEPENDENT_CHILDREN_COUNT        NUMBER(3),
  CHILD_SUPPORT_IND               VARCHAR2(1 BYTE),
  VERIFIED_DATE                   DATE,
  REMARKS                         VARCHAR2(4000 BYTE),
  POST_2005_DISPLAY_FORMAT_FLAG   NUMBER(1)     DEFAULT 0,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10),
  CONTRIBUTED_TO_SPOUSE_IND       VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_STATEMENT IS 'The table stores a record of a persons financial status. Expenses, income, assets, and debts are stored in the corresponding child detail tables, and the statement itself contains other financially relevant data, including whether the person has declined to provide income information, has dependent children, pays child support, and is incapable of self support. PERSON_ID Foreign key to the PERSON table. PERSON_RELATION_ID Foreign key to the PERSON_RELATION table. REF_FINANCIAL_STATEMENT_ID Foreign key to the FINANCIAL_STATEMENT table. Self referential constraint. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.REF_FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.FIN_STMT_MAPPING_TYPE_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.INCOME_YEAR IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.CONTRIBUTION_TO_SPOUSE_AMT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.CONTRIBUTION_TO_DEPENDENT_AMT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DISCLOSED_FINANCIAL_INFO_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.VALID_DEPENDENT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.SPOUSE_HAS_INCOME_IND IS 'Indicatorthatapersons spousehashisorherown income.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.MARRIED_CURR_CALENDAR_YEAR_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.MARRIED_PREV_CALENDAR_YEAR_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DEPENDENT_INCOME_AVAILABLE_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DEPENDENT_HAS_INCOME_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DEPENDENT_IN_SCHOOL_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.LIVED_WITH_VETERAN_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.IS_INCAPABLE_SELF_SUPPORT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.DEPENDENT_CHILDREN_COUNT IS 'BR597Numberofdependent childrenisdefinedas thenumberofqualifying dependentchildrenthis veteranhas.Thisnumber isderivedbasedonthe dependentsDOB.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.CHILD_SUPPORT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.VERIFIED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.POST_2005_DISPLAY_FORMAT_FLAG IS 'Flagtoindicatethaton thescreen,therecord shouldbeformattedin thepost-2005style.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.FINANCIAL_STATEMENT.CONTRIBUTED_TO_SPOUSE_IND IS 'This is a Yes/No indicator to show whether or not the Veteran contributed to Spousal or Dependent support during the income year.';


CREATE INDEX ADR.FINSTATE_FINSTATE_FK_I ON ADR.FINANCIAL_STATEMENT
(REF_FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.FINSTATE_PK ON ADR.FINANCIAL_STATEMENT
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINSTATE_PRSNREL_FK_I ON ADR.FINANCIAL_STATEMENT
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FINSTATE_PRSN_FK_I ON ADR.FINANCIAL_STATEMENT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FIN_STD_FINANCIALMAP_FK_I ON ADR.FINANCIAL_STATEMENT
(FIN_STMT_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.FINAN_STATEMENT_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."FINANCIAL_STATEMENT" FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into FINANCIAL_STATEMENT_H
        (
        FINANCIAL_STATEMENT_H_ID,
        FINANCIAL_STATEMENT_ID,
        PERSON_ID,
        PERSON_RELATION_ID,
        REF_FINANCIAL_STATEMENT_ID,
        INCOME_YEAR,
        FIN_STMT_MAPPING_TYPE_CODE,
        CONTRIBUTION_TO_SPOUSE_AMT,
        CONTRIBUTION_TO_DEPENDENT_AMT,
        DISCLOSED_FINANCIAL_INFO_IND,
        SPOUSE_HAS_INCOME_IND,
        MARRIED_CURR_CALENDAR_YEAR_IND,
        MARRIED_PREV_CALENDAR_YEAR_IND,
        DEPENDENT_INCOME_AVAILABLE_IND,
        DEPENDENT_HAS_INCOME_IND,
        DEPENDENT_IN_SCHOOL_IND,
        LIVED_WITH_VETERAN_IND,
        IS_INCAPABLE_SELF_SUPPORT_IND,
        DEPENDENT_CHILDREN_COUNT,
        CHILD_SUPPORT_IND,
        VERIFIED_DATE,
        REMARKS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        VALID_DEPENDENT_IND,
        POST_2005_DISPLAY_FORMAT_FLAG,
        TRANSACTION_TYPE_CODE,
        CONTRIBUTED_TO_SPOUSE_IND
          )
        values
        (
        FINANCIAL_STATEMENT_H_S.nextval,
        :old.FINANCIAL_STATEMENT_ID,
        :old.PERSON_ID,
        :old.PERSON_RELATION_ID,
        :old.REF_FINANCIAL_STATEMENT_ID,
        :old.INCOME_YEAR,
        :old.FIN_STMT_MAPPING_TYPE_CODE,
        :old.CONTRIBUTION_TO_SPOUSE_AMT,
        :old.CONTRIBUTION_TO_DEPENDENT_AMT,
        :old.DISCLOSED_FINANCIAL_INFO_IND,
        :old.SPOUSE_HAS_INCOME_IND,
        :old.MARRIED_CURR_CALENDAR_YEAR_IND,
        :old.MARRIED_PREV_CALENDAR_YEAR_IND,
        :old.DEPENDENT_INCOME_AVAILABLE_IND,
        :old.DEPENDENT_HAS_INCOME_IND,
        :old.DEPENDENT_IN_SCHOOL_IND,
        :old.LIVED_WITH_VETERAN_IND,
        :old.IS_INCAPABLE_SELF_SUPPORT_IND,
        :old.DEPENDENT_CHILDREN_COUNT,
        :old.CHILD_SUPPORT_IND,
        :old.VERIFIED_DATE,
        :old.REMARKS,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        :old.VALID_DEPENDENT_IND,
        :old.POST_2005_DISPLAY_FORMAT_FLAG,
        'D',
        :old.CONTRIBUTED_TO_SPOUSE_IND
        );

    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into FINANCIAL_STATEMENT_H
        (
        FINANCIAL_STATEMENT_H_ID,
        FINANCIAL_STATEMENT_ID,
        PERSON_ID,
        PERSON_RELATION_ID,
        REF_FINANCIAL_STATEMENT_ID,
        INCOME_YEAR,
        FIN_STMT_MAPPING_TYPE_CODE,
        CONTRIBUTION_TO_SPOUSE_AMT,
        CONTRIBUTION_TO_DEPENDENT_AMT,
        DISCLOSED_FINANCIAL_INFO_IND,
        SPOUSE_HAS_INCOME_IND,
        MARRIED_CURR_CALENDAR_YEAR_IND,
        MARRIED_PREV_CALENDAR_YEAR_IND,
        DEPENDENT_INCOME_AVAILABLE_IND,
        DEPENDENT_HAS_INCOME_IND,
        DEPENDENT_IN_SCHOOL_IND,
        LIVED_WITH_VETERAN_IND,
        IS_INCAPABLE_SELF_SUPPORT_IND,
        DEPENDENT_CHILDREN_COUNT,
        CHILD_SUPPORT_IND,
        VERIFIED_DATE,
        REMARKS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        VALID_DEPENDENT_IND,
        POST_2005_DISPLAY_FORMAT_FLAG,
        TRANSACTION_TYPE_CODE,
        CONTRIBUTED_TO_SPOUSE_IND
          )
        values
        (
        FINANCIAL_STATEMENT_H_S.nextval,
        :new.FINANCIAL_STATEMENT_ID,
        :new.PERSON_ID,
        :new.PERSON_RELATION_ID,
        :new.REF_FINANCIAL_STATEMENT_ID,
        :new.INCOME_YEAR,
        :new.FIN_STMT_MAPPING_TYPE_CODE,
        :new.CONTRIBUTION_TO_SPOUSE_AMT,
        :new.CONTRIBUTION_TO_DEPENDENT_AMT,
        :new.DISCLOSED_FINANCIAL_INFO_IND,
        :new.SPOUSE_HAS_INCOME_IND,
        :new.MARRIED_CURR_CALENDAR_YEAR_IND,
        :new.MARRIED_PREV_CALENDAR_YEAR_IND,
        :new.DEPENDENT_INCOME_AVAILABLE_IND,
        :new.DEPENDENT_HAS_INCOME_IND,
        :new.DEPENDENT_IN_SCHOOL_IND,
        :new.LIVED_WITH_VETERAN_IND,
        :new.IS_INCAPABLE_SELF_SUPPORT_IND,
        :new.DEPENDENT_CHILDREN_COUNT,
        :new.CHILD_SUPPORT_IND,
        :new.VERIFIED_DATE,
        :new.REMARKS,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.VALID_DEPENDENT_IND,
        :new.POST_2005_DISPLAY_FORMAT_FLAG,
        mDML,
        :new.CONTRIBUTED_TO_SPOUSE_IND
        );

    end if;

end  FINAN_STATEMENT_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_STATEMENT FOR ADR.FINANCIAL_STATEMENT;


ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT AVCON_1172521913_POST__000
  CHECK (POST_2005_DISPLAY_FORMAT_FLAG BETWEEN 0
AND 0 OR POST_2005_DISPLAY_FORMAT_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066079
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066080
  CHECK ("POST_2005_DISPLAY_FORMAT_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066081
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066082
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066083
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066084
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066085
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FINSTATE_PK
  PRIMARY KEY
  (FINANCIAL_STATEMENT_ID)
  USING INDEX ADR.FINSTATE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_FINSTATE_FK 
  FOREIGN KEY (REF_FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  DISABLE NOVALIDATE,
  CONSTRAINT FINSTATE_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FINSTATE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.FINANCIAL_STATEMENT TO ADREXT;

GRANT SELECT ON ADR.FINANCIAL_STATEMENT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FINANCIAL_STATEMENT TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_STATEMENT TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_STATEMENT TO ES_RW;
ALTER TABLE ADR.INSURANCE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.INSURANCE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.INSURANCE_H
(
  INSURANCE_H_ID                 NUMBER(20),
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE),
  INSURANCE_ID                   NUMBER(20),
  PERSON_ID                      NUMBER(20),
  INSURANCE_RPT_SRC_TYPE_ID      NUMBER(20),
  POLICY_HOLDER_TYPE_ID          NUMBER(20),
  INSURANCE_MAPPING_TYPE_CODE    VARCHAR2(5 BYTE),
  INSURANCE_COMPANY_NAME         VARCHAR2(100 BYTE),
  POLICY_HOLDER_SSN              VARCHAR2(20 BYTE),
  POLICY_HOLDER_NAME             VARCHAR2(50 BYTE),
  POLICY_HOLDER_BIRTH_DATE       DATE,
  POLICY_NUMBER                  VARCHAR2(30 BYTE),
  POLICY_EFFECTIVE_DATE_TXT      VARCHAR2(14 BYTE),
  POLICY_EXPIRATION_DATE_TXT     VARCHAR2(14 BYTE),
  GROUP_NAME                     VARCHAR2(100 BYTE),
  GROUP_NUMBER                   VARCHAR2(30 BYTE),
  NAME_ON_MEDICARE_CARD          VARCHAR2(35 BYTE),
  MEDICARE_CLAIM_NUMBER          VARCHAR2(25 BYTE),
  MEDICARE_PART_A_IND            VARCHAR2(1 BYTE),
  MEDICARE_PART_B_IND            VARCHAR2(1 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  PRE_CERTIFICATION_PENALTY_IND  VARCHAR2(1 BYTE),
  RECORD_MODIFIED_COUNT          NUMBER(10),
  INSURANCE_DATA_LAST_EDIT_USER  VARCHAR2(30 BYTE),
  INSURANCE_DATA_LAST_EDIT_DATE  DATE,
  STD_INSTITUTION_ID             NUMBER(20),
  SITE_UPLOAD_STATUS_TYPE_ID     NUMBER(20),
  SITE_NO_UPLOAD_REASON_TYPE_ID  NUMBER(20),
  INSURANCE_PLAN_TYPE_ID         NUMBER(20),
  PRECRTFN_REQD_IND              VARCHAR2(1 BYTE),
  DEDUCTIBLE_AMOUNT              NUMBER(10,2),
  PERCENTAGE_PAYABLE             NUMBER(3),
  FILING_TIME_LIMIT              VARCHAR2(80 BYTE),
  MEDICARE_PART_A_EFF_DATE_TXT   VARCHAR2(14 BYTE),
  MEDICARE_PART_B_EFF_DATE_TXT   VARCHAR2(14 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.INSURANCE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.INSURANCE_H.INSURANCE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INSURANCE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.INSURANCE_H.INSURANCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INSURANCE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.INSURANCE_H.INSURANCE_RPT_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INSURANCE_H.POLICY_HOLDER_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INSURANCE_H.INSURANCE_MAPPING_TYPE_CODE IS 'Hibernatemapping:used toidentifywhetherthe personsinsuranceis privateorMedicare.';

COMMENT ON COLUMN ADR.INSURANCE_H.INSURANCE_COMPANY_NAME IS 'BR657InsuranceCompany nameisdefined,asthe nameoftheinsurance company.';

COMMENT ON COLUMN ADR.INSURANCE_H.POLICY_HOLDER_SSN IS 'BR707InsuredSSNis definedasthe policyholders(insureds) socialsecuritynumber. Thisonlyneedstobe enteredifitis differentthanthe SubscriberIdnumberand theinsuredisnotthe patient.';

COMMENT ON COLUMN ADR.INSURANCE_H.POLICY_HOLDER_NAME IS 'BR703NameofInsuredis definedasthenameof theindividualforwhich thispolicywasissued. IfthePatients Relationshiptothe InsuredisPatientthen thisnamewilldefaultto thepatientsname.';

COMMENT ON COLUMN ADR.INSURANCE_H.POLICY_HOLDER_BIRTH_DATE IS 'BR705InsuredDOBis definedasthe policyholders(insureds) DateofBirth.Thisis notneededifthepatient isthepolicyholder sincethepatientsDOBis storedelsewhere.';

COMMENT ON COLUMN ADR.INSURANCE_H.POLICY_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INSURANCE_H.POLICY_EFFECTIVE_DATE_TXT IS 'BR697EffectiveDateis definedasthedatethis policywentintoeffect forthispatient.This canbeanimprecisedate andthedatecanbea futuredate.Cannotbe beforeDOB.Cannotbe AfterDOD.';

COMMENT ON COLUMN ADR.INSURANCE_H.POLICY_EXPIRATION_DATE_TXT IS 'BR699Expirationdateis definedasthedatethis insurancepolicycoverage expiresforthispatient. Thiscanbeanimprecise dateandthedatecanbe afuturedate.Thisdate mustbeafterthe effectivedate.';

COMMENT ON COLUMN ADR.INSURANCE_H.GROUP_NAME IS 'BR671GroupNameis definedasthenamethat theinsurancecompany usestoidentifythis plan.';

COMMENT ON COLUMN ADR.INSURANCE_H.GROUP_NUMBER IS 'BR673GroupNumberis definedasthenumberor codewhichtheinsurance companyusestoidentify thisplan.';

COMMENT ON COLUMN ADR.INSURANCE_H.NAME_ON_MEDICARE_CARD IS 'BR721NameonMedicare cardisdefinedasthe Nameexactlyasit appearsontheMedicare Card.';

COMMENT ON COLUMN ADR.INSURANCE_H.MEDICARE_CLAIM_NUMBER IS 'Identifierforaclaim thatwasmadefor coveragethrough Medicare.';

COMMENT ON COLUMN ADR.INSURANCE_H.MEDICARE_PART_A_IND IS 'Indicatesthataperson iscoveredbyMedicare PartAforinpatient hospitalservices, skillednursing facilities,homehealth servicesandhospice care.';

COMMENT ON COLUMN ADR.INSURANCE_H.MEDICARE_PART_B_IND IS 'Indicatesthataperson iscoveredbyMedicare PartBforthecostof physicianservices, outpatienthospital services,medical equipmentandsupplies andotherhealthservices andsupplies.';

COMMENT ON COLUMN ADR.INSURANCE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.INSURANCE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.INSURANCE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.INSURANCE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.INSURANCE_H.PRE_CERTIFICATION_PENALTY_IND IS 'Indicatesthatthereisa penaltyifapersondoes nothavemedicalcare pre-certifiedbythe insurancecompany.';

COMMENT ON COLUMN ADR.INSURANCE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.INSURANCE_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.INSURANCE_H.SITE_UPLOAD_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INSURANCE_H.SITE_NO_UPLOAD_REASON_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INSURANCE_H.INSURANCE_PLAN_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INSURANCE_H.PRECRTFN_REQD_IND IS 'Indicatesthatthe personsinsurance companyrequires precertificationfor certainprocedures.';

COMMENT ON COLUMN ADR.INSURANCE_H.DEDUCTIBLE_AMOUNT IS 'Dollaramountforthe deductiblethepersonis responsibleforaspart ofhisorherinsurance plan.';


CREATE UNIQUE INDEX ADR.INSURANCEH_PK ON ADR.INSURANCE_H
(INSURANCE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.INSURANCEH_PRSNID_NU_I ON ADR.INSURANCE_H
(PERSON_ID, INSURANCE_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM INSURANCE_H FOR ADR.INSURANCE_H;


ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_043
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066781
  CHECK ("INSURANCE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066782
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066783
  CHECK ("INSURANCE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066784
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066785
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066786
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066787
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066788
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066789
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT INSURANCEH_PK
  PRIMARY KEY
  (INSURANCE_H_ID)
  USING INDEX ADR.INSURANCEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.INSURANCE_H TO ADR_R;

GRANT SELECT ON ADR.INSURANCE_H TO ADR_RW;

GRANT SELECT ON ADR.INSURANCE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.INSURANCE_H TO ES_RW;
ALTER TABLE ADR.CONFLICT_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CONFLICT_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CONFLICT_DETAIL_H
(
  CONFLICT_DETAIL_H_ID    NUMBER(20),
  TRANSACTION_TYPE_CODE   VARCHAR2(1 BYTE),
  CONFLICT_DETAIL_ID      NUMBER(20),
  MILITARY_SERVICE_ID     NUMBER(20),
  STD_COMBATLOCATION_ID   NUMBER(20),
  CONFLICT_FROM_DATE_TXT  VARCHAR2(14 BYTE),
  CONFLICT_TO_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY       VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE     DATE,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE    DATE,
  RECORD_MODIFIED_COUNT   NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CONFLICT_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.CONFLICT_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.CONFLICT_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.MILITARY_SERVICE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.CONFLICT_FROM_DATE_TXT IS 'Dateonwhichthe personsparticipationin aparticularconflict began.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.CONFLICT_TO_DATE_TXT IS 'Dateonwhichthe personsparticipationin aparticularconflict ended.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CONFLDTLH_MILSRVC_NU_I ON ADR.CONFLICT_DETAIL_H
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CONFLDTLH_PK ON ADR.CONFLICT_DETAIL_H
(CONFLICT_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CONFLICT_DETAIL_H FOR ADR.CONFLICT_DETAIL_H;


ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_029
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066506
  CHECK ("CONFLICT_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066507
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066508
  CHECK ("CONFLICT_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066509
  CHECK ("MILITARY_SERVICE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066510
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066511
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066512
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066513
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066514
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT CONFLDTLH_PK
  PRIMARY KEY
  (CONFLICT_DETAIL_H_ID)
  USING INDEX ADR.CONFLDTLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CONFLICT_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.CONFLICT_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.CONFLICT_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CONFLICT_DETAIL_H TO ES_RW;
ALTER TABLE ADR.MILITARY_SERVICE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MILITARY_SERVICE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.MILITARY_SERVICE_H
(
  MILITARY_SERVICE_H_ID     NUMBER(20),
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE),
  MILITARY_SERVICE_ID       NUMBER(20),
  PERSON_ID                 NUMBER(20),
  STD_PERIODOFSERVICE_ID    NUMBER(20),
  FILIPINO_VET_DOC_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID        NUMBER(20),
  RECORD_CREATED_DATE       DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE),
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE      DATE,
  RECORD_MODIFIED_COUNT     NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MILITARY_SERVICE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.MILITARY_SERVICE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.MILITARY_SERVICE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.STD_PERIODOFSERVICE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.FILIPINO_VET_DOC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.MILSRVCH_PK ON ADR.MILITARY_SERVICE_H
(MILITARY_SERVICE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVCH_PRSNID_NU_I ON ADR.MILITARY_SERVICE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MILITARY_SERVICE_H FOR ADR.MILITARY_SERVICE_H;


ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_033
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066583
  CHECK ("MILITARY_SERVICE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066584
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066585
  CHECK ("MILITARY_SERVICE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066586
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066587
  CHECK ("STD_INSTITUTION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066588
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066589
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066590
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066591
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066592
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT MILSRVCH_PK
  PRIMARY KEY
  (MILITARY_SERVICE_H_ID)
  USING INDEX ADR.MILSRVCH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MILITARY_SERVICE_H TO ADR_R;

GRANT SELECT ON ADR.MILITARY_SERVICE_H TO ADR_RW;

GRANT SELECT ON ADR.MILITARY_SERVICE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.MILITARY_SERVICE_H TO ES_RW;
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MILITARY_SERVICE_EPISODE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.MILITARY_SERVICE_EPISODE_H
(
  MILITARY_SERVICE_EPISODE_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE),
  MILITARY_SERVICE_EPISODE_ID    NUMBER(20),
  MILITARY_SERVICE_ID            NUMBER(20),
  SERVICECOMPONENTTYPE_ID        NUMBER(20),
  SERVICE_BRANCH_TYPE_ID         NUMBER(20),
  SERVICE_DISCHARGE_TYPE_ID      NUMBER(20),
  MILITARY_SERVICE_NUMBER        VARCHAR2(20 BYTE),
  SERVICE_ENTRY_DATE_TXT         VARCHAR2(14 BYTE),
  SERVICE_SEPARATION_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10),
  NARRATIVE_REASON_TYPE_ID       NUMBER(20),
  NAR_RSN_SEP_SRC                VARCHAR2(10 BYTE),
  PAY_PLAN_TYPE_ID               NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MILITARY_SERVICE_EPISODE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.MILITARY_SERVICE_EPISODE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.MILITARY_SERVICE_EPISODE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.MILITARY_SERVICE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.SERVICE_BRANCH_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.SERVICE_DISCHARGE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.MILITARY_SERVICE_NUMBER IS 'MilitaryServiceNumber isaUniqueidentifier providedtoapersonby thebranchofthe militarywithwhichheor sheserved.Itisdefined astheservicenumber assignedduringthe veteransepisodesof militaryservice.The socialsecuritynumber andservicenumbercanbe thesame.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.SERVICE_ENTRY_DATE_TXT IS 'BR3278ServiceEntryDate isdefinedasthedate theveterancommenced his/herepisodesof militaryservice. ServiceEntryDateis usedtodetermine enrollmentappropriately for24monthsofservice computation.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.SERVICE_SEPARATION_DATE_TXT IS 'BR3281ServiceSeparation Dateisdefinedasthe datetheveteranended his/herepisodesof militaryservice. ServiceSeparationDate isusedtodetermine enrollmentappropriately for24monthsofservice computation.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.NAR_RSN_SEP_SRC IS 'Source of the Narrative Reason for Separation.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.PAY_PLAN_TYPE_ID IS 'Pay plan type';


CREATE INDEX ADR.MILSRVCEPH_MILSRVC_NU_I ON ADR.MILITARY_SERVICE_EPISODE_H
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.MILSRVCEPH_PK ON ADR.MILITARY_SERVICE_EPISODE_H
(MILITARY_SERVICE_EPISODE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MILITARY_SERVICE_EPISODE_H FOR ADR.MILITARY_SERVICE_EPISODE_H;


ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_042
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066765
  CHECK ("MILITARY_SERVICE_EPISODE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066766
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066767
  CHECK ("MILITARY_SERVICE_EPISODE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066768
  CHECK ("MILITARY_SERVICE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066769
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066770
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066771
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066772
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066773
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT MILSRVCEPH_PK
  PRIMARY KEY
  (MILITARY_SERVICE_EPISODE_H_ID)
  USING INDEX ADR.MILSRVCEPH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ADR_R;

GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ADR_RW;

GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ES_RW;
ALTER TABLE ADR.ADDRESS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ADDRESS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ADDRESS_H
(
  ADDRESS_H_ID                   NUMBER(20),
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE),
  ADDRESS_ID                     NUMBER(20),
  PERSON_ID                      NUMBER(20),
  INSURANCE_ID                   NUMBER(20),
  STD_ADDRESSTYPE_ID             NUMBER(20),
  ADDRESS_CHANGE_SRC_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  ADDRESS_INVALID_TYPE_ID        NUMBER(20),
  NCOA_STATUS_TYPE_ID            NUMBER(20),
  NCOA_DELIVERY_TYPE_ID          NUMBER(20),
  NCOA_ZIP_MATCH_TYPE_ID         NUMBER(20),
  NCOA_ZIP_NO_MATCH_TYPE_ID      NUMBER(20),
  NCOA_ADDRESS_CHECK_DATE        DATE,
  ADDRESS_LINE1                  VARCHAR2(100 BYTE),
  ADDRESS_LINE2                  VARCHAR2(100 BYTE),
  ADDRESS_LINE3                  VARCHAR2(100 BYTE),
  CITY                           VARCHAR2(60 BYTE),
  STATE_CODE                     VARCHAR2(50 BYTE),
  COUNTY_CODE                    VARCHAR2(50 BYTE),
  PROVINCE_CODE                  VARCHAR2(50 BYTE),
  ZIP_CODE                       VARCHAR2(20 BYTE),
  ZIP_PLUS_4                     VARCHAR2(10 BYTE),
  POSTAL_CODE                    VARCHAR2(20 BYTE),
  COUNTRY_CODE                   VARCHAR2(50 BYTE),
  ADDRESS_CHANGE_EFFECTIVE_DATE  DATE,
  ADDRESS_INVALIDATED_DATE       DATE,
  ADDRESS_START_DATE_TXT         VARCHAR2(14 BYTE),
  ADDRESS_END_DATE_TXT           VARCHAR2(14 BYTE),
  ADDRESS_PHONE_NUMBER           VARCHAR2(30 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10),
  RECORD_MODIFIED_SRC_NAME       VARCHAR2(30 BYTE),
  PERSON_RELATION_ID             NUMBER(20),
  CASSCERTIFIEDTYPE_ID           NUMBER(20),
  CASS_CERTIFIED_DATE            DATE,
  PURPOSE_OF_USE_TYPE_ID         NUMBER(20),
  SITE_OF_CHANGE_ID              NUMBER(20)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ADDRESS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ADDRESS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.PERSON_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.INSURANCE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.STD_ADDRESSTYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_CHANGE_SRC_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.STD_INSTITUTION_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_INVALID_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_STATUS_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_DELIVERY_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_ZIP_MATCH_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_ZIP_NO_MATCH_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.NCOA_ADDRESS_CHECK_DATE IS 'Dateonwhichanaddress wascheckedagainstNCOA. Dateaddresscheckedwith NCOAisdefinedasa validdatethatissetby theAAConcetheNCOA checkiscompleted.Fortherecordsthatare returnedtoADRviathe NCOAAddresscheckfile- thisdatewillbethe NCOADateChecked containedonthatfile. ForRecordsreturnedvia anaddresschangethis datewillbethedatethe Z05(addresssource= NCOA)datawasuploaded ontheADR.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_LINE1 IS 'BR3Addressline#1is definedasthefreetext formofthenumberand streetorpostofficebox ofamailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_LINE2 IS 'BR5Addressline#2is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_LINE3 IS 'BR7Addressline#3is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS_H.CITY IS 'Cityisdefinedasthe nameofacityusedfor anaddress.';

COMMENT ON COLUMN ADR.ADDRESS_H.STATE_CODE IS 'FIPSSTATECODEis definedasthe2 charactersFIPSState code.TheFIPSStatecode isthefirsttwo charactersofthe5- characterFIPScode.The FIPSstatecodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis Required,itis associatedwiththe Facilityaddressinwhich theprimaryMTwas supplied.Statecodeisdefinesas theuniquecountrycode/ stateabbreviation combinationfoundinthe databasethatbest identifiesthestate';

COMMENT ON COLUMN ADR.ADDRESS_H.COUNTY_CODE IS 'FIPSCountyCODEis definedasthelast3 charactersoftheFIPS state/countycode.The FIPScountycodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis required,itis associatedwiththe Facilityaddressin whichtheprimaryMTwas supplied5-DIGITFIPSCODEis definedasthe2digit statecode+3digit countycode.This5digit FIPScodeisassociated withtheveterans permanentmailing address,Ifnopermanent mailingaddressis supplied,andaMTis required,itis associatedwiththe Facilityaddressin whichtheprimaryMTwas supplied';

COMMENT ON COLUMN ADR.ADDRESS_H.PROVINCE_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS_H.ZIP_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS_H.ZIP_PLUS_4 IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS_H.POSTAL_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS_H.COUNTRY_CODE IS 'Countryisdefinedasthe uniqueidentifier assignedbythe International Organizationof Standardizationfora country.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof addresswentintoeffect.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_INVALIDATED_DATE IS 'Dateonwhichanaddress wasdeterminedtobe invalid.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_START_DATE_TXT IS 'Addressstartdateis definedasthedatean addressbecamevalidto useforaparty.Address startdatecanbea futuredate.Address becomesactive/current onthestartdate.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_END_DATE_TXT IS 'Addressenddateis definedasthedatean addressstoppedbeing usedforaparty.Address enddatecannotbebefore addressstartdate. Addressenddatecanbea futuredate.Address becomesinactiveonthe enddate.';

COMMENT ON COLUMN ADR.ADDRESS_H.ADDRESS_PHONE_NUMBER IS 'Telephone number associated with a temporary address.';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n. history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ADDRESS_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.ADDRESS_H.PERSON_RELATION_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS_H.SITE_OF_CHANGE_ID IS 'Foreign Key on ADR.LOOKUP_TYPE.LOOKUP_TYPE_ID';


CREATE INDEX ADR.ADDRESS_ID_NU_I ON ADR.ADDRESS_H
(ADDRESS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE UNIQUE INDEX ADR.ADDRH_PK ON ADR.ADDRESS_H
(ADDRESS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDRH_PRSNID_NU_I ON ADR.ADDRESS_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ADDRESS_H FOR ADR.ADDRESS_H;


ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_062
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067248
  CHECK ("ADDRESS_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067249
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067250
  CHECK ("ADDRESS_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067251
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067252
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067253
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067254
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067255
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ADDRH_PK
  PRIMARY KEY
  (ADDRESS_H_ID)
  USING INDEX ADR.ADDRH_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT ADDR_H_CASSCERTIFIEDTY_FK 
  FOREIGN KEY (CASSCERTIFIEDTYPE_ID) 
  REFERENCES ADR.CASSCERTIFIEDTYPE (CASSCERTIFIEDTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ADDRESS_H TO ADR_R;

GRANT SELECT ON ADR.ADDRESS_H TO ADR_RW;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ADDRESS_H TO ESCISSEEDINGUSR;

GRANT SELECT ON ADR.ADDRESS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ADDRESS_H TO ES_RW;

GRANT SELECT ON ADR.ADDRESS_H TO PSIM_ADR_R;

GRANT SELECT ON ADR.ADDRESS_H TO VET360USR;
ALTER TABLE ADR.FEE_BASIS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FEE_BASIS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.FEE_BASIS_H
(
  FEE_BASIS_H_ID               NUMBER(20),
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE),
  FEE_BASIS_ID                 NUMBER(20),
  PERSON_ID                    NUMBER(20),
  FEE_BASIS_PROGRAM_TYPE_ID    NUMBER(20),
  FEE_BASIS_TREATMENT_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  AUTHORIZATION_FROM_DATE      DATE,
  AUTHORIZATION_TO_DATE        DATE,
  FEE_BASIS_REPORT_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FEE_BASIS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.FEE_BASIS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.FEE_BASIS_PROGRAM_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.FEE_BASIS_TREATMENT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.FEE_BASIS_H.AUTHORIZATION_FROM_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.AUTHORIZATION_TO_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FEE_BASIS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FEEBASISH_PK ON ADR.FEE_BASIS_H
(FEE_BASIS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBASISH_PRSNID_NU_I ON ADR.FEE_BASIS_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FEE_BASIS_H FOR ADR.FEE_BASIS_H;


ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_030
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066528
  CHECK ("FEE_BASIS_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066529
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066530
  CHECK ("FEE_BASIS_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066531
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066532
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066533
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066534
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066535
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066536
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FEEBASISH_PK
  PRIMARY KEY
  (FEE_BASIS_H_ID)
  USING INDEX ADR.FEEBASISH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FEE_BASIS_H TO ADR_R;

GRANT SELECT ON ADR.FEE_BASIS_H TO ADR_RW;

GRANT SELECT ON ADR.FEE_BASIS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.FEE_BASIS_H TO ES_RW;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CATASTROPHIC_DISABILITY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CATASTROPHIC_DISABILITY_H
(
  CATASTROPHIC_DISABILITY_H_ID    NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  CATASTROPHIC_DISABILITY_ID      NUMBER(20),
  PERSON_ID                       NUMBER(20),
  CAT_DSBLTY_EVAL_MTHD_TYPE_ID    NUMBER(20),
  STD_INSTITUTION_ID              NUMBER(20),
  CLINICAL_APPROVER_NAME          VARCHAR2(100 BYTE),
  CATASTROPHICALLY_DISABLED_IND   VARCHAR2(1 BYTE),
  CAT_DSBLTY_EVALUATION_DATE      DATE,
  DECISION_DATE                   DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10),
  CAT_DSBLTY_REVIEW_REQUESTED_DT  DATE,
  CAT_DSBLTY_REVIEW_INITIATED_DT  DATE,
  CAT_DSBLTY_REVIEW_NOTIFIED_DT   DATE
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CATASTROPHIC_DISABILITY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CATASTROPHIC_DISABILITY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_EVAL_MTHD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CLINICAL_APPROVER_NAME IS 'Nameofthepersonwho madethecatastrophic disabilitydetermination. NameoftheChiefof StafforDesigneemaking theCatastrophically Disableddecision.Free text.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CATASTROPHICALLY_DISABLED_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_EVALUATION_DATE IS 'Reviewdateisdefinedas thedateofthe CatastrophicallyDisabled evaluation.Eitherby medicalrecordorby physicalexam.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.DECISION_DATE IS 'Dateofdecisionis definedasthedatethat theclinical determinationdecision wasmadebytheChiefof Stafforhis/her designee.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_REVIEW_REQUESTED_DT IS 'Dateonwhicharequest toreviewapersons catastrophicdisability determinationwas received';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_REVIEW_INITIATED_DT IS 'Dateonwhich catastrophicdisability reviewwasinitiatedby theChiefofStaffor his/herdesignee.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY_H.CAT_DSBLTY_REVIEW_NOTIFIED_DT IS 'Dateonwhichthe affectedpersonwas notifiedaboutthe resultsofthereview.';


CREATE UNIQUE INDEX ADR.CATDSBLTYH_PK ON ADR.CATASTROPHIC_DISABILITY_H
(CATASTROPHIC_DISABILITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLTYH_PRSNID_NU_I ON ADR.CATASTROPHIC_DISABILITY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CATASTROPHIC_DISABILITY_H FOR ADR.CATASTROPHIC_DISABILITY_H;


ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_014
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066167
  CHECK ("CATASTROPHIC_DISABILITY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066168
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066169
  CHECK ("CATASTROPHIC_DISABILITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066170
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066171
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066172
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066173
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066174
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066175
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT CATDSBLTYH_PK
  PRIMARY KEY
  (CATASTROPHIC_DISABILITY_H_ID)
  USING INDEX ADR.CATDSBLTYH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ADR_R;

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ADR_RW;

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CATASTROPHIC_DISABILITY_H TO ES_RW;
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
(
  FINANCIAL_EXPENSE_DETAIL_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE),
  FINANCIAL_EXPENSE_DETAIL_ID    NUMBER(20),
  FINANCIAL_STATEMENT_ID         NUMBER(20),
  FINANCIAL_EXPENSE_TYPE_ID      NUMBER(20),
  GROSS_AMOUNT                   NUMBER(10,2),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.FINANCIAL_EXPENSE_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.FINANCIAL_EXPENSE_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.FINANCIAL_STATEMENT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.FINANCIAL_EXPENSE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.GROSS_AMOUNT IS 'AssetAmountisdefined asthegrossannual dollaramountassociated withthespecificasset type.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FINANCIAL_EXPENSE_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FINEXPDTLH_PK ON ADR.FINANCIAL_EXPENSE_DETAIL_H
(FINANCIAL_EXPENSE_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_EXPENSE_DETAIL_H FOR ADR.FINANCIAL_EXPENSE_DETAIL_H;


ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_017
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066241
  CHECK ("FINANCIAL_EXPENSE_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066242
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066243
  CHECK ("FINANCIAL_EXPENSE_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066244
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066245
  CHECK ("FINANCIAL_EXPENSE_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066246
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066247
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066248
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066249
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066250
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT FINEXPDTLH_PK
  PRIMARY KEY
  (FINANCIAL_EXPENSE_DETAIL_H_ID)
  USING INDEX ADR.FINEXPDTLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.FINANCIAL_EXPENSE_DETAIL_H TO ES_RW;
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SITE_RECEIVED_ELIGIBILITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.SITE_RECEIVED_ELIGIBILITY
(
  SITE_RECEIVED_ELIGIBILITY_ID    NUMBER(20),
  PERSON_ID                       NUMBER(20),
  ELIGIBILITY_TYPE_ID             NUMBER(20),
  ALLIED_COUNTRY_TYPE_ID          NUMBER(20),
  FEDERAL_AGENCY_TYPE_ID          NUMBER(20),
  STD_INSTITUTION_ID              NUMBER(20),
  ELIGIBILITY_EFFECTIVE_DATE      DATE,
  ELIGIBILITY_EXPIRATION_DATE     DATE,
  ELIGIBILITY_STATUS_DATE         DATE,
  STATUS_DATE_TXT                 VARCHAR2(14 BYTE),
  PRIMARY_SECONDARY_OR_OTHER_IND  VARCHAR2(1 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SITE_RECEIVED_ELIGIBILITY IS 'The SITE_RECEIVED_ELIGIBILITY table stores data about the eligibility of a particular person, when that eligibility was received from a site, as opposed to being processed at the Health Eligibility Center (HEC).';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.SITE_RECEIVED_ELIGIBILITY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ELIGIBILITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ALLIED_COUNTRY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.FEDERAL_AGENCY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ELIGIBILITY_EFFECTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ELIGIBILITY_EXPIRATION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ELIGIBILITY_STATUS_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.STATUS_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.PRIMARY_SECONDARY_OR_OTHER_IND IS 'PrimaryEligibilityCode fieldisdefinedasthe fieldthatcontainsthe veteranscurrent eligibilitycode.The PrimaryEligibilityCode isthecodethatis assignedtotheveteran basedonbenefitfactors capturedontheintake process.Thisisthe codethatisassignedthe highestprecedence.It istheprimaryfactor thatdeterminesthe veteransenrollment priority.Itcanbe usedasasingleentity orinconjunctionwith othereligibilitycodes inthecalculationofthe enrollmentpriority.The PrimaryEligibilitycode alsocontributesin determiningifthe veteranneedstocomplete aMeansTest.SecondaryEligibility Codesisdefinedasthe codesthatareassigned totheveteranbasedon thebenefitfactors capturedontheintake process.Theyare consideredadditional factorsandcombinedwith thePrimaryEligibility Codedeterminethe VeteransEnrollment Priority.Theyalso contributeindetermining iftheveteranneedsto completeaMeansTestThe veteranrecordwill containallthe eligibilitiesunderwhich thispatientmayreceive care.Theprimary eligibilityaswellas allothereligibilities he/sheisentitledtois storedbythesystem.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SITERCVELG_PK ON ADR.SITE_RECEIVED_ELIGIBILITY
(SITE_RECEIVED_ELIGIBILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_PRSN_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_STDINST_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_STD_ALIEDCTRY_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(ALLIED_COUNTRY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_STD_ELGBTYCODE_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(ELIGIBILITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_STD_OTHRAGNCY_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(FEDERAL_AGENCY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SITE_RECEIVED_ELIG_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."SITE_RECEIVED_ELIGIBILITY" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SITE_RECEIVED_ELIGIBILITY_H
		(
		SITE_RECEIVED_ELIGIBILITY_H_ID,
		SITE_RECEIVED_ELIGIBILITY_ID,
		ELIGIBILITY_EFFECTIVE_DATE,
		ELIGIBILITY_EXPIRATION_DATE,
		ELIGIBILITY_STATUS_DATE,
		STATUS_DATE_TXT,
		PRIMARY_SECONDARY_OR_OTHER_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		STD_INSTITUTION_ID,
		ELIGIBILITY_TYPE_ID,
		RECORD_MODIFIED_COUNT,
		ALLIED_COUNTRY_TYPE_ID,
		FEDERAL_AGENCY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ELIGIBILITY_H_S.nextval,
		:old.SITE_RECEIVED_ELIGIBILITY_ID,
		:old.ELIGIBILITY_EFFECTIVE_DATE,
		:old.ELIGIBILITY_EXPIRATION_DATE,
		:old.ELIGIBILITY_STATUS_DATE,
		:old.STATUS_DATE_TXT,
		:old.PRIMARY_SECONDARY_OR_OTHER_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.PERSON_ID,
		:old.STD_INSTITUTION_ID,
		:old.ELIGIBILITY_TYPE_ID,
		:old.RECORD_MODIFIED_COUNT,
		:old.ALLIED_COUNTRY_TYPE_ID,
		:old.FEDERAL_AGENCY_TYPE_ID,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SITE_RECEIVED_ELIGIBILITY_H
		(
		SITE_RECEIVED_ELIGIBILITY_H_ID,
		SITE_RECEIVED_ELIGIBILITY_ID,
		ELIGIBILITY_EFFECTIVE_DATE,
		ELIGIBILITY_EXPIRATION_DATE,
		ELIGIBILITY_STATUS_DATE,
		STATUS_DATE_TXT,
		PRIMARY_SECONDARY_OR_OTHER_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		STD_INSTITUTION_ID,
		ELIGIBILITY_TYPE_ID,
		RECORD_MODIFIED_COUNT,
		ALLIED_COUNTRY_TYPE_ID,
		FEDERAL_AGENCY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ELIGIBILITY_H_S.nextval,
		:new.SITE_RECEIVED_ELIGIBILITY_ID,
		:new.ELIGIBILITY_EFFECTIVE_DATE,
		:new.ELIGIBILITY_EXPIRATION_DATE,
		:new.ELIGIBILITY_STATUS_DATE,
		:new.STATUS_DATE_TXT,
		:new.PRIMARY_SECONDARY_OR_OTHER_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.PERSON_ID,
		:new.STD_INSTITUTION_ID,
		:new.ELIGIBILITY_TYPE_ID,
		:new.RECORD_MODIFIED_COUNT,
		:new.ALLIED_COUNTRY_TYPE_ID,
		:new.FEDERAL_AGENCY_TYPE_ID,
		mDML
		);
	end if;

end SITE_RECEIVED_ELIG_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SITE_RECEIVED_ELIGIBILITY FOR ADR.SITE_RECEIVED_ELIGIBILITY;


ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT AVCON_1172521913_PRIMA_000
  CHECK (PRIMARY_SECONDARY_OR_OTHER_IND IN ('P', 'S', 'O'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066418
  CHECK ("SITE_RECEIVED_ELIGIBILITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066419
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066420
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066421
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066422
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066423
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066424
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SITERCVELG_PK
  PRIMARY KEY
  (SITE_RECEIVED_ELIGIBILITY_ID)
  USING INDEX ADR.SITERCVELG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SITERCVELG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.SITE_RECEIVED_ELIGIBILITY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SITE_RECEIVED_ELIGIBILITY TO ADR_RW;

GRANT SELECT ON ADR.SITE_RECEIVED_ELIGIBILITY TO ES_R;

GRANT INSERT, SELECT ON ADR.SITE_RECEIVED_ELIGIBILITY TO ES_RW;
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RATED_DISABILITY_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.RATED_DISABILITY_DETAIL_H
(
  RATED_DISABILITY_DETAIL_H_ID  NUMBER(20),
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE),
  RATED_DISABILITY_DETAIL_ID    NUMBER(20),
  DIAGNOSTIC_EXTREMITY_TYPE_ID  NUMBER(20),
  STD_DISABILITYCONDITION_ID    NUMBER(20),
  SERVICE_CONNECTED_ID          NUMBER(20),
  RATED_DISABILITY_IS_SC_IND    VARCHAR2(3 BYTE),
  DISABILITY_PERCENT            NUMBER(3),
  DISABILITY_START_DATE         DATE,
  ORIG_EFCTV_RATING_DATE_TXT    VARCHAR2(14 BYTE),
  RATING_DATE_TXT               VARCHAR2(14 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE           DATE,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE          DATE,
  RECORD_MODIFIED_COUNT         NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RATED_DISABILITY_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RATED_DISABILITY_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RATED_DISABILITY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.DIAGNOSTIC_EXTREMITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.STD_DISABILITYCONDITION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.SERVICE_CONNECTED_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RATED_DISABILITY_IS_SC_IND IS 'BR7255Rateddisability SCindicatorisdefined asayes/nocodethat identifiesiftherated disabilityisservice connectedornot.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.DISABILITY_PERCENT IS 'BR1633%Disabilityis definedasthepercentage atwhichtheVArated thisdisabilityforthis patient.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RATING_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RATEDISDTH_PK ON ADR.RATED_DISABILITY_DETAIL_H
(RATED_DISABILITY_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RATEDISDTH_SVCCON_NU_I ON ADR.RATED_DISABILITY_DETAIL_H
(SERVICE_CONNECTED_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RATED_DISABILITY_DETAIL_H FOR ADR.RATED_DISABILITY_DETAIL_H;


ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_041
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066724
  CHECK ("RATED_DISABILITY_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066725
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066726
  CHECK ("RATED_DISABILITY_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066727
  CHECK ("STD_DISABILITYCONDITION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066728
  CHECK ("SERVICE_CONNECTED_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066729
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066730
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066731
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066732
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066733
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT RATEDISDTH_PK
  PRIMARY KEY
  (RATED_DISABILITY_DETAIL_H_ID)
  USING INDEX ADR.RATEDISDTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.RATED_DISABILITY_DETAIL_H TO ES_RW;
ALTER TABLE ADR.PERSON_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_H
(
  PERSON_H_ID                     NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  PERSON_ID                       NUMBER(20),
  VPID_ID                         NUMBER(20),
  VPID_VALUE                      VARCHAR2(30 BYTE),
  HEC_IEN                         VARCHAR2(20 BYTE),
  CLAIM_FOLDER_NUMBER             VARCHAR2(20 BYTE),
  EDUCATIONAL_DEGREE              VARCHAR2(30 BYTE),
  REMARKS                         VARCHAR2(4000 BYTE),
  SENSITIVITY_IND                 VARCHAR2(1 BYTE) DEFAULT '0',
  SENSITIVITY_FLAG_SET_BY         VARCHAR2(30 BYTE),
  SENSITIVITY_FLAG_SET_DATE       DATE,
  VETERAN_IND                     VARCHAR2(1 BYTE) DEFAULT '0',
  DEATH_DATE_TXT                  VARCHAR2(14 BYTE),
  DEATH_REPORTED_DATE             DATE,
  LAZARUS_DATE_TXT                VARCHAR2(14 BYTE),
  USER_ENROLEE_SITE_ID            NUMBER(20),
  USER_ENROLEE_THROUGH_YEAR       NUMBER(4),
  DISABILITY_DISCHARGE_IND        VARCHAR2(1 BYTE),
  COMBAT_VET_ELIGIBILITY_END_DT   DATE,
  STD_PROGRAMOFSTUDY_ID           NUMBER(20),
  STD_MARITALSTATUS_ID            NUMBER(20),
  STD_RELIGION_ID                 NUMBER(20),
  MILITARY_DSBLTY_RETIREMENT_IND  VARCHAR2(1 BYTE),
  DEATH_REPORTING_SITE_ID         NUMBER(20),
  CLAIM_FOLDER_LOCATION_SITE_ID   NUMBER(20),
  DEATH_NOTIFICATION_SRC_TYPE_ID  NUMBER(20),
  VA_ASSOCIATE_TITLE              VARCHAR2(50 BYTE),
  VA_SIGNATURE_BLOCK_PRINT_NAME   VARCHAR2(40 BYTE),
  VA_SIGNATURE_BLOCK_TITLE        VARCHAR2(50 BYTE),
  VA_LAST_TRAINING_YEAR           VARCHAR2(4 BYTE),
  VAMC_MAIL_CODE                  VARCHAR2(10 BYTE),
  VA_ROOM_NUMBER                  VARCHAR2(30 BYTE),
  VA_TERMINATION_REASON_TEXT      VARCHAR2(45 BYTE),
  VA_TERMINATION_DATE             DATE,
  DEMOGRAPHIC_UPDATE_EVENT_DATE   DATE,
  PREFERRED_SITE_ID               NUMBER(20),
  WAS_PRISONER_OF_WAR_IND         VARCHAR2(1 BYTE),
  EE_MIGRATED_IND                 VARCHAR2(1 BYTE),
  APPOINTMENT_WAS_REQUESTED_IND   VARCHAR2(1 BYTE),
  APPOINTMENT_REQUESTED_DATE      DATE,
  SENSITIVITY_FLAG_SET_SRC_ID     NUMBER(20),
  SENSITIVITY_FLAG_SET_SITE_ID    NUMBER(20),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10),
  RECORD_MODIFIED_SITE_ID         NUMBER(20),
  RECORD_MODIFIED_SRC_NAME        VARCHAR2(30 BYTE),
  VOA_IND                         CHAR(1 BYTE),
  STD_MILITARYSVCQRYSTAT_ID       NUMBER(20),
  DENTAL_CLASS2_IND               VARCHAR2(1 BYTE),
  DENTAL_CLS2_APP_BEF_DUE_DATE    DATE,
  HISTORY_CREATED_DATE            DATE,
  DOD_VERIFIED_IND                VARCHAR2(1 BYTE),
  DEATH_REPORTED_BY               VARCHAR2(30 BYTE),
  MAIL_STOP_REASON                VARCHAR2(200 BYTE),
  STOP_COM_IND                    VARCHAR2(1 BYTE),
  STOP_COM_RSN_TYPE_ID            NUMBER(20),
  SUP_DOC_LOOKUP_TYPE_ID          NUMBER(20),
  ACTIVE_DUTY_IND                 VARCHAR2(1 BYTE),
  ACTIVE_DUTY_DATE                DATE
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.PERSON_H.PERSON_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERSON_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_H.VPID_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VPID_VALUE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.HEC_IEN IS 'Uniqueidentifierusedin thelegacyHECsystem. RecordsfromtheADR,the HECLegacysystemand alsothecurrentIVM systemcanbetied togetherusingthis number.';

COMMENT ON COLUMN ADR.PERSON_H.CLAIM_FOLDER_NUMBER IS 'Claimfoldernumberas suppliedbyVBA.Usually thesameasthepersons socialsecuritynumber.';

COMMENT ON COLUMN ADR.PERSON_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_IND IS 'Patientsensitivityflag fromAACisdefinedasan indicationthatthis veteranrecordisa sensitiverecordandonly thosewithabusiness purposeshouldviewthe relatedinformation.';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_FLAG_SET_BY IS 'BR7316Sensitivity assignedbyisdefinedas thepersonwhosetthe recordtosensitive.';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_FLAG_SET_DATE IS 'BR7318Date/Time sensitivityflagsetis definedasthetimestamp associatedwiththe sensitivityflag.';

COMMENT ON COLUMN ADR.PERSON_H.VETERAN_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.USER_ENROLEE_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.USER_ENROLEE_THROUGH_YEAR IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.DISABILITY_DISCHARGE_IND IS 'Indicatesifbeneficiary wasretiredfromtheU.S. ArmedForcesduetoa disabilityincurredwhile serving.';

COMMENT ON COLUMN ADR.PERSON_H.STD_PROGRAMOFSTUDY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.STD_MARITALSTATUS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.STD_RELIGION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.MILITARY_DSBLTY_RETIREMENT_IND IS 'Indicatesifbeneficiary isreceivingMilitary Disability';

COMMENT ON COLUMN ADR.PERSON_H.DEATH_REPORTING_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.CLAIM_FOLDER_LOCATION_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.DEATH_NOTIFICATION_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_ASSOCIATE_TITLE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_SIGNATURE_BLOCK_PRINT_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_SIGNATURE_BLOCK_TITLE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_LAST_TRAINING_YEAR IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VAMC_MAIL_CODE IS 'VAHOSPITALSERVICE NUMBER,I.E.116AFOR PSYCHIATRY,116BFOR PSYCHOLOGY,ETC';

COMMENT ON COLUMN ADR.PERSON_H.VA_ROOM_NUMBER IS 'Thisistheroomnumber assignedtotheperson.';

COMMENT ON COLUMN ADR.PERSON_H.VA_TERMINATION_REASON_TEXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_TERMINATION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.PREFERRED_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.WAS_PRISONER_OF_WAR_IND IS 'BR2376PHOnlyIndicator isdefinedasthe indicatorthatidentifies theveteransinthePH Registryfilewhoarenot currentlyintheHECEDB asenrolleeswithother eligibility/enrollment datareceivingVHA services.Oncethe veteranrecordiscreated intheEDBthenthisflag isremoved';

COMMENT ON COLUMN ADR.PERSON_H.APPOINTMENT_WAS_REQUESTED_IND IS 'Indicatesifbeneficiary wasretiredfromtheU.S. ArmedForcesduetoa disabilityincurredwhile serving.';

COMMENT ON COLUMN ADR.PERSON_H.APPOINTMENT_REQUESTED_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_FLAG_SET_SRC_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_FLAG_SET_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.PERSON_H.VOA_IND IS 'Veterans Online Application indicator';

COMMENT ON COLUMN ADR.PERSON_H.DENTAL_CLASS2_IND IS 'Derived from the VBA DD214 Dental Indicator. The DD214 Dental Indicator specifies whether or not the Veteran received dental treatment at service separation. The Dental Indicator is translated from the DD214 Indicator to state whether or not the Veteran is eligible for dental services.
  2  Null means not initialized
  3  0 means `NO
  4  1 means `YES';

COMMENT ON COLUMN ADR.PERSON_H.DENTAL_CLS2_APP_BEF_DUE_DATE IS 'Null means not initialized
  2  0 means `NO
  3  1 means `YES';

COMMENT ON COLUMN ADR.PERSON_H.ACTIVE_DUTY_IND IS 'indicate whether vet is in active duty. It will set by EMIS or ES.';

COMMENT ON COLUMN ADR.PERSON_H.ACTIVE_DUTY_DATE IS 'Active duty indicator last updated time.';


CREATE UNIQUE INDEX ADR.PRSNH_PK ON ADR.PERSON_H
(PERSON_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNH_PRSNID_NU_I ON ADR.PERSON_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_H FOR ADR.PERSON_H;


ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_009
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066039
  CHECK ("PERSON_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066040
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066041
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066043
  CHECK ("VPID_VALUE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066044
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066045
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066046
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066047
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066048
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT PRSNH_PK
  PRIMARY KEY
  (PERSON_H_ID)
  USING INDEX ADR.PRSNH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_H TO ADR_R;

GRANT SELECT ON ADR.PERSON_H TO ADR_RW;

GRANT SELECT ON ADR.PERSON_H TO CARUSR_R;

GRANT SELECT ON ADR.PERSON_H TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_H TO ES_RW;

GRANT SELECT ON ADR.PERSON_H TO PSIM_ADR_R;

GRANT SELECT ON ADR.PERSON_H TO VET360USR;

GRANT SELECT ON ADR.PERSON_H TO VHAISPSTALLP;
ALTER TABLE ADR.REGISTRY_TRAIT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.REGISTRY_TRAIT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.REGISTRY_TRAIT_H
(
  REGISTRY_TRAIT_H_ID    NUMBER(20),
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE),
  REGISTRY_TRAIT_ID      NUMBER(20),
  REGISTRY_TYPE_ID       NUMBER(20),
  SSN                    VARCHAR2(20 BYTE),
  PREFIX                 VARCHAR2(12 BYTE),
  FIRST_NAME             VARCHAR2(30 BYTE),
  MIDDLE_NAME            VARCHAR2(30 BYTE),
  LAST_NAME              VARCHAR2(40 BYTE),
  SUFFIX                 VARCHAR2(12 BYTE),
  EDUCATIONAL_DEGREE     VARCHAR2(30 BYTE),
  DEATH_DATE_TXT         VARCHAR2(14 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE    DATE,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  RECORD_MODIFIED_COUNT  NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.REGISTRY_TRAIT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.REGISTRY_TRAIT_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.REGISTRY_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.SSN IS 'Theverifiedsocial securitynumberthathas beenassignedbythe SocialSecurityAgencyto theperson.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.FIRST_NAME IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.MIDDLE_NAME IS 'BR7325Representative middleNameisdefinedas themiddlenameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.LAST_NAME IS 'BR7321Representative LastNameisdefinedas thefamilynameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.REGTRAITH_PK ON ADR.REGISTRY_TRAIT_H
(REGISTRY_TRAIT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.REGTRAITH_REGTRAIT_NU_I ON ADR.REGISTRY_TRAIT_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_TRAIT_H FOR ADR.REGISTRY_TRAIT_H;


ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_040
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066710
  CHECK ("REGISTRY_TRAIT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066711
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066712
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066713
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066714
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066715
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066716
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT REGTRAITH_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_H_ID)
  USING INDEX ADR.REGTRAITH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.REGISTRY_TRAIT_H TO ADR_R;

GRANT SELECT ON ADR.REGISTRY_TRAIT_H TO ADR_RW;

GRANT SELECT ON ADR.REGISTRY_TRAIT_H TO ES_R;

GRANT INSERT, SELECT ON ADR.REGISTRY_TRAIT_H TO ES_RW;
ALTER TABLE ADR.PERSON_ETHNICITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_ETHNICITY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_ETHNICITY_H
(
  PERSON_ETHNICITY_H_ID      NUMBER(20),
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE),
  PERSON_ETHNICITY_ID        NUMBER(20),
  PERSON_ID                  NUMBER(20),
  STD_ETHNICITY_ID           NUMBER(20),
  COLLECTION_METHOD_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE        DATE,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE       DATE,
  RECORD_MODIFIED_COUNT      NUMBER(10),
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_ETHNICITY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.PERSON_ETHNICITY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.PERSON_ETHNICITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.STD_ETHNICITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.COLLECTION_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNETNCTH_PK ON ADR.PERSON_ETHNICITY_H
(PERSON_ETHNICITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTH_PRSNID_NU_I ON ADR.PERSON_ETHNICITY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_ETHNICITY_H FOR ADR.PERSON_ETHNICITY_H;


ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_003
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065931
  CHECK ("PERSON_ETHNICITY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065932
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065933
  CHECK ("PERSON_ETHNICITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065934
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065935
  CHECK ("STD_ETHNICITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065936
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065937
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065938
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065939
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0065940
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT PRSNETNCTH_PK
  PRIMARY KEY
  (PERSON_ETHNICITY_H_ID)
  USING INDEX ADR.PRSNETNCTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO ADREXT;

GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO ADR_R;

GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO ADR_RW;

GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_ETHNICITY_H TO ES_RW;

GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO PSIM_ADR_R;
ALTER TABLE ADR.REGISTRY_TRAIT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.REGISTRY_TRAIT CASCADE CONSTRAINTS;

CREATE TABLE ADR.REGISTRY_TRAIT
(
  REGISTRY_TRAIT_ID      NUMBER(20),
  REGISTRY_TYPE_ID       NUMBER(20),
  SSN                    VARCHAR2(20 BYTE),
  PREFIX                 VARCHAR2(12 BYTE),
  FIRST_NAME             VARCHAR2(30 BYTE),
  MIDDLE_NAME            VARCHAR2(30 BYTE),
  LAST_NAME              VARCHAR2(40 BYTE),
  SUFFIX                 VARCHAR2(12 BYTE),
  EDUCATIONAL_DEGREE     VARCHAR2(30 BYTE),
  DEATH_DATE_TXT         VARCHAR2(14 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE    DATE,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  RECORD_MODIFIED_COUNT  NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.REGISTRY_TRAIT IS 'Used to facilitate quick searching of the Registry information. This table contains a foreign key to the Registry type table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.REGISTRY_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.SSN IS 'Theverifiedsocial securitynumberthathas beenassignedbythe SocialSecurityAgencyto theperson.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.FIRST_NAME IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.MIDDLE_NAME IS 'BR7325Representative middleNameisdefinedas themiddlenameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.LAST_NAME IS 'BR7321Representative LastNameisdefinedas thefamilynameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.REGTRAIT_FNAME_FB_I ON ADR.REGISTRY_TRAIT
(UPPER("FIRST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );

CREATE INDEX ADR.REGTRAIT_LNAME_FB_I ON ADR.REGISTRY_TRAIT
(UPPER("LAST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );

CREATE UNIQUE INDEX ADR.REGTRAIT_PK ON ADR.REGISTRY_TRAIT
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.REGTRAIT_SSN_NU_I ON ADR.REGISTRY_TRAIT
(SSN)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.REGTRAIT_STD_REGTYPE_FK_I ON ADR.REGISTRY_TRAIT
(REGISTRY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.REGISTRY_TRAIT_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."REGISTRY_TRAIT" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into REGISTRY_TRAIT_H
		(
 		 REGISTRY_TRAIT_H_ID
 		,REGISTRY_TRAIT_ID
 		,REGISTRY_TYPE_ID
 		,SSN
		,FIRST_NAME
 		,LAST_NAME
		,PREFIX
		,MIDDLE_NAME
		,SUFFIX
		,EDUCATIONAL_DEGREE
		,DEATH_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_H_S.nextval,
		:old.REGISTRY_TRAIT_ID,
		:old.REGISTRY_TYPE_ID,
		:old.SSN,
		:old.FIRST_NAME,
		:old.LAST_NAME,
		:old.PREFIX,
		:old.MIDDLE_NAME,
		:old.SUFFIX,
		:old.EDUCATIONAL_DEGREE,
		:old.DEATH_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into REGISTRY_TRAIT_H
		(
 		 REGISTRY_TRAIT_H_ID
 		,REGISTRY_TRAIT_ID
 		,REGISTRY_TYPE_ID
 		,SSN
		,FIRST_NAME
 		,LAST_NAME
		,PREFIX
		,MIDDLE_NAME
		,SUFFIX
		,EDUCATIONAL_DEGREE
		,DEATH_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_H_S.nextval,
		:new.REGISTRY_TRAIT_ID,
		:new.REGISTRY_TYPE_ID,
		:new.SSN,
		:new.FIRST_NAME,
		:new.LAST_NAME,
		:new.PREFIX,
		:new.MIDDLE_NAME,
		:new.SUFFIX,
		:new.EDUCATIONAL_DEGREE,
		:new.DEATH_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end REGISTRY_TRAIT_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_TRAIT FOR ADR.REGISTRY_TRAIT;


ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT SYS_C0066600
  CHECK ("REGISTRY_TRAIT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066601
  CHECK ("REGISTRY_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066602
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066603
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066604
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066605
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066606
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT REGTRAIT_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_ID)
  USING INDEX ADR.REGTRAIT_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.REGISTRY_TRAIT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.REGISTRY_TRAIT TO ADR_RW;

GRANT SELECT ON ADR.REGISTRY_TRAIT TO ES_R;

GRANT INSERT, SELECT ON ADR.REGISTRY_TRAIT TO ES_RW;
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RATED_DISABILITY_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.RATED_DISABILITY_DETAIL
(
  RATED_DISABILITY_DETAIL_ID    NUMBER(20),
  DIAGNOSTIC_EXTREMITY_TYPE_ID  NUMBER(20),
  STD_DISABILITYCONDITION_ID    NUMBER(20),
  SERVICE_CONNECTED_ID          NUMBER(20),
  RATED_DISABILITY_IS_SC_IND    VARCHAR2(3 BYTE),
  DISABILITY_PERCENT            NUMBER(3),
  DISABILITY_START_DATE         DATE,
  ORIG_EFCTV_RATING_DATE_TXT    VARCHAR2(14 BYTE),
  RATING_DATE_TXT               VARCHAR2(14 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE           DATE,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE          DATE,
  RECORD_MODIFIED_COUNT         NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RATED_DISABILITY_DETAIL IS 'The table stores information about a persons disability or disabilities, including whether the disability is service connected, the percentage disabled the person is, the effective dates, and the code associated with the disability. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RATED_DISABILITY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.DIAGNOSTIC_EXTREMITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.STD_DISABILITYCONDITION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.SERVICE_CONNECTED_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RATED_DISABILITY_IS_SC_IND IS 'BR7255Rateddisability SCindicatorisdefined asayes/nocodethat identifiesiftherated disabilityisservice connectedornot.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.DISABILITY_PERCENT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.DISABILITY_START_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RATING_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RATEDISDET_PK ON ADR.RATED_DISABILITY_DETAIL
(RATED_DISABILITY_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RATEDISDET_STDDSBLCND_FK_I ON ADR.RATED_DISABILITY_DETAIL
(STD_DISABILITYCONDITION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RATEDISDET_SVCCON_FK_I ON ADR.RATED_DISABILITY_DETAIL
(SERVICE_CONNECTED_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RATEDISDET_XTRMTY_FK_I ON ADR.RATED_DISABILITY_DETAIL
(DIAGNOSTIC_EXTREMITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.RATED_DSBLTY_DET_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."RATED_DISABILITY_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into RATED_DISABILITY_DETAIL_H
		(
		RATED_DISABILITY_DETAIL_H_ID,
		RATED_DISABILITY_DETAIL_ID,
		RATED_DISABILITY_IS_SC_IND,
		DISABILITY_PERCENT,
		DISABILITY_START_DATE,
		ORIG_EFCTV_RATING_DATE_TXT,
		RATING_DATE_TXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_DISABILITYCONDITION_ID,
		SERVICE_CONNECTED_ID,
		RECORD_MODIFIED_COUNT,
		DIAGNOSTIC_EXTREMITY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		RATED_DISABILITY_DETAIL_H_S.nextval,
		:old.RATED_DISABILITY_DETAIL_ID,
		:old.RATED_DISABILITY_IS_SC_IND,
		:old.DISABILITY_PERCENT,
		:old.DISABILITY_START_DATE,
		:old.ORIG_EFCTV_RATING_DATE_TXT,
		:old.RATING_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.STD_DISABILITYCONDITION_ID,
		:old.SERVICE_CONNECTED_ID,
		:old.RECORD_MODIFIED_COUNT,
		:old.DIAGNOSTIC_EXTREMITY_TYPE_ID,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into RATED_DISABILITY_DETAIL_H
		(
		RATED_DISABILITY_DETAIL_H_ID,
		RATED_DISABILITY_DETAIL_ID,
		RATED_DISABILITY_IS_SC_IND,
		DISABILITY_PERCENT,
		DISABILITY_START_DATE,
		ORIG_EFCTV_RATING_DATE_TXT,
		RATING_DATE_TXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_DISABILITYCONDITION_ID,
		SERVICE_CONNECTED_ID,
		RECORD_MODIFIED_COUNT,
		DIAGNOSTIC_EXTREMITY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		RATED_DISABILITY_DETAIL_H_S.nextval,
		:new.RATED_DISABILITY_DETAIL_ID,
		:new.RATED_DISABILITY_IS_SC_IND,
		:new.DISABILITY_PERCENT,
		:new.DISABILITY_START_DATE,
		:new.ORIG_EFCTV_RATING_DATE_TXT,
		:new.RATING_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.STD_DISABILITYCONDITION_ID,
		:new.SERVICE_CONNECTED_ID,
		:new.RECORD_MODIFIED_COUNT,
		:new.DIAGNOSTIC_EXTREMITY_TYPE_ID,
		mDML
		);
	end if;

end RATED_DSBLTY_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM RATED_DISABILITY_DETAIL FOR ADR.RATED_DISABILITY_DETAIL;


ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT SYS_C0066150
  CHECK ("RATED_DISABILITY_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066151
  CHECK ("STD_DISABILITYCONDITION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066152
  CHECK ("SERVICE_CONNECTED_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066153
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066154
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066155
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066156
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066157
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT RATEDISDET_PK
  PRIMARY KEY
  (RATED_DISABILITY_DETAIL_ID)
  USING INDEX ADR.RATEDISDET_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT RATEDISDET_SVCCON_FK 
  FOREIGN KEY (SERVICE_CONNECTED_ID) 
  REFERENCES ADR.SERVICE_CONNECTED (SERVICE_CONNECTED_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RATED_DISABILITY_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.RATED_DISABILITY_DETAIL TO ES_RW;
ALTER TABLE ADR.IRS_TRANSMISSION_DATA
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IRS_TRANSMISSION_DATA CASCADE CONSTRAINTS;

CREATE TABLE ADR.IRS_TRANSMISSION_DATA
(
  IRS_TRANSMISSION_DATA_ID  NUMBER(20)          NOT NULL,
  IRS_TRANSMISSION_LOG_ID   NUMBER(20)          NOT NULL,
  REQUEST_DATA              CLOB,
  RESPONSE_DATA             CLOB,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL
)
LOB (REQUEST_DATA) STORE AS SECUREFILE (
  TABLESPACE  L_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  COMPRESS    MEDIUM
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128M
                  NEXT             128M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
LOB (RESPONSE_DATA) STORE AS SECUREFILE (
  TABLESPACE  L_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  COMPRESS    MEDIUM
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128M
                  NEXT             128M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IRS_TRANSMISSION_DATA IS 'This table contains request and response raw data attachments sent/received in IRS transmissions.';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_DATA.IRS_TRANSMISSION_DATA_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_DATA.IRS_TRANSMISSION_LOG_ID IS 'FK to ADR.IRS_TRANSMISSION_LOG.IRS_TRANSMISSION_LOG_ID';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_DATA.REQUEST_DATA IS 'Batch request transmission data file attachment submitted to the IRS';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_DATA.RESPONSE_DATA IS 'Response data file attachment containing errors received from IRS acknowledgment processing';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_DATA.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_DATA.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_DATA.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_DATA.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_DATA.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';


CREATE INDEX ADR.IRSTRNSDAT_IRSTRNSLG_FK_I ON ADR.IRS_TRANSMISSION_DATA
(IRS_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.IRS_TRANSMISSION_DATA_ID_PK ON ADR.IRS_TRANSMISSION_DATA
(IRS_TRANSMISSION_DATA_ID)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM IRS_TRANSMISSION_DATA FOR ADR.IRS_TRANSMISSION_DATA;


ALTER TABLE ADR.IRS_TRANSMISSION_DATA ADD (
  CONSTRAINT IRS_TRANSMISSION_DATA_ID_PK
  PRIMARY KEY
  (IRS_TRANSMISSION_DATA_ID)
  USING INDEX ADR.IRS_TRANSMISSION_DATA_ID_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.IRS_TRANSMISSION_DATA ADD (
  CONSTRAINT IRSTRNSLOG_IRSTRNSDATA_FK 
  FOREIGN KEY (IRS_TRANSMISSION_LOG_ID) 
  REFERENCES ADR.IRS_TRANSMISSION_LOG (IRS_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.IRS_TRANSMISSION_DATA TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IRS_TRANSMISSION_DATA TO ADR_RW;

GRANT SELECT ON ADR.IRS_TRANSMISSION_DATA TO ES_R;

GRANT INSERT, SELECT ON ADR.IRS_TRANSMISSION_DATA TO ES_RW;
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ENROLLMENT_DETERMINATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.ENROLLMENT_DETERMINATION
(
  ENROLLMENT_DETERMINATION_ID  NUMBER(20),
  PERSON_ID                    NUMBER(20),
  EGT_SETTING_ID               NUMBER(20),
  STD_ENROLLMENTSTATUS_ID      NUMBER(20),
  ENROLLMENT_DATA_SRC_TYPE_ID  NUMBER(20),
  PRIORITY_GROUP_TYPE_ID       NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID   NUMBER(20),
  APPLICATION_SITE_ID          NUMBER(20),
  ENROLLMENT_APPLICATION_DATE  DATE,
  ENROLLMENT_START_DATE        DATE,
  ENROLLMENT_END_DATE          DATE,
  CHANGE_EFFECTIVE_DATE        DATE,
  ENROLLMENT_OVERRIDDEN_FLAG   NUMBER(1)        DEFAULT 0,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10),
  STD_ENROLLMENTPRIORGRP_ID    NUMBER(20),
  STD_ENROLLMENTPRIORSGRP_ID   NUMBER(20),
  CLOSE_APL_RSN_TYPE_ID        NUMBER(20),
  CLOSE_APP_REMARKS            VARCHAR2(4000 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ENROLLMENT_DETERMINATION IS 'The table stores data about a persons enrollment into the VHA Healthcare System, including information about when the application was submitted, when the enrollment started and ended, what priority group the person was in. There is also status and change information, as well as an indicator to show if the enrollment has been overridden. PERSON_ID Foreign key to the PERSON table. ENROLLMENT_STATUS_TYPE_ID Foreign key to the ENROLLMENT_STATUS_TYPE table. Indicates the status of a persons enrollment (for example, Verified, Rejected). ENROLLMENT_DATA_SRC_TYPE_ID Foreign key to the ENROLLMENT_DATA_SRC_TYPE table. Indicates the source of data for a persons enrollment (for example, HEC, VAMC). PRIORITY_GROUP_TYPE_ID Foreign key to the PRIORITY_GROUP_TYPE table. Indicates the Enrollment Priority Group the person falls into (Group 1 through Group 8). PRIORITY_SUB_GROUP_TYPE_ID Foreign key to the PRIORITY_SUB_GROUP_TYPE table. Indicates the Enrollment Priority Group the person falls into (for example, a, c). APPLICATION_SITE_ID Foreign key to the STD_INSTITUTION table. Indicates the site at which the application was initiated. EGT_SETTING_ID Foreign key to the EGT_SETTING table. Indicates the current EGT setting. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_DETERMINATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_DATA_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.APPLICATION_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_APPLICATION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_START_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_END_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof emailaddresswentinto effect.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.ENROLLMENT_OVERRIDDEN_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.ENROLLMENT_DETERMINATION.CLOSE_APP_REMARKS IS 'Text including any additional information for the action on close application';


CREATE INDEX ADR.ENRLMNTDET_EGTSETTING_FK_I ON ADR.ENROLLMENT_DETERMINATION
(EGT_SETTING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ENRLMNTDET_PK ON ADR.ENROLLMENT_DETERMINATION
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_PRSN_FK_I ON ADR.ENROLLMENT_DETERMINATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STDINST_FK_I ON ADR.ENROLLMENT_DETERMINATION
(APPLICATION_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLPGRP_FK_I ON ADR.ENROLLMENT_DETERMINATION
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLPSGRP_FK_I ON ADR.ENROLLMENT_DETERMINATION
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLSRC_FK_I ON ADR.ENROLLMENT_DETERMINATION
(ENROLLMENT_DATA_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLSTAT_FK_I ON ADR.ENROLLMENT_DETERMINATION
(STD_ENROLLMENTSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ENROLLMENT_DETER_AUDIR_TRGR
    AFTER UPDATE OR DELETE OR INSERT
    ON ADR.ENROLLMENT_DETERMINATION
    FOR EACH ROW
DECLARE
    Mdml   CHAR (1);
BEGIN
    IF DELETING
    THEN
        INSERT INTO ADR.Enrollment_Determination_H (Enrollment_determination_h_id,
                                                    Enrollment_determination_id,
                                                    Person_id,
                                                    Std_enrollmentstatus_id,
                                                    Enrollment_data_src_type_id,
                                                    Priority_group_type_id,
                                                    Priority_sub_group_type_id,
                                                    Application_site_id,
                                                    Egt_setting_id,
                                                    Enrollment_application_date,
                                                    Enrollment_start_date,
                                                    Enrollment_end_date,
                                                    Change_effective_date,
                                                    Enrollment_overridden_flag,
                                                    Record_created_by,
                                                    Record_created_date,
                                                    Record_modified_by,
                                                    Record_modified_date,
                                                    Record_modified_count,
                                                    Transaction_type_code,
                                                    Std_enrollmentpriorgrp_id,
                                                    Std_enrollmentpriorsgrp_id,
                                                    CLOSE_APL_RSN_TYPE_ID,
                                                         CLOSE_APP_REMARKS
)
             VALUES (ADR.Enrollment_determination_h_s.NEXTVAL,
                     :OLD.Enrollment_determination_id,
                     :OLD.Person_id,
                     :OLD.Std_enrollmentstatus_id,
                     :OLD.Enrollment_data_src_type_id,
                     :OLD.Priority_group_type_id,
                     :OLD.Priority_sub_group_type_id,
                     :OLD.Application_site_id,
                     :OLD.Egt_setting_id,
                     :OLD.Enrollment_application_date,
                     :OLD.Enrollment_start_date,
                     :OLD.Enrollment_end_date,
                     :OLD.Change_effective_date,
                     :OLD.Enrollment_overridden_flag,
                     :OLD.Record_created_by,
                     :OLD.Record_created_date,
                     :OLD.Record_modified_by,
                     :OLD.Record_modified_date,
                     :OLD.Record_modified_count,
                     'D',
                     :OLD.Std_enrollmentpriorgrp_id,
                     :OLD.Std_enrollmentpriorsgrp_id,
                     :OLD.CLOSE_APL_RSN_TYPE_ID,
                     :OLD.CLOSE_APP_REMARKS);
    ELSE
        IF UPDATING
        THEN
            Mdml := 'U';
        ELSE
            Mdml := 'I';
        END IF;

        INSERT INTO ADR.Enrollment_Determination_H (Enrollment_determination_h_id,
                                                    Enrollment_determination_id,
                                                    Person_id,
                                                    Std_enrollmentstatus_id,
                                                    Enrollment_data_src_type_id,
                                                    Priority_group_type_id,
                                                    Priority_sub_group_type_id,
                                                    Application_site_id,
                                                    Egt_setting_id,
                                                    Enrollment_application_date,
                                                    Enrollment_start_date,
                                                    Enrollment_end_date,
                                                    Change_effective_date,
                                                    Enrollment_overridden_flag,
                                                    Record_created_by,
                                                    Record_created_date,
                                                    Record_modified_by,
                                                    Record_modified_date,
                                                    Record_modified_count,
                                                    Transaction_type_code,
                                                    Std_enrollmentpriorgrp_id,
                                                    Std_enrollmentpriorsgrp_id,
                                                    CLOSE_APL_RSN_TYPE_ID,
                                                         CLOSE_APP_REMARKS)
             VALUES (ADR.Enrollment_determination_h_s.NEXTVAL,
                     :NEW.Enrollment_determination_id,
                     :NEW.Person_id,
                     :NEW.Std_enrollmentstatus_id,
                     :NEW.Enrollment_data_src_type_id,
                     :NEW.Priority_group_type_id,
                     :NEW.Priority_sub_group_type_id,
                     :NEW.Application_site_id,
                     :NEW.Egt_setting_id,
                     :NEW.Enrollment_application_date,
                     :NEW.Enrollment_start_date,
                     :NEW.Enrollment_end_date,
                     :NEW.Change_effective_date,
                     :NEW.Enrollment_overridden_flag,
                     :NEW.Record_created_by,
                     :NEW.Record_created_date,
                     :NEW.Record_modified_by,
                     :NEW.Record_modified_date,
                     :NEW.Record_modified_count,
                     Mdml,
                     :NEW.Std_enrollmentpriorgrp_id,
                     :NEW.Std_enrollmentpriorsgrp_id,
                     :NEW.CLOSE_APL_RSN_TYPE_ID,
                     :NEW.CLOSE_APP_REMARKS);
    END IF;
END ENROLLMENT_DETER_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM ENROLLMENT_DETERMINATION FOR ADR.ENROLLMENT_DETERMINATION;


ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT AVCON_1172521913_ENROL_000
  CHECK (ENROLLMENT_OVERRIDDEN_FLAG BETWEEN 0
AND 0 OR ENROLLMENT_OVERRIDDEN_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067374
  CHECK ("ENROLLMENT_DETERMINATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067375
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067376
  CHECK ("EGT_SETTING_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067377
  CHECK ("ENROLLMENT_OVERRIDDEN_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067378
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067379
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067380
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067381
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067382
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ENRLMNTDET_PK
  PRIMARY KEY
  (ENROLLMENT_DETERMINATION_ID)
  USING INDEX ADR.ENRLMNTDET_PK
  ENABLE VALIDATE,
  CONSTRAINT PERSON_ID_UK
  UNIQUE (PERSON_ID)
  USING INDEX ADR.ENRLMNTDET_PRSN_FK_I
  ENABLE NOVALIDATE);

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT CLOSE_APL_RSN_TYPE_ID_FK 
  FOREIGN KEY (CLOSE_APL_RSN_TYPE_ID) 
  REFERENCES ADR.CLOSE_APL_RSN_TYPE (CLOSE_APL_RSN_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT ENRLMNTDET_EGTSETTING_FK 
  FOREIGN KEY (EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT ENRLMNTDET_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ADREXT;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ADRTMP;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ENROLLMENT_DETERMINATION TO ADR_RW;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO BIZFLOW_R;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO ES_R;

GRANT INSERT, SELECT ON ADR.ENROLLMENT_DETERMINATION TO ES_RW;

GRANT SELECT ON ADR.ENROLLMENT_DETERMINATION TO PSIM;
ALTER TABLE ADR.SSN
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SSN CASCADE CONSTRAINTS;

CREATE TABLE ADR.SSN
(
  SSN_ID                     NUMBER(20),
  PERSON_ID                  NUMBER(20),
  PERSON_RELATION_ID         NUMBER(20),
  STD_SSNTYPE_ID             NUMBER(20),
  PSEUDO_SSN_REASON_TYPE_ID  NUMBER(20),
  SSN_CHANGE_SOURCE_TYPE_ID  NUMBER(20),
  SSN_VRFN_STATUS_TYPE_ID    NUMBER(20),
  SSA_MESSAGE_TYPE_ID        NUMBER(20),
  SSN                        VARCHAR2(20 BYTE),
  SSA_VERIFIED_DATE          DATE,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE        DATE,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE       DATE,
  RECORD_MODIFIED_COUNT      NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SSN IS 'The table supports the SSN Verification process for Spouse and Dependent records only. The un-verified SSN s are sent to the Social Security Administration via a batch process. The return batch is processed and the record status is updated according to the SSA message returned for each SSN. OWNER: This is an E&E Table ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.SSN.SSN_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SSN.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SSN.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.PSEUDO_SSN_REASON_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.SSN_CHANGE_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.SSN_VRFN_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.SSA_MESSAGE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.SSN IS 'Theverifiedsocial securitynumberthathas beenassignedbythe SocialSecurityAgencyto theperson.';

COMMENT ON COLUMN ADR.SSN.SSA_VERIFIED_DATE IS 'BR1590SSAVerification dateisdefinedasthe datetheSSASSNtapewas read.';

COMMENT ON COLUMN ADR.SSN.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SSN.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SSN.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SSN.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SSN.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SSN_PK ON ADR.SSN
(SSN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_PRSNREL_FK_I ON ADR.SSN
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_PRSN_FK_I ON ADR.SSN
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_SSNTYPE_FK_I ON ADR.SSN
(STD_SSNTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_STD_PSEUDOSSNRSN_FK_I ON ADR.SSN
(PSEUDO_SSN_REASON_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_STD_SSAVRFNCD_FK_I ON ADR.SSN
(SSA_MESSAGE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_STD_SSNCHGSRC_FK_I ON ADR.SSN
(SSN_CHANGE_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_STD_SSNVRFNSTAT_FK_I ON ADR.SSN
(SSN_VRFN_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SSN_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."SSN" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SSN_H
		(
		SSN_H_ID,
		SSN_ID,
		PERSON_ID,
		PERSON_RELATION_ID,
		STD_SSNTYPE_ID,
		PSEUDO_SSN_REASON_TYPE_ID,
		SSN_CHANGE_SOURCE_TYPE_ID,
		SSN_VRFN_STATUS_TYPE_ID,
		SSA_MESSAGE_TYPE_ID,
		SSN,
		SSA_VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SSN_H_S.nextval,
		:old.SSN_ID,
		:old.PERSON_ID,
		:old.PERSON_RELATION_ID,
		:old.STD_SSNTYPE_ID,
		:old.PSEUDO_SSN_REASON_TYPE_ID,
		:old.SSN_CHANGE_SOURCE_TYPE_ID,
		:old.SSN_VRFN_STATUS_TYPE_ID,
		:old.SSA_MESSAGE_TYPE_ID,
		:old.SSN,
		:old.SSA_VERIFIED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SSN_H
		(
		SSN_H_ID,
		SSN_ID,
		PERSON_ID,
		PERSON_RELATION_ID,
		STD_SSNTYPE_ID,
		PSEUDO_SSN_REASON_TYPE_ID,
		SSN_CHANGE_SOURCE_TYPE_ID,
		SSN_VRFN_STATUS_TYPE_ID,
		SSA_MESSAGE_TYPE_ID,
		SSN,
		SSA_VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SSN_H_S.nextval,
		:new.SSN_ID,
		:new.PERSON_ID,
		:new.PERSON_RELATION_ID,
		:new.STD_SSNTYPE_ID,
		:new.PSEUDO_SSN_REASON_TYPE_ID,
		:new.SSN_CHANGE_SOURCE_TYPE_ID,
		:new.SSN_VRFN_STATUS_TYPE_ID,
		:new.SSA_MESSAGE_TYPE_ID,
		:new.SSN,
		:new.SSA_VERIFIED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SSN_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SSN FOR ADR.SSN;


ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SYS_C0066930
  CHECK ("SSN_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066931
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066932
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066933
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066934
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066935
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SSN_PK
  PRIMARY KEY
  (SSN_ID)
  USING INDEX ADR.SSN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SSN_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SSN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.SSN TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SSN TO ADR_RW;

GRANT SELECT ON ADR.SSN TO ES_R;

GRANT INSERT, SELECT ON ADR.SSN TO ES_RW;

GRANT SELECT ON ADR.SSN TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.SSN TO PSIM_ADR_RW;
ALTER TABLE ADR.EMPLOYMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMPLOYMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMPLOYMENT
(
  EMPLOYMENT_ID                 NUMBER(20),
  PERSON_ID                     NUMBER(20),
  PERSON_RELATION_ID            NUMBER(20),
  STD_EMPLOYMENTSTATUS_ID       NUMBER(20),
  EMPLOYEE_OCCUPATION           VARCHAR2(50 BYTE),
  EMPLOYER_FULL_NAME            VARCHAR2(100 BYTE),
  PHONE_NUMBER                  VARCHAR2(128 BYTE),
  ADDRESS_LINE1                 VARCHAR2(100 BYTE),
  ADDRESS_LINE2                 VARCHAR2(100 BYTE),
  ADDRESS_LINE3                 VARCHAR2(100 BYTE),
  CITY                          VARCHAR2(60 BYTE),
  STATE_CODE                    VARCHAR2(50 BYTE),
  COUNTY_CODE                   VARCHAR2(50 BYTE),
  PROVINCE_CODE                 VARCHAR2(50 BYTE),
  ZIP_CODE                      VARCHAR2(20 BYTE),
  ZIP_PLUS_4                    VARCHAR2(10 BYTE),
  POSTAL_CODE                   VARCHAR2(20 BYTE),
  COUNTRY_CODE                  VARCHAR2(50 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE           DATE,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE          DATE,
  RECORD_MODIFIED_COUNT         NUMBER(10),
  EMPLOYEE_RETIREMENT_DATE_TXT  VARCHAR2(14 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMPLOYMENT IS 'Stores Employer name and address, and also the Employee details such as Employment status and occupation';

COMMENT ON COLUMN ADR.EMPLOYMENT.EMPLOYMENT_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.EMPLOYMENT.STD_EMPLOYMENTSTATUS_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.EMPLOYMENT.EMPLOYEE_OCCUPATION IS 'Full Name';

COMMENT ON COLUMN ADR.EMPLOYMENT.EMPLOYER_FULL_NAME IS 'Full Name';

COMMENT ON COLUMN ADR.EMPLOYMENT.ADDRESS_LINE1 IS 'The free text form of the number and street or post office box of a mailing address.';

COMMENT ON COLUMN ADR.EMPLOYMENT.ADDRESS_LINE2 IS 'The free text supplemental to the number and street of a mailing address.';

COMMENT ON COLUMN ADR.EMPLOYMENT.ADDRESS_LINE3 IS 'The free text supplemental to the number and street of a mailing address.';

COMMENT ON COLUMN ADR.EMPLOYMENT.CITY IS 'The name of a city used for an address.';

COMMENT ON COLUMN ADR.EMPLOYMENT.STATE_CODE IS 'FIPS STATE CODE is defined as the 2 characters FIPS State code. The FIPS State code is the first two characters of the 5-character FIPS code. The FIPS state code is associated with the veterans permanent mailing address, If no permanent mailing address is supplied, and a MT is Required, it is associated with the Facility address in which the primary MT was supplied.
  2  State code is defines as the unique country code / state abbreviation combination found in the database that best identifies the state';

COMMENT ON COLUMN ADR.EMPLOYMENT.COUNTY_CODE IS 'FIPS County CODE is defined as the last 3 characters of the FIPS state/county code.  The FIPS county code is associated with the veterans permanent mailing address, If no permanent mailing address is supplied, and a MT is required, it is associated with the Facility address  in which the primary MT was supplied
  2  5-DIGIT FIPS CODE is defined as the 2 digit state code + 3 digit county code. This 5 digit FIPS code is associated with the veterans permanent mailing address, If no permanent mailing address is supplied, and a MT is required, it is associated with the Facility address  in which the primary MT was supplied';

COMMENT ON COLUMN ADR.EMPLOYMENT.ZIP_CODE IS 'Postal code is defined as the mail code used for mail delivery to a country other than the USA only.
  2  Acceptable format is free Text 5 - 10 characters.';

COMMENT ON COLUMN ADR.EMPLOYMENT.POSTAL_CODE IS 'Postal code is defined as the mail code used for mail delivery to a country other than the USA only.
  2  Acceptable format is free Text 5 - 10 characters.';

COMMENT ON COLUMN ADR.EMPLOYMENT.COUNTRY_CODE IS 'Country is defined as the unique identifier assigned by the International Organization of Standardization for a country.';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMPLOYMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.EMPLOY_EMPTSTAT_FK_I ON ADR.EMPLOYMENT
(STD_EMPLOYMENTSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EMPLOY_PK ON ADR.EMPLOYMENT
(EMPLOYMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMPLOY_PRSNREL_FK_I ON ADR.EMPLOYMENT
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMPLOY_PRSN_FK_I ON ADR.EMPLOYMENT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EMPLOYMENT_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."EMPLOYMENT" FOR EACH ROW
declare
    mDML char(1);
begin

  if DELETING then
    insert into EMPLOYMENT_H
    (
    EMPLOYMENT_H_ID,
    EMPLOYMENT_ID,
    PERSON_ID,
    PERSON_RELATION_ID,
    STD_EMPLOYMENTSTATUS_ID,
    EMPLOYEE_OCCUPATION,
    EMPLOYER_FULL_NAME,
    PHONE_NUMBER,
    ADDRESS_LINE1,
    ADDRESS_LINE2,
    ADDRESS_LINE3,
    CITY,
    STATE_CODE,
    COUNTY_CODE,
    PROVINCE_CODE,
    ZIP_CODE,
    ZIP_PLUS_4,
    POSTAL_CODE,
    COUNTRY_CODE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    EMPLOYEE_RETIREMENT_DATE_TXT,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    EMPLOYMENT_h_s.nextval,
    :old.EMPLOYMENT_ID ,
    :old.PERSON_ID,
    :old.PERSON_RELATION_ID,
    :old.STD_EMPLOYMENTSTATUS_ID,
    :old.EMPLOYEE_OCCUPATION,
    :old.EMPLOYER_FULL_NAME,
    :old.PHONE_NUMBER,
    :old.ADDRESS_LINE1,
    :old.ADDRESS_LINE2,
    :old.ADDRESS_LINE3,
    :old.CITY,
    :old.STATE_CODE,
    :old.COUNTY_CODE,
    :old.PROVINCE_CODE,
    :old.ZIP_CODE,
    :old.ZIP_PLUS_4,
    :old.POSTAL_CODE,
    :old.COUNTRY_CODE,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY ,
    :old.RECORD_MODIFIED_DATE,
    :old.RECORD_MODIFIED_COUNT,
    :old.EMPLOYEE_RETIREMENT_DATE_TXT,
    'D'
    );


  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;
    insert into EMPLOYMENT_H
    (
    EMPLOYMENT_H_ID,
    EMPLOYMENT_ID,
    PERSON_ID,
    PERSON_RELATION_ID,
    STD_EMPLOYMENTSTATUS_ID,
    EMPLOYEE_OCCUPATION,
    EMPLOYER_FULL_NAME,
    PHONE_NUMBER,
    ADDRESS_LINE1,
    ADDRESS_LINE2,
    ADDRESS_LINE3,
    CITY,
    STATE_CODE,
    COUNTY_CODE,
    PROVINCE_CODE,
    ZIP_CODE,
    ZIP_PLUS_4,
    POSTAL_CODE,
    COUNTRY_CODE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    EMPLOYEE_RETIREMENT_DATE_TXT,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    EMPLOYMENT_h_s.nextval,
    :new.EMPLOYMENT_ID ,
    :new.PERSON_ID,
    :new.PERSON_RELATION_ID,
    :new.STD_EMPLOYMENTSTATUS_ID,
    :new.EMPLOYEE_OCCUPATION,
    :new.EMPLOYER_FULL_NAME,
    :new.PHONE_NUMBER,
    :new.ADDRESS_LINE1,
    :new.ADDRESS_LINE2,
    :new.ADDRESS_LINE3,
    :new.CITY,
    :new.STATE_CODE,
    :new.COUNTY_CODE,
    :new.PROVINCE_CODE,
    :new.ZIP_CODE,
    :new.ZIP_PLUS_4,
    :new.POSTAL_CODE,
    :new.COUNTRY_CODE,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY ,
    :new.RECORD_MODIFIED_DATE,
    :new.RECORD_MODIFIED_COUNT,
    :new.EMPLOYEE_RETIREMENT_DATE_TXT,
    mDML
    );



  end if;

end EMPLOYMENT_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EMPLOYMENT FOR ADR.EMPLOYMENT;


ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT SYS_C00106532
  CHECK ("EMPLOYMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106534
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106535
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106536
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106537
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00106538
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT EMPLOY_PK
  PRIMARY KEY
  (EMPLOYMENT_ID)
  USING INDEX ADR.EMPLOY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT EMPLOY_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT EMPLOY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.EMPLOYMENT TO ADREXT;

GRANT SELECT ON ADR.EMPLOYMENT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMPLOYMENT TO ADR_RW;

GRANT SELECT ON ADR.EMPLOYMENT TO ES_R;

GRANT INSERT, SELECT ON ADR.EMPLOYMENT TO ES_RW;
ALTER TABLE ADR.CL_VERIFICATION_METHOD
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CL_VERIFICATION_METHOD CASCADE CONSTRAINTS;

CREATE TABLE ADR.CL_VERIFICATION_METHOD
(
  CL_VERIFICATION_METHOD_ID    NUMBER(20)       NOT NULL,
  SPECIAL_FACTOR_ID            NUMBER(20)       NOT NULL,
  CL_VERIFICATION_METHOD_CODE  NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CL_VERIFICATION_METHOD IS 'This table contains CAMP LEJEUNE eligibility verification method information.  A CAMP LEJEUNE special factor can have 0 to many different verification types.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.CL_VERIFICATION_METHOD_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.SPECIAL_FACTOR_ID IS 'FK to ADR.SPECIAL_FACTOR.SPECIAL_FACTOR_ID';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.CL_VERIFICATION_METHOD_CODE IS 'FK to ADRREF.STD_CLVERIFICATIONTYPE.ID';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n';


CREATE UNIQUE INDEX ADR.CL_VERIFICATION_METHOD_PK ON ADR.CL_VERIFICATION_METHOD
(CL_VERIFICATION_METHOD_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.SP_FAC_ID_CL_VER_METH_CD_UI ON ADR.CL_VERIFICATION_METHOD
(SPECIAL_FACTOR_ID, CL_VERIFICATION_METHOD_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CL_VERIF_METHOD_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.CL_VERIFICATION_METHOD
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into CL_VERIFICATION_METHOD_H
        (
         CL_VERIFICATION_METHOD_H_ID,
         CL_VERIFICATION_METHOD_ID,
         SPECIAL_FACTOR_ID,
         CL_VERIFICATION_METHOD_CODE,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        values
        (
        CL_VERIFICATION_METHOD_H_S.nextval,
         :old.CL_VERIFICATION_METHOD_ID,
         :old.SPECIAL_FACTOR_ID,
         :old.CL_VERIFICATION_METHOD_CODE,
         :old.RECORD_CREATED_BY,
         :old.RECORD_CREATED_DATE,
         :old.RECORD_MODIFIED_BY,
         :old.RECORD_MODIFIED_DATE,
         :old.RECORD_MODIFIED_COUNT,
         sysdate,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;
        insert into CL_VERIFICATION_METHOD_H
        (
         CL_VERIFICATION_METHOD_H_ID,
         CL_VERIFICATION_METHOD_ID,
         SPECIAL_FACTOR_ID,
         CL_VERIFICATION_METHOD_CODE,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        values
        (
        CL_VERIFICATION_METHOD_H_S.nextval,
         :new.CL_VERIFICATION_METHOD_ID,
         :new.SPECIAL_FACTOR_ID,
         :new.CL_VERIFICATION_METHOD_CODE,
         :new.RECORD_CREATED_BY,
         :new.RECORD_CREATED_DATE,
         :new.RECORD_MODIFIED_BY,
         :new.RECORD_MODIFIED_DATE,
         :new.RECORD_MODIFIED_COUNT,
         sysdate,
        mDML
        );
    end if;

end CL_VERIF_METHOD_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CL_VERIFICATION_METHOD FOR ADR.CL_VERIFICATION_METHOD;


ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT CL_VERIFICATION_METHOD_PK
  PRIMARY KEY
  (CL_VERIFICATION_METHOD_ID)
  USING INDEX ADR.CL_VERIFICATION_METHOD_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT SPC_FAC_CL_VER_METH_FK 
  FOREIGN KEY (SPECIAL_FACTOR_ID) 
  REFERENCES ADR.SPECIAL_FACTOR (SPECIAL_FACTOR_ID)
  ENABLE NOVALIDATE,
  CONSTRAINT STD_CLVERIFTYP_CLVERMETH_FK 
  FOREIGN KEY (CL_VERIFICATION_METHOD_CODE) 
  REFERENCES ADRREF.STD_CLVERIFICATIONTYPE (ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CL_VERIFICATION_METHOD TO ADR_RW;

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD TO ES_R;

GRANT INSERT, SELECT ON ADR.CL_VERIFICATION_METHOD TO ES_RW;
ALTER TABLE ADR.CL_VERIFICATION_METHOD_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CL_VERIFICATION_METHOD_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CL_VERIFICATION_METHOD_H
(
  CL_VERIFICATION_METHOD_ID    NUMBER(20),
  SPECIAL_FACTOR_ID            NUMBER(20),
  CL_VERIFICATION_METHOD_CODE  NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  CL_VERIFICATION_METHOD_H_ID  NUMBER(20)       NOT NULL,
  HISTORY_CREATED_DATE         DATE             NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CL_VERIFICATION_METHOD_H IS 'This table contains CAMP LEJEUNE eligibility verification method information.  A CAMP LEJEUNE special factor can have 0 to many different verification types.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.CL_VERIFICATION_METHOD_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.SPECIAL_FACTOR_ID IS 'FK to ADR.SPECIAL_FACTOR.SPECIAL_FACTOR_ID';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.CL_VERIFICATION_METHOD_CODE IS 'FK to ADRREF.STD_CLVERIFICATIONTYPE.ID';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CL_VERIFICATION_METHOD_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n';


CREATE UNIQUE INDEX ADR.CL_VERIFICATION_METHOD_H_PK ON ADR.CL_VERIFICATION_METHOD_H
(CL_VERIFICATION_METHOD_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CL_VERIFICATION_METHOD_H FOR ADR.CL_VERIFICATION_METHOD_H;


ALTER TABLE ADR.CL_VERIFICATION_METHOD_H ADD (
  CONSTRAINT CL_VERIFICATION_METHOD_H_PK
  PRIMARY KEY
  (CL_VERIFICATION_METHOD_H_ID)
  USING INDEX ADR.CL_VERIFICATION_METHOD_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ADR_R;

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ADR_RW;

GRANT SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CL_VERIFICATION_METHOD_H TO ES_RW;
ALTER TABLE ADR.ADDRESS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ADDRESS CASCADE CONSTRAINTS;

CREATE TABLE ADR.ADDRESS
(
  ADDRESS_ID                     NUMBER(20),
  PERSON_ID                      NUMBER(20),
  INSURANCE_ID                   NUMBER(20),
  STD_ADDRESSTYPE_ID             NUMBER(20),
  ADDRESS_CHANGE_SRC_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  ADDRESS_INVALID_TYPE_ID        NUMBER(20),
  NCOA_STATUS_TYPE_ID            NUMBER(20),
  NCOA_DELIVERY_TYPE_ID          NUMBER(20),
  NCOA_ZIP_MATCH_TYPE_ID         NUMBER(20),
  NCOA_ZIP_NO_MATCH_TYPE_ID      NUMBER(20),
  ADDRESS_LINE1                  VARCHAR2(100 BYTE),
  ADDRESS_LINE2                  VARCHAR2(100 BYTE),
  ADDRESS_LINE3                  VARCHAR2(100 BYTE),
  CITY                           VARCHAR2(60 BYTE),
  STATE_CODE                     VARCHAR2(50 BYTE),
  COUNTY_CODE                    VARCHAR2(50 BYTE),
  PROVINCE_CODE                  VARCHAR2(50 BYTE),
  ZIP_CODE                       VARCHAR2(20 BYTE),
  ZIP_PLUS_4                     VARCHAR2(10 BYTE),
  POSTAL_CODE                    VARCHAR2(20 BYTE),
  COUNTRY_CODE                   VARCHAR2(50 BYTE),
  ADDRESS_CHANGE_EFFECTIVE_DATE  DATE,
  ADDRESS_INVALIDATED_DATE       DATE,
  NCOA_ADDRESS_CHECK_DATE        DATE,
  ADDRESS_START_DATE_TXT         VARCHAR2(14 BYTE),
  ADDRESS_END_DATE_TXT           VARCHAR2(14 BYTE),
  ADDRESS_PHONE_NUMBER           VARCHAR2(30 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10),
  RECORD_MODIFIED_SRC_NAME       VARCHAR2(30 BYTE),
  PERSON_RELATION_ID             NUMBER(20),
  CASSCERTIFIEDTYPE_ID           NUMBER(20),
  CASS_CERTIFIED_DATE            DATE,
  PURPOSE_OF_USE_TYPE_ID         NUMBER(20),
  SITE_OF_CHANGE_ID              NUMBER(20)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ADDRESS IS 'The ADDRESS table contains the components of primary, temporary, and confidential addresses for persons and addresses for insurance companies. This table also contains data used in the checking of values with National Change of Address (NCOA). Maintains all types of addresses for Persons. Also stores Insurance Company address. Foreign Keys present in table: PERSON_ID INSURANCE_ID ADDRESS_TYPE_ID (Types of addresses applicable to persons - Residential, Business etc.) ADDRESS_CHANGE_SRC_TYPE_ID (Source of the address change such as HEC, NCOA etc.) STD_INSTITUTION_ID (Site making the address change) ADDRESS_INVALID_TYPE_ID (Why the address cannot be used - Homeless, Undeliverable etc.) NCOA_STATUS_TYPE_ID ( Sent to NCOA, Not sent or Checked by NCOA) NCOA_DELIVERY_TYPE_ID ( Address good No Address Change, Foreign move etc.) NCOA_ZIP_MATCH_TYPE_ID (Building/High-Rise, Rural Route etc.) NCOA_ZIP_NO_MATCH_TYPE_ID DEMOGRAPHICS / ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ADDRESS.PERSON_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.INSURANCE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.STD_ADDRESSTYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_CHANGE_SRC_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_INVALID_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_STATUS_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_DELIVERY_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_ZIP_MATCH_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_ZIP_NO_MATCH_TYPE_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_LINE1 IS 'BR3Addressline#1is definedasthefreetext formofthenumberand streetorpostofficebox ofamailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_LINE2 IS 'BR5Addressline#2is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_LINE3 IS 'BR7Addressline#3is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.ADDRESS.CITY IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS.STATE_CODE IS 'FIPSSTATECODEis definedasthe2 charactersFIPSState code.TheFIPSStatecode isthefirsttwo charactersofthe5- characterFIPScode.The FIPSstatecodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis Required,itis associatedwiththe Facilityaddressinwhich theprimaryMTwas supplied.Statecodeisdefinesas theuniquecountrycode/ stateabbreviation combinationfoundinthe databasethatbest identifiesthestate';

COMMENT ON COLUMN ADR.ADDRESS.COUNTY_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS.PROVINCE_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS.ZIP_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS.ZIP_PLUS_4 IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS.POSTAL_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.ADDRESS.COUNTRY_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof addresswentintoeffect.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_INVALIDATED_DATE IS 'Dateonwhichanaddress wasdeterminedtobe invalid.';

COMMENT ON COLUMN ADR.ADDRESS.NCOA_ADDRESS_CHECK_DATE IS 'Dateonwhichanaddress wascheckedagainstNCOA. Dateaddresscheckedwith NCOAisdefinedasa validdatethatissetby theAAConcetheNCOA checkiscompleted.Fortherecordsthatare returnedtoADRviathe NCOAAddresscheckfile- thisdatewillbethe NCOADateChecked containedonthatfile. ForRecordsreturnedvia anaddresschangethis datewillbethedatethe Z05(addresssource= NCOA)datawasuploaded ontheADR.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_START_DATE_TXT IS 'Addressstartdateis definedasthedatean addressbecamevalidto useforaparty.Address startdatecanbea futuredate.Address becomesactive/current onthestartdate.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_END_DATE_TXT IS 'Addressenddateis definedasthedatean addressstoppedbeing usedforaparty.Address enddatecannotbebefore addressstartdate. Addressenddatecanbea futuredate.Address becomesinactiveonthe enddate.';

COMMENT ON COLUMN ADR.ADDRESS.ADDRESS_PHONE_NUMBER IS 'Telephone number associated with a temporary address.';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.ADDRESS.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.ADDRESS.PERSON_RELATION_ID IS 'TheForiegnkey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthe related table.';

COMMENT ON COLUMN ADR.ADDRESS.PURPOSE_OF_USE_TYPE_ID IS 'Foreign Key on ADR.PURPOSE_OF_USE_TYPE';

COMMENT ON COLUMN ADR.ADDRESS.SITE_OF_CHANGE_ID IS 'Foreign Key on ADR.LOOKUP_TYPE.LOOKUP_TYPE_ID';


CREATE INDEX ADR.ADDRESS_SITECHNG_NU_I ON ADR.ADDRESS
(SITE_OF_CHANGE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_INSURANCE_FK_I ON ADR.ADDRESS
(INSURANCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ADDR_PK ON ADR.ADDRESS
(ADDRESS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_PRSNREL_FK_I ON ADR.ADDRESS
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_PRSN_FK_I ON ADR.ADDRESS
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STDADDRTYPE_FK_I ON ADR.ADDRESS
(STD_ADDRESSTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STDINST_FK_I ON ADR.ADDRESS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_ADDRCHGSRC_FK_I ON ADR.ADDRESS
(ADDRESS_CHANGE_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_ADDRDELFLR_FK_I ON ADR.ADDRESS
(ADDRESS_INVALID_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_NCOADELTYP_FK_I ON ADR.ADDRESS
(NCOA_DELIVERY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_NCOASTATYP_FK_I ON ADR.ADDRESS
(NCOA_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_NCOAZIPMCH_FK_I ON ADR.ADDRESS
(NCOA_ZIP_MATCH_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ADDR_STD_NCOAZIPNOMTCH_FK_I ON ADR.ADDRESS
(NCOA_ZIP_NO_MATCH_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ADDRESS_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON ADR.ADDRESS FOR EACH ROW
declare
    mDML char(1);
begin

  if DELETING then
    insert into ADDRESS_H
    (
    ADDRESS_H_ID,
    ADDRESS_ID  ,
    PERSON_ID   ,
    INSURANCE_ID,
    STD_ADDRESSTYPE_ID,
    ADDRESS_CHANGE_SRC_TYPE_ID,
    STD_INSTITUTION_ID        ,
    ADDRESS_INVALID_TYPE_ID   ,
    NCOA_STATUS_TYPE_ID       ,
    NCOA_DELIVERY_TYPE_ID     ,
    NCOA_ZIP_MATCH_TYPE_ID    ,
    ADDRESS_LINE1             ,
    ADDRESS_LINE2             ,
    ADDRESS_LINE3             ,
    CITY                      ,
    STATE_CODE                ,
    COUNTY_CODE               ,
    PROVINCE_CODE             ,
    POSTAL_CODE               ,
    ZIP_PLUS_4                ,
    COUNTRY_CODE              ,
    ADDRESS_CHANGE_EFFECTIVE_DATE,
    ADDRESS_INVALIDATED_DATE  ,
    NCOA_ADDRESS_CHECK_DATE   ,
    ADDRESS_START_DATE_TXT   ,
    ADDRESS_END_DATE_TXT     ,
    RECORD_CREATED_BY         ,
    RECORD_CREATED_DATE       ,
    RECORD_MODIFIED_BY        ,
    RECORD_MODIFIED_DATE      ,
    RECORD_MODIFIED_COUNT     ,
    ADDRESS_PHONE_NUMBER,
    ZIP_CODE                  ,
    NCOA_ZIP_NO_MATCH_TYPE_ID ,
    RECORD_MODIFIED_SRC_NAME,
    PERSON_RELATION_ID,
    CASSCERTIFIEDTYPE_ID,
    CASS_CERTIFIED_DATE,
    purpose_of_use_type_id,
    TRANSACTION_TYPE_CODE,
    SITE_OF_CHANGE_ID
    )
    values
    (
    ADDRESS_h_s.nextval,
    :old.ADDRESS_ID  ,
    :old.PERSON_ID   ,
    :old.INSURANCE_ID,
    :old.STD_ADDRESSTYPE_ID,
    :old.ADDRESS_CHANGE_SRC_TYPE_ID,
    :old.STD_INSTITUTION_ID        ,
    :old.ADDRESS_INVALID_TYPE_ID   ,
    :old.NCOA_STATUS_TYPE_ID       ,
    :old.NCOA_DELIVERY_TYPE_ID     ,
    :old.NCOA_ZIP_MATCH_TYPE_ID    ,
    :old.ADDRESS_LINE1             ,
    :old.ADDRESS_LINE2             ,
    :old.ADDRESS_LINE3             ,
    :old.CITY                      ,
    :old.STATE_CODE                ,
    :old.COUNTY_CODE               ,
    :old.PROVINCE_CODE             ,
    :old.POSTAL_CODE               ,
    :old.ZIP_PLUS_4                ,
    :old.COUNTRY_CODE              ,
    :old.ADDRESS_CHANGE_EFFECTIVE_DATE,
    :old.ADDRESS_INVALIDATED_DATE  ,
    :old.NCOA_ADDRESS_CHECK_DATE   ,
    :old.ADDRESS_START_DATE_TXT   ,
    :old.ADDRESS_END_DATE_TXT     ,
    :old.RECORD_CREATED_BY         ,
    :old.RECORD_CREATED_DATE       ,
    :old.RECORD_MODIFIED_BY        ,
    :old.RECORD_MODIFIED_DATE      ,
    :old.RECORD_MODIFIED_COUNT     ,
    :old.ADDRESS_PHONE_NUMBER,
    :old.ZIP_CODE                  ,
    :old.NCOA_ZIP_NO_MATCH_TYPE_ID ,
    :old.RECORD_MODIFIED_SRC_NAME,
    :old.PERSON_RELATION_ID,
    :old.CASSCERTIFIEDTYPE_ID,
    :old.CASS_CERTIFIED_DATE,
    :old.purpose_of_use_type_id,
    'D',
    :old.SITE_OF_CHANGE_ID
    );
  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into ADDRESS_H
    (
    ADDRESS_H_ID,
    ADDRESS_ID  ,
    PERSON_ID   ,
    INSURANCE_ID,
    STD_ADDRESSTYPE_ID,
    ADDRESS_CHANGE_SRC_TYPE_ID,
    STD_INSTITUTION_ID        ,
    ADDRESS_INVALID_TYPE_ID   ,
    NCOA_STATUS_TYPE_ID       ,
    NCOA_DELIVERY_TYPE_ID     ,
    NCOA_ZIP_MATCH_TYPE_ID    ,
    ADDRESS_LINE1             ,
    ADDRESS_LINE2             ,
    ADDRESS_LINE3             ,
    CITY                      ,
    STATE_CODE                ,
    COUNTY_CODE               ,
    PROVINCE_CODE             ,
    POSTAL_CODE               ,
    ZIP_PLUS_4                ,
    COUNTRY_CODE              ,
    ADDRESS_CHANGE_EFFECTIVE_DATE,
    ADDRESS_INVALIDATED_DATE  ,
    NCOA_ADDRESS_CHECK_DATE   ,
    ADDRESS_START_DATE_TXT   ,
    ADDRESS_END_DATE_TXT     ,
    RECORD_CREATED_BY         ,
    RECORD_CREATED_DATE       ,
    RECORD_MODIFIED_BY        ,
    RECORD_MODIFIED_DATE      ,
    RECORD_MODIFIED_COUNT     ,
    ADDRESS_PHONE_NUMBER,
    ZIP_CODE                  ,
    NCOA_ZIP_NO_MATCH_TYPE_ID ,
    RECORD_MODIFIED_SRC_NAME,
    PERSON_RELATION_ID,
    CASSCERTIFIEDTYPE_ID,
    CASS_CERTIFIED_DATE,
    purpose_of_use_type_id,
    TRANSACTION_TYPE_CODE,
    SITE_OF_CHANGE_ID
    )
    values
    (
    ADDRESS_h_s.nextval,
    :new.ADDRESS_ID  ,
    :new.PERSON_ID   ,
    :new.INSURANCE_ID,
    :new.STD_ADDRESSTYPE_ID,
    :new.ADDRESS_CHANGE_SRC_TYPE_ID,
    :new.STD_INSTITUTION_ID        ,
    :new.ADDRESS_INVALID_TYPE_ID   ,
    :new.NCOA_STATUS_TYPE_ID       ,
    :new.NCOA_DELIVERY_TYPE_ID     ,
    :new.NCOA_ZIP_MATCH_TYPE_ID    ,
    :new.ADDRESS_LINE1             ,
    :new.ADDRESS_LINE2             ,
    :new.ADDRESS_LINE3             ,
    :new.CITY                      ,
    :new.STATE_CODE                ,
    :new.COUNTY_CODE               ,
    :new.PROVINCE_CODE             ,
    :new.POSTAL_CODE               ,
    :new.ZIP_PLUS_4                ,
    :new.COUNTRY_CODE              ,
    :new.ADDRESS_CHANGE_EFFECTIVE_DATE,
    :new.ADDRESS_INVALIDATED_DATE  ,
    :new.NCOA_ADDRESS_CHECK_DATE   ,
    :new.ADDRESS_START_DATE_TXT   ,
    :new.ADDRESS_END_DATE_TXT     ,
    :new.RECORD_CREATED_BY         ,
    :new.RECORD_CREATED_DATE       ,
    :new.RECORD_MODIFIED_BY        ,
    :new.RECORD_MODIFIED_DATE      ,
    :new.RECORD_MODIFIED_COUNT     ,
    :new.ADDRESS_PHONE_NUMBER,
    :new.ZIP_CODE                  ,
    :new.NCOA_ZIP_NO_MATCH_TYPE_ID ,
    :new.RECORD_MODIFIED_SRC_NAME,
    :new.PERSON_RELATION_ID,
    :new.CASSCERTIFIEDTYPE_ID,
    :new.CASS_CERTIFIED_DATE,
    :new.purpose_of_use_type_id,
    mDML,
    :new.SITE_OF_CHANGE_ID
    );
  end if;

end ADDRESS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ADDRESS FOR ADR.ADDRESS;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT SYS_C0067422
  CHECK ("ADDRESS_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067423
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067424
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067425
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067426
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067427
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_PK
  PRIMARY KEY
  (ADDRESS_ID)
  USING INDEX ADR.ADDR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_CASSCERTIFIEDTY_FK 
  FOREIGN KEY (CASSCERTIFIEDTYPE_ID) 
  REFERENCES ADR.CASSCERTIFIEDTYPE (CASSCERTIFIEDTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_STD_NCOADELTYP_FK 
  FOREIGN KEY (NCOA_DELIVERY_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOADELIVERYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_STD_NCOASTATYP_FK 
  FOREIGN KEY (NCOA_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOASTATUSTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_STD_NCOAZIPMCH_FK 
  FOREIGN KEY (NCOA_ZIP_MATCH_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOAZIPMATCHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADDR_STD_NCOAZIPNOMTCH_FK 
  FOREIGN KEY (NCOA_ZIP_NO_MATCH_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOAZIPNOMATCHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT ADR_SITE_OF_CNG_FK 
  FOREIGN KEY (SITE_OF_CHANGE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT PURPOSE_OF_USE_FK 
  FOREIGN KEY (PURPOSE_OF_USE_TYPE_ID) 
  REFERENCES ADR.PURPOSE_OF_USE_TYPE (PURPOSE_OF_USE_TYPE_ID)
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ADDRESS TO ADREXT;

GRANT SELECT ON ADR.ADDRESS TO ADRTMP;

GRANT SELECT ON ADR.ADDRESS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ADDRESS TO ADR_RW;

GRANT INSERT, SELECT, UPDATE ON ADR.ADDRESS TO ESCISSEEDINGUSR;

GRANT SELECT ON ADR.ADDRESS TO ES_R;

GRANT INSERT, SELECT ON ADR.ADDRESS TO ES_RW;

GRANT SELECT ON ADR.ADDRESS TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.ADDRESS TO PSIM_ADR_RW;

GRANT SELECT ON ADR.ADDRESS TO VET360USR;
ALTER TABLE ADR.RPT_SORTBY_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_SORTBY_TYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_SORTBY_TYPE
(
  RPT_SORTBY_TYPE_ID     NUMBER(20)             NOT NULL,
  CODE                   VARCHAR2(2 BYTE)       NOT NULL,
  NAME                   VARCHAR2(50 BYTE),
  DESCRIPTION            VARCHAR2(100 BYTE)     NOT NULL,
  ISACTIVE               CHAR(1 BYTE)           NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_SORTBY_TYPE IS 'lookup table for Report sort by.';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.RPT_SORTBY_TYPE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.CODE IS 'Lookup code short name';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.NAME IS 'LOOKUP CODE LONG NAME VALUE.';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.DESCRIPTION IS 'Description of the Report Sort By Code';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.ISACTIVE IS 'FLAG TO SHOW ACTIVE/INACTIVE';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_SORTBY_TYPE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPT_SORTBY_TYPE_CD_UK ON ADR.RPT_SORTBY_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPT_SORTBY_TYPE_DESC_UK ON ADR.RPT_SORTBY_TYPE
(DESCRIPTION)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPT_SORTBY_TYPE_PK ON ADR.RPT_SORTBY_TYPE
(RPT_SORTBY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_SORTBY_TYPE FOR ADR.RPT_SORTBY_TYPE;


ALTER TABLE ADR.RPT_SORTBY_TYPE ADD (
  CONSTRAINT RPT_SORTBY_TYPE_PK
  PRIMARY KEY
  (RPT_SORTBY_TYPE_ID)
  USING INDEX ADR.RPT_SORTBY_TYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_SORTBY_TYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_SORTBY_TYPE TO ADR_RW;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IRS_TRANSMISSION_LOG CASCADE CONSTRAINTS;

CREATE TABLE ADR.IRS_TRANSMISSION_LOG
(
  IRS_TRANSMISSION_LOG_ID  NUMBER(20)           NOT NULL,
  TRANSMISSION_STATUS_ID   NUMBER(20)           NOT NULL,
  TRANSMISSION_DATE        DATE                 NOT NULL,
  RECEIPT_ID               VARCHAR2(50 BYTE),
  BATCH_TYPE_IND           VARCHAR2(10 BYTE)    NOT NULL,
  YEAR                     NUMBER(4)            NOT NULL,
  CORRECTION_IND           VARCHAR2(10 BYTE)    NOT NULL,
  ACK_DATE                 DATE,
  ACK_ID                   VARCHAR2(50 BYTE),
  ERROR_DESCRIPTION        VARCHAR2(1000 BYTE),
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IRS_TRANSMISSION_LOG IS 'This table contains transmission details for submissions of ACA Minimum Essential Coverage data from ES to the IRS.';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.IRS_TRANSMISSION_LOG_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.TRANSMISSION_STATUS_ID IS 'FK to ADR.TRANSMISSION_STATUS.TRANSMISSION_STATUS_ID ';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.TRANSMISSION_DATE IS 'Date of original batch request submission';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.RECEIPT_ID IS 'Hash value provided by IRS to confirm receipt of the batch submission';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.BATCH_TYPE_IND IS 'Indicates submission of type Veterans or Beneficiaries';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.YEAR IS 'Calendar year for which the coverage is being reported';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.CORRECTION_IND IS 'Indicates correction type of Original, Corrected, or Replacement submission';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.ACK_DATE IS 'Date of completed IRS acknowledgment of processing';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.ACK_ID IS 'Hash value provided by IRS in acknowledgement response data to confirm processing';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.ERROR_DESCRIPTION IS 'Error string provided by IRS for cases of Rejected batch submission';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';


CREATE INDEX ADR.IRSTRNSLG_TRNSSTAT_FK_I ON ADR.IRS_TRANSMISSION_LOG
(TRANSMISSION_STATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.IRS_TRANSMISSION_LOG_ID_PK ON ADR.IRS_TRANSMISSION_LOG
(IRS_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ITL_RECEIPT_ID_NU_I ON ADR.IRS_TRANSMISSION_LOG
(RECEIPT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ITL_YEAR_NU_I ON ADR.IRS_TRANSMISSION_LOG
(YEAR)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM IRS_TRANSMISSION_LOG FOR ADR.IRS_TRANSMISSION_LOG;


ALTER TABLE ADR.IRS_TRANSMISSION_LOG ADD (
  CONSTRAINT IRS_TRANSMISSION_LOG_ID_PK
  PRIMARY KEY
  (IRS_TRANSMISSION_LOG_ID)
  USING INDEX ADR.IRS_TRANSMISSION_LOG_ID_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.IRS_TRANSMISSION_LOG ADD (
  CONSTRAINT TRNSSTAT_IRSTRNSLOG_FK 
  FOREIGN KEY (TRANSMISSION_STATUS_ID) 
  REFERENCES ADR.TRANSMISSION_STATUS (TRANSMISSION_STATUS_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.IRS_TRANSMISSION_LOG TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IRS_TRANSMISSION_LOG TO ADR_RW;

GRANT SELECT ON ADR.IRS_TRANSMISSION_LOG TO ES_R;

GRANT INSERT, SELECT ON ADR.IRS_TRANSMISSION_LOG TO ES_RW;
ALTER TABLE ADR.TRANSMISSION_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.TRANSMISSION_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.TRANSMISSION_STATUS
(
  TRANSMISSION_STATUS_ID  NUMBER(20)            NOT NULL,
  CODE                    VARCHAR2(10 BYTE)     NOT NULL,
  NAME                    VARCHAR2(30 BYTE)     NOT NULL,
  DESCRIPTION             VARCHAR2(250 BYTE)    NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.TRANSMISSION_STATUS IS 'This table contains reference lookup values to track the state of IRS submissions';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.TRANSMISSION_STATUS_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.CODE IS 'Lookup code short name value';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.NAME IS 'Lookup code long name value';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.DESCRIPTION IS 'Lookup code description';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';


CREATE UNIQUE INDEX ADR.TRANSMISSION_STATUS_ID_PK ON ADR.TRANSMISSION_STATUS
(TRANSMISSION_STATUS_ID)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.TRNS_STAT_CODE_NU_I ON ADR.TRANSMISSION_STATUS
(CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.TRNS_STAT_NAME_NU_I ON ADR.TRANSMISSION_STATUS
(NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM TRANSMISSION_STATUS FOR ADR.TRANSMISSION_STATUS;


ALTER TABLE ADR.TRANSMISSION_STATUS ADD (
  CONSTRAINT TRANSMISSION_STATUS_ID_PK
  PRIMARY KEY
  (TRANSMISSION_STATUS_ID)
  USING INDEX ADR.TRANSMISSION_STATUS_ID_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.TRANSMISSION_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.TRANSMISSION_STATUS TO ADR_RW;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_PERSON_MERGE_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_PERSON_MERGE_STATUS
(
  RPT_PERSON_MERGE_STATUS_ID  NUMBER(20)        NOT NULL,
  RPT_SCHEDULED_REPORT_ID     NUMBER(20)        NOT NULL,
  STD_PERSONMERGESTATUS_ID    NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_PERSON_MERGE_STATUS IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RPT_PERSON_MERGE_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTPRSNMRG_PK ON ADR.RPT_PERSON_MERGE_STATUS
(RPT_PERSON_MERGE_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPRSNMRG_SCHEDRPT_FK_I ON ADR.RPT_PERSON_MERGE_STATUS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPRSNMRG_STDPRSNMRG_FK_I ON ADR.RPT_PERSON_MERGE_STATUS
(STD_PERSONMERGESTATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_PERSON_MERGE_STATUS FOR ADR.RPT_PERSON_MERGE_STATUS;


ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS ADD (
  CONSTRAINT RPTPRSNMRG_PK
  PRIMARY KEY
  (RPT_PERSON_MERGE_STATUS_ID)
  USING INDEX ADR.RPTPRSNMRG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS ADD (
  CONSTRAINT RPTPRSNMRG_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_PERSON_MERGE_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_PERSON_MERGE_STATUS TO ADR_RW;

GRANT SELECT ON ADR.RPT_PERSON_MERGE_STATUS TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_PERSON_MERGE_STATUS TO ES_RW;
ALTER TABLE ADR.WKF_MESSAGING_CASE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_MESSAGING_CASE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_MESSAGING_CASE_H
(
  WKF_MESSAGING_CASE_H_ID       NUMBER(20)      NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL,
  WKF_MESSAGING_CASE_ID         NUMBER(20)      NOT NULL,
  HL7_MESSAGE_ID                VARCHAR2(50 BYTE),
  WKF_CASE_ID                   VARCHAR2(50 BYTE),
  MESSAGE_TRANSMISSION_TYPE_ID  VARCHAR2(50 BYTE),
  ACK_TYPE_ID                   VARCHAR2(50 BYTE),
  STD_INSTITUTION_ID            VARCHAR2(50 BYTE),
  TRANSMISSION_TYPE_CODE        VARCHAR2(50 BYTE),
  TRANSMISSION_DATE             DATE,
  ACK_DATE                      DATE,
  ERROR_MESSAGE_TEXT            VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_MESSAGING_CASE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.WKF_MESSAGING_CASE_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.WKF_MESSAGING_CASE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.HL7_MESSAGE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.MESSAGE_TRANSMISSION_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.ACK_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.TRANSMISSION_TYPE_CODE IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.TRANSMISSION_DATE IS 'BR2216Thedate/timethe transmissionwasmadeto thissiteorreceived fromthissite.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.ACK_DATE IS 'BR2228TheACKdate/time isdefinedasthedate andtimeHECreceivedthe ACKonoutboundmessages orthedate/timeHECsent theackoninbound messages.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFMSGCSH_PK ON ADR.WKF_MESSAGING_CASE_H
(WKF_MESSAGING_CASE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKF_MESSAGING_CASE_H_FK_I ON ADR.WKF_MESSAGING_CASE_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WKF_MESSAGING_CASE_H FOR ADR.WKF_MESSAGING_CASE_H;


ALTER TABLE ADR.WKF_MESSAGING_CASE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_000
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT WKFMSGCSH_PK
  PRIMARY KEY
  (WKF_MESSAGING_CASE_H_ID)
  USING INDEX ADR.WKFMSGCSH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_MESSAGING_CASE_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_MESSAGING_CASE_H TO ADR_RW;
ALTER TABLE ADR.BENEFICIARY_MST_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_MST_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_MST_H
(
  BENEFICIARY_MST_H_ID   NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  BENEFICIARY_MST_ID     NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  MST_STATUS_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID     NUMBER(20),
  MST_EVALUATION_DATE    DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_MST_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.BENEFICIARY_MST_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.BENEFICIARY_MST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.MST_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.MST_EVALUATION_DATE IS 'DateonwhichtheMST screeningwasconducted. Eitherbymedicalrecord orbyphysicalexam.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BNFYMSTH_PK ON ADR.BENEFICIARY_MST_H
(BENEFICIARY_MST_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYMSTH_PRSNID_NU_I ON ADR.BENEFICIARY_MST_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_MST_H FOR ADR.BENEFICIARY_MST_H;


ALTER TABLE ADR.BENEFICIARY_MST_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_001
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT BNFYMSTH_PK
  PRIMARY KEY
  (BENEFICIARY_MST_H_ID)
  USING INDEX ADR.BNFYMSTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_MST_H TO ADR_R;

GRANT SELECT ON ADR.BENEFICIARY_MST_H TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_MST_H TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_MST_H TO ES_RW;
ALTER TABLE ADR.COMBAT_EPISODE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COMBAT_EPISODE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.COMBAT_EPISODE_H
(
  COMBAT_EPISODE_H_ID    NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  COMBAT_EPISODE_ID      NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  OEFOIFSOURCE_ID        NUMBER(20),
  COMBATPAYTYPE_ID       NUMBER(20),
  COMBATLOCATIONTYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID     NUMBER(20),
  COMBAT_FROM_DATE_TXT   VARCHAR2(14 BYTE),
  COMBAT_TO_DATE_TXT     VARCHAR2(14 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COMBAT_EPISODE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.COMBAT_EPISODE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.COMBAT_EPISODE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.OEFOIFSOURCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.COMBATPAYTYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.COMBATLOCATIONTYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CMBTEPSDH_PK ON ADR.COMBAT_EPISODE_H
(COMBAT_EPISODE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSDH_PRSNID_NU_I ON ADR.COMBAT_EPISODE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COMBAT_EPISODE_H FOR ADR.COMBAT_EPISODE_H;


ALTER TABLE ADR.COMBAT_EPISODE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_002
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CMBTEPSDH_PK
  PRIMARY KEY
  (COMBAT_EPISODE_H_ID)
  USING INDEX ADR.CMBTEPSDH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COMBAT_EPISODE_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_EPISODE_H TO ADR_RW;

GRANT SELECT ON ADR.COMBAT_EPISODE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.COMBAT_EPISODE_H TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H
(
  CAT_DSBLTY_DIAGNOSIS_H_ID   NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  CAT_DSBLTY_DIAGNOSIS_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  DIAGNOSIS_TYPE_ID           NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.CAT_DSBLTY_DIAGNOSIS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.CAT_DSBLTY_DIAGNOSIS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.DIAGNOSIS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSDIAGH_CATDSBLTY_NU_I ON ADR.CAT_DSBLTY_DIAGNOSIS_H
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSDIAGH_PK ON ADR.CAT_DSBLTY_DIAGNOSIS_H
(CAT_DSBLTY_DIAGNOSIS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_DIAGNOSIS_H FOR ADR.CAT_DSBLTY_DIAGNOSIS_H;


ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_004
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CATDSDIAGH_PK
  PRIMARY KEY
  (CAT_DSBLTY_DIAGNOSIS_H_ID)
  USING INDEX ADR.CATDSDIAGH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ADR_R;

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS_H TO ES_RW;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_STATUS_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_STATUS_DETAIL
(
  WKF_CASE_STATUS_DETAIL_ID  NUMBER(20)         NOT NULL,
  WKF_CASE_ID                NUMBER(20),
  WKF_CASE_ACTIVITY_TYPE_ID  NUMBER(20),
  WKF_CASE_REQUEST_TYPE_ID   NUMBER(20),
  WKF_CASE_STATUS_TYPE_ID    NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_STATUS_DETAIL IS 'The table stores status information used to mark progress toward completion for a particular workflow case. The status is the current phase of the case. The status value acts as a progress indicator as the case activities are completed. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.WKF_CASE_STATUS_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCSESTAT_PK ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_STATUS_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSESTAT_STD_WKFACTVTY_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_ACTIVITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSESTAT_STD_WKFCSST_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSESTAT_STD_WKFRQST_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_REQUEST_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSESTAT_WKFCASE_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_STA_DET_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE_STATUS_DETAIL for each row
declare
   	mDML char(1);
begin

	if DELETING then
	     insert into WKF_CASE_STATUS_DETAIL_H
		(
		WKF_CASE_STATUS_DETAIL_H_ID,
		WKF_CASE_STATUS_DETAIL_ID,
		WKF_CASE_ID,
		WKF_CASE_REQUEST_TYPE_ID ,
		WKF_CASE_STATUS_TYPE_ID ,
		WKF_CASE_ACTIVITY_TYPE_ID,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_STATUS_DETAIL_H_S.nextval  ,
		:old.WKF_CASE_STATUS_DETAIL_ID,
		:old.WKF_CASE_ID,
		:old.WKF_CASE_REQUEST_TYPE_ID,
		:old.WKF_CASE_STATUS_TYPE_ID ,
		:old.WKF_CASE_ACTIVITY_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

	     insert into WKF_CASE_STATUS_DETAIL_H
		(
		WKF_CASE_STATUS_DETAIL_H_ID,
		WKF_CASE_STATUS_DETAIL_ID,
		WKF_CASE_ID,
		WKF_CASE_REQUEST_TYPE_ID ,
		WKF_CASE_STATUS_TYPE_ID ,
		WKF_CASE_ACTIVITY_TYPE_ID,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_STATUS_DETAIL_H_S.nextval  ,
		:new.WKF_CASE_STATUS_DETAIL_ID,
		:new.WKF_CASE_ID,
		:new.WKF_CASE_REQUEST_TYPE_ID,
		:new.WKF_CASE_STATUS_TYPE_ID ,
		:new.WKF_CASE_ACTIVITY_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

End WKF_CASE_STA_det_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_STATUS_DETAIL FOR ADR.WKF_CASE_STATUS_DETAIL;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_PK
  PRIMARY KEY
  (WKF_CASE_STATUS_DETAIL_ID)
  USING INDEX ADR.WKFCSESTAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_STD_WKFACTVTY_FK 
  FOREIGN KEY (WKF_CASE_ACTIVITY_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEACTIVITY (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCSESTAT_STD_WKFCSST_FK 
  FOREIGN KEY (WKF_CASE_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASESTATUS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCSESTAT_STD_WKFRQST_FK 
  FOREIGN KEY (WKF_CASE_REQUEST_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEREQUEST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCSESTAT_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_STATUS_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE_STATUS_DETAIL TO ADR_RW;
ALTER TABLE ADR.COMBAT_EPISODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COMBAT_EPISODE CASCADE CONSTRAINTS;

CREATE TABLE ADR.COMBAT_EPISODE
(
  COMBAT_EPISODE_ID      NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  OEFOIFSOURCE_ID        NUMBER(20),
  COMBATPAYTYPE_ID       NUMBER(20),
  COMBATLOCATIONTYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID     NUMBER(20),
  COMBAT_FROM_DATE_TXT   VARCHAR2(14 BYTE),
  COMBAT_TO_DATE_TXT     VARCHAR2(14 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COMBAT_EPISODE IS 'This holds the OEF / OIF functionality (enhancement to the Military Service determination, in the case of Operation Iraqi Freedom) This is like an upgraded Military Service / Military Service Episode / Conflict Detail structure';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.COMBAT_EPISODE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.OEFOIFSOURCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.COMBATPAYTYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.COMBATLOCATIONTYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COMBAT_EPISODE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CMBTEPSD_PK ON ADR.COMBAT_EPISODE
(COMBAT_EPISODE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_PRSN_FK_I ON ADR.COMBAT_EPISODE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_STDCBTPAY_FK_I ON ADR.COMBAT_EPISODE
(COMBATPAYTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_STDCMBTLOC_FK_I ON ADR.COMBAT_EPISODE
(COMBATLOCATIONTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_STDINST_FK_I ON ADR.COMBAT_EPISODE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTEPSD_STDOEFSRC_FK_I ON ADR.COMBAT_EPISODE
(OEFOIFSOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.COMBAT_EPISODE_audir_trgr
after Update or Delete or Insert
ON ADR.COMBAT_EPISODE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into COMBAT_EPISODE_H
		(
  		COMBAT_EPISODE_H_ID,
 		COMBAT_EPISODE_ID,
 		PERSON_ID,
 		OEFOIFSOURCE_ID,
 		COMBATPAYTYPE_ID,
 		COMBATLOCATIONTYPE_ID,
 		STD_INSTITUTION_ID,
 		COMBAT_FROM_DATE_TXT,
 		COMBAT_TO_DATE_TXT,
 		RECORD_CREATED_BY,
 		RECORD_CREATED_DATE,
 		RECORD_MODIFIED_BY,
 		RECORD_MODIFIED_DATE,
 		RECORD_MODIFIED_COUNT,
 		TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_EPISODE_H_S.nextval,
 		:OLD.COMBAT_EPISODE_ID,
 		:OLD.PERSON_ID,
 		:OLD.OEFOIFSOURCE_ID,
 		:OLD.COMBATPAYTYPE_ID,
 		:OLD.COMBATLOCATIONTYPE_ID,
 		:OLD.STD_INSTITUTION_ID,
 		:OLD.COMBAT_FROM_DATE_TXT,
 		:OLD.COMBAT_TO_DATE_TXT,
 		:OLD.RECORD_CREATED_BY,
 		:OLD.RECORD_CREATED_DATE,
 		:OLD.RECORD_MODIFIED_BY,
 		:OLD.RECORD_MODIFIED_DATE,
 		:OLD.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into COMBAT_EPISODE_H
		(
  		COMBAT_EPISODE_H_ID,
 		COMBAT_EPISODE_ID,
 		PERSON_ID,
 		OEFOIFSOURCE_ID,
 		COMBATPAYTYPE_ID,
 		COMBATLOCATIONTYPE_ID,
 		STD_INSTITUTION_ID,
 		COMBAT_FROM_DATE_TXT,
 		COMBAT_TO_DATE_TXT,
 		RECORD_CREATED_BY,
 		RECORD_CREATED_DATE,
 		RECORD_MODIFIED_BY,
 		RECORD_MODIFIED_DATE,
 		RECORD_MODIFIED_COUNT,
 		TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_EPISODE_H_S.nextval,
 		:NEW.COMBAT_EPISODE_ID,
 		:NEW.PERSON_ID,
 		:NEW.OEFOIFSOURCE_ID,
 		:NEW.COMBATPAYTYPE_ID,
 		:NEW.COMBATLOCATIONTYPE_ID,
		:NEW.STD_INSTITUTION_ID,
 		:NEW.COMBAT_FROM_DATE_TXT,
 		:NEW.COMBAT_TO_DATE_TXT,
 		:NEW.RECORD_CREATED_BY,
 		:NEW.RECORD_CREATED_DATE,
 		:NEW.RECORD_MODIFIED_BY,
 		:NEW.RECORD_MODIFIED_DATE,
 		:NEW.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end COMBAT_EPISODE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM COMBAT_EPISODE FOR ADR.COMBAT_EPISODE;


ALTER TABLE ADR.COMBAT_EPISODE ADD (
  CONSTRAINT CMBTEPSD_PK
  PRIMARY KEY
  (COMBAT_EPISODE_ID)
  USING INDEX ADR.CMBTEPSD_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COMBAT_EPISODE ADD (
  CONSTRAINT CMBTEPSD_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COMBAT_EPISODE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_EPISODE TO ADR_RW;

GRANT SELECT ON ADR.COMBAT_EPISODE TO ES_R;

GRANT INSERT, SELECT ON ADR.COMBAT_EPISODE TO ES_RW;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SHAD_REGISTRY_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.SHAD_REGISTRY_DETAIL
(
  SHAD_REGISTRY_DETAIL_ID  NUMBER(20)           NOT NULL,
  SHAD_REGISTRY_ID         NUMBER(20)           NOT NULL,
  SHAD_DOCUMENT_TYPE_ID    NUMBER(20)           NOT NULL,
  DOCUMENT_RECEIVED_DATE   DATE,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SHAD_REGISTRY_DETAIL IS 'Detail table for SHAD registry.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.SHAD_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.SHAD_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.SHAD_DOCUMENT_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.DOCUMENT_RECEIVED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SHADREGDTL_PK ON ADR.SHAD_REGISTRY_DETAIL
(SHAD_REGISTRY_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADREGDTL_SHADRGSTRY_FK_I ON ADR.SHAD_REGISTRY_DETAIL
(SHAD_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADREGDTL_STD_SHADOCTYP_FK_I ON ADR.SHAD_REGISTRY_DETAIL
(SHAD_DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SHAD_REGISTRY_det_audir_trgr
after Update or Delete or Insert
ON ADR.SHAD_REGISTRY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SHAD_REGISTRY_DETAIL_H
		(
 		SHAD_REGISTRY_DETAIL_H_ID
 		,SHAD_REGISTRY_DETAIL_ID
 		,SHAD_REGISTRY_ID
 		,SHAD_DOCUMENT_TYPE_ID
		,DOCUMENT_RECEIVED_DATE
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_DETAIL_H_S.nextval,
		:old.SHAD_REGISTRY_DETAIL_ID,
		:old.SHAD_REGISTRY_ID,
		:old.SHAD_DOCUMENT_TYPE_ID,
		:OLD.DOCUMENT_RECEIVED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SHAD_REGISTRY_DETAIL_H
		(
 		SHAD_REGISTRY_DETAIL_H_ID
 		,SHAD_REGISTRY_DETAIL_ID
 		,SHAD_REGISTRY_ID
 		,SHAD_DOCUMENT_TYPE_ID
		,DOCUMENT_RECEIVED_DATE
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_DETAIL_H_S.nextval,
		:new.SHAD_REGISTRY_DETAIL_ID,
		:new.SHAD_REGISTRY_ID,
		:new.SHAD_DOCUMENT_TYPE_ID,
		:new.DOCUMENT_RECEIVED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SHAD_REGISTRY_det_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SHAD_REGISTRY_DETAIL FOR ADR.SHAD_REGISTRY_DETAIL;


ALTER TABLE ADR.SHAD_REGISTRY_DETAIL ADD (
  CONSTRAINT SHADREGDTL_PK
  PRIMARY KEY
  (SHAD_REGISTRY_DETAIL_ID)
  USING INDEX ADR.SHADREGDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL ADD (
  CONSTRAINT SHADREGDTL_SHADRGSTRY_FK 
  FOREIGN KEY (SHAD_REGISTRY_ID) 
  REFERENCES ADR.SHAD_REGISTRY (SHAD_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SHAD_REGISTRY_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.SHAD_REGISTRY_DETAIL TO ES_RW;
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY CASCADE CONSTRAINTS;

CREATE TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY
(
  NCOA_ADDRESS_VERIFY_SUMMARY_ID  NUMBER(20)    NOT NULL,
  SCREENED_ADDRESS_COUNT          NUMBER(10),
  EXCLUDED_ADDRESS_COUNT          NUMBER(10),
  DECEASED_ADDRESS_COUNT          NUMBER(10),
  SENT_TO_AAC_COUNT               NUMBER(10),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY IS 'Contains a summary of the address batch that was sent for NCOA processing';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.NCOA_ADDRESS_VERIFY_SUMMARY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.VERIFYSUM_PK ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY
(NCOA_ADDRESS_VERIFY_SUMMARY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM NCOA_ADDRESS_VERIFY_SUMMARY FOR ADR.NCOA_ADDRESS_VERIFY_SUMMARY;


ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY ADD (
  CONSTRAINT VERIFYSUM_PK
  PRIMARY KEY
  (NCOA_ADDRESS_VERIFY_SUMMARY_ID)
  USING INDEX ADR.VERIFYSUM_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY TO ADR_RW;

GRANT SELECT ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY TO ES_R;

GRANT INSERT, SELECT ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_TRAVEL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_TRAVEL_H
(
  BENEFICIARY_TRAVEL_H_ID  NUMBER(20)           NOT NULL,
  TRANSACTION_TYPE_CODE    VARCHAR2(1 BYTE)     NOT NULL,
  BENEFICIARY_TRAVEL_ID    NUMBER(20)           NOT NULL,
  PERSON_ID                NUMBER(20)           NOT NULL,
  STD_INSTITUTION_ID       NUMBER(20),
  INCOME_YEAR              NUMBER(4),
  TRAVEL_ELIGIBILITY_IND   VARCHAR2(1 BYTE),
  TRAVEL_CLAIM_DATE        DATE,
  TRAVEL_CERTIFIED_DATE    DATE,
  TRAVEL_CERTIFIED_AMOUNT  NUMBER(10,2),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_TRAVEL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.BENEFICIARY_TRAVEL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.BENEFICIARY_TRAVEL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.INCOME_YEAR IS 'Incomeyearforwhichthe visitsummaryinformation isbeingcollected.IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRAVEL_ELIGIBILITY_IND IS 'BR3553EligibleIndicator isdefinedasacodeto indicateifthisperson isrequiredtoperforma BeneficiaryTraveltest toreceivebenefits.The acceptablevaluesare Yes/No.This determinationisdoneby VISTAandsenttotheHEC .Ifaveteranis30-100% serviceconnectedorin receiptofVAPensionhe isentitledto BeneficiaryTravelupon requestwithouttheneed tosupplyfinancial information. Thebelowbusinessrules areappliedonVISTA.The veteranisrequiredto supplyfinancial informationtodetermine ifhe/sheiseligibleto receivebeneficiary travel.Ifhe/shehasone ofthefollowingprimary orothereligibilities: Non-ServiceConnected ServiceConnected0% non-compensable Lessthan30%service connected WWIorMexicanBorder veteran PurpleHeart POWORtheveteranis inreceiptofMedicaidOR isinreceiptofMilitary RetirementDisabilityThe veteranisNOTrequired tosupplyfinancial informationtodetermine ifhe/sheiseligibleto receivebeneficiary travelbenefits. Ifhe/sheis/hasoneof thefollowing: TheveteranIsa DomiciliaryInpatient TheveteranIsDeceased Theveteranhasoneof thefollowing primary/other eligibilities 1.ReceivingVAPension 2.ServiceConnected30- 100%';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRAVEL_CLAIM_DATE IS 'Dateonwhichatravel benefitsclaimwas submitted.TravelClaimDate/Timeis definedasthe BeneficiaryTravelCLAIM date/timeDatemustbe precise.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRAVEL_CERTIFIED_DATE IS 'DateCertifiedisdefined asthedateofannual incomecertificationused intheBeneficialTravel Claimprocess.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.TRAVEL_CERTIFIED_AMOUNT IS 'AmountCertifiedis definedasthepatients annualincomeforthe previousyearasreported bythepatient.Ifthe veteranisrequiredtodo abeneficiarytraveltest thisnumberwillbe comparedtotheVA Pensionthresholdbased on#ofdependents.This comparisonisamanual comparisondoneonVISTA bythetravelclerk.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_TRAVEL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BENTRVLH_PK ON ADR.BENEFICIARY_TRAVEL_H
(BENEFICIARY_TRAVEL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BENTRVLH_PRSNID_NU_I ON ADR.BENEFICIARY_TRAVEL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_TRAVEL_H FOR ADR.BENEFICIARY_TRAVEL_H;


ALTER TABLE ADR.BENEFICIARY_TRAVEL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_006
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT BENTRVLH_PK
  PRIMARY KEY
  (BENEFICIARY_TRAVEL_H_ID)
  USING INDEX ADR.BENTRVLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ADR_R;

GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_TRAVEL_H TO ES_RW;
ALTER TABLE ADR.RPT_USERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_USERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_USERS
(
  RPT_USER_ID              NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  USERID                   NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_USERS IS 'ESR reporting table: Shows which user scheduled a particular report for run.';

COMMENT ON COLUMN ADR.RPT_USERS.RPT_USER_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_USERS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_USERS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTUSERS_PK ON ADR.RPT_USERS
(RPT_USER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTUSERS_SCHEDRPT_FK_I ON ADR.RPT_USERS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTUSERS_USER_1_FK_I ON ADR.RPT_USERS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_USERS FOR ADR.RPT_USERS;


ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_PK
  PRIMARY KEY
  (RPT_USER_ID)
  USING INDEX ADR.RPTUSERS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTUSERS_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_USERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_USERS TO ADR_RW;

GRANT SELECT ON ADR.RPT_USERS TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_USERS TO ES_RW;
ALTER TABLE ADR.RPT_COM_ERROR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_COM_ERROR CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_COM_ERROR
(
  RPT_COM_ERROR_ID         NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  COM_AAC_ERROR_TYPE_ID    NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_COM_ERROR IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RPT_COM_ERROR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTCOMERR_COMERRTYP_FK_I ON ADR.RPT_COM_ERROR
(COM_AAC_ERROR_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTCOMERR_PK ON ADR.RPT_COM_ERROR
(RPT_COM_ERROR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTCOMERR_SCHEDRPT_FK_I ON ADR.RPT_COM_ERROR
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_COM_ERROR FOR ADR.RPT_COM_ERROR;


ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_PK
  PRIMARY KEY
  (RPT_COM_ERROR_ID)
  USING INDEX ADR.RPTCOMERR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_COMERRTYP_FK 
  FOREIGN KEY (COM_AAC_ERROR_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMERRORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTCOMERR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_COM_ERROR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_COM_ERROR TO ADR_RW;

GRANT SELECT ON ADR.RPT_COM_ERROR TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_COM_ERROR TO ES_RW;
ALTER TABLE ADR.ROLE_PERMISSIONS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLE_PERMISSIONS CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLE_PERMISSIONS
(
  ROLE_PERMISSION_ID     NUMBER(20)             NOT NULL,
  PERMISSION_TYPE_ID     NUMBER(20)             NOT NULL,
  ROLE_ID                NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLE_PERMISSIONS IS 'Intersection table mapping users and roles The USER_ROLES table is an application administration table that stores the role that determines database access for users.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.ROLE_PERMISSION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ROLEPERMS_PK ON ADR.ROLE_PERMISSIONS
(ROLE_PERMISSION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ROLEPERMS_ROLE_FK_I ON ADR.ROLE_PERMISSIONS
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ROLEPERMS_STD_PERM_FK_I ON ADR.ROLE_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ROLE_PERMSSN_audir_trgr
after Update or Delete or Insert
ON ADR.ROLE_PERMISSIONS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ROLE_PERMISSIONS_H
		(
		ROLE_PERMISSIONS_H_ID,
		ROLE_PERMISSION_ID,
		ROLE_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSIONS_H_S.nextval,
		:old.ROLE_PERMISSION_ID,
		:old.ROLE_ID,
		:old.PERMISSION_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ROLE_PERMISSIONS_H
		(
		ROLE_PERMISSIONS_H_ID,
		ROLE_PERMISSION_ID,
		ROLE_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSIONS_H_S.nextval,
		:new.ROLE_PERMISSION_ID,
		:new.ROLE_ID,
		:new.PERMISSION_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ROLE_PERMSSN_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ROLE_PERMISSIONS FOR ADR.ROLE_PERMISSIONS;


ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_PK
  PRIMARY KEY
  (ROLE_PERMISSION_ID)
  USING INDEX ADR.ROLEPERMS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT ROLEPERMS_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLE_PERMISSIONS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ROLE_PERMISSIONS TO ADR_RW;

GRANT SELECT ON ADR.ROLE_PERMISSIONS TO ES_R;

GRANT INSERT, SELECT ON ADR.ROLE_PERMISSIONS TO ES_RW;
ALTER TABLE ADR.WKF_CASE_COMMENTS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_COMMENTS CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_COMMENTS
(
  WKF_CASE_COMMENT_ID    NUMBER(20)             NOT NULL,
  WKF_CASE_ID            NUMBER(20),
  COMMENT_VALUE          VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_COMMENTS IS 'The table stores user remarks pertinent to a particular workflow case. Contains all the comment records for a case Freeform text which may be entered by the user to document pertinent information regarding the case. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.WKF_CASE_COMMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.COMMENT_VALUE IS 'Additionaltextinfo associatedwiththe messageevent';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCMTS_PK ON ADR.WKF_CASE_COMMENTS
(WKF_CASE_COMMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCMTS_WKFCASE_FK_I ON ADR.WKF_CASE_COMMENTS
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_COMM_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE_COMMENTS for each row
declare
   	mDML char(1);
begin

	if DELETING then
	     insert into WKF_CASE_Comments_H
		(
		WKF_CASE_COMMENT_H_ID,
		WKF_CASE_ID,
		WKF_CASE_COMMENT_ID,
		COMMENT_VALUE ,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_COMMENTS_H_S.nextval  ,
		:old.WKF_CASE_ID,
		:old.WKF_CASE_COMMENT_ID,
		:old.COMMENT_VALUE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

	     insert into WKF_CASE_Comments_H
		(
		WKF_CASE_COMMENT_H_ID,
		WKF_CASE_ID,
		WKF_CASE_COMMENT_ID,
		COMMENT_VALUE ,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_COMMENTS_H_S.nextval  ,
		:new.WKF_CASE_ID,
		:new.WKF_CASE_COMMENT_ID,
		:new.COMMENT_VALUE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

End WKF_CASE_COMM_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_COMMENTS FOR ADR.WKF_CASE_COMMENTS;


ALTER TABLE ADR.WKF_CASE_COMMENTS ADD (
  CONSTRAINT WKFCMTS_PK
  PRIMARY KEY
  (WKF_CASE_COMMENT_ID)
  USING INDEX ADR.WKFCMTS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_CASE_COMMENTS ADD (
  CONSTRAINT WKFCMTS_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_COMMENTS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE_COMMENTS TO ADR_RW;
ALTER TABLE ADR.EMERGENCY_RESPONSE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMERGENCY_RESPONSE CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMERGENCY_RESPONSE
(
  EMERGENCY_RESPONSE_ID     NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  STD_EMERGENCYRESPONSE_ID  NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMERGENCY_RESPONSE IS 'This feature instituted in the aftermath of Hurricane Katrina. Table lists details of any emergency response assistance provided to the Beneficiary.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.EMERGENCY_RESPONSE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.STD_EMERGENCYRESPONSE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EMERGRESP_PK ON ADR.EMERGENCY_RESPONSE
(EMERGENCY_RESPONSE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMERGRESP_PRSN_FK_I ON ADR.EMERGENCY_RESPONSE
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMERGRESP_STDEMRGNCY_FK_I ON ADR.EMERGENCY_RESPONSE
(STD_EMERGENCYRESPONSE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EMERG_RESPONSE_AUDIR_TRGR
after Update or Delete or Insert
on ADR.EMERGENCY_RESPONSE
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EMERGENCY_RESPONSE_H
		(
		EMERGENCY_RESPONSE_H_ID,
 		EMERGENCY_RESPONSE_ID,
		PERSON_ID,
		STD_EMERGENCYRESPONSE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EMERGENCY_RESPONSE_H_S.nextval,
 		:old.EMERGENCY_RESPONSE_ID,
		:old.PERSON_ID,
		:old.STD_EMERGENCYRESPONSE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EMERGENCY_RESPONSE_H
		(
		EMERGENCY_RESPONSE_H_ID,
 		EMERGENCY_RESPONSE_ID,
		PERSON_ID,
		STD_EMERGENCYRESPONSE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EMERGENCY_RESPONSE_H_S.nextval,
 		:new.EMERGENCY_RESPONSE_ID,
		:new.PERSON_ID,
		:new.STD_EMERGENCYRESPONSE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end emerg_response_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EMERGENCY_RESPONSE FOR ADR.EMERGENCY_RESPONSE;


ALTER TABLE ADR.EMERGENCY_RESPONSE ADD (
  CONSTRAINT EMERGRESP_PK
  PRIMARY KEY
  (EMERGENCY_RESPONSE_ID)
  USING INDEX ADR.EMERGRESP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EMERGENCY_RESPONSE ADD (
  CONSTRAINT EMERGRESP_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.EMERGENCY_RESPONSE TO ADREXT;

GRANT SELECT ON ADR.EMERGENCY_RESPONSE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMERGENCY_RESPONSE TO ADR_RW;

GRANT SELECT ON ADR.EMERGENCY_RESPONSE TO ES_R;

GRANT INSERT, SELECT ON ADR.EMERGENCY_RESPONSE TO ES_RW;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_ENROLLMENT_CATEGORY CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_ENROLLMENT_CATEGORY
(
  RPT_ENROLLMENT_CATEGORY_ID  NUMBER(20)        NOT NULL,
  RPT_SCHEDULED_REPORT_ID     NUMBER(20)        NOT NULL,
  STD_ENROLLMENTCATTYPE_ID    NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_ENROLLMENT_CATEGORY IS 'ESR Reporting table. Enrollment Category reports for category types such as: Enrolled In-Process Not Enrolled';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RPT_ENROLLMENT_CATEGORY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTENRLCAT_PK ON ADR.RPT_ENROLLMENT_CATEGORY
(RPT_ENROLLMENT_CATEGORY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENRLCAT_SCHEDRPT_FK_I ON ADR.RPT_ENROLLMENT_CATEGORY
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENRLCAT_STD_ENRLMNTCAT_FK_I ON ADR.RPT_ENROLLMENT_CATEGORY
(STD_ENROLLMENTCATTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_ENROLLMENT_CATEGORY FOR ADR.RPT_ENROLLMENT_CATEGORY;


ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY ADD (
  CONSTRAINT RPTENRLCAT_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_CATEGORY_ID)
  USING INDEX ADR.RPTENRLCAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY ADD (
  CONSTRAINT RPTENRLCAT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_ENROLLMENT_CATEGORY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ENROLLMENT_CATEGORY TO ADR_RW;

GRANT SELECT ON ADR.RPT_ENROLLMENT_CATEGORY TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_ENROLLMENT_CATEGORY TO ES_RW;
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.REGISTRY_LOAD_EXCEPTION CASCADE CONSTRAINTS;

CREATE TABLE ADR.REGISTRY_LOAD_EXCEPTION
(
  REGISTRY_LOAD_EXCEPTION_ID   NUMBER(20)       NOT NULL,
  REGISTRY_LOAD_STATISTICS_ID  NUMBER(20),
  RPT_EXCEPTION_TYPE_ID        NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  EXCEPTION_TXT                CLOB
)
LOB (EXCEPTION_TXT) STORE AS (
  TABLESPACE  M_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          4M
                  NEXT             4M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.REGISTRY_LOAD_EXCEPTION IS 'Stores statistics captured during migration of the Registry data from the HEC legacy system to ADR. Number of records processed, number inserted, pass count, match count etc.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.REGISTRY_LOAD_EXCEPTION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.REGISTRY_LOAD_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RGSTRLODX_PK ON ADR.REGISTRY_LOAD_EXCEPTION
(REGISTRY_LOAD_EXCEPTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RGSTRLODX_RGSTRYSTAT_FK_I ON ADR.REGISTRY_LOAD_EXCEPTION
(REGISTRY_LOAD_STATISTICS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RGSTRLODX_STD_RPTEXCPT_FK_I ON ADR.REGISTRY_LOAD_EXCEPTION
(RPT_EXCEPTION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_LOAD_EXCEPTION FOR ADR.REGISTRY_LOAD_EXCEPTION;


ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_PK
  PRIMARY KEY
  (REGISTRY_LOAD_EXCEPTION_ID)
  USING INDEX ADR.RGSTRLODX_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_RGSTRYSTAT_FK 
  FOREIGN KEY (REGISTRY_LOAD_STATISTICS_ID) 
  REFERENCES ADR.REGISTRY_LOAD_STATISTICS (REGISTRY_LOAD_STATISTICS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RGSTRLODX_STD_RPTEXCPT_FK 
  FOREIGN KEY (RPT_EXCEPTION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEXCEPTIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.REGISTRY_LOAD_EXCEPTION TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.REGISTRY_LOAD_EXCEPTION TO ADR_RW;

GRANT SELECT ON ADR.REGISTRY_LOAD_EXCEPTION TO ES_R;

GRANT INSERT, SELECT ON ADR.REGISTRY_LOAD_EXCEPTION TO ES_RW;
ALTER TABLE ADR.PERSON_RELATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RELATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RELATION
(
  PERSON_RELATION_ID             NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  STD_GENDER_ID                  NUMBER(20),
  PERSON_RELATION_TYPE_ID        NUMBER(20),
  PRSN_RELATION_MAPPING_TYPE_CD  VARCHAR2(5 BYTE),
  HEC_IEN                        VARCHAR2(20 BYTE),
  PREFIX                         VARCHAR2(12 BYTE),
  FIRST_NAME                     VARCHAR2(30 BYTE),
  MIDDLE_NAME                    VARCHAR2(30 BYTE),
  LAST_NAME                      VARCHAR2(40 BYTE),
  MAIDEN_NAME                    VARCHAR2(40 BYTE),
  SUFFIX                         VARCHAR2(12 BYTE),
  BIRTH_DATE_TXT                 VARCHAR2(14 BYTE),
  EDUCATIONAL_DEGREE             VARCHAR2(30 BYTE),
  RELATION_EFFECTIVE_DATE_TXT    VARCHAR2(14 BYTE),
  RELATION_END_DATE              DATE,
  INCAPABLE_SELF_SUPPORT_IND     VARCHAR2(1 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   4
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_RELATION IS 'The table stores information about the spouse and dependent(s) associated with a person, including their name, date of birth, gender, and type of relationship. Spouses and Dependents are not enumerated by the Identity Management service. They exist only as details to the Person record. PERSON_ID is a mandatory foreign key to this table. DEMOGRAPHICS / ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.PERSON_RELATION.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RELATION.STD_GENDER_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.PERSON_RELATION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.PRSN_RELATION_MAPPING_TYPE_CD IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.HEC_IEN IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_RELATION.FIRST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.MIDDLE_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.LAST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.MAIDEN_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_RELATION.BIRTH_DATE_TXT IS 'BR7731Thedateofbirth isdefinedasthebirth dateoftheveteranor spouseassociatedwith thecommunicationtobe mailed.';

COMMENT ON COLUMN ADR.PERSON_RELATION.EDUCATIONAL_DEGREE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RELATION_EFFECTIVE_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RELATION_END_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.INCAPABLE_SELF_SUPPORT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRSNREL_PK ON ADR.PERSON_RELATION
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNREL_PRSN_FK_I ON ADR.PERSON_RELATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNREL_SG_FK_I ON ADR.PERSON_RELATION
(STD_GENDER_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNREL_STD_PRSNREL_FK_I ON ADR.PERSON_RELATION
(PRSN_RELATION_MAPPING_TYPE_CD)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNREL_STD_RELTYP_FK_I ON ADR.PERSON_RELATION
(PERSON_RELATION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERSON_RELATION_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_RELATION
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERSON_RELATION_H
		(
		PERSON_RELATION_H_ID,
		PERSON_RELATION_ID,
		PERSON_ID,
		STD_GENDER_ID,
		PERSON_RELATION_TYPE_ID,
		PRSN_RELATION_MAPPING_TYPE_CD,
		HEC_IEN,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		SUFFIX,
		BIRTH_DATE_TXT,
		EDUCATIONAL_DEGREE,
		RELATION_EFFECTIVE_DATE_TXT,
		RELATION_END_DATE,
		INCAPABLE_SELF_SUPPORT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_RELATION_H_S.nextval,
		:old.PERSON_RELATION_ID,
		:old.PERSON_ID,
		:old.STD_GENDER_ID,
		:old.PERSON_RELATION_TYPE_ID,
		:old.PRSN_RELATION_MAPPING_TYPE_CD,
		:old.HEC_IEN,
		:old.PREFIX,
		:old.FIRST_NAME,
		:old.MIDDLE_NAME,
		:old.LAST_NAME,
		:old.MAIDEN_NAME,
		:old.SUFFIX,
		:old.BIRTH_DATE_TXT,
		:old.EDUCATIONAL_DEGREE,
		:old.RELATION_EFFECTIVE_DATE_TXT,
		:old.RELATION_END_DATE,
		:old.INCAPABLE_SELF_SUPPORT_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERSON_RELATION_H
		(
		PERSON_RELATION_H_ID,
		PERSON_RELATION_ID,
		PERSON_ID,
		STD_GENDER_ID,
		PERSON_RELATION_TYPE_ID,
		PRSN_RELATION_MAPPING_TYPE_CD,
		HEC_IEN,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		SUFFIX,
		BIRTH_DATE_TXT,
		EDUCATIONAL_DEGREE,
		RELATION_EFFECTIVE_DATE_TXT,
		RELATION_END_DATE,
		INCAPABLE_SELF_SUPPORT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_RELATION_H_S.nextval,
		:new.PERSON_RELATION_ID,
		:new.PERSON_ID,
		:new.STD_GENDER_ID,
		:new.PERSON_RELATION_TYPE_ID,
		:new.PRSN_RELATION_MAPPING_TYPE_CD,
		:new.HEC_IEN,
		:new.PREFIX,
		:new.FIRST_NAME,
		:new.MIDDLE_NAME,
		:new.LAST_NAME,
		:new.MAIDEN_NAME,
		:new.SUFFIX,
		:new.BIRTH_DATE_TXT,
		:new.EDUCATIONAL_DEGREE,
		:new.RELATION_EFFECTIVE_DATE_TXT,
		:new.RELATION_END_DATE,
		:new.INCAPABLE_SELF_SUPPORT_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PERSON_RELATION_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON_RELATION FOR ADR.PERSON_RELATION;


ALTER TABLE ADR.PERSON_RELATION ADD (
  CONSTRAINT PRSNREL_PK
  PRIMARY KEY
  (PERSON_RELATION_ID)
  USING INDEX ADR.PRSNREL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_RELATION ADD (
  CONSTRAINT PRSNREL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.PERSON_RELATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RELATION TO ADR_RW;

GRANT SELECT ON ADR.PERSON_RELATION TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_RELATION TO ES_RW;

GRANT SELECT ON ADR.PERSON_RELATION TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_RELATION TO PSIM_ADR_RW;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H
(
  CONFIDENTIAL_ADDR_CATGRY_H_ID  NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  CONFIDENTIAL_ADDR_CATGRY_ID    NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  CONFIDENTIAL_ADDR_TYPE_ID      NUMBER(20)     NOT NULL,
  INACTIVE_FLAG                  NUMBER(1)      DEFAULT 0                     NOT NULL,
  INACTIVE_DATE                  DATE,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL,
  RECORD_MODIFIED_SITE_ID        NUMBER(20),
  RECORD_MODIFIED_SRC_NAME       VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.CONFIDENTIAL_ADDR_CATGRY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.CONFIDENTIAL_ADDR_CATGRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.CNFADDRH_PK ON ADR.CONFIDENTIAL_ADDR_CATGRY_H
(CONFIDENTIAL_ADDR_CATGRY_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CNFADDRH_PRSNID_NU_I ON ADR.CONFIDENTIAL_ADDR_CATGRY_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CONFIDENTIAL_ADDR_CATGRY_H FOR ADR.CONFIDENTIAL_ADDR_CATGRY_H;


ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_010
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CNFADDRH_PK
  PRIMARY KEY
  (CONFIDENTIAL_ADDR_CATGRY_H_ID)
  USING INDEX ADR.CNFADDRH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ADR_R;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ADR_RW;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO ES_RW;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY_H TO PSIM_ADR_R;
ALTER TABLE ADR.SERVICE_CONNECTED
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SERVICE_CONNECTED CASCADE CONSTRAINTS;

CREATE TABLE ADR.SERVICE_CONNECTED
(
  SERVICE_CONNECTED_ID            NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  SC_TOTAL_AMOUNT                 NUMBER(10,2),
  SERVICE_AWARD_DATE_TXT          VARCHAR2(14 BYTE),
  SC_COMBINED_PERCENT             NUMBER(3),
  SC_COMBINED_PCT_EFCTV_DATE_TXT  VARCHAR2(14 BYTE),
  SC_PERMANENT_AND_TOTAL_IND      NUMBER(1)     DEFAULT 0,
  SC_PERMNT_AND_TOTAL_EFCTV_DT    DATE,
  UNEMPLOYABLE_INDICATOR          NUMBER(1)     DEFAULT 0,
  SERVICE_CONNECTED_IND           NUMBER(1),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SERVICE_CONNECTED IS 'The table stores information about a persons disabilities that are related to their time in the military, including the award amount, the associated dates, and whether the disability is permanent and total, and whether the person is unemployable. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SERVICE_CONNECTED_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_TOTAL_AMOUNT IS 'ServiceConnected-Total checkamount';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SERVICE_AWARD_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_COMBINED_PERCENT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_COMBINED_PCT_EFCTV_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_PERMANENT_AND_TOTAL_IND IS 'BR1611Permanent&Total Indicatorisdefinedasa codethatindicatesif thepatientis permanentlyandtotally disableddeterminedby VAROduetoaservice- connectedcondition.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_PERMNT_AND_TOTAL_EFCTV_DT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.UNEMPLOYABLE_INDICATOR IS 'BR1613Unemployable Indicatorisdefinedasa codethatindicatesif thispatientisrated unemployablebytheVARO duetoaservice connectedcondition.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SVCCON_PK ON ADR.SERVICE_CONNECTED
(SERVICE_CONNECTED_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SVCCON_PRSN_FK_I ON ADR.SERVICE_CONNECTED
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SERVICE_CONNECTED_AUDIR_TRGR
after Update or Delete or Insert
on ADR.SERVICE_CONNECTED
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SERVICE_CONNECTED_H
		(
		SERVICE_CONNECTED_H_ID,
		SERVICE_CONNECTED_ID,
		SC_TOTAL_AMOUNT,
		SERVICE_AWARD_DATE_TXT,
		SC_COMBINED_PERCENT,
		SC_COMBINED_PCT_EFCTV_DATE_TXT,
		SC_PERMANENT_AND_TOTAL_IND,
		SC_PERMNT_AND_TOTAL_EFCTV_DT,
		UNEMPLOYABLE_INDICATOR,
		SERVICE_CONNECTED_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SERVICE_CONNECTED_H_S.nextval,
		:old.SERVICE_CONNECTED_ID,
		:old.SC_TOTAL_AMOUNT,
		:old.SERVICE_AWARD_DATE_TXT,
		:old.SC_COMBINED_PERCENT,
		:old.SC_COMBINED_PCT_EFCTV_DATE_TXT,
		:old.SC_PERMANENT_AND_TOTAL_IND,
		:old.SC_PERMNT_AND_TOTAL_EFCTV_DT,
		:old.UNEMPLOYABLE_INDICATOR,
		:old.SERVICE_CONNECTED_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SERVICE_CONNECTED_H
		(
		SERVICE_CONNECTED_H_ID,
		SERVICE_CONNECTED_ID,
		SC_TOTAL_AMOUNT,
		SERVICE_AWARD_DATE_TXT,
		SC_COMBINED_PERCENT,
		SC_COMBINED_PCT_EFCTV_DATE_TXT,
		SC_PERMANENT_AND_TOTAL_IND,
		SC_PERMNT_AND_TOTAL_EFCTV_DT,
		UNEMPLOYABLE_INDICATOR,
		SERVICE_CONNECTED_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SERVICE_CONNECTED_H_S.nextval,
		:new.SERVICE_CONNECTED_ID,
		:new.SC_TOTAL_AMOUNT,
		:new.SERVICE_AWARD_DATE_TXT,
		:new.SC_COMBINED_PERCENT,
		:new.SC_COMBINED_PCT_EFCTV_DATE_TXT,
		:new.SC_PERMANENT_AND_TOTAL_IND,
		:new.SC_PERMNT_AND_TOTAL_EFCTV_DT,
		:new.UNEMPLOYABLE_INDICATOR,
		:new.SERVICE_CONNECTED_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end SERVICE_CONNECTED_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SERVICE_CONNECTED FOR ADR.SERVICE_CONNECTED;


ALTER TABLE ADR.SERVICE_CONNECTED ADD (
  CONSTRAINT SVCCON_PK
  PRIMARY KEY
  (SERVICE_CONNECTED_ID)
  USING INDEX ADR.SVCCON_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SERVICE_CONNECTED ADD (
  CONSTRAINT SVCCON_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.SERVICE_CONNECTED TO ADREXT;

GRANT SELECT ON ADR.SERVICE_CONNECTED TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SERVICE_CONNECTED TO ADR_RW;

GRANT SELECT ON ADR.SERVICE_CONNECTED TO ES_R;

GRANT INSERT, SELECT ON ADR.SERVICE_CONNECTED TO ES_RW;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PRISONER_OF_WAR_REGISTRY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PRISONER_OF_WAR_REGISTRY_H
(
  PRISONER_OF_WAR_REGISTRY_H_ID  NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  PRISONER_OF_WAR_REGISTRY_ID    NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20),
  REGISTRY_TRAIT_ID              NUMBER(20),
  POW_STDYESNO_ID                NUMBER(20),
  LEGACY_ICN                     VARCHAR2(30 BYTE),
  LEGACY_USERNAME                VARCHAR2(30 BYTE),
  LEGACY_ENTERED_DATE            DATE,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PRISONER_OF_WAR_REGISTRY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.PRISONER_OF_WAR_REGISTRY_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.PRISONER_OF_WAR_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.POWH_PK ON ADR.PRISONER_OF_WAR_REGISTRY_H
(PRISONER_OF_WAR_REGISTRY_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWH_POWREGID_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY_H
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWH_PRSNID_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWH_REGTRAIT_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PRISONER_OF_WAR_REGISTRY_H FOR ADR.PRISONER_OF_WAR_REGISTRY_H;


ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_011
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT POWH_PK
  PRIMARY KEY
  (PRISONER_OF_WAR_REGISTRY_H_ID)
  USING INDEX ADR.POWH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY_H TO ADR_R;

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY_H TO ADR_RW;

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.PRISONER_OF_WAR_REGISTRY_H TO ES_RW;
ALTER TABLE ADR.FEE_BASIS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.FEE_BASIS CASCADE CONSTRAINTS;

CREATE TABLE ADR.FEE_BASIS
(
  FEE_BASIS_ID                 NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  FEE_BASIS_PROGRAM_TYPE_ID    NUMBER(20),
  FEE_BASIS_TREATMENT_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  AUTHORIZATION_FROM_DATE      DATE,
  AUTHORIZATION_TO_DATE        DATE,
  FEE_BASIS_REPORT_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.FEE_BASIS IS 'The table stores information about persons who use medical services outside the VHA, but paid for by the VHA because it is not feasible economically for care to be provided due to geographical inaccessibility. PERSON_ID Foreign key to the PERSON table. FEE_BASIS_PROGRAM_TYPE_ID Foreign key to the FEE_BASIS_PROGRAM_TYPE table. Indicates the type of fee basis program associated with the person (for example, Pharmacy, Outpatient). FEE_BASIS_TREATMENT_TYPE_ID Foreign key to the FEE_BASIS_TREATMENT_TYPE table. Indicates the applicable type of treatment for the fee basis program (for example, Short Term Fee Status, Home Nursing Services). STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.FEE_BASIS.FEE_BASIS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.FEE_BASIS.FEE_BASIS_PROGRAM_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.FEE_BASIS_TREATMENT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.FEE_BASIS.AUTHORIZATION_FROM_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.AUTHORIZATION_TO_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.FEE_BASIS_REPORT_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.FEE_BASIS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.FEEBASIS_PK ON ADR.FEE_BASIS
(FEE_BASIS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBASIS_PRSN_FK_I ON ADR.FEE_BASIS
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBASIS_STDINST_FK_I ON ADR.FEE_BASIS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBSIS_STD_FEEBSISPROG_FK_I ON ADR.FEE_BASIS
(FEE_BASIS_PROGRAM_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.FEEBSIS_STD_FEEBSISTRTMT_FK_I ON ADR.FEE_BASIS
(FEE_BASIS_TREATMENT_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.FEE_BASIS_audir_trgr
after Update or Delete or Insert
ON ADR.FEE_BASIS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into FEE_BASIS_H
		(
		FEE_BASIS_H_ID,
		FEE_BASIS_ID,
		PERSON_ID,
		FEE_BASIS_PROGRAM_TYPE_ID,
		FEE_BASIS_TREATMENT_TYPE_ID,
		STD_INSTITUTION_ID,
		AUTHORIZATION_FROM_DATE,
		AUTHORIZATION_TO_DATE,
		FEE_BASIS_REPORT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FEE_BASIS_H_S.nextval,
		:old.FEE_BASIS_ID,
		:old.PERSON_ID,
		:old.FEE_BASIS_PROGRAM_TYPE_ID,
		:old.FEE_BASIS_TREATMENT_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.AUTHORIZATION_FROM_DATE,
		:old.AUTHORIZATION_TO_DATE,
		:old.FEE_BASIS_REPORT_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FEE_BASIS_H
		(
		FEE_BASIS_H_ID,
		FEE_BASIS_ID,
		PERSON_ID,
		FEE_BASIS_PROGRAM_TYPE_ID,
		FEE_BASIS_TREATMENT_TYPE_ID,
		STD_INSTITUTION_ID,
		AUTHORIZATION_FROM_DATE,
		AUTHORIZATION_TO_DATE,
		FEE_BASIS_REPORT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FEE_BASIS_H_S.nextval,
		:new.FEE_BASIS_ID,
		:new.PERSON_ID,
		:new.FEE_BASIS_PROGRAM_TYPE_ID,
		:new.FEE_BASIS_TREATMENT_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.AUTHORIZATION_FROM_DATE,
		:new.AUTHORIZATION_TO_DATE,
		:new.FEE_BASIS_REPORT_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  FEE_BASIS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM FEE_BASIS FOR ADR.FEE_BASIS;


ALTER TABLE ADR.FEE_BASIS ADD (
  CONSTRAINT FEEBASIS_PK
  PRIMARY KEY
  (FEE_BASIS_ID)
  USING INDEX ADR.FEEBASIS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.FEE_BASIS ADD (
  CONSTRAINT FEEBASIS_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.FEE_BASIS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.FEE_BASIS TO ADR_RW;

GRANT SELECT ON ADR.FEE_BASIS TO ES_R;

GRANT INSERT, SELECT ON ADR.FEE_BASIS TO ES_RW;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_INVALID_ADDRESS_REASON CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_INVALID_ADDRESS_REASON
(
  RPT_INVALID_ADDRESS_REASON_ID  NUMBER(20)     NOT NULL,
  RPT_SCHEDULED_REPORT_ID        NUMBER(20)     NOT NULL,
  ADDRESS_INVALID_TYPE_ID        NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_INVALID_ADDRESS_REASON IS 'ESR reporting table. Provides for reporting on the basis of various invalid address reasons: Mail was returned or is otherwise known to be undeliverable Veteran has no known address';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RPT_INVALID_ADDRESS_REASON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.ADDRESS_INVALID_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTINVADDR_ADDRINVTYP_FK_I ON ADR.RPT_INVALID_ADDRESS_REASON
(ADDRESS_INVALID_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTINVADDR_PK ON ADR.RPT_INVALID_ADDRESS_REASON
(RPT_INVALID_ADDRESS_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTINVADDR_SCHEDRPT_FK_I ON ADR.RPT_INVALID_ADDRESS_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_INVALID_ADDRESS_REASON FOR ADR.RPT_INVALID_ADDRESS_REASON;


ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON ADD (
  CONSTRAINT RPTINVADDR_PK
  PRIMARY KEY
  (RPT_INVALID_ADDRESS_REASON_ID)
  USING INDEX ADR.RPTINVADDR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON ADD (
  CONSTRAINT RPTINVADDR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_INVALID_ADDRESS_REASON TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_INVALID_ADDRESS_REASON TO ADR_RW;

GRANT SELECT ON ADR.RPT_INVALID_ADDRESS_REASON TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_INVALID_ADDRESS_REASON TO ES_RW;
ALTER TABLE ADR.EGT_STATISTICS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_STATISTICS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_STATISTICS_H
(
  EGT_STATISTICS_H_ID             NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  EGT_STATISTICS_ID               NUMBER(20)    NOT NULL,
  EGT_SETTING_ID                  NUMBER(20)    NOT NULL,
  EGT_STATUS_TYPE_ID              NUMBER(20),
  PROCESS_NUMBER                  VARCHAR2(20 BYTE),
  PROCESS_MESSAGE_DESCRIPTION     VARCHAR2(250 BYTE),
  PROCESS_START_DATE              DATE,
  PROCESS_END_DATE                DATE,
  IN_PROCESS_CATGRY_COUNT         NUMBER(10),
  ENROLLED_CATGRY_COUNT           NUMBER(10),
  BENEFICIARY_PROCESSED_COUNT     NUMBER(10),
  BENEFICIARY_NOT_ENROLLED_COUNT  NUMBER(10),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_STATISTICS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.EGT_STATISTICS_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.EGT_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.EGT_SETTING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.PROCESS_START_DATE IS 'BR2312ProcessStarted Date/Time:Holdsthe date/timethatthe processtorecalculate theenrollmentstatuses basedonthenewEGT settingstarted.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.PROCESS_END_DATE IS 'BR2316ProcessEnded Date/Timeisthe Date/Timethatthe processtorecalculate theenrollmentstatuses basedonthenewEGT settingended.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.ENROLLED_CATGRY_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.BENEFICIARY_PROCESSED_COUNT IS 'BR2326TotalVETSIn Processisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryofIn Processasaresultof therecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.BENEFICIARY_NOT_ENROLLED_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_STATISTICS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EGTSTATH_PK ON ADR.EGT_STATISTICS_H
(EGT_STATISTICS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EGT_STATISTICS_H FOR ADR.EGT_STATISTICS_H;


ALTER TABLE ADR.EGT_STATISTICS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_013
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT EGTSTATH_PK
  PRIMARY KEY
  (EGT_STATISTICS_H_ID)
  USING INDEX ADR.EGTSTATH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_STATISTICS_H TO ADR_R;

GRANT SELECT ON ADR.EGT_STATISTICS_H TO ADR_RW;

GRANT SELECT ON ADR.EGT_STATISTICS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_STATISTICS_H TO ES_RW;
ALTER TABLE ADR.PERSON_ETHNICITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_ETHNICITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_ETHNICITY
(
  PERSON_ETHNICITY_ID        NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_ETHNICITY_ID           NUMBER(20)         NOT NULL,
  COLLECTION_METHOD_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_ETHNICITY IS 'The table stores information a persons reported ethnic group and the method by which that information was reported. DEMOGRAPHICS';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.PERSON_ETHNICITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.STD_ETHNICITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.COLLECTION_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNETNCTY_PK ON ADR.PERSON_ETHNICITY
(PERSON_ETHNICITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTY_PRSN_FK_I ON ADR.PERSON_ETHNICITY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTY_STDETH_FK_I ON ADR.PERSON_ETHNICITY
(STD_ETHNICITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTY_STDINST2_FK_I ON ADR.PERSON_ETHNICITY
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTY_STD_CLLNMTHD_FK_I ON ADR.PERSON_ETHNICITY
(COLLECTION_METHOD_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERSON_ETHNICITY_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_ETHNICITY for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into PERSON_ETHNICITY_H
    (
    PERSON_ETHNICITY_H_ID,
    PERSON_ETHNICITY_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_ETHNICITY_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_ETHNICITY_H_S.nextval,
    :old.PERSON_ETHNICITY_ID,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.STD_ETHNICITY_ID,
    :old.COLLECTION_METHOD_TYPE_ID,
    :old.PERSON_ID,
    :old.RECORD_MODIFIED_COUNT,
    :old.RECORD_MODIFIED_SITE_ID,
    :old.RECORD_MODIFIED_SRC_NAME,
    'D'
    );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into PERSON_ETHNICITY_H
    (
    PERSON_ETHNICITY_H_ID,
    PERSON_ETHNICITY_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_ETHNICITY_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_ETHNICITY_H_S.nextval,
    :new.PERSON_ETHNICITY_ID,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.STD_ETHNICITY_ID,
    :new.COLLECTION_METHOD_TYPE_ID,
    :new.PERSON_ID,
    :new.RECORD_MODIFIED_COUNT,
    :new.RECORD_MODIFIED_SITE_ID,
    :new.RECORD_MODIFIED_SRC_NAME,
    mDML
    );

  end if;

end PERSON_ETHNICITY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON_ETHNICITY FOR ADR.PERSON_ETHNICITY;


ALTER TABLE ADR.PERSON_ETHNICITY ADD (
  CONSTRAINT PRSNETNCTY_PK
  PRIMARY KEY
  (PERSON_ETHNICITY_ID)
  USING INDEX ADR.PRSNETNCTY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_ETHNICITY ADD (
  CONSTRAINT PRSNETNCTY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.PERSON_ETHNICITY TO ADREXT;

GRANT SELECT ON ADR.PERSON_ETHNICITY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_ETHNICITY TO ADR_RW;

GRANT SELECT ON ADR.PERSON_ETHNICITY TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_ETHNICITY TO ES_RW;

GRANT SELECT ON ADR.PERSON_ETHNICITY TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_ETHNICITY TO PSIM_ADR_RW;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_SCHEDULED_REPORTS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_SCHEDULED_REPORTS
(
  RPT_SCHEDULED_REPORT_ID         NUMBER(20)    NOT NULL,
  USERID                          NUMBER(20),
  RPT_STANDARD_REPORT_ID          NUMBER(20)    NOT NULL,
  RPT_DIVISION_TYPE_ID            NUMBER(20),
  RPT_SCHEDULE_TYPE_ID            NUMBER(20),
  RPT_MONTH_LIST_TYPE_ID          NUMBER(20),
  RPT_QUARTER_LIST_TYPE_ID        NUMBER(20),
  RPT_DAY_OF_QUARTER_TYPE_ID      NUMBER(20),
  RPT_DAY_OF_MONTH_TYPE_ID        NUMBER(20),
  RPT_DAY_OF_WEEK_TYPE_ID         NUMBER(20),
  RPT_WEEK_OF_MONTH_TYPE_ID       NUMBER(20),
  RPT_OUTPUT_FORMAT_TYPE_ID       NUMBER(20),
  RPT_OUTPUT_FILE_TYPE_ID         NUMBER(20),
  RPT_WORK_ITEM_STATUS_TYPE_ID    NUMBER(20),
  RPT_PERIOD_TYPE_ID              NUMBER(20),
  RPT_SITE_DISPLAY_TYPE_ID        NUMBER(20),
  RPT_DETAIL_BY_TYPE_ID           NUMBER(20),
  RPT_DETAIL_FOR_TYPE_ID          NUMBER(20),
  RPT_RUN_FREQUENCY_TYPE_ID       NUMBER(20),
  RPT_EXCEPTION_TYPE_ID           NUMBER(20),
  RPT_ENROLLPRSTAT_ID             NUMBER(20),
  REPORT_BATCH_NUMBER             VARCHAR2(20 BYTE),
  BEGIN_INCOME_YEAR               NUMBER(4),
  END_INCOME_YEAR                 NUMBER(4),
  REPORT_GENERATE_DATE            DATE,
  REPORT_FROM_DATE                DATE,
  REPORT_TO_DATE                  DATE,
  REPORT_AS_OF_DATE               DATE,
  REPORT_RECIPIENT_EMAIL          VARCHAR2(1000 BYTE),
  REPORTING_PERIOD_YEAR           NUMBER(4),
  REPORTING_PERIOD_FROM_DATE      DATE,
  REPORTING_PERIOD_TO_DATE        DATE,
  LETTER_FILE_RECEIVED_DATE       DATE,
  ENROLLMENT_CHANGE_EFCTV_DATE    DATE,
  ADDRESS_UPDATE_DAYS_COUNT       NUMBER(10),
  PURPLE_HEART_DAYS_COUNT         NUMBER(10),
  ENROLLMENT_STATUS_RECORD_COUNT  NUMBER(10),
  DAY_NUMBER                      NUMBER(4),
  HOUR_NUMBER                     NUMBER(4),
  MINUTE_NUMBER                   NUMBER(4),
  RANDOM_RECORDS_COUNT            NUMBER(10),
  INCLUDE_USERS_FLAG              NUMBER(1)     DEFAULT 0                     NOT NULL,
  RUN_REPORT_BY_USER_FLAG         NUMBER(1)     DEFAULT 0                     NOT NULL,
  OUTLIER_DAYS                    NUMBER(3),
  UPDATE_BETWEEN_DAYS             NUMBER(3),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  RPT_SORTBY_TYPE_ID              NUMBER(20),
  PRIOR_ENROLLMENT                VARCHAR2(5 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_SCHEDULED_REPORTS IS 'ESR Reporting table; This table stores all the reports that have been scheduled to run';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RPT_STANDARD_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.REPORT_BATCH_NUMBER IS 'Batchnumberthatthe reportbelongsto.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.BEGIN_INCOME_YEAR IS 'IncomeYearSpecifiedfor Reportrun';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.END_INCOME_YEAR IS 'IncomeYearSpecifiedfor Reportrun';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.REPORT_GENERATE_DATE IS 'Datethereportwas generated';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.ADDRESS_UPDATE_DAYS_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.PURPLE_HEART_DAYS_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.ENROLLMENT_STATUS_RECORD_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.INCLUDE_USERS_FLAG IS 'NumericFLAGfield-1 indicatesthatUsersare includedinthereport outputemail';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RUN_REPORT_BY_USER_FLAG IS 'NumericFLAGfield-1 indicatesthatreportis beingrunonaperuser basis';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RPT_SORTBY_TYPE_ID IS 'Foreign Key from  RPT_SORTBY_TYPE table';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.PRIOR_ENROLLMENT IS 'Indicates prior enrollment for the report generated either with Prior enrollment, without prior enrollment or all records. Valid values: all, yes, and no';


CREATE UNIQUE INDEX ADR.SCHEDRPT_PK ON ADR.RPT_SCHEDULED_REPORTS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SCHEDRPT_RPTDIVTYPE_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DIVISION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SCHEDRPT_RPTWRKITM_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_WORK_ITEM_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SCHEDRPT_USER_1_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTDAYQRTR_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DAY_OF_QUARTER_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTDTLBY_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DETAIL_BY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTDTLFOR_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DETAIL_FOR_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTDYWKTYP_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DAY_OF_WEEK_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTENRLPRSTAT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_ENROLLPRSTAT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTEXCPT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_EXCEPTION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTFORMAT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_OUTPUT_FORMAT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTFREQTYP_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_RUN_FREQUENCY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTMNTHDAY_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DAY_OF_MONTH_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTMTHLST_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_MONTH_LIST_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTOUTFILE_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_OUTPUT_FILE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTPERIOD_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_PERIOD_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTQRTRLST_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_QUARTER_LIST_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTSCHED_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_SCHEDULE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTSITEDSP_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_SITE_DISPLAY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTSTDRPT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_STANDARD_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTWKMNTH_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_WEEK_OF_MONTH_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_SCHEDULED_REPORTS FOR ADR.RPT_SCHEDULED_REPORTS;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT AVCON_1172521913_INCLU_000
  CHECK (INCLUDE_USERS_FLAG BETWEEN 0
AND 0 OR INCLUDE_USERS_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT AVCON_1172521913_RUN_R_000
  CHECK (RUN_REPORT_BY_USER_FLAG BETWEEN 0
AND 0 OR RUN_REPORT_BY_USER_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT PRIOR_ENROLLMENT_CK
  CHECK (PRIOR_ENROLLMENT IN ('all', 'yes', 'no'))
  ENABLE VALIDATE,
  CONSTRAINT SCHEDRPT_PK
  PRIMARY KEY
  (RPT_SCHEDULED_REPORT_ID)
  USING INDEX ADR.SCHEDRPT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT RPT_SORTBY_TYPE_ID_FK 
  FOREIGN KEY (RPT_SORTBY_TYPE_ID) 
  REFERENCES ADR.RPT_SORTBY_TYPE (RPT_SORTBY_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT SCHEDRPT_RPTDIVTYPE_FK 
  FOREIGN KEY (RPT_DIVISION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDIVISIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SCHEDRPT_RPTWRKITM_FK 
  FOREIGN KEY (RPT_WORK_ITEM_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTWORKITEMSTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SCHEDRPT_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTDAYQRTR_FK 
  FOREIGN KEY (RPT_DAY_OF_QUARTER_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFQUARTERTYP (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTDTLBY_FK 
  FOREIGN KEY (RPT_DETAIL_BY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDETAILBYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTDTLFOR_FK 
  FOREIGN KEY (RPT_DETAIL_FOR_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDETAILFORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTDYWKTYP_FK 
  FOREIGN KEY (RPT_DAY_OF_WEEK_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFWEEKTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTENRLPRSTAT_FK 
  FOREIGN KEY (RPT_ENROLLPRSTAT_ID) 
  REFERENCES ADRREF.STD_REPORTENROLLPRSTAT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTEXCPT_FK 
  FOREIGN KEY (RPT_EXCEPTION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEXCEPTIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTFORMAT_FK 
  FOREIGN KEY (RPT_OUTPUT_FORMAT_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTFORMATTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTFREQTYP_FK 
  FOREIGN KEY (RPT_RUN_FREQUENCY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTRUNFREQUENCYTYP (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTMNTHDAY_FK 
  FOREIGN KEY (RPT_DAY_OF_MONTH_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFMONTHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTMTHLST_FK 
  FOREIGN KEY (RPT_MONTH_LIST_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTMONTHLIST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTOUTFILE_FK 
  FOREIGN KEY (RPT_OUTPUT_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTPUTFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTPERIOD_FK 
  FOREIGN KEY (RPT_PERIOD_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTPERIODTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTQRTRLST_FK 
  FOREIGN KEY (RPT_QUARTER_LIST_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTQUARTERLIST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTSCHED_FK 
  FOREIGN KEY (RPT_SCHEDULE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTSCHEDULETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTSITEDSP_FK 
  FOREIGN KEY (RPT_SITE_DISPLAY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTSITEDISPLAYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTSTDRPT_FK 
  FOREIGN KEY (RPT_STANDARD_REPORT_ID) 
  REFERENCES ADRREF.STD_RPTSTANDARDREPORTS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTWKMNTH_FK 
  FOREIGN KEY (RPT_WEEK_OF_MONTH_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTWEEKOFMONTHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_SCHEDULED_REPORTS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_SCHEDULED_REPORTS TO ADR_RW;

GRANT SELECT ON ADR.RPT_SCHEDULED_REPORTS TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_SCHEDULED_REPORTS TO ES_RW;
ALTER TABLE ADR.USER_LOGIN_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_LOGIN_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_LOGIN_H
(
  USER_LOGIN_H_ID          NUMBER(20)           NOT NULL,
  TRANSACTION_TYPE_CODE    VARCHAR2(1 BYTE)     NOT NULL,
  ID                       NUMBER(20)           NOT NULL,
  USERID                   NUMBER(20)           NOT NULL,
  LAST_LOGIN_SUCCESS_DATE  DATE,
  LAST_LOGIN_FAILURE_DATE  DATE,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_LOGIN_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.USER_LOGIN_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.LAST_LOGIN_SUCCESS_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.USER_LOGIN_H.LAST_LOGIN_FAILURE_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USERLOGINH_PK ON ADR.USER_LOGIN_H
(USER_LOGIN_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USER_LOGIN_H FOR ADR.USER_LOGIN_H;


ALTER TABLE ADR.USER_LOGIN_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_015
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USERLOGINH_PK
  PRIMARY KEY
  (USER_LOGIN_H_ID)
  USING INDEX ADR.USERLOGINH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_LOGIN_H TO ADR_R;

GRANT SELECT ON ADR.USER_LOGIN_H TO ADR_RW;

GRANT SELECT ON ADR.USER_LOGIN_H TO CARUSR_R;
ALTER TABLE ADR.USER_PERMISSION_SETS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_PERMISSION_SETS CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_PERMISSION_SETS
(
  USER_PERMISSION_SET_ID  NUMBER(20)            NOT NULL,
  PERMISSION_SET_ID       NUMBER(20)            NOT NULL,
  USERID                  NUMBER(20)            NOT NULL,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_PERMISSION_SETS IS 'Intersection table mapping users and roles The USER_ROLES table is an application administration table that stores the role that determines database access for users.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.USER_PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.USERPERMST_PERMSET_FK_I ON ADR.USER_PERMISSION_SETS
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.USERPERMST_PK ON ADR.USER_PERMISSION_SETS
(USER_PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.USERPERMST_USER_1_FK_I ON ADR.USER_PERMISSION_SETS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.USER_PERM_SET_audir_trgr
after Update or Delete or Insert
ON ADR.USER_PERMISSION_SETS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USER_PERMISSION_SETS_H
		(
		USER_PERMISSION_SET_H_ID,
		USER_PERMISSION_SET_ID,
		USERID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSION_SETS_H_S.nextval,
		:old.USER_PERMISSION_SET_ID,
		:old.USERID,
		:old.PERMISSION_SET_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USER_PERMISSION_SETS_H
		(
		USER_PERMISSION_SET_H_ID,
		USER_PERMISSION_SET_ID,
		USERID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSION_SETS_H_S.nextval,
		:new.USER_PERMISSION_SET_ID,
		:new.USERID,
		:new.PERMISSION_SET_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USER_PERM_SET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM USER_PERMISSION_SETS FOR ADR.USER_PERMISSION_SETS;


ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_PK
  PRIMARY KEY
  (USER_PERMISSION_SET_ID)
  USING INDEX ADR.USERPERMST_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT USERPERMST_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_PERMISSION_SETS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_PERMISSION_SETS TO ADR_RW;
ALTER TABLE ADR.RPT_WKF_CASE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_WKF_CASE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_WKF_CASE
(
  RPT_WKF_CASE_ID          NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  WKF_CASE_TYPE_ID         NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_WKF_CASE IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RPT_WKF_CASE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTWKFCASE_PK ON ADR.RPT_WKF_CASE
(RPT_WKF_CASE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTWKFCASE_SCHEDRPT_FK_I ON ADR.RPT_WKF_CASE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTWKFCASE_WKFCASETYP_FK_I ON ADR.RPT_WKF_CASE
(WKF_CASE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_WKF_CASE FOR ADR.RPT_WKF_CASE;


ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_PK
  PRIMARY KEY
  (RPT_WKF_CASE_ID)
  USING INDEX ADR.RPTWKFCASE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTWKFCASE_WKFCASETYP_FK 
  FOREIGN KEY (WKF_CASE_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_WKF_CASE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_WKF_CASE TO ADR_RW;

GRANT SELECT ON ADR.RPT_WKF_CASE TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_WKF_CASE TO ES_RW;
ALTER TABLE ADR.JOB_CONFIG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.JOB_CONFIG CASCADE CONSTRAINTS;

CREATE TABLE ADR.JOB_CONFIG
(
  JOB_CONFIG_ID            NUMBER(20)           NOT NULL,
  JOB_NAME                 VARCHAR2(80 BYTE)    NOT NULL,
  JOB_GROUP_NAME           VARCHAR2(80 BYTE)    NOT NULL,
  EMAIL_DISTRIBUTION_LIST  VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.JOB_CONFIG.JOB_CONFIG_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.JCONFIG_PK ON ADR.JOB_CONFIG
(JOB_CONFIG_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.JOB_CONFIG_GRPNAME_I ON ADR.JOB_CONFIG
(JOB_GROUP_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.JOB_CONFIG_NAME_I ON ADR.JOB_CONFIG
(JOB_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM JOB_CONFIG FOR ADR.JOB_CONFIG;


ALTER TABLE ADR.JOB_CONFIG ADD (
  CONSTRAINT JCONFIG_PK
  PRIMARY KEY
  (JOB_CONFIG_ID)
  USING INDEX ADR.JCONFIG_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.JOB_CONFIG TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.JOB_CONFIG TO ADR_RW;

GRANT SELECT ON ADR.JOB_CONFIG TO ES_R;

GRANT INSERT, SELECT ON ADR.JOB_CONFIG TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFITS_APPLICATION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFITS_APPLICATION_H
(
  HEALTH_BENEFITS_APPLN_H_ID      NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  HEALTH_BENEFITS_APPLICATION_ID  NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  APPLICATION_DATE                DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  STD_HEALTHBENEFITTYPE_ID        NUMBER(20),
  Z07_FROM_VISTA_IND              VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFITS_APPLICATION_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.HEALTH_BENEFITS_APPLN_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.HEALTH_BENEFITS_APPLICATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.APPLICATION_DATE IS 'BR2260Enrollment ApplicationDateis definedasthedateof theapplicationfor enrollment.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION_H.Z07_FROM_VISTA_IND IS 'Indicates whether or not the HL7 message for this person has come from VISTA - this is actually a derived value that is persisted in the database in order to save repeated queries on the huge HL7 log table';


CREATE UNIQUE INDEX ADR.HEALTHAPPH_PK ON ADR.HEALTH_BENEFITS_APPLICATION_H
(HEALTH_BENEFITS_APPLN_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HEALTHAPPH_PRSNID_NU_I ON ADR.HEALTH_BENEFITS_APPLICATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFITS_APPLICATION_H FOR ADR.HEALTH_BENEFITS_APPLICATION_H;


ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_018
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT HEALTHAPPH_PK
  PRIMARY KEY
  (HEALTH_BENEFITS_APPLN_H_ID)
  USING INDEX ADR.HEALTHAPPH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ADREXT;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ADR_R;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFITS_APPLICATION_H TO ES_RW;
ALTER TABLE ADR.SIGNATURE_IMAGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SIGNATURE_IMAGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.SIGNATURE_IMAGE
(
  SIGNATURE_IMAGE_ID           NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  SIGNATURE_INDICATOR_TYPE_ID  NUMBER(20),
  SUBMITTING_SITE_ID           NUMBER(20),
  INCOME_YEAR                  NUMBER(4),
  IMAGE_NUMBER                 VARCHAR2(30 BYTE),
  INDEXED_DATE                 DATE,
  USERNAME                     VARCHAR2(30 BYTE),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SIGNATURE_IMAGE IS 'The SIGNATURE_IMAGE table stores information about the image of a persons signature stored during the means test process. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.SIGNATURE_IMAGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.SIGNATURE_INDICATOR_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.SUBMITTING_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.IMAGE_NUMBER IS 'BR5850 Consent/Authorization ImageIndexNumberis definedastheunique imageindexnumber associatedwiththe veteranthatisassigned bytheimagingsystem.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.USERNAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SIGNATURE_PK ON ADR.SIGNATURE_IMAGE
(SIGNATURE_IMAGE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SIGNATURE_PRSN_FK_I ON ADR.SIGNATURE_IMAGE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SIGNATURE_SIGNINDTYP_FK_I ON ADR.SIGNATURE_IMAGE
(SIGNATURE_INDICATOR_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SIGNATURE_STDINST_FK_I ON ADR.SIGNATURE_IMAGE
(SUBMITTING_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SIGNATURE_IMAGE_audir_trgr
after Update or Delete or Insert
ON ADR.SIGNATURE_IMAGE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SIGNATURE_IMAGE_H
		(
		SIGNATURE_IMAGE_H_ID,
		SIGNATURE_IMAGE_ID,
		SIGNATURE_INDICATOR_TYPE_ID,
		IMAGE_NUMBER,
		INCOME_YEAR,
		INDEXED_DATE,
		USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		SUBMITTING_SITE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SIGNATURE_IMAGE_H_S.nextval,
		:old.SIGNATURE_IMAGE_ID,
		:old.SIGNATURE_INDICATOR_TYPE_ID,
		:old.IMAGE_NUMBER,
		:old.INCOME_YEAR,
		:old.INDEXED_DATE,
		:old.USERNAME,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.SUBMITTING_SITE_ID,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SIGNATURE_IMAGE_H
		(
		SIGNATURE_IMAGE_H_ID,
		SIGNATURE_IMAGE_ID,
		SIGNATURE_INDICATOR_TYPE_ID,
		IMAGE_NUMBER,
		INCOME_YEAR,
		INDEXED_DATE,
		USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		SUBMITTING_SITE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SIGNATURE_IMAGE_H_S.nextval,
		:new.SIGNATURE_IMAGE_ID,
		:new.SIGNATURE_INDICATOR_TYPE_ID,
		:new.IMAGE_NUMBER,
		:new.INCOME_YEAR,
		:new.INDEXED_DATE,
		:new.USERNAME,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.SUBMITTING_SITE_ID,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SIGNATURE_IMAGE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SIGNATURE_IMAGE FOR ADR.SIGNATURE_IMAGE;


ALTER TABLE ADR.SIGNATURE_IMAGE ADD (
  CONSTRAINT SIGNATURE_PK
  PRIMARY KEY
  (SIGNATURE_IMAGE_ID)
  USING INDEX ADR.SIGNATURE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SIGNATURE_IMAGE ADD (
  CONSTRAINT SIGNATURE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.SIGNATURE_IMAGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SIGNATURE_IMAGE TO ADR_RW;

GRANT SELECT ON ADR.SIGNATURE_IMAGE TO ES_R;

GRANT INSERT, SELECT ON ADR.SIGNATURE_IMAGE TO ES_RW;
ALTER TABLE ADR.PERMISSION_SET
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERMISSION_SET CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERMISSION_SET
(
  PERMISSION_SET_ID      NUMBER(20)             NOT NULL,
  NAME                   VARCHAR2(100 BYTE)     NOT NULL,
  DESCRIPTION            VARCHAR2(250 BYTE),
  ACTIVE_DATE            DATE,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERMISSION_SET IS 'LOOKUP TABLE - this contains the list of permissions present in the application: Administer Application Parameters Administer System Parameters Manage Address Manage All Eligibility & Enrollment Manage Communications Log Manage EGT Setting Manage Financial Information Manage Person Associations Manage Person Demographics Manage Person Insurance Manage Person Military Service Info Manage Person POW Information Manage Person Purple Heart Manage Registries Manage Select Eligibility & Enrollment Manage User Profile Manage Workload Perform S&D Merge Perform Veteran Merge Re-transmit Messages Schedule/Run Reports View Completed Reports View Registries';

COMMENT ON COLUMN ADR.PERMISSION_SET.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PERMSET_PK ON ADR.PERMISSION_SET
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PERMSET_U_CODE_UK ON ADR.PERMISSION_SET
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERMISSION_SET_audir_trgr
after Update or Delete or Insert
ON ADR.PERMISSION_SET
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERMISSION_SET_H
		(
		PERMISSION_SET_H_ID,
		PERMISSION_SET_ID,
		NAME,
		DESCRIPTION,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMISSION_SET_H_S.nextval,
		:old.PERMISSION_SET_ID,
		:old.NAME,
		:old.DESCRIPTION,
		:old.ACTIVE_DATE,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERMISSION_SET_H
		(
		PERMISSION_SET_H_ID,
		PERMISSION_SET_ID,
		NAME,
		DESCRIPTION,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMISSION_SET_H_S.nextval,
		:new.PERMISSION_SET_ID,
		:new.NAME,
		:new.DESCRIPTION,
		:new.ACTIVE_DATE,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PERMISSION_SET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERMISSION_SET FOR ADR.PERMISSION_SET;


ALTER TABLE ADR.PERMISSION_SET ADD (
  CONSTRAINT PERMSET_PK
  PRIMARY KEY
  (PERMISSION_SET_ID)
  USING INDEX ADR.PERMSET_PK
  ENABLE VALIDATE,
  CONSTRAINT PERMSET_U_CODE_UK
  UNIQUE (NAME)
  USING INDEX ADR.PERMSET_U_CODE_UK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERMISSION_SET TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERMISSION_SET TO ADR_RW;

GRANT SELECT ON ADR.PERMISSION_SET TO CARUSR_R;

GRANT SELECT ON ADR.PERMISSION_SET TO ES_R;

GRANT INSERT, SELECT ON ADR.PERMISSION_SET TO ES_RW;
ALTER TABLE ADR.RPT_REGISTRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_REGISTRY CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_REGISTRY
(
  RPT_REGISTRY_ID          NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  REGISTRY_TYPE_ID         NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_REGISTRY IS 'ESR reporting table. Allows for reporting to be performed on each of the Registries, namely; Prisoner of War Registry Purple Heart Registry SHAD Registry';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RPT_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.REGISTRY_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTRGSTRY_PK ON ADR.RPT_REGISTRY
(RPT_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTRGSTRY_SCHEDRPT_FK_I ON ADR.RPT_REGISTRY
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTRGSTRY_STD_REGTYPE_FK_I ON ADR.RPT_REGISTRY
(REGISTRY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_REGISTRY FOR ADR.RPT_REGISTRY;


ALTER TABLE ADR.RPT_REGISTRY ADD (
  CONSTRAINT RPTRGSTRY_PK
  PRIMARY KEY
  (RPT_REGISTRY_ID)
  USING INDEX ADR.RPTRGSTRY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_REGISTRY ADD (
  CONSTRAINT RPTRGSTRY_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_REGISTRY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_REGISTRY TO ADR_RW;

GRANT SELECT ON ADR.RPT_REGISTRY TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_REGISTRY TO ES_RW;
ALTER TABLE ADR.USERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.USERS
(
  USERID                    NUMBER(20)          NOT NULL,
  USER_GROUP_TYPE_ID        NUMBER(20),
  STD_INSTITUTION_ID        NUMBER(20),
  USERNAME                  VARCHAR2(30 BYTE)   NOT NULL,
  FULL_NAME                 VARCHAR2(100 BYTE),
  PASSWORD                  VARCHAR2(128 BYTE),
  PASSWORD_CREATE_DATE      DATE,
  PASSWORD_CHANGE_DATE      DATE                NOT NULL,
  PASSWORD_EXPIRE_DATE      DATE,
  ACCOUNT_EXPIRE_DATE       DATE,
  ACCOUNT_LOCK_DATE         DATE,
  INITIAL_LOGIN_DATE        DATE,
  NUMBER_OF_LOGIN_ATTEMPTS  NUMBER(3),
  FIRST_NAME                VARCHAR2(30 BYTE),
  MIDDLE_NAME               VARCHAR2(30 BYTE),
  LAST_NAME                 VARCHAR2(40 BYTE),
  MAIDEN_NAME               VARCHAR2(40 BYTE),
  EMPLOYEE_NUMBER           VARCHAR2(50 BYTE),
  JOB_TITLE                 VARCHAR2(80 BYTE),
  EMAIL_ADDRESS             VARCHAR2(128 BYTE),
  TELEPHONE_NUMBER          VARCHAR2(30 BYTE),
  AGREEMENT_SIGNATURE_CODE  VARCHAR2(6 BYTE),
  SIGNATURE_VERIFIED_IND    VARCHAR2(1 BYTE),
  FAX_NUMBER                VARCHAR2(30 BYTE),
  INACTIVE_FLAG             NUMBER(1)           DEFAULT 0                     NOT NULL,
  INACTIVE_DATE             DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USERS IS 'The table is an application administration table used to designate the authorized users of the database.';

COMMENT ON COLUMN ADR.USERS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.USER_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.USERS.USERNAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.FULL_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.PASSWORD IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.PASSWORD_CHANGE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.PASSWORD_EXPIRE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.ACCOUNT_EXPIRE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.ACCOUNT_LOCK_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.FIRST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.MIDDLE_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.LAST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.MAIDEN_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.EMPLOYEE_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.EMAIL_ADDRESS IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.TELEPHONE_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.FAX_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USERS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USERS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USERS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USERS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.USER_1_STDINST_FK_I ON ADR.USERS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.USER_1_UK2_UK ON ADR.USERS
(USERNAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.USER_1_USRGRPTYP_FK_I ON ADR.USERS
(USER_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.USER_PK ON ADR.USERS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.USERS_audir_trgr
after Update or Delete or Insert
ON ADR.USERS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USERS_H
		(
		USERS_H_ID,
		USERID,
		STD_INSTITUTION_ID,
		USERNAME,
		FULL_NAME,
		PASSWORD,
		PASSWORD_CREATE_DATE,
		PASSWORD_CHANGE_DATE,
		PASSWORD_EXPIRE_DATE,
		USER_GROUP_TYPE_ID,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		EMPLOYEE_NUMBER,
		EMAIL_ADDRESS,
		TELEPHONE_NUMBER,
		FAX_NUMBER,
		JOB_TITLE,
		AGREEMENT_SIGNATURE_CODE,
		SIGNATURE_VERIFIED_IND,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		ACCOUNT_EXPIRE_DATE,
		ACCOUNT_LOCK_DATE,
		NUMBER_OF_LOGIN_ATTEMPTS,
		INITIAL_LOGIN_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USERS_H_S.nextval,
		:old.USERID,
		:old.STD_INSTITUTION_ID,
		:old.USERNAME,
		:old.FULL_NAME,
		:old.PASSWORD,
		:old.PASSWORD_CREATE_DATE,
		:old.PASSWORD_CHANGE_DATE,
		:old.PASSWORD_EXPIRE_DATE,
		:old.USER_GROUP_TYPE_ID,
		:old.FIRST_NAME,
		:old.MIDDLE_NAME,
		:old.LAST_NAME,
		:old.MAIDEN_NAME,
		:old.EMPLOYEE_NUMBER,
		:old.EMAIL_ADDRESS,
		:old.TELEPHONE_NUMBER,
		:old.FAX_NUMBER,
		:old.JOB_TITLE,
		:old.AGREEMENT_SIGNATURE_CODE,
		:old.SIGNATURE_VERIFIED_IND,
		:old.INACTIVE_FLAG,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.ACCOUNT_EXPIRE_DATE,
		:old.ACCOUNT_LOCK_DATE,
		:old.NUMBER_OF_LOGIN_ATTEMPTS,
		:old.INITIAL_LOGIN_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USERS_H
		(
		USERS_H_ID,
		USERID,
		STD_INSTITUTION_ID,
		USERNAME,
		FULL_NAME,
		PASSWORD,
		PASSWORD_CREATE_DATE,
		PASSWORD_CHANGE_DATE,
		PASSWORD_EXPIRE_DATE,
		USER_GROUP_TYPE_ID,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		EMPLOYEE_NUMBER,
		EMAIL_ADDRESS,
		TELEPHONE_NUMBER,
		FAX_NUMBER,
		JOB_TITLE,
		AGREEMENT_SIGNATURE_CODE,
		SIGNATURE_VERIFIED_IND,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		ACCOUNT_EXPIRE_DATE,
		ACCOUNT_LOCK_DATE,
		NUMBER_OF_LOGIN_ATTEMPTS,
		INITIAL_LOGIN_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USERS_H_S.nextval,
		:new.USERID,
		:new.STD_INSTITUTION_ID,
		:new.USERNAME,
		:new.FULL_NAME,
		:new.PASSWORD,
		:new.PASSWORD_CREATE_DATE,
		:new.PASSWORD_CHANGE_DATE,
		:new.PASSWORD_EXPIRE_DATE,
		:new.USER_GROUP_TYPE_ID,
		:new.FIRST_NAME,
		:new.MIDDLE_NAME,
		:new.LAST_NAME,
		:new.MAIDEN_NAME,
		:new.EMPLOYEE_NUMBER,
		:new.EMAIL_ADDRESS,
		:new.TELEPHONE_NUMBER,
		:new.FAX_NUMBER,
		:new.JOB_TITLE,
		:new.AGREEMENT_SIGNATURE_CODE,
		:new.SIGNATURE_VERIFIED_IND,
		:new.INACTIVE_FLAG,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.ACCOUNT_EXPIRE_DATE,
		:new.ACCOUNT_LOCK_DATE,
		:new.NUMBER_OF_LOGIN_ATTEMPTS,
		:new.INITIAL_LOGIN_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USERS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM USERS FOR ADR.USERS;


ALTER TABLE ADR.USERS ADD (
  CONSTRAINT AVCON_1172521913_INACT_042
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT USER_PK
  PRIMARY KEY
  (USERID)
  USING INDEX ADR.USER_PK
  ENABLE VALIDATE,
  CONSTRAINT USER_1_UK2_UK
  UNIQUE (USERNAME)
  USING INDEX ADR.USER_1_UK2_UK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USERS TO ADR_RW;

GRANT SELECT ON ADR.USERS TO CARUSR_R;

GRANT SELECT ON ADR.USERS TO IAM_R;

GRANT INSERT, SELECT, UPDATE ON ADR.USERS TO IAM_RW;
ALTER TABLE ADR.EGT_SITE_STATISTICS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_SITE_STATISTICS CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_SITE_STATISTICS
(
  EGT_SITE_STATISTICS_ID          NUMBER(20)    NOT NULL,
  EGT_STATISTICS_ID               NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  ENROLLED_CATGRY_COUNT           NUMBER(10),
  IN_PROCESS_CATGRY_COUNT         NUMBER(10),
  BENEFICIARY_PROCESSED_COUNT     NUMBER(10),
  BENEFICIARY_NOT_ENROLLED_COUNT  NUMBER(10),
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_SITE_STATISTICS IS 'Enrollment Global Threshold statistics per site The EGT_SITE_STATISTICS table contains information by site about persons who are not enrolled. EGT_SETTING_ID Foreign key to the EGT_SETTING table. STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table. Indicates the site to which the statistics apply. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.EGT_SITE_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.EGT_STATISTICS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.ENROLLED_CATGRY_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.BENEFICIARY_PROCESSED_COUNT IS 'BR2326TotalVETSIn Processisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryofIn Processasaresultof therecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.BENEFICIARY_NOT_ENROLLED_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.EGTSTSTIC_EGTSETTING_FK_I ON ADR.EGT_SITE_STATISTICS
(EGT_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EGTSTSTIC_PK ON ADR.EGT_SITE_STATISTICS
(EGT_SITE_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSTSTIC_STDINST_FK_I ON ADR.EGT_SITE_STATISTICS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EGT_SITE_STATISTICS_audir_trgr
after Update or Delete or Insert
ON ADR.EGT_SITE_STATISTICS
for each row
declare
   	mDML char(1);
begin
	if DELETING then
		insert into EGT_SITE_STATISTICS_H
		(
		EGT_SITE_STATISTICS_H_ID,
		EGT_SITE_STATISTICS_ID,
		EGT_STATISTICS_ID,
		STD_INSTITUTION_ID,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		BENEFICIARY_PROCESSED_COUNT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      		)
		values
		(
		EGT_SITE_STATISTICS_H_s.nextval,
		:old.EGT_SITE_STATISTICS_ID,
		:old.EGT_STATISTICS_ID,
		:old.STD_INSTITUTION_ID,
		:old.BENEFICIARY_NOT_ENROLLED_COUNT,
		:old.IN_PROCESS_CATGRY_COUNT,
		:old.ENROLLED_CATGRY_COUNT,
		:old.BENEFICIARY_PROCESSED_COUNT,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EGT_SITE_STATISTICS_H
		(
		EGT_SITE_STATISTICS_H_ID,
		EGT_SITE_STATISTICS_ID,
		EGT_STATISTICS_ID,
		STD_INSTITUTION_ID,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		BENEFICIARY_PROCESSED_COUNT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      		)
		values
		(
		EGT_SITE_STATISTICS_H_s.nextval,
		:new.EGT_SITE_STATISTICS_ID,
		:new.EGT_STATISTICS_ID,
		:new.STD_INSTITUTION_ID,
		:new.BENEFICIARY_NOT_ENROLLED_COUNT,
		:new.IN_PROCESS_CATGRY_COUNT,
		:new.ENROLLED_CATGRY_COUNT,
		:new.BENEFICIARY_PROCESSED_COUNT,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  EGT_SITE_STATISTICS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EGT_SITE_STATISTICS FOR ADR.EGT_SITE_STATISTICS;


ALTER TABLE ADR.EGT_SITE_STATISTICS ADD (
  CONSTRAINT EGTSTSTIC_PK
  PRIMARY KEY
  (EGT_SITE_STATISTICS_ID)
  USING INDEX ADR.EGTSTSTIC_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EGT_SITE_STATISTICS ADD (
  CONSTRAINT EGTSTSTIC_EGTSTAT_FK 
  FOREIGN KEY (EGT_STATISTICS_ID) 
  REFERENCES ADR.EGT_STATISTICS (EGT_STATISTICS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_SITE_STATISTICS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EGT_SITE_STATISTICS TO ADR_RW;

GRANT SELECT ON ADR.EGT_SITE_STATISTICS TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_SITE_STATISTICS TO ES_RW;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.POW_REGISTRY_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.POW_REGISTRY_DETAIL_H
(
  POW_REGISTRY_DETAIL_H_ID     NUMBER(20)       NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  POW_REGISTRY_DETAIL_ID       NUMBER(20)       NOT NULL,
  PRISONER_OF_WAR_REGISTRY_ID  NUMBER(20)       NOT NULL,
  POW_DATA_SOURCE_TYPE_ID      NUMBER(20),
  POW_DOCUMENT_TYPE_ID         NUMBER(20),
  STD_POWCASUALTYLOCATION_ID   NUMBER(20),
  POW_CONFINE_LOCN_TYPE_ID     NUMBER(20),
  POW_CAPTURE_DATE_TXT         VARCHAR2(14 BYTE),
  POW_RELEASE_DATE_TXT         VARCHAR2(14 BYTE),
  NUMBER_OF_DAYS_IN_CAPTIVITY  NUMBER(6),
  LEGACY_ENTERED_DATE          DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.POW_REGISTRY_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_REGISTRY_DETAIL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.PRISONER_OF_WAR_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_DATA_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_DOCUMENT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.STD_POWCASUALTYLOCATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_CONFINE_LOCN_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.POWREGDTH_PK ON ADR.POW_REGISTRY_DETAIL_H
(POW_REGISTRY_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTH_POWREGID_NU_I ON ADR.POW_REGISTRY_DETAIL_H
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM POW_REGISTRY_DETAIL_H FOR ADR.POW_REGISTRY_DETAIL_H;


ALTER TABLE ADR.POW_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_022
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT POWREGDTH_PK
  PRIMARY KEY
  (POW_REGISTRY_DETAIL_H_ID)
  USING INDEX ADR.POWREGDTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.POW_REGISTRY_DETAIL_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.POW_REGISTRY_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.POW_REGISTRY_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.POW_REGISTRY_DETAIL_H TO ES_RW;
ALTER TABLE ADR.BENEFICIARY_NTR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_NTR CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_NTR
(
  BENEFICIARY_NTR_ID              NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  NTR_DIAGNOSIS_SITE_ID           NUMBER(20),
  NTR_VERIFICATION_SITE_ID        NUMBER(20),
  NTR_VERIFY_METHOD_TYPE_ID       NUMBER(20),
  VERIFICATION_DATE               DATE,
  AVIATOR_PRE1955_IND             VARCHAR2(1 BYTE),
  NAVY_SUB_TRAINEE_PRE_1965_IND   VARCHAR2(1 BYTE),
  RECEIVED_NTR_TREATMENT_IND      VARCHAR2(1 BYTE),
  DIAGNOSED_HEAD_NECK_CANCER_IND  VARCHAR2(1 BYTE),
  HEAD_NECK_CANCER_DIAGNOSIS_DT   DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_NTR IS 'The BENEFICIARY_NTR table shows that a person has been clinically determined to have suffered from Nose Throat Radium exposure. The table includes the site at which the determination was made, the verification date and method, and whether the person has been diagnosed and treated with cancer. PERSON_ID Foreign key to the PERSON table. Indicates the particular person to whom the Nose, Throat, Radium data applies. NTR_DIAGNOSIS_SITE_ID Foreign key to STD_INSTITUTION table NTR_VERIFICATION_SITE_ID Foreign key to STD_INSTITUTION table NTR_VERIFY_METHOD_TYPE_ID Foreign key to the NTR_VERIFY_METHOD_TYPE table. Indicates which technique was used to verify a persons NTR status (for example, Military Record, Qualifying Military Service). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.BENEFICIARY_NTR_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.NTR_DIAGNOSIS_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.NTR_VERIFICATION_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.NTR_VERIFY_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.VERIFICATION_DATE IS 'BR6805(NTR)Date/Time DiagnosisVerifiedis definedasthedateand timetheNose/Throat RadiumTreatment diagnosiswasverified.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.AVIATOR_PRE1955_IND IS 'Indicateswhetherornot apersonwasanaviator before1955,when exposurewasmorelikely tohavehappened.AviatiorPriorto1955is aquestionthatis presentedtotheuserif theveteranhasanswered YEStotheNTRIndicator. ThequestionisDidyou serveasanaviatorin theMilitarybeforeJan 31,1955?Thevalues includeYES/NO.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.NAVY_SUB_TRAINEE_PRE_1965_IND IS 'Indicateswhetherornot apersonwasaNavy submarinetraineebefore 1955,whenexposurewas morelikelytohave happened.SubmarineTraineeprior to1965isaquestion thatispresentedtothe useriftheveteranhas answeredYEStotheNTR Indicator.Thequestion isDidyouhavesubmarine traininginthemilitary beforeJan1,1965?';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECEIVED_NTR_TREATMENT_IND IS 'ReceivedNTRTreatment definestheanswera veterangavetothe question:DIDYOURECEIVE NOSEORTHROATRADIUM TREATMENTSINTHE MILITARY?';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.DIAGNOSED_HEAD_NECK_CANCER_IND IS 'Indicateswhethera personhasbeendiagnosed withhead/neckcancer.DiagnosedwithCancerof HeadNeckisaquestion thatispresentedtothe useriftheveteranhas answeredYEStotheNTR Indicator.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_NTR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BNFYNTR_PK ON ADR.BENEFICIARY_NTR
(BENEFICIARY_NTR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYNTR_PRSN_FK_I ON ADR.BENEFICIARY_NTR
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYNTR_STDINST_FK_I ON ADR.BENEFICIARY_NTR
(NTR_VERIFICATION_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYNTR_STDINST_H_FK_I ON ADR.BENEFICIARY_NTR
(NTR_DIAGNOSIS_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYNTR_STD_NTRVRFYMTD_FK_I ON ADR.BENEFICIARY_NTR
(NTR_VERIFY_METHOD_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.BENEFICIARY_NTR_AUDIR_TRGR
after Update or Delete or Insert
on ADR.BENEFICIARY_NTR
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into BENEFICIARY_NTR_H
		(
		BENEFICIARY_NTR_H_ID ,
		BENEFICIARY_NTR_ID       ,
		PERSON_ID                      ,
		NTR_DIAGNOSIS_SITE_ID ,
		NTR_VERIFICATION_SITE_ID ,
		NTR_VERIFY_METHOD_TYPE_ID,
		VERIFICATION_DATE            ,
		AVIATOR_PRE1955_IND        ,
		NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		RECEIVED_NTR_TREATMENT_IND     ,
		DIAGNOSED_HEAD_NECK_CANCER_IND,
		HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		RECORD_CREATED_BY              ,
		RECORD_CREATED_DATE         ,
		RECORD_MODIFIED_BY             ,
		RECORD_MODIFIED_DATE        ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_ntr_h_s.nextval,
		:old.BENEFICIARY_NTR_ID       ,
		:old.PERSON_ID                      ,
		:old.NTR_DIAGNOSIS_SITE_ID ,
		:old.NTR_VERIFICATION_SITE_ID ,
		:old.NTR_VERIFY_METHOD_TYPE_ID,
		:old.VERIFICATION_DATE            ,
		:old.AVIATOR_PRE1955_IND        ,
		:old.NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		:old.RECEIVED_NTR_TREATMENT_IND     ,
		:old.DIAGNOSED_HEAD_NECK_CANCER_IND,
		:old.HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		:old.RECORD_CREATED_BY              ,
		:old.RECORD_CREATED_DATE         ,
		:old.RECORD_MODIFIED_BY             ,
		:old.RECORD_MODIFIED_DATE        ,
		:old.RECORD_MODIFIED_COUNT     ,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_NTR_H
		(
		BENEFICIARY_NTR_H_ID ,
		BENEFICIARY_NTR_ID       ,
		PERSON_ID                      ,
		NTR_DIAGNOSIS_SITE_ID ,
		NTR_VERIFICATION_SITE_ID ,
		NTR_VERIFY_METHOD_TYPE_ID,
		VERIFICATION_DATE            ,
		AVIATOR_PRE1955_IND        ,
		NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		RECEIVED_NTR_TREATMENT_IND     ,
		DIAGNOSED_HEAD_NECK_CANCER_IND,
		HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		RECORD_CREATED_BY              ,
		RECORD_CREATED_DATE         ,
		RECORD_MODIFIED_BY             ,
		RECORD_MODIFIED_DATE        ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_ntr_h_s.nextval,
		:new.BENEFICIARY_NTR_ID       ,
		:new.PERSON_ID                      ,
		:new.NTR_DIAGNOSIS_SITE_ID ,
		:new.NTR_VERIFICATION_SITE_ID ,
		:new.NTR_VERIFY_METHOD_TYPE_ID,
		:new.VERIFICATION_DATE            ,
		:new.AVIATOR_PRE1955_IND        ,
		:new.NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		:new.RECEIVED_NTR_TREATMENT_IND     ,
		:new.DIAGNOSED_HEAD_NECK_CANCER_IND,
		:new.HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		:new.RECORD_CREATED_BY              ,
		:new.RECORD_CREATED_DATE         ,
		:new.RECORD_MODIFIED_BY             ,
		:new.RECORD_MODIFIED_DATE        ,
		:new.RECORD_MODIFIED_COUNT     ,
		mDML
		);

	end if;
end BENEFICIARY_NTR_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_NTR FOR ADR.BENEFICIARY_NTR;


ALTER TABLE ADR.BENEFICIARY_NTR ADD (
  CONSTRAINT BNFYNTR_PK
  PRIMARY KEY
  (BENEFICIARY_NTR_ID)
  USING INDEX ADR.BNFYNTR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BENEFICIARY_NTR ADD (
  CONSTRAINT BNFYNTR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_NTR TO ADREXT;

GRANT SELECT ON ADR.BENEFICIARY_NTR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_NTR TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_NTR TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_NTR TO ES_RW;
ALTER TABLE ADR.COMBAT_PAY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COMBAT_PAY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.COMBAT_PAY_H
(
  COMBAT_PAY_H_ID            NUMBER(20)         NOT NULL,
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE)   NOT NULL,
  COMBAT_PAY_ID              NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  COMBATSERVICESOURCE_ID     NUMBER(20),
  COMBATSERVICELOCATION_ID   NUMBER(20),
  COMBAT_PAY_START_DATE_TXT  VARCHAR2(14 BYTE),
  COMBAT_PAY_END_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  STD_COMBATPAYTYPE_ID       NUMBER(20),
  HISTORY_CREATED_DATE       DATE
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COMBAT_PAY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBAT_PAY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBAT_PAY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBATSERVICESOURCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBATSERVICELOCATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.COMBAT_PAY_START_DATE_TXT IS 'DatewhentheBeneficiary startedreceivingCombat Pay';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.STD_COMBATPAYTYPE_ID IS 'Identifier for existing  SDS Combat Pay Type';

COMMENT ON COLUMN ADR.COMBAT_PAY_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.CMBTPAYH_PK ON ADR.COMBAT_PAY_H
(COMBAT_PAY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAYH_PRSNID_NU_I ON ADR.COMBAT_PAY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COMBAT_PAY_H FOR ADR.COMBAT_PAY_H;


ALTER TABLE ADR.COMBAT_PAY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_023
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CMBTPAYH_PK
  PRIMARY KEY
  (COMBAT_PAY_H_ID)
  USING INDEX ADR.CMBTPAYH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COMBAT_PAY_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_PAY_H TO ADR_RW;

GRANT SELECT ON ADR.COMBAT_PAY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.COMBAT_PAY_H TO ES_RW;
ALTER TABLE ADR.POW_REGISTRY_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.POW_REGISTRY_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.POW_REGISTRY_DETAIL
(
  POW_REGISTRY_DETAIL_ID       NUMBER(20)       NOT NULL,
  PRISONER_OF_WAR_REGISTRY_ID  NUMBER(20)       NOT NULL,
  POW_DATA_SOURCE_TYPE_ID      NUMBER(20),
  POW_DOCUMENT_TYPE_ID         NUMBER(20),
  POW_CONFINE_LOCN_TYPE_ID     NUMBER(20),
  STD_POWCASUALTYLOCATION_ID   NUMBER(20),
  POW_CAPTURE_DATE_TXT         VARCHAR2(14 BYTE),
  POW_RELEASE_DATE_TXT         VARCHAR2(14 BYTE),
  NUMBER_OF_DAYS_IN_CAPTIVITY  NUMBER(6),
  LEGACY_ENTERED_DATE          DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.POW_REGISTRY_DETAIL IS 'Detail table of Prisoner of War When Veteran was captured, released, how many days in captivity etc.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.POW_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.PRISONER_OF_WAR_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.POW_DATA_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.POW_DOCUMENT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.POW_CONFINE_LOCN_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.STD_POWCASUALTYLOCATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.POWREGDTL_PK ON ADR.POW_REGISTRY_DETAIL
(POW_REGISTRY_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_POWCSLTLOC_FK_I ON ADR.POW_REGISTRY_DETAIL
(STD_POWCASUALTYLOCATION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_POW_FK_I ON ADR.POW_REGISTRY_DETAIL
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_STD_POWDATASRC_FK_I ON ADR.POW_REGISTRY_DETAIL
(POW_DATA_SOURCE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_STD_POWDOC_FK_I ON ADR.POW_REGISTRY_DETAIL
(POW_DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_STD_POWPRD_FK_I ON ADR.POW_REGISTRY_DETAIL
(POW_CONFINE_LOCN_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.pow_reg_det_audir_trgr
after Update or Delete or Insert
ON ADR.POW_REGISTRY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into POW_REGISTRY_DETAIL_H
		(
		POW_REGISTRY_DETAIL_H_ID,
		POW_REGISTRY_DETAIL_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		POW_DATA_SOURCE_TYPE_ID,
		POW_DOCUMENT_TYPE_ID,
		POW_CONFINE_LOCN_TYPE_ID,
		STD_POWCASUALTYLOCATION_ID,
		POW_CAPTURE_DATE_TXT,
		POW_RELEASE_DATE_TXT,
		NUMBER_OF_DAYS_IN_CAPTIVITY,
		LEGACY_ENTERED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		POW_REGISTRY_DETAIL_H_S.nextval,
		:old.POW_REGISTRY_DETAIL_ID,
		:old.PRISONER_OF_WAR_REGISTRY_ID,
		:old.POW_DATA_SOURCE_TYPE_ID,
		:old.POW_DOCUMENT_TYPE_ID,
		:old.POW_CONFINE_LOCN_TYPE_ID,
		:old.STD_POWCASUALTYLOCATION_ID,
		:old.POW_CAPTURE_DATE_TXT,
		:old.POW_RELEASE_DATE_TXT,
		:old.NUMBER_OF_DAYS_IN_CAPTIVITY,
		:old.LEGACY_ENTERED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into POW_REGISTRY_DETAIL_H
		(
		POW_REGISTRY_DETAIL_H_ID,
		POW_REGISTRY_DETAIL_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		POW_DATA_SOURCE_TYPE_ID,
		POW_DOCUMENT_TYPE_ID,
		POW_CONFINE_LOCN_TYPE_ID,
		STD_POWCASUALTYLOCATION_ID,
		POW_CAPTURE_DATE_TXT,
		POW_RELEASE_DATE_TXT,
		NUMBER_OF_DAYS_IN_CAPTIVITY,
		LEGACY_ENTERED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		POW_REGISTRY_DETAIL_H_S.nextval,
		:new.POW_REGISTRY_DETAIL_ID,
		:new.PRISONER_OF_WAR_REGISTRY_ID,
		:new.POW_DATA_SOURCE_TYPE_ID,
		:new.POW_DOCUMENT_TYPE_ID,
		:new.POW_CONFINE_LOCN_TYPE_ID,
		:new.STD_POWCASUALTYLOCATION_ID,
		:new.POW_CAPTURE_DATE_TXT,
		:new.POW_RELEASE_DATE_TXT,
		:new.NUMBER_OF_DAYS_IN_CAPTIVITY,
		:new.LEGACY_ENTERED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end pow_reg_det_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM POW_REGISTRY_DETAIL FOR ADR.POW_REGISTRY_DETAIL;


ALTER TABLE ADR.POW_REGISTRY_DETAIL ADD (
  CONSTRAINT POWREGDTL_PK
  PRIMARY KEY
  (POW_REGISTRY_DETAIL_ID)
  USING INDEX ADR.POWREGDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.POW_REGISTRY_DETAIL ADD (
  CONSTRAINT POWREGDTL_POW_FK 
  FOREIGN KEY (PRISONER_OF_WAR_REGISTRY_ID) 
  REFERENCES ADR.PRISONER_OF_WAR_REGISTRY (PRISONER_OF_WAR_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.POW_REGISTRY_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.POW_REGISTRY_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.POW_REGISTRY_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.POW_REGISTRY_DETAIL TO ES_RW;
ALTER TABLE ADR.USER_ROLES_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_ROLES_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_ROLES_H
(
  USER_ROLES_H_ID        NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  USER_ROLE_ID           NUMBER(20)             NOT NULL,
  USERID                 NUMBER(20)             NOT NULL,
  ROLE_ID                NUMBER(20)             NOT NULL,
  INACTIVE_FLAG          NUMBER(1)              DEFAULT 0                     NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_ROLES_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USER_ROLES_H.USER_ROLES_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USER_ROLES_H.USER_ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_ROLES_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES_H.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_ROLES_H.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USERROLEH_PK ON ADR.USER_ROLES_H
(USER_ROLES_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USER_ROLES_H FOR ADR.USER_ROLES_H;


ALTER TABLE ADR.USER_ROLES_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_024
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USERROLEH_PK
  PRIMARY KEY
  (USER_ROLES_H_ID)
  USING INDEX ADR.USERROLEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_ROLES_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_ROLES_H TO ADR_RW;

GRANT SELECT ON ADR.USER_ROLES_H TO CARUSR_R;

GRANT SELECT ON ADR.USER_ROLES_H TO IAM_R;

GRANT INSERT, SELECT ON ADR.USER_ROLES_H TO IAM_RW;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CONFIDENTIAL_ADDR_CATGRY CASCADE CONSTRAINTS;

CREATE TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
(
  CONFIDENTIAL_ADDR_CATGRY_ID  NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  CONFIDENTIAL_ADDR_TYPE_ID    NUMBER(20)       NOT NULL,
  INACTIVE_FLAG                NUMBER(1)        DEFAULT 0                     NOT NULL,
  INACTIVE_DATE                DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  RECORD_MODIFIED_SITE_ID      NUMBER(20),
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CONFIDENTIAL_ADDR_CATGRY IS 'The CONFIDENTIAL_ADDR_CATGRY table stores the type of confidential address specified for a person. Addresses can be designated confidential by the associated person, and that person can indicate the address to be confidential for one or more of these categories: eligibility/enrollment, appointment/scheduling, copayments/veteran billing, medical records, and all others. Owner: PSD PERSON_ID Foreign key to the PERSON table. Indicates the particular person to whom the address belongs. CONFIDENTIAL_ADDR_TYPE_ID Foreign key to the CONFIDENTIAL_ADDR_TYPE. Indicates which under what circumstances an address is considered confidential (for example, eligibility/enrollment, appointment/scheduling).';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.CONFIDENTIAL_ADDR_CATGRY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.CONFIDENTIAL_ADDR_CATGRY.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.CNFADDR_PK ON ADR.CONFIDENTIAL_ADDR_CATGRY
(CONFIDENTIAL_ADDR_CATGRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CNFADDR_PRSN_FK_I ON ADR.CONFIDENTIAL_ADDR_CATGRY
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CNFADDR_STDINST2_FK_I ON ADR.CONFIDENTIAL_ADDR_CATGRY
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CNFADDR_STD_CNFADDRCAT_FK_I ON ADR.CONFIDENTIAL_ADDR_CATGRY
(CONFIDENTIAL_ADDR_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CONF_ADDR_CATGRY_audir_trgr
after Update or Delete or Insert
ON ADR.CONFIDENTIAL_ADDR_CATGRY
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CONFIDENTIAL_ADDR_CATGRY_H
		(
		CONFIDENTIAL_ADDR_CATGRY_H_ID,
		CONFIDENTIAL_ADDR_CATGRY_ID  ,
		PERSON_ID                   ,
		CONFIDENTIAL_ADDR_TYPE_ID    ,
		INACTIVE_FLAG                ,
		INACTIVE_DATE                ,
		RECORD_CREATED_BY            ,
		RECORD_CREATED_DATE          ,
		RECORD_MODIFIED_BY           ,
		RECORD_MODIFIED_DATE         ,
		RECORD_MODIFIED_COUNT        ,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CONFIDENTIAL_ADDR_CATGRY_H_S.nextval,
		:old.CONFIDENTIAL_ADDR_CATGRY_ID  ,
		:old.PERSON_ID                   ,
		:old.CONFIDENTIAL_ADDR_TYPE_ID    ,
		:old.INACTIVE_FLAG                ,
		:old.INACTIVE_DATE                ,
		:old.RECORD_CREATED_BY            ,
		:old.RECORD_CREATED_DATE          ,
		:old.RECORD_MODIFIED_BY           ,
		:old.RECORD_MODIFIED_DATE         ,
		:old.RECORD_MODIFIED_COUNT        ,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D'
		);
	else

		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CONFIDENTIAL_ADDR_CATGRY_H
		(
		CONFIDENTIAL_ADDR_CATGRY_H_ID,
		CONFIDENTIAL_ADDR_CATGRY_ID  ,
		PERSON_ID                   ,
		CONFIDENTIAL_ADDR_TYPE_ID    ,
		INACTIVE_FLAG                ,
		INACTIVE_DATE                ,
		RECORD_CREATED_BY            ,
		RECORD_CREATED_DATE          ,
		RECORD_MODIFIED_BY           ,
		RECORD_MODIFIED_DATE         ,
		RECORD_MODIFIED_COUNT        ,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CONFIDENTIAL_ADDR_CATGRY_H_S.nextval,
		:new.CONFIDENTIAL_ADDR_CATGRY_ID  ,
		:new.PERSON_ID                   ,
		:new.CONFIDENTIAL_ADDR_TYPE_ID    ,
		:new.INACTIVE_FLAG                ,
		:new.INACTIVE_DATE                ,
		:new.RECORD_CREATED_BY            ,
		:new.RECORD_CREATED_DATE          ,
		:new.RECORD_MODIFIED_BY           ,
		:new.RECORD_MODIFIED_DATE         ,
		:new.RECORD_MODIFIED_COUNT        ,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML
		);
	end if;
end CONF_ADDR_CATGRY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CONFIDENTIAL_ADDR_CATGRY FOR ADR.CONFIDENTIAL_ADDR_CATGRY;


ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT AVCON_1172521913_INACT_046
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT CNFADDR_PK
  PRIMARY KEY
  (CONFIDENTIAL_ADDR_CATGRY_ID)
  USING INDEX ADR.CNFADDR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT CNFADDR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ADR_RW;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ES_R;

GRANT INSERT, SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO ES_RW;

GRANT SELECT ON ADR.CONFIDENTIAL_ADDR_CATGRY TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.CONFIDENTIAL_ADDR_CATGRY TO PSIM_ADR_RW;
ALTER TABLE ADR.PERSON_UNMERGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_UNMERGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_UNMERGE
(
  PERSON_UNMERGE_ID      NUMBER(20)             NOT NULL,
  PERSON_ID_1            NUMBER(20),
  PERSON_ID_2            NUMBER(20),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_UNMERGE IS 'In the case that two distinct identities of Persons have mistakenly been merged into a single record, the merged record will now have to be un-merged in this table.';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.PERSON_UNMERGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRSNUNMRG_PK ON ADR.PERSON_UNMERGE
(PERSON_UNMERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_UNMERGE FOR ADR.PERSON_UNMERGE;


ALTER TABLE ADR.PERSON_UNMERGE ADD (
  CONSTRAINT PRSNUNMRG_PK
  PRIMARY KEY
  (PERSON_UNMERGE_ID)
  USING INDEX ADR.PRSNUNMRG_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_UNMERGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_UNMERGE TO ADR_RW;

GRANT SELECT ON ADR.PERSON_UNMERGE TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_UNMERGE TO ES_RW;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMERGENCY_RESPONSE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMERGENCY_RESPONSE_H
(
  EMERGENCY_RESPONSE_H_ID   NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  EMERGENCY_RESPONSE_ID     NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  STD_EMERGENCYRESPONSE_ID  NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMERGENCY_RESPONSE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.EMERGENCY_RESPONSE_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.EMERGENCY_RESPONSE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.STD_EMERGENCYRESPONSE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMERGENCY_RESPONSE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EMERGRESH_PK ON ADR.EMERGENCY_RESPONSE_H
(EMERGENCY_RESPONSE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMERGRESH_PRSNID_NU_I ON ADR.EMERGENCY_RESPONSE_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EMERGENCY_RESPONSE_H FOR ADR.EMERGENCY_RESPONSE_H;


ALTER TABLE ADR.EMERGENCY_RESPONSE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_025
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT EMERGRESH_PK
  PRIMARY KEY
  (EMERGENCY_RESPONSE_H_ID)
  USING INDEX ADR.EMERGRESH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H TO ADR_R;

GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H TO ADR_RW;

GRANT SELECT ON ADR.EMERGENCY_RESPONSE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EMERGENCY_RESPONSE_H TO ES_RW;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SHAD_REGISTRY_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SHAD_REGISTRY_DETAIL_H
(
  SHAD_REGISTRY_DETAIL_H_ID  NUMBER(20)         NOT NULL,
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE)   NOT NULL,
  SHAD_REGISTRY_DETAIL_ID    NUMBER(20)         NOT NULL,
  SHAD_REGISTRY_ID           NUMBER(20)         NOT NULL,
  SHAD_DOCUMENT_TYPE_ID      NUMBER(20),
  DOCUMENT_RECEIVED_DATE     DATE,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SHAD_REGISTRY_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.SHAD_REGISTRY_DETAIL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.SHAD_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.SHAD_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.SHAD_DOCUMENT_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.DOCUMENT_RECEIVED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SHADREGDH_PK ON ADR.SHAD_REGISTRY_DETAIL_H
(SHAD_REGISTRY_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADREGDH_SHADRGSTRY_FK_I ON ADR.SHAD_REGISTRY_DETAIL_H
(SHAD_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SHAD_REGISTRY_DETAIL_H FOR ADR.SHAD_REGISTRY_DETAIL_H;


ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_026
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT SHADREGDH_PK
  PRIMARY KEY
  (SHAD_REGISTRY_DETAIL_H_ID)
  USING INDEX ADR.SHADREGDH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL_H TO ES_R;

GRANT INSERT, SELECT ON ADR.SHAD_REGISTRY_DETAIL_H TO ES_RW;
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_HEC_REJECT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_HEC_REJECT_DETAIL
(
  COM_HEC_REJECT_DETAIL_ID  NUMBER(20)          NOT NULL,
  COM_MAILING_ID            NUMBER(20)          NOT NULL,
  REJECT_REASON_TEXT        VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_HEC_REJECT_DETAIL IS 'Contains detail reasons as to why the letter was rejected at the HEC COM_MAILING_ID Foreign key to the COM_MAILING table.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.COM_HEC_REJECT_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_HEC_REJECT_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMRJCTDTL_COMMAIL_FK_I ON ADR.COM_HEC_REJECT_DETAIL
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMRJCTDTL_PK ON ADR.COM_HEC_REJECT_DETAIL
(COM_HEC_REJECT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_HEC_REJECT_DETAIL FOR ADR.COM_HEC_REJECT_DETAIL;


ALTER TABLE ADR.COM_HEC_REJECT_DETAIL ADD (
  CONSTRAINT COMRJCTDTL_PK
  PRIMARY KEY
  (COM_HEC_REJECT_DETAIL_ID)
  USING INDEX ADR.COMRJCTDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL ADD (
  CONSTRAINT COMRJCTDTL_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COM_HEC_REJECT_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_HEC_REJECT_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.COM_HEC_REJECT_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_HEC_REJECT_DETAIL TO ES_RW;
ALTER TABLE ADR.USERS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USERS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USERS_H
(
  USERS_H_ID                NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  USERID                    NUMBER(20)          NOT NULL,
  USER_GROUP_TYPE_ID        NUMBER(20),
  STD_INSTITUTION_ID        NUMBER(20),
  USERNAME                  VARCHAR2(30 BYTE)   NOT NULL,
  FULL_NAME                 VARCHAR2(100 BYTE),
  PASSWORD                  VARCHAR2(128 BYTE),
  PASSWORD_CREATE_DATE      DATE,
  PASSWORD_CHANGE_DATE      DATE,
  PASSWORD_EXPIRE_DATE      DATE,
  ACCOUNT_EXPIRE_DATE       DATE,
  ACCOUNT_LOCK_DATE         DATE,
  INITIAL_LOGIN_DATE        DATE,
  NUMBER_OF_LOGIN_ATTEMPTS  NUMBER(3),
  FIRST_NAME                VARCHAR2(30 BYTE),
  MIDDLE_NAME               VARCHAR2(30 BYTE),
  LAST_NAME                 VARCHAR2(40 BYTE),
  MAIDEN_NAME               VARCHAR2(40 BYTE),
  EMPLOYEE_NUMBER           VARCHAR2(50 BYTE),
  JOB_TITLE                 VARCHAR2(80 BYTE),
  EMAIL_ADDRESS             VARCHAR2(128 BYTE),
  TELEPHONE_NUMBER          VARCHAR2(30 BYTE),
  FAX_NUMBER                VARCHAR2(30 BYTE),
  AGREEMENT_SIGNATURE_CODE  VARCHAR2(6 BYTE),
  SIGNATURE_VERIFIED_IND    VARCHAR2(1 BYTE),
  INACTIVE_FLAG             NUMBER(1)           DEFAULT 0                     NOT NULL,
  INACTIVE_DATE             DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USERS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USERS_H.USERS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USERS_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.USER_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.USERS_H.USERNAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.ACCOUNT_EXPIRE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.ACCOUNT_LOCK_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.NUMBER_OF_LOGIN_ATTEMPTS IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.FIRST_NAME IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.USERS_H.MIDDLE_NAME IS 'BR7325Representative middleNameisdefinedas themiddlenameofthe associationtype identified.';

COMMENT ON COLUMN ADR.USERS_H.LAST_NAME IS 'BR7321Representative LastNameisdefinedas thefamilynameofthe associationtype identified.';

COMMENT ON COLUMN ADR.USERS_H.EMAIL_ADDRESS IS 'Theemailaddressforthe personorinsurance company.';

COMMENT ON COLUMN ADR.USERS_H.TELEPHONE_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USERS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USERS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USERS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USERS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USERH_PK ON ADR.USERS_H
(USERS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USERS_H FOR ADR.USERS_H;


ALTER TABLE ADR.USERS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_028
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USERH_PK
  PRIMARY KEY
  (USERS_H_ID)
  USING INDEX ADR.USERH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USERS_H TO ADR_R;

GRANT SELECT ON ADR.USERS_H TO ADR_RW;

GRANT SELECT ON ADR.USERS_H TO CARUSR_R;

GRANT SELECT ON ADR.USERS_H TO IAM_R;

GRANT INSERT, SELECT ON ADR.USERS_H TO IAM_RW;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_ENROLLMENT_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_ENROLLMENT_STATUS
(
  RPT_ENROLLMENT_STATUS_ID  NUMBER(20)          NOT NULL,
  RPT_SCHEDULED_REPORT_ID   NUMBER(20)          NOT NULL,
  STD_ENROLLMENTSTATUS_ID   NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_ENROLLMENT_STATUS IS 'ESR Reporting table: Provides reporting based on the following enrollment status: Unverified Verified Deceased Cancelled/Declined Rejected; Initial Application by VAMC Pending; No Eligibility Code Pending; Means Test Required Pending; Eligibility Status is Unverified Pending; Other Not Eligible; Refused to Pay Copay Not Eligible; Ineligible Date';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RPT_ENROLLMENT_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTENRSTAT_ENRLMTSTAT_FK_I ON ADR.RPT_ENROLLMENT_STATUS
(STD_ENROLLMENTSTATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTENRSTAT_PK ON ADR.RPT_ENROLLMENT_STATUS
(RPT_ENROLLMENT_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENRSTAT_SCHEDRPT_FK_I ON ADR.RPT_ENROLLMENT_STATUS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_ENROLLMENT_STATUS FOR ADR.RPT_ENROLLMENT_STATUS;


ALTER TABLE ADR.RPT_ENROLLMENT_STATUS ADD (
  CONSTRAINT RPTENRSTAT_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_STATUS_ID)
  USING INDEX ADR.RPTENRSTAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS ADD (
  CONSTRAINT RPTENRSTAT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_ENROLLMENT_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ENROLLMENT_STATUS TO ADR_RW;

GRANT SELECT ON ADR.RPT_ENROLLMENT_STATUS TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_ENROLLMENT_STATUS TO ES_RW;
ALTER TABLE ADR.COM_PRINT_CHECK
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_PRINT_CHECK CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_PRINT_CHECK
(
  COM_PRINT_CHECK_ID       NUMBER(20)           NOT NULL,
  COM_MAILING_ID           NUMBER(20),
  COM_PRINT_REQUEST_ID     NUMBER(20),
  COM_CANCELED_REQUEST_ID  NUMBER(20),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_PRINT_CHECK IS 'The table contains snapshots of what portion of the batch of letters that has been processed. Used to determine where to pick up since the last execution of the batch job. COM_MAILING_ID Foreign key to the COM_MAILING table. COM_PRINT_REQUEST_ID Foreign key to the COM_PRINT_REQUEST table. COM_CANCELED_REQUEST_ID Foreign key to the COM_CANCELED_REQUEST table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.COM_PRINT_CHECK_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.COM_PRINT_REQUEST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.COM_CANCELED_REQUEST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_PRINT_CHECK.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMPRTCHK_COMCNLPR_FK_I ON ADR.COM_PRINT_CHECK
(COM_CANCELED_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMPRTCHK_COMMAIL_FK_I ON ADR.COM_PRINT_CHECK
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMPRTCHK_COMPRTREQ_FK_I ON ADR.COM_PRINT_CHECK
(COM_PRINT_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMPRTCHK_PK ON ADR.COM_PRINT_CHECK
(COM_PRINT_CHECK_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_PRINT_CHECK FOR ADR.COM_PRINT_CHECK;


ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_PK
  PRIMARY KEY
  (COM_PRINT_CHECK_ID)
  USING INDEX ADR.COMPRTCHK_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_COMCNLPR_FK 
  FOREIGN KEY (COM_CANCELED_REQUEST_ID) 
  REFERENCES ADR.COM_CANCELED_REQUEST (COM_CANCELED_REQUEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT COMPRTCHK_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT COMPRTCHK_COMPRTREQ_FK 
  FOREIGN KEY (COM_PRINT_REQUEST_ID) 
  REFERENCES ADR.COM_PRINT_REQUEST (COM_PRINT_REQUEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COM_PRINT_CHECK TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_PRINT_CHECK TO ADR_RW;

GRANT SELECT ON ADR.COM_PRINT_CHECK TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_PRINT_CHECK TO ES_RW;
ALTER TABLE ADR.INCOMPETENT_RULING
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.INCOMPETENT_RULING CASCADE CONSTRAINTS;

CREATE TABLE ADR.INCOMPETENT_RULING
(
  INCOMPETENT_RULING_ID          NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  CIVIL_INCPTNT_RULING_DATE_TXT  VARCHAR2(14 BYTE),
  VA_INCPTNT_RULING_DATE_TXT     VARCHAR2(14 BYTE),
  RULED_INCOMPETENT_IND          VARCHAR2(1 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.INCOMPETENT_RULING IS 'The INCOMPETENT_RULING table stores data about the ruling that deemed a person incompetent to manage his or her own affairs. PERSON_ID Foreign key to the PERSON table. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.INCOMPETENT_RULING.INCOMPETENT_RULING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INCOMPETENT_RULING.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.INCOMPETENT_RULING.CIVIL_INCPTNT_RULING_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INCOMPETENT_RULING.VA_INCPTNT_RULING_DATE_TXT IS 'BR1621DateRuled Incompetent(VA)is definedastheDatethe veteranwasruled incompetenttohandle her/hisVAFunds.';

COMMENT ON COLUMN ADR.INCOMPETENT_RULING.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.INCOMPETENT_RULING.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.INCOMPETENT_RULING.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.INCOMPETENT_RULING.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.INCOMPETENT_RULING.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.INCOMPRULE_PK ON ADR.INCOMPETENT_RULING
(INCOMPETENT_RULING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.INCOMPRULE_PRSN_FK_I ON ADR.INCOMPETENT_RULING
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.INCOMPETENT_RUL_AUDIR_TRGR
after Update or Delete or Insert
on ADR.INCOMPETENT_RULING
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into INCOMPETENT_RULING_H
		(
		INCOMPETENT_RULING_H_ID,
		INCOMPETENT_RULING_ID,
		PERSON_ID,
		CIVIL_INCPTNT_RULING_DATE_TXT,
		VA_INCPTNT_RULING_DATE_TXT,
		RULED_INCOMPETENT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INCOMPETENT_RULING_H_S.nextval,
		:old.INCOMPETENT_RULING_ID,
		:old.PERSON_ID,
		:old.CIVIL_INCPTNT_RULING_DATE_TXT,
		:old.VA_INCPTNT_RULING_DATE_TXT,
		:old.RULED_INCOMPETENT_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into INCOMPETENT_RULING_H
		(
		INCOMPETENT_RULING_H_ID,
		INCOMPETENT_RULING_ID,
		PERSON_ID,
		CIVIL_INCPTNT_RULING_DATE_TXT,
		VA_INCPTNT_RULING_DATE_TXT,
		RULED_INCOMPETENT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INCOMPETENT_RULING_H_S.nextval,
		:new.INCOMPETENT_RULING_ID,
		:new.PERSON_ID,
		:new.CIVIL_INCPTNT_RULING_DATE_TXT,
		:new.VA_INCPTNT_RULING_DATE_TXT,
		:new.RULED_INCOMPETENT_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  INCOMPETENT_RUL_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM INCOMPETENT_RULING FOR ADR.INCOMPETENT_RULING;


ALTER TABLE ADR.INCOMPETENT_RULING ADD (
  CONSTRAINT INCOMPRULE_PK
  PRIMARY KEY
  (INCOMPETENT_RULING_ID)
  USING INDEX ADR.INCOMPRULE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.INCOMPETENT_RULING ADD (
  CONSTRAINT INCOMPRULE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.INCOMPETENT_RULING TO ADREXT;

GRANT SELECT ON ADR.INCOMPETENT_RULING TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.INCOMPETENT_RULING TO ADR_RW;

GRANT SELECT ON ADR.INCOMPETENT_RULING TO ES_R;

GRANT INSERT, SELECT ON ADR.INCOMPETENT_RULING TO ES_RW;
ALTER TABLE ADR.INELIGIBLE_RULING
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.INELIGIBLE_RULING CASCADE CONSTRAINTS;

CREATE TABLE ADR.INELIGIBLE_RULING
(
  INELIGIBLE_RULING_ID    NUMBER(20)            NOT NULL,
  PERSON_ID               NUMBER(20)            NOT NULL,
  INELIGIBLE_DATE         DATE,
  INELIGIBLE_REASON_TEXT  VARCHAR2(250 BYTE),
  VARO_DECISION_TEXT      VARCHAR2(250 BYTE),
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL,
  STD_INSTITUTION_ID      NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.INELIGIBLE_RULING IS 'The table stores data about the ruling that deemed a person ineligible to receive healthcare benefits from the VHA. PERSON_ID Foreign key to the PERSON table. STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table. Indicates the site at which the ruling was made. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.INELIGIBLE_RULING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.INELIGIBLE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.INELIGIBLE_REASON_TEXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.VARO_DECISION_TEXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';


CREATE UNIQUE INDEX ADR.INELIGBRLG_PK ON ADR.INELIGIBLE_RULING
(INELIGIBLE_RULING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.INELIGBRLG_PRSN_FK_I ON ADR.INELIGIBLE_RULING
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.INELIGBRLG_STDINST_FK_I ON ADR.INELIGIBLE_RULING
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.INELIGIBLE_RUL_AUDIR_TRGR
after Update or Delete or Insert
on ADR.INELIGIBLE_RULING
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into INELIGIBLE_RULING_H
		(
		INELIGIBLE_RULING_H_ID,
		INELIGIBLE_RULING_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		INELIGIBLE_DATE,
		INELIGIBLE_REASON_TEXT,
		VARO_DECISION_TEXT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INELIGIBLE_RULING_H_S.nextval,
		:old.INELIGIBLE_RULING_ID,
		:old.PERSON_ID,
		:old.STD_INSTITUTION_ID,
		:old.INELIGIBLE_DATE,
		:old.INELIGIBLE_REASON_TEXT,
		:old.VARO_DECISION_TEXT,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT     ,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into INELIGIBLE_RULING_H
		(
		INELIGIBLE_RULING_H_ID,
		INELIGIBLE_RULING_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		INELIGIBLE_DATE,
		INELIGIBLE_REASON_TEXT,
		VARO_DECISION_TEXT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INELIGIBLE_RULING_H_S.nextval,
		:new.INELIGIBLE_RULING_ID,
		:new.PERSON_ID,
		:new.STD_INSTITUTION_ID,
		:new.INELIGIBLE_DATE,
		:new.INELIGIBLE_REASON_TEXT,
		:new.VARO_DECISION_TEXT,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  INELIGIBLE_RUL_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM INELIGIBLE_RULING FOR ADR.INELIGIBLE_RULING;


ALTER TABLE ADR.INELIGIBLE_RULING ADD (
  CONSTRAINT INELIGBRLG_PK
  PRIMARY KEY
  (INELIGIBLE_RULING_ID)
  USING INDEX ADR.INELIGBRLG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.INELIGIBLE_RULING ADD (
  CONSTRAINT INELIGBRLG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.INELIGIBLE_RULING TO ADREXT;

GRANT SELECT ON ADR.INELIGIBLE_RULING TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.INELIGIBLE_RULING TO ADR_RW;

GRANT SELECT ON ADR.INELIGIBLE_RULING TO ES_R;

GRANT INSERT, SELECT ON ADR.INELIGIBLE_RULING TO ES_RW;
ALTER TABLE ADR.PERSON_MERGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_MERGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_MERGE
(
  PERSON_MERGE_ID           NUMBER(20)          NOT NULL,
  PRIMARY_PERSON_ID         NUMBER(20),
  DEPRECATED_PERSON_ID      NUMBER(20),
  MERGE_RECORD_LOCKED_FLAG  NUMBER(1)           DEFAULT 0,
  MERGE_START_DATE          DATE,
  MERGE_END_DATE            DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  MERGE_DATA_TEXT           CLOB
)
LOB (MERGE_DATA_TEXT) STORE AS (
  TABLESPACE  M_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          4M
                  NEXT             4M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_MERGE IS 'This table supports the person merge process - in the case of a single identity sharing two or more records in the system, the identities are merged together into a single record.';

COMMENT ON COLUMN ADR.PERSON_MERGE.PERSON_MERGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_MERGE.PRIMARY_PERSON_ID IS 'Non-keyID-thereisno foreignkeyenforcing thisvalue.Thisfieldcontainsthe IDvaluefortheperson recordtobemerged.';

COMMENT ON COLUMN ADR.PERSON_MERGE.DEPRECATED_PERSON_ID IS 'Non-keyID-thereisno foreignkeyenforcing thisvalue.Thisfieldcontainsthe IDvalueforthe duplicatepersonrecord.';

COMMENT ON COLUMN ADR.PERSON_MERGE.MERGE_RECORD_LOCKED_FLAG IS 'NeumericFLAGrecord-if 1indicatesthatthe recordislocked.';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_MERGE.MERGE_DATA_TEXT IS 'Textvaluecontaining detailsofmergedrecord';


CREATE INDEX ADR.PRSNMRG_DEPRECPRSNID_NU_I ON ADR.PERSON_MERGE
(DEPRECATED_PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PRSNMRG_PK ON ADR.PERSON_MERGE
(PERSON_MERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNMRG_PRIMRYPRSNID_NU_I ON ADR.PERSON_MERGE
(PRIMARY_PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_MERGE FOR ADR.PERSON_MERGE;


ALTER TABLE ADR.PERSON_MERGE ADD (
  CONSTRAINT AVCON_1172521913_MERGE_000
  CHECK (MERGE_RECORD_LOCKED_FLAG BETWEEN 0
AND 0 OR MERGE_RECORD_LOCKED_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT PRSNMRG_PK
  PRIMARY KEY
  (PERSON_MERGE_ID)
  USING INDEX ADR.PRSNMRG_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_MERGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_MERGE TO ADR_RW;

GRANT SELECT ON ADR.PERSON_MERGE TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_MERGE TO ES_RW;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VA_PERSON_CLASS_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.VA_PERSON_CLASS_DETAIL
(
  VA_PERSON_CLASS_DETAIL_ID  NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_PERSONCLASS_ID         NUMBER(20),
  STD_INSTITUTION_ID         NUMBER(20),
  PERSON_CLASS_START_DATE    DATE,
  PERSON_CLASS_END_DATE      DATE,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VA_PERSON_CLASS_DETAIL IS 'The table stores data for persons designated as practitioners for the VHA. The Person Class designation shows what type of function(s) practitioners are authorized to perform (for example, audiologist, social worker, and chiropractor). DEMOGRAPHICS';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.VA_PERSON_CLASS_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.STD_PERSONCLASS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.PERSON_CLASS_START_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.PERSON_CLASS_END_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.VAPRSNCLAS_PK ON ADR.VA_PERSON_CLASS_DETAIL
(VA_PERSON_CLASS_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPRSNCLAS_PRSN_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPRSNCLAS_STDINST2_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPRSNCLAS_STDINST_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPRSNCLAS_STDPRCLASS_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(STD_PERSONCLASS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.VA_PERSON_CLASS_DET_audir_trgr
after Update or Delete or Insert
ON ADR.VA_PERSON_CLASS_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into VA_PERSON_CLASS_DETAIL_H
		(
		VA_PERSON_CLASS_DETAIL_H_ID,
		VA_PERSON_CLASS_DETAIL_ID,
		PERSON_CLASS_START_DATE,
		PERSON_CLASS_END_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_PERSONCLASS_ID,
		STD_INSTITUTION_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_CLASS_DETAIL_H_S.nextval,
		:old.VA_PERSON_CLASS_DETAIL_ID,
		:old.PERSON_CLASS_START_DATE,
		:old.PERSON_CLASS_END_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.STD_PERSONCLASS_ID,
		:old.STD_INSTITUTION_ID,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into VA_PERSON_CLASS_DETAIL_H
		(
		VA_PERSON_CLASS_DETAIL_H_ID,
		VA_PERSON_CLASS_DETAIL_ID,
		PERSON_CLASS_START_DATE,
		PERSON_CLASS_END_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_PERSONCLASS_ID,
		STD_INSTITUTION_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_CLASS_DETAIL_H_S.nextval,
		:new.VA_PERSON_CLASS_DETAIL_ID,
		:new.PERSON_CLASS_START_DATE,
		:new.PERSON_CLASS_END_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.STD_PERSONCLASS_ID,
		:new.STD_INSTITUTION_ID,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML
		);
	end if;

end VA_PERSON_CLASS_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM VA_PERSON_CLASS_DETAIL FOR ADR.VA_PERSON_CLASS_DETAIL;


ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL ADD (
  CONSTRAINT VAPRSNCLAS_PK
  PRIMARY KEY
  (VA_PERSON_CLASS_DETAIL_ID)
  USING INDEX ADR.VAPRSNCLAS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL ADD (
  CONSTRAINT VAPRSNCLAS_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VA_PERSON_CLASS_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.VA_PERSON_CLASS_DETAIL TO PSIM_ADR_RW;

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL TO VHAISPSTALLP;
ALTER TABLE ADR.BENEFICIARY_MST
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.BENEFICIARY_MST CASCADE CONSTRAINTS;

CREATE TABLE ADR.BENEFICIARY_MST
(
  BENEFICIARY_MST_ID     NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  MST_STATUS_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID     NUMBER(20),
  MST_EVALUATION_DATE    DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.BENEFICIARY_MST IS 'The BENEFICIARY_MST table shows that a person has been clinically determined to have suffered a Military Sexual Trauma, and includes the status of the determination, the site at which the determination was made. PERSON_ID Foreign key to the PERSON table. Indicates the particular person to whom the Military Sexual Trauma data applies. MST_STATUS_TYPE_ID Foreign key to the MST_STATUS_TYPE table, which indicates the status of a persons screening for MST. STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table, which indicates the site at which MST status was determined. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.BENEFICIARY_MST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.MST_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.MST_EVALUATION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.BENEFICIARY_MST.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.BNFYMST_PK ON ADR.BENEFICIARY_MST
(BENEFICIARY_MST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYMST_PRSN_FK_I ON ADR.BENEFICIARY_MST
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYMST_STDINST_FK_I ON ADR.BENEFICIARY_MST
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.BNFYMST_STD_MSTST_FK_I ON ADR.BENEFICIARY_MST
(MST_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.BENEFICIARY_MST_AUDIR_TRGR
after Update or Delete or Insert
on ADR.BENEFICIARY_MST
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin
	if DELETING then
		insert into BENEFICIARY_MST_H
		(
		BENEFICIARY_MST_H_ID,
		BENEFICIARY_MST_ID  ,
		PERSON_ID           ,
		MST_STATUS_TYPE_ID ,
		STD_INSTITUTION_ID  ,
		MST_EVALUATION_DATE,
		RECORD_CREATED_BY   ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY  ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_mst_h_s.nextval,
		:old.BENEFICIARY_MST_ID,
		:old.PERSON_ID        ,
		:old.MST_STATUS_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.MST_EVALUATION_DATE,
		:old.RECORD_CREATED_BY ,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY ,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else

		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_MST_H
		(
		BENEFICIARY_MST_H_ID,
		BENEFICIARY_MST_ID  ,
		PERSON_ID           ,
		MST_STATUS_TYPE_ID ,
		STD_INSTITUTION_ID ,
		MST_EVALUATION_DATE,
		RECORD_CREATED_BY  ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_mst_h_s.nextval,
		:new.BENEFICIARY_MST_ID,
		:new.PERSON_ID         ,
		:new.MST_STATUS_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.MST_EVALUATION_DATE,
		:new.RECORD_CREATED_BY  ,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end beneficiary_mst_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM BENEFICIARY_MST FOR ADR.BENEFICIARY_MST;


ALTER TABLE ADR.BENEFICIARY_MST ADD (
  CONSTRAINT BNFYMST_PK
  PRIMARY KEY
  (BENEFICIARY_MST_ID)
  USING INDEX ADR.BNFYMST_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.BENEFICIARY_MST ADD (
  CONSTRAINT BNFYMST_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.BENEFICIARY_MST TO ADREXT;

GRANT SELECT ON ADR.BENEFICIARY_MST TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.BENEFICIARY_MST TO ADR_RW;

GRANT SELECT ON ADR.BENEFICIARY_MST TO ES_R;

GRANT INSERT, SELECT ON ADR.BENEFICIARY_MST TO ES_RW;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PRISONER_OF_WAR_REGISTRY CASCADE CONSTRAINTS;

CREATE TABLE ADR.PRISONER_OF_WAR_REGISTRY
(
  PRISONER_OF_WAR_REGISTRY_ID  NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20),
  REGISTRY_TRAIT_ID            NUMBER(20),
  POW_STDYESNO_ID              NUMBER(20),
  LEGACY_ICN                   VARCHAR2(30 BYTE),
  LEGACY_USERNAME              VARCHAR2(30 BYTE),
  LEGACY_ENTERED_DATE          DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PRISONER_OF_WAR_REGISTRY IS 'The table contains data about persons who have been captured and imprisoned as prisoners of war, The data originates from the Department of Defense, Veterans Benefits Administration, and the National Archives. This table corresponds to the Prisoner of War Registry File. All persons in the POW registry file are enumerated and a record is created for them in this table with full details. The Enrollment application uses some of the information in this table as a factor in enrollment calculations. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.PRISONER_OF_WAR_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.LEGACY_ENTERED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.POW_LGCYICN_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY
(LEGACY_ICN)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.POW_PK ON ADR.PRISONER_OF_WAR_REGISTRY
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POW_PRSN_FK_I ON ADR.PRISONER_OF_WAR_REGISTRY
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POW_REGTRAIT_FK_I ON ADR.PRISONER_OF_WAR_REGISTRY
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POW_STDYESNO_FK_I ON ADR.PRISONER_OF_WAR_REGISTRY
(POW_STDYESNO_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.POW_REGISTRY_AUDIR_TRGR
after Update or Delete or Insert
on ADR.PRISONER_OF_WAR_REGISTRY
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PRISONER_OF_WAR_REGISTRY_H
		(
		PRISONER_OF_WAR_REGISTRY_H_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		LEGACY_ICN,
		LEGACY_USERNAME,
		LEGACY_ENTERED_DATE,
		POW_STDYESNO_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PRISONER_OF_WAR_REGISTRY_H_S.nextval,
		:old.PRISONER_OF_WAR_REGISTRY_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.PERSON_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.LEGACY_ICN,
		:old.LEGACY_USERNAME,
		:old.LEGACY_ENTERED_DATE,
		:old.POW_STDYESNO_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PRISONER_OF_WAR_REGISTRY_H
		(
		PRISONER_OF_WAR_REGISTRY_H_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		LEGACY_ICN,
		LEGACY_USERNAME,
		LEGACY_ENTERED_DATE,
		POW_STDYESNO_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PRISONER_OF_WAR_REGISTRY_H_S.nextval,
		:new.PRISONER_OF_WAR_REGISTRY_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.PERSON_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.LEGACY_ICN,
		:new.LEGACY_USERNAME,
		:new.LEGACY_ENTERED_DATE,
		:new.POW_STDYESNO_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end POW_REGISTRY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PRISONER_OF_WAR_REGISTRY FOR ADR.PRISONER_OF_WAR_REGISTRY;


ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_PK
  PRIMARY KEY
  (PRISONER_OF_WAR_REGISTRY_ID)
  USING INDEX ADR.POW_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT POW_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY TO ADREXT;

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PRISONER_OF_WAR_REGISTRY TO ADR_RW;

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY TO ES_R;

GRANT INSERT, SELECT ON ADR.PRISONER_OF_WAR_REGISTRY TO ES_RW;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_CANCEL_DECLINE_REASON CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_CANCEL_DECLINE_REASON
(
  RPT_CANCEL_DECLINE_REASON_ID   NUMBER(20)     NOT NULL,
  RPT_SCHEDULED_REPORT_ID        NUMBER(20)     NOT NULL,
  CANCEL_DECLINE_REASON_TYPE_ID  NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_CANCEL_DECLINE_REASON IS 'ESR reporting table. Contains the RPT_SCHEDULED_REPORT_ID and the cancel / decline reason type id.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RPT_CANCEL_DECLINE_REASON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.CANCEL_DECLINE_REASON_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTCANDECL_CANDCLNRSN_FK_I ON ADR.RPT_CANCEL_DECLINE_REASON
(CANCEL_DECLINE_REASON_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTCANDECL_PK ON ADR.RPT_CANCEL_DECLINE_REASON
(RPT_CANCEL_DECLINE_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTCANDECL_SCHEDRPT_FK_I ON ADR.RPT_CANCEL_DECLINE_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_CANCEL_DECLINE_REASON FOR ADR.RPT_CANCEL_DECLINE_REASON;


ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON ADD (
  CONSTRAINT RPTCANDECL_PK
  PRIMARY KEY
  (RPT_CANCEL_DECLINE_REASON_ID)
  USING INDEX ADR.RPTCANDECL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON ADD (
  CONSTRAINT RPTCANDECL_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_CANCEL_DECLINE_REASON TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_CANCEL_DECLINE_REASON TO ADR_RW;

GRANT SELECT ON ADR.RPT_CANCEL_DECLINE_REASON TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_CANCEL_DECLINE_REASON TO ES_RW;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VA_PERSON_DIVISION_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.VA_PERSON_DIVISION_DETAIL_H
(
  VA_PERSON_DIVISION_DETAIL_H_ID  NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  VA_PERSON_DIVISION_DETAIL_ID    NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  DEFAULT_DIVISION_FLAG           NUMBER(1)     DEFAULT 0                     NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  RECORD_MODIFIED_SITE_ID         NUMBER(20),
  RECORD_MODIFIED_SRC_NAME        VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VA_PERSON_DIVISION_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.VA_PERSON_DIVISION_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.VA_PERSON_DIVISION_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.VAPERDVSNH_PK ON ADR.VA_PERSON_DIVISION_DETAIL_H
(VA_PERSON_DIVISION_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPERDVSNH_PRSNID_NU_I ON ADR.VA_PERSON_DIVISION_DETAIL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VA_PERSON_DIVISION_DETAIL_H FOR ADR.VA_PERSON_DIVISION_DETAIL_H;


ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_032
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT VAPERDVSNH_PK
  PRIMARY KEY
  (VA_PERSON_DIVISION_DETAIL_H_ID)
  USING INDEX ADR.VAPERDVSNH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H TO PSIM_ADR_R;
ALTER TABLE ADR.SHAD_REGISTRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SHAD_REGISTRY CASCADE CONSTRAINTS;

CREATE TABLE ADR.SHAD_REGISTRY
(
  SHAD_REGISTRY_ID       NUMBER(20)             NOT NULL,
  REGISTRY_TRAIT_ID      NUMBER(20),
  PERSON_ID              NUMBER(20),
  SHAD_STDYESNO_ID       NUMBER(20),
  CLAIM_NUMBER           VARCHAR2(20 BYTE),
  LEGACY_USERNAME        VARCHAR2(30 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SHAD_REGISTRY IS 'The contains data about persons who have been exposed to hazardous environments as part of their military service. The Shipboard Hazard and Defense (SHAD) data originates from the Veterans Benefits Administration (VBA). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.SHAD_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SHADRGSTRY_PK ON ADR.SHAD_REGISTRY
(SHAD_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADRGSTRY_PRSN_FK_I ON ADR.SHAD_REGISTRY
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADRGSTRY_REGTRAIT_FK_I ON ADR.SHAD_REGISTRY
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADRGSTRY_STDYESNO_FK_I ON ADR.SHAD_REGISTRY
(SHAD_STDYESNO_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SHAD_REGISTRY_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.SHAD_REGISTRY
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SHAD_REGISTRY_H
		(
		SHAD_REGISTRY_H_ID,
		SHAD_REGISTRY_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		CLAIM_NUMBER,
		SHAD_STDYESNO_ID,
		LEGACY_USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_H_S.nextval,
		:old.SHAD_REGISTRY_ID,
		:old.PERSON_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.CLAIM_NUMBER,
		:old.SHAD_STDYESNO_ID,
		:old.LEGACY_USERNAME,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SHAD_REGISTRY_H
		(
		SHAD_REGISTRY_H_ID,
		SHAD_REGISTRY_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		CLAIM_NUMBER,
		SHAD_STDYESNO_ID,
		LEGACY_USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_H_S.nextval,
		:new.SHAD_REGISTRY_ID,
		:new.PERSON_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.CLAIM_NUMBER,
		:new.SHAD_STDYESNO_ID,
		:new.LEGACY_USERNAME,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end SHAD_REGISTRY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SHAD_REGISTRY FOR ADR.SHAD_REGISTRY;


ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_PK
  PRIMARY KEY
  (SHAD_REGISTRY_ID)
  USING INDEX ADR.SHADRGSTRY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT SHADRGSTRY_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.SHAD_REGISTRY TO ADREXT;

GRANT SELECT ON ADR.SHAD_REGISTRY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SHAD_REGISTRY TO ADR_RW;

GRANT SELECT ON ADR.SHAD_REGISTRY TO ES_R;

GRANT INSERT, SELECT ON ADR.SHAD_REGISTRY TO ES_RW;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERMISSION_SET_PERMISSIONS CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERMISSION_SET_PERMISSIONS
(
  PERM_SET_PERMISSIONS_ID  NUMBER(20)           NOT NULL,
  PERMISSION_TYPE_ID       NUMBER(20)           NOT NULL,
  PERMISSION_SET_ID        NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERMISSION_SET_PERMISSIONS IS 'Intersection table mapping users and roles The USER_ROLES table is an application administration table that stores the role that determines database access for users.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.PERM_SET_PERMISSIONS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRMSTPRM_PK ON ADR.PERMISSION_SET_PERMISSIONS
(PERM_SET_PERMISSIONS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PSETPRM_PERMSET_FK_I ON ADR.PERMISSION_SET_PERMISSIONS
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PSETPRM_STD_PERM_FK_I ON ADR.PERMISSION_SET_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERM_SET_PERM_audir_trgr
after Update or Delete or Insert
ON ADR.PERMISSION_SET_PERMISSIONS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERMISSION_SET_PERMISSIONS_H
		(
		PERM_SET_PERMISSIONS_H_ID,
		PERM_SET_PERMISSIONS_ID,
		PERMISSION_SET_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMSSN_SET_PERMSSNS_H_S.nextval,
		:old.PERM_SET_PERMISSIONS_ID,
		:old.PERMISSION_SET_ID,
		:old.PERMISSION_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERMISSION_SET_PERMISSIONS_H
		(
		PERM_SET_PERMISSIONS_H_ID,
		PERM_SET_PERMISSIONS_ID,
		PERMISSION_SET_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMSSN_SET_PERMSSNS_H_S.nextval,
		:new.PERM_SET_PERMISSIONS_ID,
		:new.PERMISSION_SET_ID,
		:new.PERMISSION_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PERM_SET_PERM_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERMISSION_SET_PERMISSIONS FOR ADR.PERMISSION_SET_PERMISSIONS;


ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PRMSTPRM_PK
  PRIMARY KEY
  (PERM_SET_PERMISSIONS_ID)
  USING INDEX ADR.PRMSTPRM_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PSETPRM_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT PSETPRM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERMISSION_SET_PERMISSIONS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERMISSION_SET_PERMISSIONS TO ADR_RW;

GRANT SELECT ON ADR.PERMISSION_SET_PERMISSIONS TO ES_R;

GRANT INSERT, SELECT ON ADR.PERMISSION_SET_PERMISSIONS TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_DIAGNOSIS CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_DIAGNOSIS
(
  CAT_DSBLTY_DIAGNOSIS_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  DIAGNOSIS_TYPE_ID           NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_DIAGNOSIS IS 'The CAT_DSBLTY_DIAGNOSIS table is a child table of CATASTROPHIC_DISABILITY that shows the specific disability or disabilities with which the person has been diagnosed. CATASTROPHIC_DISABILITY_ID Foreign key to the CATASTROPHIC_DISABILITY table. DIAGNOSIS_TYPE_ID Foreign key to the DIAGNOSIS_TYPE. Indicates the type of disability that was diagnosed for a person (for example, paraplegia, legal blindness). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.CAT_DSBLTY_DIAGNOSIS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.DIAGNOSIS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_DIAGNOSIS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSDIAG_CATDSBLTY_FK_I ON ADR.CAT_DSBLTY_DIAGNOSIS
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSDIAG_PK ON ADR.CAT_DSBLTY_DIAGNOSIS
(CAT_DSBLTY_DIAGNOSIS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSDIAG_STD_DIAGCD_FK_I ON ADR.CAT_DSBLTY_DIAGNOSIS
(DIAGNOSIS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_DIAG_audir_trgr
after Update or Delete or Insert
ON ADR.CAT_DSBLTY_DIAGNOSIS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CAT_DSBLTY_DIAGNOSIS_H
		(
		CAT_DSBLTY_DIAGNOSIS_H_ID,
		CAT_DSBLTY_DIAGNOSIS_ID,
		CATASTROPHIC_DISABILITY_ID,
		DIAGNOSIS_TYPE_ID         ,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_DIAGNOSIS_H_S.nextval,
		:old.CAT_DSBLTY_DIAGNOSIS_ID,
		:old.CATASTROPHIC_DISABILITY_ID,
		:old.DIAGNOSIS_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CAT_DSBLTY_DIAGNOSIS_H
		(
		CAT_DSBLTY_DIAGNOSIS_H_ID,
		CAT_DSBLTY_DIAGNOSIS_ID,
		CATASTROPHIC_DISABILITY_ID,
		DIAGNOSIS_TYPE_ID         ,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_DIAGNOSIS_H_S.nextval,
		:new.CAT_DSBLTY_DIAGNOSIS_ID,
		:new.CATASTROPHIC_DISABILITY_ID,
		:new.DIAGNOSIS_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;


end  CAT_DSBLTY_DIAG_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_DIAGNOSIS FOR ADR.CAT_DSBLTY_DIAGNOSIS;


ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS ADD (
  CONSTRAINT CATDSDIAG_PK
  PRIMARY KEY
  (CAT_DSBLTY_DIAGNOSIS_ID)
  USING INDEX ADR.CATDSDIAG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS ADD (
  CONSTRAINT CATDSDIAG_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_DIAGNOSIS TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_DIAGNOSIS TO ES_RW;
ALTER TABLE ADR.PERSON_RACE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RACE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RACE_H
(
  PERSON_RACE_H_ID           NUMBER(20)         NOT NULL,
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE)   NOT NULL,
  PERSON_RACE_ID             NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_RACE_ID                NUMBER(20)         NOT NULL,
  COLLECTION_METHOD_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_RACE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.PERSON_RACE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.PERSON_RACE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.STD_RACE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.COLLECTION_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNRACEH_PK ON ADR.PERSON_RACE_H
(PERSON_RACE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACEH_PRSNID_NU_I ON ADR.PERSON_RACE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_RACE_H FOR ADR.PERSON_RACE_H;


ALTER TABLE ADR.PERSON_RACE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_034
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PRSNRACEH_PK
  PRIMARY KEY
  (PERSON_RACE_H_ID)
  USING INDEX ADR.PRSNRACEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_RACE_H TO ADREXT;

GRANT SELECT ON ADR.PERSON_RACE_H TO ADR_R;

GRANT SELECT ON ADR.PERSON_RACE_H TO ADR_RW;

GRANT SELECT ON ADR.PERSON_RACE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_RACE_H TO ES_RW;

GRANT SELECT ON ADR.PERSON_RACE_H TO PSIM_ADR_R;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_PROCEDURE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_PROCEDURE_H
(
  CAT_DSBLTY_PROCEDURE_H_ID   NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  CAT_DSBLTY_PROCEDURE_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  PROCEDURE_TYPE_ID           NUMBER(20)        NOT NULL,
  AFFECTED_EXTREMITY_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_PROCEDURE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.CAT_DSBLTY_PROCEDURE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.CAT_DSBLTY_PROCEDURE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.PROCEDURE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.AFFECTED_EXTREMITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_PROCEDURE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSBLPRH_CATDSBLTY_NU_I ON ADR.CAT_DSBLTY_PROCEDURE_H
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSBLPRH_PK ON ADR.CAT_DSBLTY_PROCEDURE_H
(CAT_DSBLTY_PROCEDURE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_PROCEDURE_H FOR ADR.CAT_DSBLTY_PROCEDURE_H;


ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_035
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CATDSBLPRH_PK
  PRIMARY KEY
  (CAT_DSBLTY_PROCEDURE_H_ID)
  USING INDEX ADR.CATDSBLPRH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ADR_R;

GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_PROCEDURE_H TO ES_RW;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ELIGIBILITY_DETERMINATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.ELIGIBILITY_DETERMINATION
(
  ELIGIBILITY_DETERMINATION_ID  NUMBER(20)      NOT NULL,
  ENROLLMENT_DETERMINATION_ID   NUMBER(20)      NOT NULL,
  ELIGIBILITY_TYPE_ID           NUMBER(20),
  STD_ELIGIBILITYFACTOR_ID      NUMBER(20),
  PRIMARY_SECONDARY_OR_OTHER    VARCHAR2(1 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ELIGIBILITY_DETERMINATION IS 'The ELIGIBILITY_DETERMINATION table contains information about the eligibility codes applicable to a persons enrollment in the VHA Healthcare system. ENROLLMENT_DETERMINATION_ID Foreign key to the ENROLLMENT_DETERMINATION table. ELIGIBILITY_TYPE_ID Foreign key to the ELIGIBILITY_TYPE table. Indicates the eligibility codes associated with a particular person (for example, Service Connected 50% to 100%, Purple Heart). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.ELIGIBILITY_DETERMINATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.ENROLLMENT_DETERMINATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.ELIGIBILITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.STD_ELIGIBILITYFACTOR_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.PRIMARY_SECONDARY_OR_OTHER IS 'Indicateswhetheran eligibilityisaprimary, secondary,orother eligibility.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ELIGIBILITY_DETERMINATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.ELGBDETER_ENRLMNTDET_FK_I ON ADR.ELIGIBILITY_DETERMINATION
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ELGBDETER_PK ON ADR.ELIGIBILITY_DETERMINATION
(ELIGIBILITY_DETERMINATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBDETER_STDELGFCTR_FK_I ON ADR.ELIGIBILITY_DETERMINATION
(STD_ELIGIBILITYFACTOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ELGBDETER_STD_ELGBTYCODE_FK_I ON ADR.ELIGIBILITY_DETERMINATION
(ELIGIBILITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENROLLMENT_DETERM_MOD_DT_NDX ON ADR.ELIGIBILITY_DETERMINATION
(RECORD_MODIFIED_DATE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ELIGIBILITY_DET_audir_trgr
after Update or Delete or Insert
ON ADR.ELIGIBILITY_DETERMINATION
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ELIGIBILITY_DETERMINATION_H
		(
		ELIGIBILITY_DETERMINATION_H_ID,
		ELIGIBILITY_DETERMINATION_ID  ,
		ENROLLMENT_DETERMINATION_ID   ,
		ELIGIBILITY_TYPE_ID           ,
		PRIMARY_SECONDARY_OR_OTHER    ,
		STD_ELIGIBILITYFACTOR_ID	  ,
		RECORD_CREATED_BY             ,
		RECORD_CREATED_DATE           ,
		RECORD_MODIFIED_BY            ,
		RECORD_MODIFIED_DATE          ,
		RECORD_MODIFIED_COUNT         ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ELIGIBILITY_DETERMINATION_H_s.nextval,
		:old.ELIGIBILITY_DETERMINATION_ID,
		:old.ENROLLMENT_DETERMINATION_ID,
		:old.ELIGIBILITY_TYPE_ID,
		:old.PRIMARY_SECONDARY_OR_OTHER,
		:old.STD_ELIGIBILITYFACTOR_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ELIGIBILITY_DETERMINATION_H
		(
		ELIGIBILITY_DETERMINATION_H_ID,
		ELIGIBILITY_DETERMINATION_ID  ,
		ENROLLMENT_DETERMINATION_ID   ,
		ELIGIBILITY_TYPE_ID           ,
		PRIMARY_SECONDARY_OR_OTHER    ,
		STD_ELIGIBILITYFACTOR_ID,
		RECORD_CREATED_BY             ,
		RECORD_CREATED_DATE           ,
		RECORD_MODIFIED_BY            ,
		RECORD_MODIFIED_DATE          ,
		RECORD_MODIFIED_COUNT         ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ELIGIBILITY_DETERMINATION_H_s.nextval,
		:new.ELIGIBILITY_DETERMINATION_ID,
		:new.ENROLLMENT_DETERMINATION_ID,
		:new.ELIGIBILITY_TYPE_ID,
		:new.PRIMARY_SECONDARY_OR_OTHER,
		:new.STD_ELIGIBILITYFACTOR_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  ELIGIBILITY_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ELIGIBILITY_DETERMINATION FOR ADR.ELIGIBILITY_DETERMINATION;


ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT AVCON_1172521913_PRIMA_001
  CHECK (PRIMARY_SECONDARY_OR_OTHER IN ('P', 'S', 'O'))
  ENABLE VALIDATE,
  CONSTRAINT ELGBDETER_PK
  PRIMARY KEY
  (ELIGIBILITY_DETERMINATION_ID)
  USING INDEX ADR.ELGBDETER_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT ELGBDETER_ENRLMNTDET_FK 
  FOREIGN KEY (ENROLLMENT_DETERMINATION_ID) 
  REFERENCES ADR.ENROLLMENT_DETERMINATION (ENROLLMENT_DETERMINATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ELIGIBILITY_DETERMINATION TO ADR_RW;

GRANT SELECT ON ADR.ELIGIBILITY_DETERMINATION TO ES_R;

GRANT INSERT, SELECT ON ADR.ELIGIBILITY_DETERMINATION TO ES_RW;
ALTER TABLE ADR.COMBAT_PAY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COMBAT_PAY CASCADE CONSTRAINTS;

CREATE TABLE ADR.COMBAT_PAY
(
  COMBAT_PAY_ID              NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  COMBATSERVICESOURCE_ID     NUMBER(20),
  COMBATSERVICELOCATION_ID   NUMBER(20),
  COMBAT_PAY_START_DATE_TXT  VARCHAR2(14 BYTE),
  COMBAT_PAY_END_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  STD_COMBATPAYTYPE_ID       NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COMBAT_PAY IS 'This holds the OEF / OIF functionality (enhancement to the Military Service determination, in the case of Operation Iraqi Freedom) This is like an upgraded Military Service / Military Service Episode / Conflict Detail structure';

COMMENT ON COLUMN ADR.COMBAT_PAY.COMBAT_PAY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COMBAT_PAY.COMBATSERVICESOURCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY.COMBATSERVICELOCATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY.COMBAT_PAY_START_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COMBAT_PAY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.COMBAT_PAY.STD_COMBATPAYTYPE_ID IS 'Identifier for existing	SDS Combat Pay Type';


CREATE UNIQUE INDEX ADR.CMBTPAY_PK ON ADR.COMBAT_PAY
(COMBAT_PAY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAY_PRSN_FK_I ON ADR.COMBAT_PAY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAY_STDCBTPTYP_FK_I ON ADR.COMBAT_PAY
(STD_COMBATPAYTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAY_STDCBTSLOC_FK_I ON ADR.COMBAT_PAY
(COMBATSERVICELOCATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMBTPAY_STDCBTSSRC_FK_I ON ADR.COMBAT_PAY
(COMBATSERVICESOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.COMBAT_PAY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.COMBAT_PAY
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into COMBAT_PAY_H
		(
		 COMBAT_PAY_H_ID
 		,COMBAT_PAY_ID
 		,PERSON_ID
 		,COMBATSERVICESOURCE_ID
 		,COMBATSERVICELOCATION_ID
        ,STD_COMBATPAYTYPE_ID
 		,COMBAT_PAY_START_DATE_TXT
 		,COMBAT_PAY_END_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_PAY_H_S.nextval,
		:old.COMBAT_PAY_ID,
		:old.PERSON_ID ,
 		:old.COMBATSERVICESOURCE_ID,
 		:old.COMBATSERVICELOCATION_ID,
        :old.STD_COMBATPAYTYPE_ID,
 		:old.COMBAT_PAY_START_DATE_TXT,
 		:old.COMBAT_PAY_END_DATE_TXT,
 		:old.RECORD_CREATED_BY,
 		:old.RECORD_CREATED_DATE,
 		:old.RECORD_MODIFIED_BY,
 		:old.RECORD_MODIFIED_DATE,
 		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;
		insert into COMBAT_PAY_H
		(
		 COMBAT_PAY_H_ID
 		,COMBAT_PAY_ID
 		,PERSON_ID
 		,COMBATSERVICESOURCE_ID
 		,COMBATSERVICELOCATION_ID
        ,STD_COMBATPAYTYPE_ID
 		,COMBAT_PAY_START_DATE_TXT
 		,COMBAT_PAY_END_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_PAY_H_S.nextval,
		:new.COMBAT_PAY_ID,
		:new.PERSON_ID ,
 		:new.COMBATSERVICESOURCE_ID,
 		:new.COMBATSERVICELOCATION_ID,
        :new.STD_COMBATPAYTYPE_ID,
 		:new.COMBAT_PAY_START_DATE_TXT,
 		:new.COMBAT_PAY_END_DATE_TXT,
 		:new.RECORD_CREATED_BY,
 		:new.RECORD_CREATED_DATE,
 		:new.RECORD_MODIFIED_BY,
 		:new.RECORD_MODIFIED_DATE,
 		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end COMBAT_PAY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM COMBAT_PAY FOR ADR.COMBAT_PAY;


ALTER TABLE ADR.COMBAT_PAY ADD (
  CONSTRAINT CMBTPAY_PK
  PRIMARY KEY
  (COMBAT_PAY_ID)
  USING INDEX ADR.CMBTPAY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COMBAT_PAY ADD (
  CONSTRAINT CMBTPAY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COMBAT_PAY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COMBAT_PAY TO ADR_RW;

GRANT SELECT ON ADR.COMBAT_PAY TO ES_R;

GRANT INSERT, SELECT ON ADR.COMBAT_PAY TO ES_RW;
ALTER TABLE ADR.PERMISSION_SET_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERMISSION_SET_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERMISSION_SET_H
(
  PERMISSION_SET_H_ID    NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  PERMISSION_SET_ID      NUMBER(20)             NOT NULL,
  NAME                   VARCHAR2(100 BYTE)     NOT NULL,
  DESCRIPTION            VARCHAR2(250 BYTE),
  ACTIVE_DATE            DATE,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERMISSION_SET_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.PERMISSION_SET_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PERMSETH_PK ON ADR.PERMISSION_SET_H
(PERMISSION_SET_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERMISSION_SET_H FOR ADR.PERMISSION_SET_H;


ALTER TABLE ADR.PERMISSION_SET_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_036
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PERMSETH_PK
  PRIMARY KEY
  (PERMISSION_SET_H_ID)
  USING INDEX ADR.PERMSETH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERMISSION_SET_H TO ADR_R;

GRANT SELECT ON ADR.PERMISSION_SET_H TO ADR_RW;

GRANT SELECT ON ADR.PERMISSION_SET_H TO CARUSR_R;

GRANT SELECT ON ADR.PERMISSION_SET_H TO ES_R;

GRANT INSERT, SELECT ON ADR.PERMISSION_SET_H TO ES_RW;
ALTER TABLE ADR.USER_PERMISSION_SETS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_PERMISSION_SETS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_PERMISSION_SETS_H
(
  USER_PERMISSION_SET_H_ID  NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  USER_PERMISSION_SET_ID    NUMBER(20)          NOT NULL,
  USERID                    NUMBER(20)          NOT NULL,
  PERMISSION_SET_ID         NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_PERMISSION_SETS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.USER_PERMISSION_SET_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.USER_PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USRPERMSTH_PK ON ADR.USER_PERMISSION_SETS_H
(USER_PERMISSION_SET_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USER_PERMISSION_SETS_H FOR ADR.USER_PERMISSION_SETS_H;


ALTER TABLE ADR.USER_PERMISSION_SETS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_037
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USRPERMSTH_PK
  PRIMARY KEY
  (USER_PERMISSION_SET_H_ID)
  USING INDEX ADR.USRPERMSTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_PERMISSION_SETS_H TO ADR_R;

GRANT SELECT ON ADR.USER_PERMISSION_SETS_H TO ADR_RW;
ALTER TABLE ADR.INELIGIBLE_RULING_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.INELIGIBLE_RULING_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.INELIGIBLE_RULING_H
(
  INELIGIBLE_RULING_H_ID  NUMBER(20)            NOT NULL,
  TRANSACTION_TYPE_CODE   VARCHAR2(1 BYTE)      NOT NULL,
  INELIGIBLE_RULING_ID    NUMBER(20)            NOT NULL,
  PERSON_ID               NUMBER(20)            NOT NULL,
  STD_INSTITUTION_ID      NUMBER(20),
  INELIGIBLE_DATE         DATE,
  INELIGIBLE_REASON_TEXT  VARCHAR2(250 BYTE),
  VARO_DECISION_TEXT      VARCHAR2(250 BYTE),
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.INELIGIBLE_RULING_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.INELIGIBLE_RULING_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.INELIGIBLE_RULING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.VARO_DECISION_TEXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.INELIGIBLE_RULING_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.INELIGBRLH_PK ON ADR.INELIGIBLE_RULING_H
(INELIGIBLE_RULING_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.INELIGBRLH_PRSNID_NU_I ON ADR.INELIGIBLE_RULING_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM INELIGIBLE_RULING_H FOR ADR.INELIGIBLE_RULING_H;


ALTER TABLE ADR.INELIGIBLE_RULING_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_038
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT INELIGBRLH_PK
  PRIMARY KEY
  (INELIGIBLE_RULING_H_ID)
  USING INDEX ADR.INELIGBRLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.INELIGIBLE_RULING_H TO ADR_R;

GRANT SELECT ON ADR.INELIGIBLE_RULING_H TO ADR_RW;

GRANT SELECT ON ADR.INELIGIBLE_RULING_H TO ES_R;

GRANT INSERT, SELECT ON ADR.INELIGIBLE_RULING_H TO ES_RW;
ALTER TABLE ADR.ROLES
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLES CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLES
(
  ROLE_ID                NUMBER(20)             NOT NULL,
  ROLE_NAME              VARCHAR2(50 BYTE)      NOT NULL,
  DESCRIPTION            VARCHAR2(250 BYTE),
  SORT_ORDER             NUMBER(6)              DEFAULT 0,
  INACTIVE_FLAG          NUMBER(1)              DEFAULT 0                     NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL,
  ACTIVE_DATE            DATE
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLES IS 'The table is a application administration table that is used to designate a role for a particular user.';

COMMENT ON COLUMN ADR.ROLES.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLES.ROLE_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.DESCRIPTION IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.SORT_ORDER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLES.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLES.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLES.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLES.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ROLE_PK ON ADR.ROLES
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ROLE_U_CODE_UK ON ADR.ROLES
(ROLE_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ROLES_audir_trgr
after Update or Delete or Insert
ON ADR.ROLES
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ROLES_H
		(
		ROLES_H_ID,
		ROLE_ID,
		ROLE_NAME,
		DESCRIPTION,
		SORT_ORDER,
		ACTIVE_DATE,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLES_H_S.nextval,
		:old.ROLE_ID,
		:old.ROLE_NAME,
		:old.DESCRIPTION,
		:old.SORT_ORDER,
		:old.ACTIVE_DATE,
		:old.INACTIVE_FLAG,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ROLES_H
		(
		ROLES_H_ID,
		ROLE_ID,
		ROLE_NAME,
		DESCRIPTION,
		SORT_ORDER,
		ACTIVE_DATE,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLES_H_S.nextval,
		:new.ROLE_ID,
		:new.ROLE_NAME,
		:new.DESCRIPTION,
		:new.SORT_ORDER,
		:new.ACTIVE_DATE,
		:new.INACTIVE_FLAG,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ROLES_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ROLES FOR ADR.ROLES;


ALTER TABLE ADR.ROLES ADD (
  CONSTRAINT AVCON_1172521913_INACT_063
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT ROLE_PK
  PRIMARY KEY
  (ROLE_ID)
  USING INDEX ADR.ROLE_PK
  ENABLE VALIDATE,
  CONSTRAINT ROLE_U_CODE_UK
  UNIQUE (ROLE_NAME)
  USING INDEX ADR.ROLE_U_CODE_UK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLES TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ROLES TO ADR_RW;

GRANT SELECT ON ADR.ROLES TO CARUSR_R;

GRANT SELECT ON ADR.ROLES TO ES_R;

GRANT INSERT, SELECT ON ADR.ROLES TO ES_RW;

GRANT SELECT ON ADR.ROLES TO IAM_R;

GRANT SELECT ON ADR.ROLES TO IAM_RW;
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_ENROLLMENT_OVERRIDE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_ENROLLMENT_OVERRIDE
(
  RPT_ENROLLMENT_OVERRIDE_ID  NUMBER(20)        NOT NULL,
  RPT_SCHEDULED_REPORT_ID     NUMBER(20)        NOT NULL,
  STD_ENRLOVERRIDEREASON_ID   NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_ENROLLMENT_OVERRIDE IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RPT_ENROLLMENT_OVERRIDE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTENROVER_PK ON ADR.RPT_ENROLLMENT_OVERRIDE
(RPT_ENROLLMENT_OVERRIDE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENROVER_SCHEDRPT_FK_I ON ADR.RPT_ENROLLMENT_OVERRIDE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENROVER_STDENROVRD_FK_I ON ADR.RPT_ENROLLMENT_OVERRIDE
(STD_ENRLOVERRIDEREASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_ENROLLMENT_OVERRIDE FOR ADR.RPT_ENROLLMENT_OVERRIDE;


ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT RPTENROVER_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_OVERRIDE_ID)
  USING INDEX ADR.RPTENROVER_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT RPTENROVER_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_ENROLLMENT_OVERRIDE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ENROLLMENT_OVERRIDE TO ADR_RW;

GRANT SELECT ON ADR.RPT_ENROLLMENT_OVERRIDE TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_ENROLLMENT_OVERRIDE TO ES_RW;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ENROLLMENT_OVERRIDE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ENROLLMENT_OVERRIDE_H
(
  ENROLLMENT_OVERRIDE_H_ID      NUMBER(20)      NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL,
  ENROLLMENT_OVERRIDE_ID        NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20)      NOT NULL,
  STD_ENROLLMENTOVERRIDERSN_ID  NUMBER(20),
  OVERRIDE_FLAG                 NUMBER(1)       DEFAULT 0,
  OVERRIDE_DATE                 DATE,
  REMARKS                       VARCHAR2(80 BYTE),
  OVERRIDE_CREATED_USER         VARCHAR2(30 BYTE),
  OVERRIDE_CREATED_DATE         DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ENROLLMENT_OVERRIDE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.ENROLLMENT_OVERRIDE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.OVERRIDE_FLAG IS 'Flagusedtoindicate thatapersons enrollmenthasbeen overridden.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.OVERRIDE_DATE IS 'Dateonwhichapersons enrollmentwas overridden.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.OVERRIDE_CREATED_USER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.OVERRIDE_CREATED_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ENROLLMENT_OVERRIDE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ENROLOVERH_PK ON ADR.ENROLLMENT_OVERRIDE_H
(ENROLLMENT_OVERRIDE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ENROLOVERH_PRSNID_NU_I ON ADR.ENROLLMENT_OVERRIDE_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ENROLLMENT_OVERRIDE_H FOR ADR.ENROLLMENT_OVERRIDE_H;


ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_039
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT ENROLOVERH_PK
  PRIMARY KEY
  (ENROLLMENT_OVERRIDE_H_ID)
  USING INDEX ADR.ENROLOVERH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ADR_R;

GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ADR_RW;

GRANT SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ENROLLMENT_OVERRIDE_H TO ES_RW;
ALTER TABLE ADR.EMAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EMAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.EMAIL
(
  EMAIL_ID                     NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20),
  INSURANCE_ID                 NUMBER(20),
  EMAIL_TYPE_ID                NUMBER(20),
  EMAIL_CHANGE_SOURCE_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  EMAIL_ADDRESS                VARCHAR2(128 BYTE) NOT NULL,
  CHANGE_EFFECTIVE_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  RECORD_MODIFIED_SITE_ID      NUMBER(20),
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE),
  SITE_OF_CHANGE_ID            NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EMAIL IS 'The table contains email address(es) for a Person and also for an Insurance company Maintains all types of email addresses for Persons. Also stores Insurance Company email address. PERSON_ID Foreign key to the PERSON table. INSURANCE_ID Foreign key to the INSURANCE table. EMAIL_TYPE_ID Foreign key to the EMAIL_TYPE table. Indicates the type of email address (for example, Private, Business). DEMOGRAPHICS / ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.EMAIL.EMAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EMAIL.INSURANCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.EMAIL_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.EMAIL_CHANGE_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.EMAIL_ADDRESS IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EMAIL.CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof emailaddresswentinto effect.';

COMMENT ON COLUMN ADR.EMAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EMAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EMAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EMAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EMAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.EMAIL.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.EMAIL.SITE_OF_CHANGE_ID IS 'Foreign Key on ADR.LOOKUP_TYPE.LOOKUP_TYPE_ID';


CREATE INDEX ADR.EMAIL_INSURANCE_FK_I ON ADR.EMAIL
(INSURANCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EMAIL_PK ON ADR.EMAIL
(EMAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_PRSN_FK_I ON ADR.EMAIL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_SITECHNG_NU_I ON ADR.EMAIL
(SITE_OF_CHANGE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_STDINST2_FK_I ON ADR.EMAIL
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_STDINST_FK_I ON ADR.EMAIL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_STD_EMAILADDRTYP_FK_I ON ADR.EMAIL
(EMAIL_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EMAIL_STD_EMAILCHGSRC_FK_I ON ADR.EMAIL
(EMAIL_CHANGE_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EMAIL_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.EMAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EMAIL_H
		(
		EMAIL_H_ID,
		EMAIL_ID,
		PERSON_ID,
		INSURANCE_ID,
		EMAIL_TYPE_ID,
		EMAIL_ADDRESS,
		CHANGE_EFFECTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		STD_INSTITUTION_ID,
		EMAIL_CHANGE_SOURCE_TYPE_ID,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE,
		SITE_OF_CHANGE_ID
		)
		values
		(
		EMAIL_H_S.nextval,
		:old.EMAIL_ID,
		:old.PERSON_ID,
		:old.INSURANCE_ID,
		:old.EMAIL_TYPE_ID,
		:old.EMAIL_ADDRESS,
		:old.CHANGE_EFFECTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		:old.STD_INSTITUTION_ID,
		:old.EMAIL_CHANGE_SOURCE_TYPE_ID,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D',
		:old.SITE_OF_CHANGE_ID
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EMAIL_H
		(
		EMAIL_H_ID,
		EMAIL_ID,
		PERSON_ID,
		INSURANCE_ID,
		EMAIL_TYPE_ID,
		EMAIL_ADDRESS,
		CHANGE_EFFECTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		STD_INSTITUTION_ID,
		EMAIL_CHANGE_SOURCE_TYPE_ID,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE,
		SITE_OF_CHANGE_ID
		)
		values
		(
		EMAIL_H_S.nextval,
		:new.EMAIL_ID,
		:new.PERSON_ID,
		:new.INSURANCE_ID,
		:new.EMAIL_TYPE_ID,
		:new.EMAIL_ADDRESS,
		:new.CHANGE_EFFECTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		:new.STD_INSTITUTION_ID,
		:new.EMAIL_CHANGE_SOURCE_TYPE_ID,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML,
		:new.SITE_OF_CHANGE_ID
		);
	end if;

end EMAIL_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EMAIL FOR ADR.EMAIL;


ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_PK
  PRIMARY KEY
  (EMAIL_ID)
  USING INDEX ADR.EMAIL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT EMAIL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT EML_SITE_OF_CNG_FK 
  FOREIGN KEY (SITE_OF_CHANGE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EMAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EMAIL TO ADR_RW;

GRANT SELECT ON ADR.EMAIL TO ESCISSEEDINGUSR;

GRANT SELECT ON ADR.EMAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.EMAIL TO ES_RW;

GRANT SELECT ON ADR.EMAIL TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.EMAIL TO PSIM_ADR_RW;

GRANT SELECT ON ADR.EMAIL TO VET360USR;
ALTER TABLE ADR.RPT_MESSAGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_MESSAGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_MESSAGE
(
  RPT_MESSAGE_ID                NUMBER(20)      NOT NULL,
  RPT_SCHEDULED_REPORT_ID       NUMBER(20)      NOT NULL,
  MESSAGE_TRANSMISSION_TYPE_ID  NUMBER(20)      NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_MESSAGE IS 'ESR reporting table. Allows for reporting on the basis of various message transmission types, such as: AAC Communication Request to AAC EDB Financial Query to EDB EDB Communication Address Update to EDB EDB Communication Errors to EDB EDB Communication Rejects to EDB EDB Death to EDB EDB Demographic to EDB EDB Eligibility Solicited to EDB EDB Eligibility or Enrollment Query to EDB EDB Eligibility to EDB EDB Follow Up Insurance Data to EDB EDB Full Data Solicited to EDB EDB Full Data to EDB EDB IVM Billing or Collecting Data to EDB EDB Lazarus Death to EDB EDB MFA EGT Setting to EDB';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RPT_MESSAGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_MESSAGE.MESSAGE_TRANSMISSION_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTMSG_HL7TRANTYP_FK_I ON ADR.RPT_MESSAGE
(MESSAGE_TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTMSG_PK ON ADR.RPT_MESSAGE
(RPT_MESSAGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTMSG_SCHEDRPT_FK_I ON ADR.RPT_MESSAGE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_MESSAGE FOR ADR.RPT_MESSAGE;


ALTER TABLE ADR.RPT_MESSAGE ADD (
  CONSTRAINT RPTMSG_PK
  PRIMARY KEY
  (RPT_MESSAGE_ID)
  USING INDEX ADR.RPTMSG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_MESSAGE ADD (
  CONSTRAINT RPTMSG_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_MESSAGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_MESSAGE TO ADR_RW;

GRANT SELECT ON ADR.RPT_MESSAGE TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_MESSAGE TO ES_RW;
ALTER TABLE ADR.EGT_SETTING
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_SETTING CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_SETTING
(
  EGT_SETTING_ID              NUMBER(20)        NOT NULL,
  EGT_TYPE_ID                 NUMBER(20)        NOT NULL,
  PRIORITY_GROUP_TYPE_ID      NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID  NUMBER(20),
  REFERENCE_EGT_SETTING_ID    NUMBER(20),
  EGT_EFFECTIVE_DATE          DATE,
  FEDERAL_REGISTRY_DATE       DATE,
  CURRENT_EGT_FLAG            NUMBER(1)         DEFAULT 0                     NOT NULL,
  DISABLED_EGT_FLAG           NUMBER(1)         DEFAULT 0                     NOT NULL,
  REMARKS                     VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_SETTING IS 'Enrollment Global Threshold setting for beneficiaries The EGT_SETTING table stores a record for Enrollment Group Threshold (EGT) that is set. This threshold dictates what the cutoff point is for persons receiving care from the VHA. Any person in an enrollment priority group less than or equal to the EGT setting is eligible to enroll in the VHA system and receive care; any person in an enrollment priority group greater than the threshold will not be eligible for enrollment. EGT_TYPE_ID Foreign key to the EGT_TYPE table. Indicates the type of setting (for example, annual fiscal year, enrollment decision). PRIORITY_GROUP_TYPE_ID Foreign key to the PRIORITY_GROUP_TYPE table. Indicates the Enrollment Priority Group that has been set (Group 1 through Group 8). PRIORITY_SUB_GROUP_TYPE_ID Foreign key to the PRIORITY_SUB_GROUP_TYPE table. Indicates the Enrollment Priority Group that has been set (for example, a, c). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.EGT_SETTING.EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.EGT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.REFERENCE_EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.EGT_EFFECTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.FEDERAL_REGISTRY_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING.CURRENT_EGT_FLAG IS 'Flagusedtoindicate thatanEGTsettinghas beendisabled.DisabledIndicatoris usedifthisentrywas enteredinerror,this fieldshouldbeset.If theEGTthatthisrecord representsneedstobe disabledforanyreason (wrongEGTEffectDate, etcwasentered)thenthe EGTentryneedstobe disabled.Thiswill preventtheprocessingof alltheenrollment recordsfromtaking place.';

COMMENT ON COLUMN ADR.EGT_SETTING.DISABLED_EGT_FLAG IS 'Flagusedtoindicate thatanEGTsettinghas beendisabled.DisabledIndicatoris usedifthisentrywas enteredinerror,this fieldshouldbeset.If theEGTthatthisrecord representsneedstobe disabledforanyreason (wrongEGTEffectDate, etcwasentered)thenthe EGTentryneedstobe disabled.Thiswill preventtheprocessingof alltheenrollment recordsfromtaking place.';

COMMENT ON COLUMN ADR.EGT_SETTING.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_SETTING.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.EGTSETTING_EGTSETTING_FK_I ON ADR.EGT_SETTING
(REFERENCE_EGT_SETTING_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EGTSETTING_PK ON ADR.EGT_SETTING
(EGT_SETTING_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSETTING_STD_EGTTYP_FK_I ON ADR.EGT_SETTING
(EGT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSETTING_STD_ENRLPGRP_FK_I ON ADR.EGT_SETTING
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSETTING_STD_ENRLPSGRP_FK_I ON ADR.EGT_SETTING
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EGT_SETTING_audir_trgr
after Update or Delete or Insert
ON ADR.EGT_SETTING
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EGT_SETTING_H
		(
		EGT_SETTING_H_ID,
		EGT_SETTING_ID  ,
		EGT_TYPE_ID     ,
		PRIORITY_GROUP_TYPE_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		EGT_EFFECTIVE_DATE        ,
		FEDERAL_REGISTRY_DATE     ,
		REMARKS                   ,
		DISABLED_EGT_FLAG         ,
		CURRENT_EGT_FLAG,
		REFERENCE_EGT_SETTING_ID,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
      		)
		values
		(
		EGT_SETTING_H_s.nextval,
		:old.EGT_SETTING_ID,
		:old.EGT_TYPE_ID,
		:old.PRIORITY_GROUP_TYPE_ID,
		:old.PRIORITY_SUB_GROUP_TYPE_ID,
		:old.EGT_EFFECTIVE_DATE,
		:old.FEDERAL_REGISTRY_DATE,
		:old.REMARKS,
		:old.DISABLED_EGT_FLAG,
		:old.CURRENT_EGT_FLAG,
		:old.REFERENCE_EGT_SETTING_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EGT_SETTING_H
		(
		EGT_SETTING_H_ID,
		EGT_SETTING_ID  ,
		EGT_TYPE_ID     ,
		PRIORITY_GROUP_TYPE_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		EGT_EFFECTIVE_DATE        ,
		FEDERAL_REGISTRY_DATE     ,
		REMARKS                   ,
		DISABLED_EGT_FLAG         ,
		CURRENT_EGT_FLAG,
		REFERENCE_EGT_SETTING_ID,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		EGT_SETTING_H_s.nextval,
		:new.EGT_SETTING_ID,
		:new.EGT_TYPE_ID,
		:new.PRIORITY_GROUP_TYPE_ID,
		:new.PRIORITY_SUB_GROUP_TYPE_ID,
		:new.EGT_EFFECTIVE_DATE,
		:new.FEDERAL_REGISTRY_DATE,
		:new.REMARKS,
		:new.DISABLED_EGT_FLAG,
		:new.CURRENT_EGT_FLAG,
		:new.REFERENCE_EGT_SETTING_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  EGT_SETTING_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EGT_SETTING FOR ADR.EGT_SETTING;


ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT AVCON_1172521913_CURRE_000
  CHECK (CURRENT_EGT_FLAG BETWEEN 0 AND 0 OR CURRENT_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT AVCON_1172521913_DISAB_000
  CHECK (DISABLED_EGT_FLAG BETWEEN 0
AND 0 OR DISABLED_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT EGTSETTING_PK
  PRIMARY KEY
  (EGT_SETTING_ID)
  USING INDEX ADR.EGTSETTING_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT EGTSETTING_EGTSETTING_FK 
  FOREIGN KEY (REFERENCE_EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_SETTING TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EGT_SETTING TO ADR_RW;

GRANT SELECT ON ADR.EGT_SETTING TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_SETTING TO ES_RW;
ALTER TABLE ADR.WKF_MESSAGING_CASE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_MESSAGING_CASE CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_MESSAGING_CASE
(
  WKF_MESSAGING_CASE_ID         NUMBER(20)      NOT NULL,
  WKF_CASE_ID                   NUMBER(20)      NOT NULL,
  ACK_TYPE_ID                   NUMBER(20),
  HL7_MESSAGE_ID                VARCHAR2(50 BYTE),
  MESSAGE_TRANSMISSION_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID            NUMBER(20),
  TRANSMISSION_TYPE_CODE        VARCHAR2(50 BYTE),
  TRANSMISSION_DATE             DATE,
  ACK_DATE                      DATE,
  ERROR_MESSAGE_TEXT            VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_MESSAGING_CASE IS 'Stores information for a case associated with or initiated by an HL7 message. This requires permanent retention (due to potential future adjudication) of information critical to the case. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.WKF_MESSAGING_CASE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.ACK_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.HL7_MESSAGE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.MESSAGE_TRANSMISSION_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.TRANSMISSION_TYPE_CODE IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.TRANSMISSION_DATE IS 'BR2216Thedate/timethe transmissionwasmadeto thissiteorreceived fromthissite.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.ACK_DATE IS 'BR2228TheACKdate/time isdefinedasthedate andtimeHECreceivedthe ACKonoutboundmessages orthedate/timeHECsent theackoninbound messages.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.ERROR_MESSAGE_TEXT IS 'Additionaltextinfo associatedwiththe messageevent';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFMSGCS_PK ON ADR.WKF_MESSAGING_CASE
(WKF_MESSAGING_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFMSGCS_STDINST_FK_I ON ADR.WKF_MESSAGING_CASE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFMSGCS_STD_MSGTYP_FK_2_I ON ADR.WKF_MESSAGING_CASE
(ACK_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFMSGCS_STD_MSGTYP_FK_I ON ADR.WKF_MESSAGING_CASE
(MESSAGE_TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFMSGCS_WKFCASE_FK_I ON ADR.WKF_MESSAGING_CASE
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.wkf_msg_case_audir_trgr
after Update or Delete or Insert
ON ADR.WKF_MESSAGING_CASE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into WKF_MESSAGING_CASE_H
		(
		WKF_MESSAGING_CASE_H_ID,
		WKF_MESSAGING_CASE_ID,
		HL7_MESSAGE_ID,
		WKF_CASE_ID,
		MESSAGE_TRANSMISSION_TYPE_ID,
		ACK_TYPE_ID,
		STD_INSTITUTION_ID,
		TRANSMISSION_TYPE_CODE,
		TRANSMISSION_DATE,
		ACK_DATE,
		ERROR_MESSAGE_TEXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_MESSAGING_CASE_H_S.nextval,
		:old.WKF_MESSAGING_CASE_ID,
		:old.HL7_MESSAGE_ID,
		:old.WKF_CASE_ID,
		:old.MESSAGE_TRANSMISSION_TYPE_ID,
		:old.ACK_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.TRANSMISSION_TYPE_CODE,
		:old.TRANSMISSION_DATE,
		:old.ACK_DATE,
		:old.ERROR_MESSAGE_TEXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into WKF_MESSAGING_CASE_H
		(
		WKF_MESSAGING_CASE_H_ID,
		WKF_MESSAGING_CASE_ID,
		HL7_MESSAGE_ID,
		WKF_CASE_ID,
		MESSAGE_TRANSMISSION_TYPE_ID,
		ACK_TYPE_ID,
		STD_INSTITUTION_ID,
		TRANSMISSION_TYPE_CODE,
		TRANSMISSION_DATE,
		ACK_DATE,
		ERROR_MESSAGE_TEXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_MESSAGING_CASE_H_S.nextval,
		:new.WKF_MESSAGING_CASE_ID,
		:new.HL7_MESSAGE_ID,
		:new.WKF_CASE_ID,
		:new.MESSAGE_TRANSMISSION_TYPE_ID,
		:new.ACK_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.TRANSMISSION_TYPE_CODE,
		:new.TRANSMISSION_DATE,
		:new.ACK_DATE,
		:new.ERROR_MESSAGE_TEXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;
end wkf_msg_case_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_MESSAGING_CASE FOR ADR.WKF_MESSAGING_CASE;


ALTER TABLE ADR.WKF_MESSAGING_CASE ADD (
  CONSTRAINT WKFMSGCS_PK
  PRIMARY KEY
  (WKF_MESSAGING_CASE_ID)
  USING INDEX ADR.WKFMSGCS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_MESSAGING_CASE ADD (
  CONSTRAINT WKFMSGCS_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_MESSAGING_CASE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_MESSAGING_CASE TO ADR_RW;
ALTER TABLE ADR.USER_PERMISSIONS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_PERMISSIONS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_PERMISSIONS_H
(
  USER_PERMISSIONS_H_ID  NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  USER_PERMISSION_ID     NUMBER(20)             NOT NULL,
  USERID                 NUMBER(20)             NOT NULL,
  PERMISSION_TYPE_ID     NUMBER(20)             NOT NULL,
  ACTIVE_DATE            DATE,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_PERMISSIONS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.USER_PERMISSIONS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.USER_PERMISSION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USRPERMH_PK ON ADR.USER_PERMISSIONS_H
(USER_PERMISSIONS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USER_PERMISSIONS_H FOR ADR.USER_PERMISSIONS_H;


ALTER TABLE ADR.USER_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_044
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USRPERMH_PK
  PRIMARY KEY
  (USER_PERMISSIONS_H_ID)
  USING INDEX ADR.USRPERMH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_PERMISSIONS_H TO ADR_R;

GRANT SELECT ON ADR.USER_PERMISSIONS_H TO ADR_RW;

GRANT SELECT ON ADR.USER_PERMISSIONS_H TO CARUSR_R;
ALTER TABLE ADR.EGT_SETTING_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_SETTING_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_SETTING_H
(
  EGT_SETTING_H_ID            NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  EGT_SETTING_ID              NUMBER(20)        NOT NULL,
  EGT_TYPE_ID                 NUMBER(20)        NOT NULL,
  PRIORITY_GROUP_TYPE_ID      NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID  NUMBER(20),
  REFERENCE_EGT_SETTING_ID    NUMBER(20),
  EGT_EFFECTIVE_DATE          DATE,
  FEDERAL_REGISTRY_DATE       DATE,
  CURRENT_EGT_FLAG            NUMBER(1)         DEFAULT 0                     NOT NULL,
  DISABLED_EGT_FLAG           NUMBER(1)         DEFAULT 0                     NOT NULL,
  REMARKS                     VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_SETTING_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.EGT_SETTING_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.EGT_SETTING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.EGT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.REFERENCE_EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.EGT_EFFECTIVE_DATE IS 'DateonwhichtheEGT settingbecomes effective.TheEGTEffectiveDateis definedastheEffective DateforthisEGTtogo intoeffect.Itis referencedbythe determineenrollment businessrules.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.FEDERAL_REGISTRY_DATE IS 'FederalRegisterDate holdsthedatethatthe EGTchangewaspublished intheFederalRegister.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.CURRENT_EGT_FLAG IS 'Flagusedtoindicate thatanEGTsettinghas beendisabled.DisabledIndicatoris usedifthisentrywas enteredinerror,this fieldshouldbeset.If theEGTthatthisrecord representsneedstobe disabledforanyreason (wrongEGTEffectDate, etcwasentered)thenthe EGTentryneedstobe disabled.Thiswill preventtheprocessingof alltheenrollment recordsfromtaking place.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.DISABLED_EGT_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_SETTING_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EGTSETTINH_PK ON ADR.EGT_SETTING_H
(EGT_SETTING_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EGT_SETTING_H FOR ADR.EGT_SETTING_H;


ALTER TABLE ADR.EGT_SETTING_H ADD (
  CONSTRAINT AVCON_1172521913_CURRE_001
  CHECK (CURRENT_EGT_FLAG BETWEEN 0 AND 0 OR CURRENT_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT AVCON_1172521913_TRANS_045
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT EGTSETTINH_PK
  PRIMARY KEY
  (EGT_SETTING_H_ID)
  USING INDEX ADR.EGTSETTINH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_SETTING_H TO ADR_R;

GRANT SELECT ON ADR.EGT_SETTING_H TO ADR_RW;

GRANT SELECT ON ADR.EGT_SETTING_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_SETTING_H TO ES_RW;
ALTER TABLE ADR.EGT_STATISTICS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_STATISTICS CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_STATISTICS
(
  EGT_STATISTICS_ID               NUMBER(20)    NOT NULL,
  EGT_SETTING_ID                  NUMBER(20)    NOT NULL,
  EGT_STATUS_TYPE_ID              NUMBER(20),
  PROCESS_NUMBER                  VARCHAR2(20 BYTE),
  PROCESS_MESSAGE_DESCRIPTION     VARCHAR2(250 BYTE),
  PROCESS_START_DATE              DATE,
  PROCESS_END_DATE                DATE,
  IN_PROCESS_CATGRY_COUNT         NUMBER(10),
  ENROLLED_CATGRY_COUNT           NUMBER(10),
  BENEFICIARY_PROCESSED_COUNT     NUMBER(10),
  BENEFICIARY_NOT_ENROLLED_COUNT  NUMBER(10),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_STATISTICS IS 'Enrollment Global Threshold Statistics ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.EGT_STATISTICS.EGT_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.EGT_SETTING_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.PROCESS_START_DATE IS 'BR2312ProcessStarted Date/Time:Holdsthe date/timethatthe processtorecalculate theenrollmentstatuses basedonthenewEGT settingstarted.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.PROCESS_END_DATE IS 'BR2316ProcessEnded Date/Timeisthe Date/Timethatthe processtorecalculate theenrollmentstatuses basedonthenewEGT settingended.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.ENROLLED_CATGRY_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.BENEFICIARY_PROCESSED_COUNT IS 'BR2326TotalVETSIn Processisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryofIn Processasaresultof therecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.BENEFICIARY_NOT_ENROLLED_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_STATISTICS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.EGTSTAT_EGTSETTING_FK_I ON ADR.EGT_STATISTICS
(EGT_SETTING_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.EGTSTAT_PK ON ADR.EGT_STATISTICS
(EGT_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.EGTSTAT_STD_EGTPRCST_FK_I ON ADR.EGT_STATISTICS
(EGT_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.EGT_STATISTICS_audir_trgr
after Update or Delete or Insert
ON ADR.EGT_STATISTICS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EGT_STATISTICS_H
		(
		EGT_STATISTICS_H_ID,
		EGT_STATISTICS_ID,
		EGT_SETTING_ID,
		PROCESS_START_DATE,
		PROCESS_END_DATE,
		BENEFICIARY_PROCESSED_COUNT,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		PROCESS_NUMBER,
		PROCESS_MESSAGE_DESCRIPTION,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EGT_STATISTICS_H_S.nextval,
		:old.EGT_STATISTICS_ID,
		:old.EGT_SETTING_ID,
		:old.PROCESS_START_DATE,
		:old.PROCESS_END_DATE,
		:old.BENEFICIARY_PROCESSED_COUNT,
		:old.BENEFICIARY_NOT_ENROLLED_COUNT,
		:old.PROCESS_NUMBER,
		:old.PROCESS_MESSAGE_DESCRIPTION,
		:old.IN_PROCESS_CATGRY_COUNT,
		:old.ENROLLED_CATGRY_COUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EGT_STATISTICS_H
		(
		EGT_STATISTICS_H_ID,
		EGT_STATISTICS_ID,
		EGT_SETTING_ID,
		PROCESS_START_DATE,
		PROCESS_END_DATE,
		BENEFICIARY_PROCESSED_COUNT,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		PROCESS_NUMBER,
		PROCESS_MESSAGE_DESCRIPTION,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EGT_STATISTICS_H_S.nextval,
		:new.EGT_STATISTICS_ID,
		:new.EGT_SETTING_ID,
		:new.PROCESS_START_DATE,
		:new.PROCESS_END_DATE,
		:new.BENEFICIARY_PROCESSED_COUNT,
		:new.BENEFICIARY_NOT_ENROLLED_COUNT,
		:new.PROCESS_NUMBER,
		:new.PROCESS_MESSAGE_DESCRIPTION,
		:new.IN_PROCESS_CATGRY_COUNT,
		:new.ENROLLED_CATGRY_COUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end EGT_STATISTICS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM EGT_STATISTICS FOR ADR.EGT_STATISTICS;


ALTER TABLE ADR.EGT_STATISTICS ADD (
  CONSTRAINT EGTSTAT_PK
  PRIMARY KEY
  (EGT_STATISTICS_ID)
  USING INDEX ADR.EGTSTAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.EGT_STATISTICS ADD (
  CONSTRAINT EGTSTAT_EGTSETTING_FK 
  FOREIGN KEY (EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_STATISTICS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.EGT_STATISTICS TO ADR_RW;

GRANT SELECT ON ADR.EGT_STATISTICS TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_STATISTICS TO ES_RW;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.HEALTH_BENEFITS_APPLICATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.HEALTH_BENEFITS_APPLICATION
(
  HEALTH_BENEFITS_APPLICATION_ID  NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  APPLICATION_DATE                DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  STD_HEALTHBENEFITTYPE_ID        NUMBER(20),
  Z07_FROM_VISTA_IND              VARCHAR2(1 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.HEALTH_BENEFITS_APPLICATION IS 'Basic information about an application made for healthcare benefits. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.HEALTH_BENEFITS_APPLICATION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.STD_INSTITUTION_ID IS 'Site at which the application was made.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.APPLICATION_DATE IS 'BR2260Enrollment ApplicationDateis definedasthedateof theapplicationfor enrollment. Migrated and calculated for each veteran with an enrollment record.. ';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.STD_HEALTHBENEFITTYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.HEALTH_BENEFITS_APPLICATION.Z07_FROM_VISTA_IND IS 'Indicates whether or not the HL7 message for this person has come from VISTA - this is actually a derived value that is persisted in the database in order to save repeated queries on the huge HL7 log table';


CREATE UNIQUE INDEX ADR.HEALTHAPP_PK ON ADR.HEALTH_BENEFITS_APPLICATION
(HEALTH_BENEFITS_APPLICATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HEALTHAPP_PRSN_FK_I ON ADR.HEALTH_BENEFITS_APPLICATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HEALTHAPP_STDHEALTH_FK_I ON ADR.HEALTH_BENEFITS_APPLICATION
(STD_HEALTHBENEFITTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.HEALTHAPP_STDINST_FK_I ON ADR.HEALTH_BENEFITS_APPLICATION
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.HEALTH_BENF_APPLN_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.HEALTH_BENEFITS_APPLICATION for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into HEALTH_BENEFITS_APPLICATION_H
    (
    HEALTH_BENEFITS_APPLN_H_ID,
    HEALTH_BENEFITS_APPLICATION_ID,
    PERSON_ID,
    STD_INSTITUTION_ID,
    APPLICATION_DATE,
    STD_HEALTHBENEFITTYPE_ID,
    Z07_FROM_VISTA_IND,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE
        )
    values
    (
    HEALTH_BENEFITS_APP_H_S.nextval,
    :old.HEALTH_BENEFITS_APPLICATION_ID,
    :old.PERSON_ID,
    :old.STD_INSTITUTION_ID,
    :old.APPLICATION_DATE,
    :old.STD_HEALTHBENEFITTYPE_ID,
    :old.Z07_FROM_VISTA_IND,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.RECORD_MODIFIED_COUNT,
    'D'
    );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into HEALTH_BENEFITS_APPLICATION_H
    (
    HEALTH_BENEFITS_APPLN_H_ID,
    HEALTH_BENEFITS_APPLICATION_ID,
    PERSON_ID,
    STD_INSTITUTION_ID,
    APPLICATION_DATE,
    STD_HEALTHBENEFITTYPE_ID,
    Z07_FROM_VISTA_IND,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE
        )
    values
    (
    HEALTH_BENEFITS_APP_H_S.nextval,
    :new.HEALTH_BENEFITS_APPLICATION_ID,
    :new.PERSON_ID,
    :new.STD_INSTITUTION_ID,
    :new.APPLICATION_DATE,
    :new.STD_HEALTHBENEFITTYPE_ID,
    :new.Z07_FROM_VISTA_IND,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.RECORD_MODIFIED_COUNT,
    mDML
    );

  end if;

end  HEALTH_BENF_APPLN_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM HEALTH_BENEFITS_APPLICATION FOR ADR.HEALTH_BENEFITS_APPLICATION;


ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION ADD (
  CONSTRAINT HEALTHAPP_PK
  PRIMARY KEY
  (HEALTH_BENEFITS_APPLICATION_ID)
  USING INDEX ADR.HEALTHAPP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION ADD (
  CONSTRAINT HEALTHAPP_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ADREXT;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.HEALTH_BENEFITS_APPLICATION TO ADR_RW;

GRANT SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ES_R;

GRANT INSERT, SELECT ON ADR.HEALTH_BENEFITS_APPLICATION TO ES_RW;
ALTER TABLE ADR.CONFLICT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CONFLICT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.CONFLICT_DETAIL
(
  CONFLICT_DETAIL_ID      NUMBER(20)            NOT NULL,
  MILITARY_SERVICE_ID     NUMBER(20)            NOT NULL,
  STD_COMBATLOCATION_ID   NUMBER(20),
  CONFLICT_FROM_DATE_TXT  VARCHAR2(14 BYTE),
  CONFLICT_TO_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CONFLICT_DETAIL IS 'The table stores information about conflicts the person has been a part of during their military service. MILITARY_SERVICE_ID Foreign key to the MILITARY_SERVICE table. CONFLICT_LOCATION_TYPE_ID Foreign key to the CONFLICT_LOCATION_TYPE table. Indicates the particular conflict in which a person participated as part of his or her military service (for example, Korea, Vietnam). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.CONFLICT_DETAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.MILITARY_SERVICE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.CONFLICT_FROM_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.CONFLICT_TO_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CONFLICT_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CONFLDTL_MILSRVC_FK_I ON ADR.CONFLICT_DETAIL
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CONFLDTL_PK ON ADR.CONFLICT_DETAIL
(CONFLICT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CONFLDTL_STD_CMBTLOCN_FK_I ON ADR.CONFLICT_DETAIL
(STD_COMBATLOCATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CONFLICT_DETAIL_audir_trgr
after Update or Delete or Insert
ON ADR.CONFLICT_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CONFLICT_DETAIL_H
		(
		CONFLICT_DETAIL_H_ID ,
		CONFLICT_DETAIL_ID   ,
		MILITARY_SERVICE_ID  ,
		STD_COMBATLOCATION_ID,
		CONFLICT_FROM_DATE_TXT  ,
		CONFLICT_TO_DATE_TXT    ,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		CONFLICT_DETAIL_H_S.nextval,
		:old.CONFLICT_DETAIL_ID,
		:old.MILITARY_SERVICE_ID,
		:old.STD_COMBATLOCATION_ID,
		:old.CONFLICT_FROM_DATE_TXT,
		:old.CONFLICT_TO_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CONFLICT_DETAIL_H
		(
		CONFLICT_DETAIL_H_ID ,
		CONFLICT_DETAIL_ID   ,
		MILITARY_SERVICE_ID  ,
		STD_COMBATLOCATION_ID,
		CONFLICT_FROM_DATE_TXT  ,
		CONFLICT_TO_DATE_TXT    ,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		CONFLICT_DETAIL_H_S.nextval,
		:new.CONFLICT_DETAIL_ID,
		:new.MILITARY_SERVICE_ID,
		:new.STD_COMBATLOCATION_ID,
		:new.CONFLICT_FROM_DATE_TXT,
		:new.CONFLICT_TO_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  CONFLICT_DETAIL_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CONFLICT_DETAIL FOR ADR.CONFLICT_DETAIL;


ALTER TABLE ADR.CONFLICT_DETAIL ADD (
  CONSTRAINT CONFLDTL_PK
  PRIMARY KEY
  (CONFLICT_DETAIL_ID)
  USING INDEX ADR.CONFLDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CONFLICT_DETAIL ADD (
  CONSTRAINT CONFLDTL_MILSRVC_FK 
  FOREIGN KEY (MILITARY_SERVICE_ID) 
  REFERENCES ADR.MILITARY_SERVICE (MILITARY_SERVICE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.CONFLICT_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CONFLICT_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.CONFLICT_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.CONFLICT_DETAIL TO ES_RW;
ALTER TABLE ADR.ADR_DB_VER
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ADR_DB_VER CASCADE CONSTRAINTS;

CREATE TABLE ADR.ADR_DB_VER
(
  DB_VERSION      VARCHAR2(20 BYTE),
  DB_CREATE_DATE  DATE                          NOT NULL,
  ADR_DB_VER_ID   NUMBER(20)                    NOT NULL,
  ADR_CR          VARCHAR2(20 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ADR_DB_VER IS 'LOOKUP TABLE';


CREATE UNIQUE INDEX ADR.ADR_DBVER_CR_UK ON ADR.ADR_DB_VER
(ADR_CR)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ADR_DBVER_VERSION_UK ON ADR.ADR_DB_VER
(DB_VERSION, ADR_CR)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ADR_DB_VER FOR ADR.ADR_DB_VER;


ALTER TABLE ADR.ADR_DB_VER ADD (
  CONSTRAINT ADR_DBVER_PK
  PRIMARY KEY
  (ADR_DB_VER_ID)
  DISABLE NOVALIDATE,
  CONSTRAINT ADR_DBVER_CR_UK
  UNIQUE (ADR_CR)
  USING INDEX ADR.ADR_DBVER_CR_UK
  ENABLE VALIDATE,
  CONSTRAINT ADR_DBVER_VERSION_UK
  UNIQUE (DB_VERSION, ADR_CR)
  USING INDEX ADR.ADR_DBVER_VERSION_UK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ADR_DB_VER TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.ADR_DB_VER TO ADR_RW;

GRANT SELECT ON ADR.ADR_DB_VER TO ES_R;

GRANT INSERT, SELECT ON ADR.ADR_DB_VER TO ES_RW;

GRANT SELECT ON ADR.ADR_DB_VER TO PUBLIC;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_CONDITION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_CONDITION_H
(
  CAT_DSBLTY_CONDITION_H_ID   NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  CAT_DSBLTY_CONDITION_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  CONDITION_TYPE_ID           NUMBER(20)        NOT NULL,
  PRMNT_DSBLTY_STDYESNO_ID    NUMBER(20),
  DISABILITY_SCORE            NUMBER(3),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  PRMNT_DSBLTY_STDPERM_ID     NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_CONDITION_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.CAT_DSBLTY_CONDITION_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.CAT_DSBLTY_CONDITION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.CONDITION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.DISABILITY_SCORE IS 'BR3034Scoreisbasedon thefollowingand contingentonwhichCD conditionwasselected (FOLS,FIM,GAF,or KATZ).Eachonewill haveascoreassociated withit.FolsteinMini- MentalStateExamination (FOLS)isanumber between0-30,onthe Folstein.Mini-Mental StateExamination (MMSE).Functional IndependenceMeasure:The FIMcontains18measures in6domains.The13 MOTORITEMSarein4 domains:-self-care,- sphinctercontrol,- transfers,and- locomotion.Thevaluein thisfieldisbasedon thenumberofMOTORitems forwhichtheveteran receivedascoreof2or lower.FIMSScoreis0- 13.TheKatzIndexof ActivitiesofDaily Living(ADLs)assignsa numberfrom1to3in eachof6activities.1 isdependent,2isan intermediatelimitation, and3isindependent. TheKatzIndexmaybe usedtodeterminewhether aveteranis catastrophically disabled.Thisfieldmust containthenumberof permanentADLsforwhich theveteranreceiveda scoreof1(dependent). ItisNOTtheoverall scoreontheKATZtest (whichcanrangefrom0 to6.)GAFscoreisa numberbetween1and100.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSCONDH_CATDSBLTY_NU_I ON ADR.CAT_DSBLTY_CONDITION_H
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSCONDH_PK ON ADR.CAT_DSBLTY_CONDITION_H
(CAT_DSBLTY_CONDITION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_CONDITION_H FOR ADR.CAT_DSBLTY_CONDITION_H;


ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_047
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CATDSCONDH_PK
  PRIMARY KEY
  (CAT_DSBLTY_CONDITION_H_ID)
  USING INDEX ADR.CATDSCONDH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ADR_R;

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_CONDITION_H TO ES_RW;
ALTER TABLE ADR.COM_LETTER_TEMPLATE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_LETTER_TEMPLATE CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_LETTER_TEMPLATE
(
  COM_LETTER_TEMPLATE_ID        NUMBER(20)      NOT NULL,
  COM_LETTER_TYPE_ID            NUMBER(20)      NOT NULL,
  COM_LETTER_GENERATED_TYPE_ID  NUMBER(20),
  LETTER_TEMPLATE_NAME          VARCHAR2(100 BYTE),
  LETTER_TEMPLATE_DESCRIPTION   VARCHAR2(250 BYTE),
  LETTER_TEMPLATE_TEXT          VARCHAR2(4000 BYTE),
  LETTER_TEMPLATE_FORM_NUMBER   VARCHAR2(100 BYTE),
  LETTER_TEMPLATE_START_DATE    DATE,
  LETTER_TEMPLATE_END_DATE      DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_LETTER_TEMPLATE IS 'The table stores data for templates used to generate a particular type of letter. COM_LETTER_TYPE_ID Foreign key to the COM_LETTER_TYPE table. Indicates the general type of letter (for example, IVM, ENR). COM_LETTER_GENERATED_TYPE_ID Foreign key to the COM_LETTER_GENERATED_TYPE table. Indicates how a letter is generated (for example, manually or automatically).';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.COM_LETTER_TEMPLATE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.COM_LETTER_GENERATED_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_LETTER_TEMPLATE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.COMLTRTPL_PK ON ADR.COM_LETTER_TEMPLATE
(COM_LETTER_TEMPLATE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMLTRTPL_STD_COMLTRGTYPE_FK_I ON ADR.COM_LETTER_TEMPLATE
(COM_LETTER_GENERATED_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMLTRTPL_STD_COMLTRTYPE_FK_I ON ADR.COM_LETTER_TEMPLATE
(COM_LETTER_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_LETTER_TEMPLATE FOR ADR.COM_LETTER_TEMPLATE;


ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_PK
  PRIMARY KEY
  (COM_LETTER_TEMPLATE_ID)
  USING INDEX ADR.COMLTRTPL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_STD_COMLTRGTYPE_FK 
  FOREIGN KEY (COM_LETTER_GENERATED_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERGENTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT COMLTRTPL_STD_COMLTRTYPE_FK 
  FOREIGN KEY (COM_LETTER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_LETTER_TEMPLATE TO ADREXT;

GRANT SELECT ON ADR.COM_LETTER_TEMPLATE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_LETTER_TEMPLATE TO ADR_RW;

GRANT SELECT ON ADR.COM_LETTER_TEMPLATE TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_LETTER_TEMPLATE TO ES_RW;
ALTER TABLE ADR.ROLE_PERMISSIONS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLE_PERMISSIONS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLE_PERMISSIONS_H
(
  ROLE_PERMISSIONS_H_ID  NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  ROLE_PERMISSION_ID     NUMBER(20)             NOT NULL,
  ROLE_ID                NUMBER(20)             NOT NULL,
  PERMISSION_TYPE_ID     NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLE_PERMISSIONS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.ROLE_PERMISSIONS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.ROLE_PERMISSION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ROLEPRMSH_PK ON ADR.ROLE_PERMISSIONS_H
(ROLE_PERMISSIONS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ROLE_PERMISSIONS_H FOR ADR.ROLE_PERMISSIONS_H;


ALTER TABLE ADR.ROLE_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_048
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT ROLEPRMSH_PK
  PRIMARY KEY
  (ROLE_PERMISSIONS_H_ID)
  USING INDEX ADR.ROLEPRMSH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLE_PERMISSIONS_H TO ADR_R;

GRANT SELECT ON ADR.ROLE_PERMISSIONS_H TO ADR_RW;

GRANT SELECT ON ADR.ROLE_PERMISSIONS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ROLE_PERMISSIONS_H TO ES_RW;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_ASSIGNMENT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_ASSIGNMENT_H
(
  WKF_CASE_ASSIGNMENT_H_ID  NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  WKF_CASE_ASSIGNMENT_ID    NUMBER(20)          NOT NULL,
  WKF_CASE_ID               NUMBER(20),
  WKF_CASE_ASSIGNED_BY      VARCHAR2(30 BYTE),
  WKF_CASE_ASSIGNED_TO      VARCHAR2(30 BYTE),
  WKF_CASE_ASSIGNMENT_DATE  DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_ASSIGNMENT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.WKF_CASE_ASSIGNMENT_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.WKF_CASE_ASSIGNMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCSASGH_PK ON ADR.WKF_CASE_ASSIGNMENT_H
(WKF_CASE_ASSIGNMENT_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKF_CASE_ASSIGNMENT_H_FK_I ON ADR.WKF_CASE_ASSIGNMENT_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_ASSIGNMENT_H FOR ADR.WKF_CASE_ASSIGNMENT_H;


ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_049
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT WKFCSASGH_PK
  PRIMARY KEY
  (WKF_CASE_ASSIGNMENT_H_ID)
  USING INDEX ADR.WKFCSASGH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT_H TO ADR_R;

GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT_H TO ADR_RW;
ALTER TABLE ADR.COM_FORM_STATISTICS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_FORM_STATISTICS CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_FORM_STATISTICS
(
  COM_FORM_STATISTICS_ID          NUMBER(20)    NOT NULL,
  COM_TRANSMISSION_LOG_ID         NUMBER(20)    NOT NULL,
  FORM_NUMBER                     VARCHAR2(100 BYTE),
  FORM_NUMBER_ERROR_REASON_TEXT   VARCHAR2(4000 BYTE),
  FORM_NUMBER_REJECT_REASON_TEXT  VARCHAR2(4000 BYTE),
  FORM_NUMBER_RECORD_COUNT        NUMBER(10),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_FORM_STATISTICS IS 'Contains the statistics for letter mailings';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.COM_FORM_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.COM_TRANSMISSION_LOG_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_FORM_STATISTICS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMFRMSTAT_COMTRANLOG_FK_I ON ADR.COM_FORM_STATISTICS
(COM_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMFRMSTAT_PK ON ADR.COM_FORM_STATISTICS
(COM_FORM_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_FORM_STATISTICS FOR ADR.COM_FORM_STATISTICS;


ALTER TABLE ADR.COM_FORM_STATISTICS ADD (
  CONSTRAINT COMFRMSTAT_PK
  PRIMARY KEY
  (COM_FORM_STATISTICS_ID)
  USING INDEX ADR.COMFRMSTAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_FORM_STATISTICS ADD (
  CONSTRAINT COMFRMSTAT_COMTRANLOG_FK 
  FOREIGN KEY (COM_TRANSMISSION_LOG_ID) 
  REFERENCES ADR.COM_TRANSMISSION_LOG (COM_TRANSMISSION_LOG_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_FORM_STATISTICS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_FORM_STATISTICS TO ADR_RW;

GRANT SELECT ON ADR.COM_FORM_STATISTICS TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_FORM_STATISTICS TO ES_RW;
ALTER TABLE ADR.COM_CANCELED_REQUEST
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_CANCELED_REQUEST CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_CANCELED_REQUEST
(
  COM_CANCELED_REQUEST_ID  NUMBER(20)           NOT NULL,
  COM_MAILING_ID           NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_CANCELED_REQUEST IS 'The table stores data about cancelled export letter entries.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.COM_CANCELED_REQUEST_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.COM_MAILING_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_CANCELED_REQUEST.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.COMCNLPR_COMMAIL_FK_I ON ADR.COM_CANCELED_REQUEST
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMCNLPR_PK ON ADR.COM_CANCELED_REQUEST
(COM_CANCELED_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_CANCELED_REQUEST FOR ADR.COM_CANCELED_REQUEST;


ALTER TABLE ADR.COM_CANCELED_REQUEST ADD (
  CONSTRAINT COMCNLPR_PK
  PRIMARY KEY
  (COM_CANCELED_REQUEST_ID)
  USING INDEX ADR.COMCNLPR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.COM_CANCELED_REQUEST ADD (
  CONSTRAINT COMCNLPR_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.COM_CANCELED_REQUEST TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_CANCELED_REQUEST TO ADR_RW;

GRANT SELECT ON ADR.COM_CANCELED_REQUEST TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_CANCELED_REQUEST TO ES_RW;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IVM_MIGRATE_EXTRACT CASCADE CONSTRAINTS;

CREATE TABLE ADR.IVM_MIGRATE_EXTRACT
(
  IVM_MIGRATE_EXTRACT_ID  NUMBER(20)            NOT NULL,
  IVM_MIGRATE_TYPE_ID     NUMBER(20)            NOT NULL,
  EXTRACT_FILE_NAME       VARCHAR2(100 BYTE),
  EXTRACT_START_DATE      DATE,
  EXTRACT_END_DATE        DATE,
  EXTRACT_RECORD_COUNT    NUMBER(10),
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IVM_MIGRATE_EXTRACT IS 'For a brief period just after Deployment, the ADR database to be running in parallel with an EDB database that contains the IVM data. During this period, any deltas that occur in the ADR system after initial migration, will be stored in this table. Hence, this is a one-time, IVM migration related table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.IVM_MIGRATE_EXTRACT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.IVMMGEX_PK ON ADR.IVM_MIGRATE_EXTRACT
(IVM_MIGRATE_EXTRACT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IVMMGEX_STD_IVMMGRTYP_FK_I ON ADR.IVM_MIGRATE_EXTRACT
(IVM_MIGRATE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE_EXTRACT FOR ADR.IVM_MIGRATE_EXTRACT;


ALTER TABLE ADR.IVM_MIGRATE_EXTRACT ADD (
  CONSTRAINT IVMMGEX_PK
  PRIMARY KEY
  (IVM_MIGRATE_EXTRACT_ID)
  USING INDEX ADR.IVMMGEX_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_EXTRACT TO ADR_RW;

GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT TO ES_R;

GRANT INSERT, SELECT ON ADR.IVM_MIGRATE_EXTRACT TO ES_RW;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL
(
  IVM_MIGRATE_EXTRACT_DETAIL_ID  NUMBER(20)     NOT NULL,
  IVM_MIGRATE_EXTRACT_ID         NUMBER(20)     NOT NULL,
  INCOME_YEAR                    NUMBER(4),
  LEGACY_ICN                     VARCHAR2(30 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL IS 'For a brief period just after Deployment, the ADR database to be running in parallel with an EDB database that contains the IVM data. During this period, any deltas that occur in the ADR system after initial migration, will be stored in this table. Hence, this is a one-time, IVM migration related table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.IVM_MIGRATE_EXTRACT_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.IVM_MIGRATE_EXTRACT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.INCOME_YEAR IS 'Incomeyearforwhichthe visitsummaryinformation isbeingcollected.IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.IVMMGEXDTL_IVMMGEX_FK_I ON ADR.IVM_MIGRATE_EXTRACT_DETAIL
(IVM_MIGRATE_EXTRACT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.IVMMGEXDTL_PK ON ADR.IVM_MIGRATE_EXTRACT_DETAIL
(IVM_MIGRATE_EXTRACT_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE_EXTRACT_DETAIL FOR ADR.IVM_MIGRATE_EXTRACT_DETAIL;


ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL ADD (
  CONSTRAINT IVMMGEXDTL_PK
  PRIMARY KEY
  (IVM_MIGRATE_EXTRACT_DETAIL_ID)
  USING INDEX ADR.IVMMGEXDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL ADD (
  CONSTRAINT IVMMGEXDTL_IVMMGEX_FK 
  FOREIGN KEY (IVM_MIGRATE_EXTRACT_ID) 
  REFERENCES ADR.IVM_MIGRATE_EXTRACT (IVM_MIGRATE_EXTRACT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ES_RW;
ALTER TABLE ADR.PERSON_RACE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RACE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RACE
(
  PERSON_RACE_ID             NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_RACE_ID                NUMBER(20)         NOT NULL,
  COLLECTION_METHOD_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_RACE IS 'The table stores information a persons reported race and the method by which that information was reported. DEMOGRAPHICS';

COMMENT ON COLUMN ADR.PERSON_RACE.PERSON_RACE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RACE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RACE.STD_RACE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE.COLLECTION_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNRACE_PK ON ADR.PERSON_RACE
(PERSON_RACE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACE_PRSN_FK_I ON ADR.PERSON_RACE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACE_STDINST2_FK_I ON ADR.PERSON_RACE
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACE_STDRACE_FK_I ON ADR.PERSON_RACE
(STD_RACE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACE_STD_CLLNMTHD_FK_I ON ADR.PERSON_RACE
(COLLECTION_METHOD_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERSON_RACE_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_RACE for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into PERSON_RACE_H
    (
    PERSON_RACE_H_ID,
    PERSON_RACE_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_RACE_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_RACE_H_S.nextval,
    :old.PERSON_RACE_ID,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.STD_RACE_ID,
    :old.COLLECTION_METHOD_TYPE_ID,
    :old.PERSON_ID,
    :old.RECORD_MODIFIED_COUNT,
    :old.RECORD_MODIFIED_SITE_ID,
    :old.RECORD_MODIFIED_SRC_NAME,
    'D'
    );



  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into PERSON_RACE_H
    (
    PERSON_RACE_H_ID,
    PERSON_RACE_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_RACE_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_RACE_H_S.nextval,
    :new.PERSON_RACE_ID,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.STD_RACE_ID,
    :new.COLLECTION_METHOD_TYPE_ID,
    :new.PERSON_ID,
    :new.RECORD_MODIFIED_COUNT,
    :new.RECORD_MODIFIED_SITE_ID,
    :new.RECORD_MODIFIED_SRC_NAME,
    mDML
    );



  end if;

end PERSON_RACE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON_RACE FOR ADR.PERSON_RACE;


ALTER TABLE ADR.PERSON_RACE ADD (
  CONSTRAINT PRSNRACE_PK
  PRIMARY KEY
  (PERSON_RACE_ID)
  USING INDEX ADR.PRSNRACE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_RACE ADD (
  CONSTRAINT PRSNRACE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.PERSON_RACE TO ADREXT;

GRANT SELECT ON ADR.PERSON_RACE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RACE TO ADR_RW;

GRANT SELECT ON ADR.PERSON_RACE TO ES_R;

GRANT INSERT, SELECT ON ADR.PERSON_RACE TO ES_RW;

GRANT SELECT ON ADR.PERSON_RACE TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_RACE TO PSIM_ADR_RW;
ALTER TABLE ADR.RPT_USER_GROUP
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_USER_GROUP CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_USER_GROUP
(
  RPT_USER_GROUP_ID        NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  USER_GROUP_TYPE_ID       NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_USER_GROUP IS 'ESR reporting table. allows for reporting based on which group of users performed the query';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RPT_USER_GROUP_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.USER_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTUSRGRP_PK ON ADR.RPT_USER_GROUP
(RPT_USER_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTUSRGRP_SCHEDRPT_FK_I ON ADR.RPT_USER_GROUP
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTUSRGRP_USRGRPTYP_FK_I ON ADR.RPT_USER_GROUP
(USER_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_USER_GROUP FOR ADR.RPT_USER_GROUP;


ALTER TABLE ADR.RPT_USER_GROUP ADD (
  CONSTRAINT RPTUSRGRP_PK
  PRIMARY KEY
  (RPT_USER_GROUP_ID)
  USING INDEX ADR.RPTUSRGRP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_USER_GROUP ADD (
  CONSTRAINT RPTUSRGRP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_USER_GROUP TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_USER_GROUP TO ADR_RW;

GRANT SELECT ON ADR.RPT_USER_GROUP TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_USER_GROUP TO ES_RW;
ALTER TABLE ADR.PH_REGISTRY_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PH_REGISTRY_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.PH_REGISTRY_DETAIL
(
  PH_REGISTRY_DETAIL_ID        NUMBER(20)       NOT NULL,
  PURPLE_HEART_REGISTRY_ID     NUMBER(20)       NOT NULL,
  PH_DOCUMENT_TYPE_ID          NUMBER(20),
  PH_DATA_SOURCE_TYPE_ID       NUMBER(20),
  PH_DOCUMENT_RECEIVED_DATE    DATE,
  PH_DOCUMENT_LOGIN_DATE       DATE,
  PH_DOCUMENT_LOGIN_USERNAME   VARCHAR2(30 BYTE),
  PH_DOCUMENT_ACCEPTABLE_IND   VARCHAR2(1 BYTE),
  PH_DOC_UNACCEPTABLE_REMARKS  VARCHAR2(2000 BYTE),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PH_REGISTRY_DETAIL IS 'Contains details about a Purple Heart Registry Such as when PH documentation was received, when and who logged it in to the system.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PURPLE_HEART_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DATA_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_RECEIVED_DATE IS 'BR2352DateDocument Receivedisdefinedasis thedatetheHECreceived PHdocumentationfroma siteoraveteranor veteranrepresentative. Acceptableentriesare: thecurrentdaysdateor oneinthepastbutNOTa futuredate.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_LOGIN_DATE IS 'DatethePHDocumentation wasenteredintothe system';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_LOGIN_USERNAME IS 'Nameofuserwhokeyedin PHDocumentationintothe system';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_ACCEPTABLE_IND IS 'BR2358Document AcceptableIndicatoris definedasthevalueof YESorNOifthedocument receivedfromasiteor theveteranhasmetthe criteriadefinedinthe VHADirective.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOC_UNACCEPTABLE_REMARKS IS 'BR2361Unacceptable Remarksisdefinedasis afreetextfieldthat allowstheuserto commentonwhyadocument wasunacceptableafter theyhavesentaPH630A letter.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PHREGDTL_PK ON ADR.PH_REGISTRY_DETAIL
(PH_REGISTRY_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHREGDTL_PRPLHRTREG_FK_I ON ADR.PH_REGISTRY_DETAIL
(PURPLE_HEART_REGISTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHREGDTL_STD_DCRNDOCTYP_FK_I ON ADR.PH_REGISTRY_DETAIL
(PH_DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHREGDTL_STD_PHDATASRC_FK_I ON ADR.PH_REGISTRY_DETAIL
(PH_DATA_SOURCE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PH_REGISTRY_DET_audir_trgr
after Update or Delete or Insert
ON ADR.PH_REGISTRY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PH_REGISTRY_DETAIL_H
		(
  		 PH_REGISTRY_DETAIL_H_ID,
 		 PH_REGISTRY_DETAIL_ID,
 		 PH_DOCUMENT_TYPE_ID,
		 PURPLE_HEART_REGISTRY_ID,
		 PH_DATA_SOURCE_TYPE_ID,
 		 PH_DOCUMENT_RECEIVED_DATE,
 		 PH_DOCUMENT_LOGIN_DATE,
 		 PH_DOCUMENT_LOGIN_USERNAME,
 		 PH_DOCUMENT_ACCEPTABLE_IND,
 		 PH_DOC_UNACCEPTABLE_REMARKS,
 		 RECORD_CREATED_BY,
 		 RECORD_CREATED_DATE,
 		 RECORD_MODIFIED_BY,
 		 RECORD_MODIFIED_DATE,
 		 RECORD_MODIFIED_COUNT,
		 TRANSACTION_TYPE_CODE
		)
		values
		(
		PH_REGISTRY_DETAIL_H_S.nextval,
		:old.PH_REGISTRY_DETAIL_ID,
		:old.PH_DOCUMENT_TYPE_ID,
		:old.PURPLE_HEART_REGISTRY_ID,
		:old.PH_DATA_SOURCE_TYPE_ID,
		:old.PH_DOCUMENT_RECEIVED_DATE,
		:old.PH_DOCUMENT_LOGIN_DATE,
		:old.PH_DOCUMENT_LOGIN_USERNAME,
		:old.PH_DOCUMENT_ACCEPTABLE_IND,
		:old.PH_DOC_UNACCEPTABLE_REMARKS,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PH_REGISTRY_DETAIL_H
		(
  		 PH_REGISTRY_DETAIL_H_ID,
 		 PH_REGISTRY_DETAIL_ID,
 		 PH_DOCUMENT_TYPE_ID,
		 PURPLE_HEART_REGISTRY_ID,
		 PH_DATA_SOURCE_TYPE_ID,
 		 PH_DOCUMENT_RECEIVED_DATE,
 		 PH_DOCUMENT_LOGIN_DATE,
 		 PH_DOCUMENT_LOGIN_USERNAME,
 		 PH_DOCUMENT_ACCEPTABLE_IND,
 		 PH_DOC_UNACCEPTABLE_REMARKS,
 		 RECORD_CREATED_BY,
 		 RECORD_CREATED_DATE,
 		 RECORD_MODIFIED_BY,
 		 RECORD_MODIFIED_DATE,
 		 RECORD_MODIFIED_COUNT,
		 TRANSACTION_TYPE_CODE
		)
		values
		(
		PH_REGISTRY_DETAIL_H_S.nextval,
		:new.PH_REGISTRY_DETAIL_ID,
		:new.PH_DOCUMENT_TYPE_ID,
		:new.PURPLE_HEART_REGISTRY_ID,
		:new.PH_DATA_SOURCE_TYPE_ID,
		:new.PH_DOCUMENT_RECEIVED_DATE,
		:new.PH_DOCUMENT_LOGIN_DATE,
		:new.PH_DOCUMENT_LOGIN_USERNAME,
		:new.PH_DOCUMENT_ACCEPTABLE_IND,
		:new.PH_DOC_UNACCEPTABLE_REMARKS,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PH_REGISTRY_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PH_REGISTRY_DETAIL FOR ADR.PH_REGISTRY_DETAIL;


ALTER TABLE ADR.PH_REGISTRY_DETAIL ADD (
  CONSTRAINT PHREGDTL_PK
  PRIMARY KEY
  (PH_REGISTRY_DETAIL_ID)
  USING INDEX ADR.PHREGDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PH_REGISTRY_DETAIL ADD (
  CONSTRAINT PHREGDTL_PRPLHRTREG_FK 
  FOREIGN KEY (PURPLE_HEART_REGISTRY_ID) 
  REFERENCES ADR.PURPLE_HEART_REGISTRY (PURPLE_HEART_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PH_REGISTRY_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PH_REGISTRY_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.PH_REGISTRY_DETAIL TO ES_R;

GRANT INSERT, SELECT ON ADR.PH_REGISTRY_DETAIL TO ES_RW;
ALTER TABLE ADR.ROLES_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLES_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLES_H
(
  ROLES_H_ID             NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  ROLE_ID                NUMBER(20)             NOT NULL,
  ROLE_NAME              VARCHAR2(50 BYTE)      NOT NULL,
  DESCRIPTION            VARCHAR2(250 BYTE),
  SORT_ORDER             NUMBER(6)              DEFAULT 0,
  INACTIVE_FLAG          NUMBER(1)              DEFAULT 0                     NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL,
  ACTIVE_DATE            DATE
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLES_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ROLES_H.ROLES_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ROLES_H.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLES_H.ROLE_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES_H.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ROLESH_PK ON ADR.ROLES_H
(ROLES_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ROLES_H FOR ADR.ROLES_H;


ALTER TABLE ADR.ROLES_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_050
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT ROLESH_PK
  PRIMARY KEY
  (ROLES_H_ID)
  USING INDEX ADR.ROLESH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLES_H TO ADR_R;

GRANT SELECT ON ADR.ROLES_H TO ADR_RW;

GRANT SELECT ON ADR.ROLES_H TO CARUSR_R;

GRANT SELECT ON ADR.ROLES_H TO ES_R;

GRANT INSERT, SELECT ON ADR.ROLES_H TO ES_RW;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.EGT_SITE_STATISTICS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.EGT_SITE_STATISTICS_H
(
  EGT_SITE_STATISTICS_H_ID        NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  EGT_SITE_STATISTICS_ID          NUMBER(20)    NOT NULL,
  EGT_STATISTICS_ID               NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  IN_PROCESS_CATGRY_COUNT         NUMBER(10),
  BENEFICIARY_PROCESSED_COUNT     NUMBER(10),
  BENEFICIARY_NOT_ENROLLED_COUNT  NUMBER(10),
  ENROLLED_CATGRY_COUNT           NUMBER(10),
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.EGT_SITE_STATISTICS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.EGT_SITE_STATISTICS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.EGT_SITE_STATISTICS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.EGT_STATISTICS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.BENEFICIARY_PROCESSED_COUNT IS 'BR2326TotalVETSIn Processisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryofIn Processasaresultof therecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.BENEFICIARY_NOT_ENROLLED_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.ENROLLED_CATGRY_COUNT IS 'BR2324TotalVETSNot Enrolledisthetotal numberofveteranrecords thatweresettothe EnrollmentCategoryof NOTENROLLEDasaresult oftherecalculationof enrollmentstatusesbased onachangetotheEGT settings.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.EGT_SITE_STATISTICS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.EGTSTSTICH_PK ON ADR.EGT_SITE_STATISTICS_H
(EGT_SITE_STATISTICS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM EGT_SITE_STATISTICS_H FOR ADR.EGT_SITE_STATISTICS_H;


ALTER TABLE ADR.EGT_SITE_STATISTICS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_051
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT EGTSTSTICH_PK
  PRIMARY KEY
  (EGT_SITE_STATISTICS_H_ID)
  USING INDEX ADR.EGTSTSTICH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H TO ADR_R;

GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H TO ADR_RW;

GRANT SELECT ON ADR.EGT_SITE_STATISTICS_H TO ES_R;

GRANT INSERT, SELECT ON ADR.EGT_SITE_STATISTICS_H TO ES_RW;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SITE_RECEIVED_ENROLLMENT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SITE_RECEIVED_ENROLLMENT_H
(
  SITE_RECEIVED_ENROLLMENT_H_ID  NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  SITE_RECEIVED_ENROLLMENT_ID    NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  STD_ENROLLMENTSTATUS_ID        NUMBER(20),
  ENROLLMENT_DATA_SRC_TYPE_ID    NUMBER(20),
  PRIORITY_GROUP_TYPE_ID         NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  ENROLLMENT_START_DATE          DATE,
  ENROLLMENT_END_DATE            DATE,
  ENROLLMENT_CHANGE_EFCTV_DATE   DATE,
  OVERRIDE_IND                   NUMBER(1),
  REMARKS                        VARCHAR2(200 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SITE_RECEIVED_ENROLLMENT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.SITE_RECEIVED_ENROLLMENT_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.SITE_RECEIVED_ENROLLMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.ENROLLMENT_DATA_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.ENROLLMENT_START_DATE IS 'BR2240EnrollmentDateis definedashestarting dateforthisenrollment.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.ENROLLMENT_END_DATE IS 'BR7771Theenrollmentend dateisdefinedasthe enddateofthispersons enrollment.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.OVERRIDE_IND IS 'Whenanactormanually RemailsorMailsaletter andtheconditionsto sendtheletteras identifiedintheLetter DecisionTablesandthe Supplementary Specificationsarenot metthesystemdisplays thismessagetotheactor Theletterhas failedtomeetthe conditionstosendthe letter.Thecondition thatfailedisinsert LetterCriterianotmet ORtheHECReject Reason.Doyouwantto overridethiscondition andsendtheletter?';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SITERECENH_PK ON ADR.SITE_RECEIVED_ENROLLMENT_H
(SITE_RECEIVED_ENROLLMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERECENH_PRSNID_NU_I ON ADR.SITE_RECEIVED_ENROLLMENT_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SITE_RECEIVED_ENROLLMENT_H FOR ADR.SITE_RECEIVED_ENROLLMENT_H;


ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_052
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT SITERECENH_PK
  PRIMARY KEY
  (SITE_RECEIVED_ENROLLMENT_H_ID)
  USING INDEX ADR.SITERECENH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT_H TO ADR_R;

GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT_H TO ADR_RW;

GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT_H TO ES_R;

GRANT INSERT, SELECT ON ADR.SITE_RECEIVED_ENROLLMENT_H TO ES_RW;
ALTER TABLE ADR.RPT_MESSAGE_ERROR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_MESSAGE_ERROR CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_MESSAGE_ERROR
(
  RPT_MESSAGE_ERROR_ID     NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  ACK_TYPE_ID              NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_MESSAGE_ERROR IS 'ESR reporting table. Allows reporting on the basis of various HL7 acknowledgement codes such as: Accept Commit Accept Commit Error Commit Reject Error Reject';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RPT_MESSAGE_ERROR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.ACK_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTMSGERR_PK ON ADR.RPT_MESSAGE_ERROR
(RPT_MESSAGE_ERROR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTMSGERR_SCHEDRPT_FK_I ON ADR.RPT_MESSAGE_ERROR
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTMSGERR_STD_MSGTYP_FK_I ON ADR.RPT_MESSAGE_ERROR
(ACK_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_MESSAGE_ERROR FOR ADR.RPT_MESSAGE_ERROR;


ALTER TABLE ADR.RPT_MESSAGE_ERROR ADD (
  CONSTRAINT RPTMSGERR_PK
  PRIMARY KEY
  (RPT_MESSAGE_ERROR_ID)
  USING INDEX ADR.RPTMSGERR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_MESSAGE_ERROR ADD (
  CONSTRAINT RPTMSGERR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_MESSAGE_ERROR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_MESSAGE_ERROR TO ADR_RW;

GRANT SELECT ON ADR.RPT_MESSAGE_ERROR TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_MESSAGE_ERROR TO ES_RW;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_VBA_QUERY_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_VBA_QUERY_STATUS
(
  RPT_VBA_QUERY_STATUS_ID   NUMBER(20)          NOT NULL,
  RPT_SCHEDULED_REPORT_ID   NUMBER(20)          NOT NULL,
  VBA_QUERY_STATUS_TYPE_ID  NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_VBA_QUERY_STATUS IS 'ESR reporting table. Allows for reporting based on each of the VBA query status types, such as: No VBA Data on File VBA Data Auto-upload VBA Data Pending Rev VBA Data Manually Ac VBA Data Rejected VBA Query Initiated VBA Queried - Pending VBA Data Inconclusive Unsolicited Change O Unsolicited Eligible Unsolicited Lazarus';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RPT_VBA_QUERY_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.VBA_QUERY_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTVBAQRY_PK ON ADR.RPT_VBA_QUERY_STATUS
(RPT_VBA_QUERY_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTVBAQRY_SCHEDRPT_FK_I ON ADR.RPT_VBA_QUERY_STATUS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTVBAQRY_STD_VBAQURYST_FK_I ON ADR.RPT_VBA_QUERY_STATUS
(VBA_QUERY_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_VBA_QUERY_STATUS FOR ADR.RPT_VBA_QUERY_STATUS;


ALTER TABLE ADR.RPT_VBA_QUERY_STATUS ADD (
  CONSTRAINT RPTVBAQRY_PK
  PRIMARY KEY
  (RPT_VBA_QUERY_STATUS_ID)
  USING INDEX ADR.RPTVBAQRY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS ADD (
  CONSTRAINT RPTVBAQRY_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_VBA_QUERY_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_VBA_QUERY_STATUS TO ADR_RW;

GRANT SELECT ON ADR.RPT_VBA_QUERY_STATUS TO ES_R;

GRANT INSERT, SELECT ON ADR.RPT_VBA_QUERY_STATUS TO ES_RW;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_ASSIGNMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_ASSIGNMENT
(
  WKF_CASE_ASSIGNMENT_ID    NUMBER(20)          NOT NULL,
  WKF_CASE_ID               NUMBER(20),
  WKF_CASE_ASSIGNED_BY      VARCHAR2(30 BYTE),
  WKF_CASE_ASSIGNED_TO      VARCHAR2(30 BYTE),
  WKF_CASE_ASSIGNMENT_DATE  DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_ASSIGNMENT IS 'The table stores data about the user assigned to a particular workflow case. Each Workflow case can be assigned or re-assigned to users in the system. This table keeps a record of all case assignments. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.WKF_CASE_ASSIGNMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCSASGMT_PK ON ADR.WKF_CASE_ASSIGNMENT
(WKF_CASE_ASSIGNMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSASGMT_WKFCASE_FK_I ON ADR.WKF_CASE_ASSIGNMENT
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_ASSGN_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE_ASSIGNMENT for each row
declare
   	mDML char(1);
begin

	if DELETING then
	     insert into WKF_CASE_ASSIGNMENT_H
		(
		WKF_CASE_ASSIGNMENT_H_ID,
		WKF_CASE_ASSIGNMENT_ID,
		WKF_CASE_ID,
		WKF_CASE_ASSIGNED_BY,
		WKF_CASE_ASSIGNED_TO,
		WKF_CASE_ASSIGNMENT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_ASSIGNMENT_H_S.nextval  ,
		:old.WKF_CASE_ASSIGNMENT_ID,
		:old.WKF_CASE_ID,
		:old.WKF_CASE_ASSIGNED_BY,
		:old.WKF_CASE_ASSIGNED_TO,
		:old.WKF_CASE_ASSIGNMENT_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

	     insert into WKF_CASE_ASSIGNMENT_H
		(
		WKF_CASE_ASSIGNMENT_H_ID,
		WKF_CASE_ASSIGNMENT_ID,
		WKF_CASE_ID,
		WKF_CASE_ASSIGNED_BY,
		WKF_CASE_ASSIGNED_TO,
		WKF_CASE_ASSIGNMENT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_ASSIGNMENT_H_S.nextval  ,
		:new.WKF_CASE_ASSIGNMENT_ID,
		:new.WKF_CASE_ID,
		:new.WKF_CASE_ASSIGNED_BY,
		:new.WKF_CASE_ASSIGNED_TO,
		:new.WKF_CASE_ASSIGNMENT_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

End WKF_CASE_ASSGN_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_ASSIGNMENT FOR ADR.WKF_CASE_ASSIGNMENT;


ALTER TABLE ADR.WKF_CASE_ASSIGNMENT ADD (
  CONSTRAINT WKFCSASGMT_PK
  PRIMARY KEY
  (WKF_CASE_ASSIGNMENT_ID)
  USING INDEX ADR.WKFCSASGMT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT ADD (
  CONSTRAINT WKFCSASGMT_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE_ASSIGNMENT TO ADR_RW;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CATASTROPHIC_DISABILITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.CATASTROPHIC_DISABILITY
(
  CATASTROPHIC_DISABILITY_ID      NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  CAT_DSBLTY_EVAL_MTHD_TYPE_ID    NUMBER(20),
  STD_INSTITUTION_ID              NUMBER(20),
  CATASTROPHICALLY_DISABLED_IND   VARCHAR2(1 BYTE),
  CLINICAL_APPROVER_NAME          VARCHAR2(100 BYTE),
  CAT_DSBLTY_EVALUATION_DATE      DATE,
  DECISION_DATE                   DATE,
  CAT_DSBLTY_REVIEW_REQUESTED_DT  DATE,
  CAT_DSBLTY_REVIEW_INITIATED_DT  DATE,
  CAT_DSBLTY_REVIEW_NOTIFIED_DT   DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CATASTROPHIC_DISABILITY IS 'The CATASTROPHIC_DISABILITY table shows that a person has been clinically determined to have a disability severe enough to be called catastrophic. The table includes the site at which the determination was made, the verification date and method. It also includes information about any reviews of this determination have taken place. PERSON_ID Foreign key to the PERSON table. Indicates the person who has been clinically determined to have a catastrophic disability. CAT_DSBLTY_EVAL_MTHD_TYPE_ID Foreign key to the CAT_DSBLTY_EVAL_MTHD_TYPE table. Indicates how the evaluation was done (for example, automated record review, physical examination). STD_INSTITUTION_ID Site at which the catastrophic disability determination was made. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_EVAL_MTHD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CATASTROPHICALLY_DISABLED_IND IS 'NULL =  no CD data
  2  `0 = no letter sent
  3  `1 = letter sent	';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CLINICAL_APPROVER_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_EVALUATION_DATE IS 'Reviewdateisdefinedas thedateofthe CatastrophicallyDisabled evaluation.Eitherby medicalrecordorby physicalexam.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.DECISION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_REVIEW_REQUESTED_DT IS 'Dateonwhicharequest toreviewapersons catastrophicdisability determinationwas received';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_REVIEW_INITIATED_DT IS 'Dateonwhich catastrophicdisability reviewwasinitiatedby theChiefofStaffor his/herdesignee.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.CAT_DSBLTY_REVIEW_NOTIFIED_DT IS 'Dateonwhichthe affectedpersonwas notifiedaboutthe resultsofthereview.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CATASTROPHIC_DISABILITY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CATDSBLTY_PK ON ADR.CATASTROPHIC_DISABILITY
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLTY_PRSN_FK_I ON ADR.CATASTROPHIC_DISABILITY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLTY_STDINST_FK_I ON ADR.CATASTROPHIC_DISABILITY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSBLTY_STD_EVALMTHD_FK_I ON ADR.CATASTROPHIC_DISABILITY
(CAT_DSBLTY_EVAL_MTHD_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CAT_DISABILITY_AUDIR_TRGR
  AFTER UPDATE OR DELETE OR INSERT
  ON ADR.CATASTROPHIC_DISABILITY   FOR EACH ROW
DECLARE

    Mdml                               CHAR(1);

BEGIN

  IF DELETING THEN

    INSERT
    INTO      Catastrophic_Disability_H
              (Catastrophic_disability_h_id,
               Catastrophic_disability_id,
               Person_id,
               Cat_dsblty_eval_mthd_type_id,
               Std_institution_id,
               Clinical_approver_name,
               Catastrophically_disabled_ind,
               Cat_dsblty_evaluation_date,
               Decision_date,
               Record_created_by,
               Record_created_date,
               Record_modified_by,
               Record_modified_date,
               Record_modified_count,
               Cat_dsblty_review_requested_dt,
               Cat_dsblty_review_initiated_dt,
               Cat_dsblty_review_notified_dt,
               Transaction_type_code)
    VALUES    (ADR.Catastrophic_disability_h_s.NEXTVAL,
               :OLD.Catastrophic_disability_id     ,
               :OLD.Person_id                      ,
               :OLD.Cat_dsblty_eval_mthd_type_id   ,
               :OLD.Std_institution_id             ,
               :OLD.Clinical_approver_name,
               :OLD.Catastrophically_disabled_ind  ,
               :OLD.Cat_dsblty_evaluation_date     ,
               :OLD.Decision_date                  ,
               :OLD.Record_created_by   ,
               :OLD.Record_created_date            ,
               :OLD.Record_modified_by             ,
               :OLD.Record_modified_date        ,
               :OLD.Record_modified_count     ,
               :OLD.Cat_dsblty_review_requested_dt,
               :OLD.Cat_dsblty_review_initiated_dt,
               :OLD.Cat_dsblty_review_notified_dt  ,
               'D');

  ELSE

    IF UPDATING THEN

      Mdml := 'U';

    ELSE

      Mdml := 'I';

    END IF;

    INSERT
    INTO      ADR.Catastrophic_Disability_H
              (Catastrophic_disability_h_id,
               Catastrophic_disability_id,
               Person_id,
               Cat_dsblty_eval_mthd_type_id,
               Std_institution_id,
               Clinical_approver_name,
               Catastrophically_disabled_ind,
               Cat_dsblty_evaluation_date,
               Decision_date,
               Record_created_by,
               Record_created_date,
               Record_modified_by,
               Record_modified_date,
               Record_modified_count,
               Cat_dsblty_review_requested_dt,
               Cat_dsblty_review_initiated_dt,
               Cat_dsblty_review_notified_dt,
               Transaction_type_code)
    VALUES     (ADR.Catastrophic_disability_h_s.NEXTVAL,
                :NEW.Catastrophic_disability_id,
                :NEW.Person_id,
                :NEW.Cat_dsblty_eval_mthd_type_id,
                :NEW.Std_institution_id,
                :NEW.Clinical_approver_name,
                :NEW.Catastrophically_disabled_ind,
                :NEW.Cat_dsblty_evaluation_date,
                :NEW.Decision_date,
                :NEW.Record_created_by,
                :NEW.Record_created_date,
                :NEW.Record_modified_by,
                :NEW.Record_modified_date,
                :NEW.Record_modified_count,
                :NEW.Cat_dsblty_review_requested_dt,
                :NEW.Cat_dsblty_review_initiated_dt,
                :NEW.Cat_dsblty_review_notified_dt,
                Mdml);

  END IF;

END  Cat_Disability_Audir_Trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CATASTROPHIC_DISABILITY FOR ADR.CATASTROPHIC_DISABILITY;


ALTER TABLE ADR.CATASTROPHIC_DISABILITY ADD (
  CONSTRAINT CATDSBLTY_PK
  PRIMARY KEY
  (CATASTROPHIC_DISABILITY_ID)
  USING INDEX ADR.CATDSBLTY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CATASTROPHIC_DISABILITY ADD (
  CONSTRAINT CATDSBLTY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY TO ADREXT;

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CATASTROPHIC_DISABILITY TO ADR_RW;

GRANT SELECT ON ADR.CATASTROPHIC_DISABILITY TO ES_R;

GRANT INSERT, SELECT ON ADR.CATASTROPHIC_DISABILITY TO ES_RW;
ALTER TABLE ADR.COM_TRANSMISSION_LOG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.COM_TRANSMISSION_LOG CASCADE CONSTRAINTS;

CREATE TABLE ADR.COM_TRANSMISSION_LOG
(
  COM_TRANSMISSION_LOG_ID       NUMBER(20)      NOT NULL,
  MESSAGE_TRANSMISSION_TYPE_ID  NUMBER(20),
  FILE_NAME                     VARCHAR2(100 BYTE),
  FILE_RECORD_COUNT             NUMBER(18),
  FILE_RECEIVED_DATE            DATE,
  TRANSMISSION_START_DATE       DATE,
  TRANSMISSION_END_DATE         DATE,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.COM_TRANSMISSION_LOG IS 'The COM_TRANSMISSION_LOG table records all inbound and outbound letters to and from the ESR communications subsystem. MESSAGE_TRANSMISSION_TYPE_ID Foreign key to the MESSAGE_TRANSMISSION_TYPE table.';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.COM_TRANSMISSION_LOG_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.MESSAGE_TRANSMISSION_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.COM_TRANSMISSION_LOG.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.COMTRANLOG_PK ON ADR.COM_TRANSMISSION_LOG
(COM_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.COMTRANS_STD_MSGTYP_FK_I ON ADR.COM_TRANSMISSION_LOG
(MESSAGE_TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM COM_TRANSMISSION_LOG FOR ADR.COM_TRANSMISSION_LOG;


ALTER TABLE ADR.COM_TRANSMISSION_LOG ADD (
  CONSTRAINT COMTRANLOG_PK
  PRIMARY KEY
  (COM_TRANSMISSION_LOG_ID)
  USING INDEX ADR.COMTRANLOG_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.COM_TRANSMISSION_LOG TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.COM_TRANSMISSION_LOG TO ADR_RW;

GRANT SELECT ON ADR.COM_TRANSMISSION_LOG TO ES_R;

GRANT INSERT, SELECT ON ADR.COM_TRANSMISSION_LOG TO ES_RW;
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IVM_MIGRATE_STATISTICS CASCADE CONSTRAINTS;

CREATE TABLE ADR.IVM_MIGRATE_STATISTICS
(
  IVM_MIGRATE_STATISTICS_ID  NUMBER(20)         NOT NULL,
  PROCESSED_COUNT            NUMBER(10),
  LOAD_FAIL_CLEAR_COUNT      NUMBER(10),
  NO_IVM_CRITERIA_COUNT      NUMBER(10),
  NO_MATCH_COUNT             NUMBER(10),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IVM_MIGRATE_STATISTICS IS 'For a brief period just after Deployment, the ADR database to be running in parallel with an EDB database that contains the IVM data. During this period, any deltas that occur in the ADR system after initial migration, will be stored in this table. Hence, this is a one-time, IVM migration related table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.IVM_MIGRATE_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.IVMMIGSTAT_PK ON ADR.IVM_MIGRATE_STATISTICS
(IVM_MIGRATE_STATISTICS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE_STATISTICS FOR ADR.IVM_MIGRATE_STATISTICS;


ALTER TABLE ADR.IVM_MIGRATE_STATISTICS ADD (
  CONSTRAINT IVMMIGSTAT_PK
  PRIMARY KEY
  (IVM_MIGRATE_STATISTICS_ID)
  USING INDEX ADR.IVMMIGSTAT_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.IVM_MIGRATE_STATISTICS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_STATISTICS TO ADR_RW;

GRANT SELECT ON ADR.IVM_MIGRATE_STATISTICS TO ES_R;

GRANT INSERT, SELECT ON ADR.IVM_MIGRATE_STATISTICS TO ES_RW;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CAT_DSBLTY_CONDITION CASCADE CONSTRAINTS;

CREATE TABLE ADR.CAT_DSBLTY_CONDITION
(
  CAT_DSBLTY_CONDITION_ID     NUMBER(20)        NOT NULL,
  CATASTROPHIC_DISABILITY_ID  NUMBER(20)        NOT NULL,
  CONDITION_TYPE_ID           NUMBER(20)        NOT NULL,
  PRMNT_DSBLTY_STDYESNO_ID    NUMBER(20),
  DISABILITY_SCORE            NUMBER(3),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  PRMNT_DSBLTY_STDPERM_ID     NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CAT_DSBLTY_CONDITION IS 'The CAT_DSBLTY_CONDITION table is a child table of CATASTROPHIC_DISABILITY that shows the assessment tool used to evaluate the persons disability. CATASTROPHIC_DISABILITY_ID Foreign key to the CATASTROPHIC_DISABILITY table. CONDITION_TYPE_ID Foreign key to the CONDITION_TYPE table. Indicates what kind of disability a person has, according to the assessment tool used (for example, KATZ, FOLS). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.CAT_DSBLTY_CONDITION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.CATASTROPHIC_DISABILITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.CONDITION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.DISABILITY_SCORE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CAT_DSBLTY_CONDITION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.CATDSCOND_CATDSBLTY_FK_I ON ADR.CAT_DSBLTY_CONDITION
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.CATDSCOND_PK ON ADR.CAT_DSBLTY_CONDITION
(CAT_DSBLTY_CONDITION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSCOND_STDPERM_FK_I ON ADR.CAT_DSBLTY_CONDITION
(PRMNT_DSBLTY_STDPERM_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSCOND_STDYESNO_FK_I ON ADR.CAT_DSBLTY_CONDITION
(PRMNT_DSBLTY_STDYESNO_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CATDSCON_STD_CNDN_FK_I ON ADR.CAT_DSBLTY_CONDITION
(CONDITION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_COND_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.CAT_DSBLTY_CONDITION
for each row
declare
       mDML char(1);
begin

    if DELETING then
        insert into CAT_DSBLTY_CONDITION_H
        (
        CAT_DSBLTY_CONDITION_H_ID,
        CAT_DSBLTY_CONDITION_ID,
        CATASTROPHIC_DISABILITY_ID,
        CONDITION_TYPE_ID         ,
        RECORD_CREATED_BY         ,
        RECORD_CREATED_DATE       ,
        RECORD_MODIFIED_BY        ,
        RECORD_MODIFIED_DATE      ,
        RECORD_MODIFIED_COUNT     ,
        PRMNT_DSBLTY_STDYESNO_ID  ,
        DISABILITY_SCORE          ,
        TRANSACTION_TYPE_CODE     ,
        PRMNT_DSBLTY_STDPERM_ID
        )
        values
        (
        CAT_DSBLTY_CONDITION_H_s.nextval,
        :old.CAT_DSBLTY_CONDITION_ID,
        :old.CATASTROPHIC_DISABILITY_ID,
        :old.CONDITION_TYPE_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        :old.PRMNT_DSBLTY_STDYESNO_ID,
        :old.DISABILITY_SCORE,
        'D',
        :old.PRMNT_DSBLTY_STDPERM_ID
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into CAT_DSBLTY_CONDITION_H
        (
        CAT_DSBLTY_CONDITION_H_ID,
        CAT_DSBLTY_CONDITION_ID,
        CATASTROPHIC_DISABILITY_ID,
        CONDITION_TYPE_ID         ,
        RECORD_CREATED_BY         ,
        RECORD_CREATED_DATE       ,
        RECORD_MODIFIED_BY        ,
        RECORD_MODIFIED_DATE      ,
        RECORD_MODIFIED_COUNT     ,
        PRMNT_DSBLTY_STDYESNO_ID  ,
        DISABILITY_SCORE          ,
        TRANSACTION_TYPE_CODE     ,
        PRMNT_DSBLTY_STDPERM_ID
        )
        values
        (
        CAT_DSBLTY_CONDITION_H_s.nextval,
        :new.CAT_DSBLTY_CONDITION_ID,
        :new.CATASTROPHIC_DISABILITY_ID,
        :new.CONDITION_TYPE_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.PRMNT_DSBLTY_STDYESNO_ID,
        :new.DISABILITY_SCORE,
        mDML,
        :new.PRMNT_DSBLTY_STDPERM_ID
        );
    end if;

end  CAT_DSBLTY_COND_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_CONDITION FOR ADR.CAT_DSBLTY_CONDITION;


ALTER TABLE ADR.CAT_DSBLTY_CONDITION ADD (
  CONSTRAINT CATDSCOND_PK
  PRIMARY KEY
  (CAT_DSBLTY_CONDITION_ID)
  USING INDEX ADR.CATDSCOND_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.CAT_DSBLTY_CONDITION ADD (
  CONSTRAINT CATDSCOND_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.CAT_DSBLTY_CONDITION TO ADR_RW;

GRANT SELECT ON ADR.CAT_DSBLTY_CONDITION TO ES_R;

GRANT INSERT, SELECT ON ADR.CAT_DSBLTY_CONDITION TO ES_RW;
ALTER TABLE ADR.SHAD_REGISTRY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SHAD_REGISTRY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SHAD_REGISTRY_H
(
  SHAD_REGISTRY_H_ID     NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  SHAD_REGISTRY_ID       NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20),
  REGISTRY_TRAIT_ID      NUMBER(20),
  SHAD_STDYESNO_ID       NUMBER(20),
  CLAIM_NUMBER           VARCHAR2(20 BYTE),
  LEGACY_USERNAME        VARCHAR2(30 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SHAD_REGISTRY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.SHAD_REGISTRY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.SHAD_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SHADRGSTRH_PK ON ADR.SHAD_REGISTRY_H
(SHAD_REGISTRY_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADRGSTRH_PRSNID_NU_I ON ADR.SHAD_REGISTRY_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SHAD_REGISTRY_H FOR ADR.SHAD_REGISTRY_H;


ALTER TABLE ADR.SHAD_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_056
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT SHADRGSTRH_PK
  PRIMARY KEY
  (SHAD_REGISTRY_H_ID)
  USING INDEX ADR.SHADRGSTRH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SHAD_REGISTRY_H TO ADR_R;

GRANT SELECT ON ADR.SHAD_REGISTRY_H TO ADR_RW;

GRANT SELECT ON ADR.SHAD_REGISTRY_H TO ES_R;

GRANT INSERT, SELECT ON ADR.SHAD_REGISTRY_H TO ES_RW;
ALTER TABLE ADR.CANCEL_DECLINE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.CANCEL_DECLINE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.CANCEL_DECLINE_H
(
  CANCEL_DECLINE_H_ID            NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  CANCEL_DECLINE_ID              NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  CANCEL_DECLINE_STATUS_TYPE_ID  NUMBER(20),
  CANCEL_DECLINE_REASON_TYPE_ID  NUMBER(20),
  CANCEL_DECLINE_IND             VARCHAR2(1 BYTE),
  CANCEL_DECLINE_EFFECTIVE_DATE  DATE,
  REMARKS                        VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.CANCEL_DECLINE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_REASON_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_IND IS 'Indicateswhethera personhascancelledor declinedenrollmentwith theVHAhealthcare system.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.CANCEL_DECLINE_EFFECTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.CANCEL_DECLINE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CANDECH_PK ON ADR.CANCEL_DECLINE_H
(CANCEL_DECLINE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CANDECH_PRSNID_NU_I ON ADR.CANCEL_DECLINE_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CANCEL_DECLINE_H FOR ADR.CANCEL_DECLINE_H;


ALTER TABLE ADR.CANCEL_DECLINE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_057
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT CANDECH_PK
  PRIMARY KEY
  (CANCEL_DECLINE_H_ID)
  USING INDEX ADR.CANDECH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.CANCEL_DECLINE_H TO ADR_R;

GRANT SELECT ON ADR.CANCEL_DECLINE_H TO ADR_RW;

GRANT SELECT ON ADR.CANCEL_DECLINE_H TO ES_R;

GRANT INSERT, SELECT ON ADR.CANCEL_DECLINE_H TO ES_RW;
ALTER TABLE ADR.WKF_CASE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE
(
  WKF_CASE_ID               NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20),
  WKF_CASE_TYPE_ID          NUMBER(20)          NOT NULL,
  WKF_CASE_REQUEST_TYPE_ID  NUMBER(20),
  WKF_CASE_ISSUE_TYPE_ID    NUMBER(20),
  REQUEST_RECEIVED_SITE_ID  NUMBER(20),
  STD_USERGROUPTYPE_ID      NUMBER(20),
  REQUEST_RECEIVED_DATE     DATE,
  CASE_DUE_DATE             DATE,
  ERROR_MESSAGE_TEXT        VARCHAR2(250 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  BF_PROCESSED              NUMBER(1)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE IS 'Contains all the workflow records that are manual cases i.e. a business event that requires staff to perform work. Workflow Cases may be handled by the system automatically or may become a case that a staff member will work. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_CASE.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCASE_PK ON ADR.WKF_CASE
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_PRSN_FK_I ON ADR.WKF_CASE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_STDINST_FK_I ON ADR.WKF_CASE
(REQUEST_RECEIVED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_STD_USRGRPTYP_FK_I ON ADR.WKF_CASE
(STD_USERGROUPTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_STD_WKFCSTYPE_FK_I ON ADR.WKF_CASE
(WKF_CASE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_STD_WKFRQST_FK_I ON ADR.WKF_CASE
(WKF_CASE_REQUEST_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_WKFISUTYPE_FK_I ON ADR.WKF_CASE
(WKF_CASE_ISSUE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE for each row
declare
    mDML char(1);
begin

  if DELETING then
       insert into WKF_CASE_H
    (

    WKF_CASE_H_ID,
    WKF_CASE_ID,
    PERSON_ID,
    WKF_CASE_TYPE_ID,
    WKF_CASE_REQUEST_TYPE_ID,
    WKF_CASE_ISSUE_TYPE_ID,
    REQUEST_RECEIVED_SITE_ID,
    REQUEST_RECEIVED_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE,
    Bf_Processed
    )
    values
    (
    WKF_CASE_H_S.nextval,
    :old.WKF_CASE_ID,
    :old.PERSON_ID,
    :old.WKF_CASE_TYPE_ID,
    :old.WKF_CASE_REQUEST_TYPE_ID,
    :old.WKF_CASE_ISSUE_TYPE_ID,
    :old.REQUEST_RECEIVED_SITE_ID,
    :old.REQUEST_RECEIVED_DATE,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.RECORD_MODIFIED_COUNT,
    'D',
    :old.Bf_Processed
    );
  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

       insert into WKF_CASE_H
    (
    WKF_CASE_H_ID,
    WKF_CASE_ID,
    PERSON_ID,
    WKF_CASE_TYPE_ID,
    WKF_CASE_REQUEST_TYPE_ID,
    WKF_CASE_ISSUE_TYPE_ID,
    REQUEST_RECEIVED_SITE_ID,
    REQUEST_RECEIVED_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE,
    Bf_Processed
    )
    values
    (
    WKF_CASE_H_S.nextval,
    :new.WKF_CASE_ID,
    :new.PERSON_ID,
    :new.WKF_CASE_TYPE_ID,
    :new.WKF_CASE_REQUEST_TYPE_ID,
    :new.WKF_CASE_ISSUE_TYPE_ID,
    :new.REQUEST_RECEIVED_SITE_ID,
    :new.REQUEST_RECEIVED_DATE,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.RECORD_MODIFIED_COUNT,
    mDML,
    :new.Bf_Processed
    );
  end if;

End WKF_CASE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE FOR ADR.WKF_CASE;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_PK
  PRIMARY KEY
  (WKF_CASE_ID)
  USING INDEX ADR.WKFCASE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT WKFCASE_STD_WKFCSTYPE_FK 
  FOREIGN KEY (WKF_CASE_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCASE_STD_WKFRQST_FK 
  FOREIGN KEY (WKF_CASE_REQUEST_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEREQUEST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCASE_WKFISUTYPE_FK 
  FOREIGN KEY (WKF_CASE_ISSUE_TYPE_ID) 
  REFERENCES ADRREF.STD_WKFISSUETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE TO ADR_RW;

GRANT INSERT, SELECT, UPDATE ON ADR.WKF_CASE TO BIZFLOW_RW;
ALTER TABLE ADR.PERSON_RELATION_UNMERGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RELATION_UNMERGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RELATION_UNMERGE
(
  PERSON_RELATION_UNMERGE_ID  NUMBER(20)        NOT NULL,
  PERSON_RELATION_ID_2        NUMBER(20),
  PERSON_RELATION_ID_1        NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
    